/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.util.HashSet;
import java.util.Set;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.UserIdentityManager;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.RelationMemberData;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.data.osm.UserInfo;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.NodeMovedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesAddedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesRemovedEvent;
import org.openstreetmap.josm.data.osm.event.RelationMembersChangedEvent;
import org.openstreetmap.josm.data.osm.event.TagsChangedEvent;
import org.openstreetmap.josm.data.osm.event.WayNodesChangedEvent;
import org.openstreetmap.josm.data.osm.history.History;
import org.openstreetmap.josm.data.osm.history.HistoryNode;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.data.osm.history.HistoryRelation;
import org.openstreetmap.josm.data.osm.history.HistoryWay;
import org.openstreetmap.josm.data.osm.visitor.OsmPrimitiveVisitor;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.history.DiffTableModel;
import org.openstreetmap.josm.gui.history.PointInTimeType;
import org.openstreetmap.josm.gui.history.TagTableModel;
import org.openstreetmap.josm.gui.history.TwoColumnDiff;
import org.openstreetmap.josm.gui.history.VersionTableModel;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.MainLayerManager;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.util.ChangeNotifier;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class HistoryBrowserModel
extends ChangeNotifier
implements MainLayerManager.ActiveLayerChangeListener,
DataSetListener {
    private History history;
    private HistoryOsmPrimitive reference;
    private HistoryOsmPrimitive current;
    private HistoryOsmPrimitive latest;
    private final VersionTableModel versionTableModel = new VersionTableModel(this);
    private final TagTableModel currentTagTableModel = new TagTableModel(this, PointInTimeType.CURRENT_POINT_IN_TIME);
    private final TagTableModel referenceTagTableModel = new TagTableModel(this, PointInTimeType.REFERENCE_POINT_IN_TIME);
    private final DiffTableModel currentRelationMemberTableModel;
    private final DiffTableModel referenceRelationMemberTableModel;
    private final DiffTableModel referenceNodeListTableModel = new DiffTableModel();
    private final DiffTableModel currentNodeListTableModel = new DiffTableModel();

    public HistoryBrowserModel() {
        OsmDataLayer editLayer;
        this.currentRelationMemberTableModel = new DiffTableModel();
        this.referenceRelationMemberTableModel = new DiffTableModel();
        if (Main.main != null && (editLayer = MainApplication.getLayerManager().getEditLayer()) != null) {
            editLayer.data.addDataSetListener(this);
        }
        MainApplication.getLayerManager().addActiveLayerChangeListener(this);
    }

    public HistoryBrowserModel(History history) {
        this();
        CheckParameterUtil.ensureParameterNotNull(history, "history");
        this.setHistory(history);
    }

    public History getHistory() {
        return this.history;
    }

    private boolean canShowAsLatest(OsmPrimitive primitive) {
        if (primitive == null) {
            return false;
        }
        if (primitive.isNew() || !primitive.isUsable()) {
            return false;
        }
        try {
            HistoryOsmPrimitive.forOsmPrimitive(primitive);
        }
        catch (IllegalArgumentException ign) {
            Logging.trace(ign);
            return false;
        }
        if (this.history == null) {
            return false;
        }
        if (this.history.getByVersion(primitive.getVersion()) != null) {
            return primitive.isModified();
        }
        return this.history.getLatest().getVersion() <= (long)primitive.getVersion();
    }

    public void setHistory(History history) {
        this.history = history;
        if (history.getNumVersions() > 0) {
            OsmPrimitive p;
            HistoryOsmPrimitive newLatest = null;
            OsmDataLayer editLayer = MainApplication.getLayerManager().getEditLayer();
            if (editLayer != null && this.canShowAsLatest(p = editLayer.data.getPrimitiveById(history.getId(), history.getType()))) {
                newLatest = new HistoryPrimitiveBuilder().build(p);
            }
            if (newLatest == null) {
                this.current = history.getLatest();
                int prevIndex = history.getNumVersions() - 2;
                this.reference = prevIndex < 0 ? history.getEarliest() : history.get(prevIndex);
            } else {
                this.reference = history.getLatest();
                this.current = newLatest;
            }
            this.setLatest(newLatest);
        }
        this.initTagTableModels();
        this.fireModelChange();
    }

    private void fireModelChange() {
        this.initNodeListTableModels();
        this.initMemberListTableModels();
        this.fireStateChanged();
        this.versionTableModel.fireTableDataChanged();
    }

    public VersionTableModel getVersionTableModel() {
        return this.versionTableModel;
    }

    private void initTagTableModels() {
        this.currentTagTableModel.initKeyList();
        this.referenceTagTableModel.initKeyList();
    }

    private void initNodeListTableModels() {
        if (this.current == null || this.current.getType() != OsmPrimitiveType.WAY || this.reference == null || this.reference.getType() != OsmPrimitiveType.WAY) {
            return;
        }
        TwoColumnDiff diff = new TwoColumnDiff(((HistoryWay)this.reference).getNodes().toArray(), ((HistoryWay)this.current).getNodes().toArray());
        this.referenceNodeListTableModel.setRows(diff.referenceDiff, diff.referenceReversed);
        this.currentNodeListTableModel.setRows(diff.currentDiff, false);
    }

    private void initMemberListTableModels() {
        if (this.current == null || this.current.getType() != OsmPrimitiveType.RELATION || this.reference == null || this.reference.getType() != OsmPrimitiveType.RELATION) {
            return;
        }
        TwoColumnDiff diff = new TwoColumnDiff(((HistoryRelation)this.reference).getMembers().toArray(), ((HistoryRelation)this.current).getMembers().toArray());
        this.referenceRelationMemberTableModel.setRows(diff.referenceDiff, diff.referenceReversed);
        this.currentRelationMemberTableModel.setRows(diff.currentDiff, false);
    }

    public TagTableModel getTagTableModel(PointInTimeType pointInTimeType) {
        CheckParameterUtil.ensureParameterNotNull((Object)pointInTimeType, "pointInTimeType");
        if (pointInTimeType.equals((Object)PointInTimeType.CURRENT_POINT_IN_TIME)) {
            return this.currentTagTableModel;
        }
        return this.referenceTagTableModel;
    }

    public DiffTableModel getNodeListTableModel(PointInTimeType pointInTimeType) {
        CheckParameterUtil.ensureParameterNotNull((Object)pointInTimeType, "pointInTimeType");
        if (pointInTimeType.equals((Object)PointInTimeType.CURRENT_POINT_IN_TIME)) {
            return this.currentNodeListTableModel;
        }
        return this.referenceNodeListTableModel;
    }

    public DiffTableModel getRelationMemberTableModel(PointInTimeType pointInTimeType) {
        CheckParameterUtil.ensureParameterNotNull((Object)pointInTimeType, "pointInTimeType");
        if (pointInTimeType.equals((Object)PointInTimeType.CURRENT_POINT_IN_TIME)) {
            return this.currentRelationMemberTableModel;
        }
        return this.referenceRelationMemberTableModel;
    }

    public void setReferencePointInTime(HistoryOsmPrimitive reference) {
        CheckParameterUtil.ensureParameterNotNull(reference, "reference");
        if (this.history == null) {
            throw new IllegalStateException(I18n.tr("History not initialized yet. Failed to set reference primitive.", new Object[0]));
        }
        if (reference.getId() != this.history.getId()) {
            throw new IllegalArgumentException(I18n.tr("Failed to set reference. Reference ID {0} does not match history ID {1}.", reference.getId(), this.history.getId()));
        }
        if (this.history.getByVersion(reference.getVersion()) == null) {
            throw new IllegalArgumentException(I18n.tr("Failed to set reference. Reference version {0} not available in history.", reference.getVersion()));
        }
        this.reference = reference;
        this.initTagTableModels();
        this.initNodeListTableModels();
        this.initMemberListTableModels();
        this.fireStateChanged();
    }

    public void setCurrentPointInTime(HistoryOsmPrimitive current) {
        CheckParameterUtil.ensureParameterNotNull(current, "current");
        if (this.history == null) {
            throw new IllegalStateException(I18n.tr("History not initialized yet. Failed to set current primitive.", new Object[0]));
        }
        if (current.getId() != this.history.getId()) {
            throw new IllegalArgumentException(I18n.tr("Failed to set reference. Reference ID {0} does not match history ID {1}.", current.getId(), this.history.getId()));
        }
        if (this.history.getByVersion(current.getVersion()) == null) {
            throw new IllegalArgumentException(I18n.tr("Failed to set current primitive. Current version {0} not available in history.", current.getVersion()));
        }
        this.current = current;
        this.initTagTableModels();
        this.initNodeListTableModels();
        this.initMemberListTableModels();
        this.fireStateChanged();
    }

    public HistoryOsmPrimitive getCurrentPointInTime() {
        return this.getPointInTime(PointInTimeType.CURRENT_POINT_IN_TIME);
    }

    public HistoryOsmPrimitive getReferencePointInTime() {
        return this.getPointInTime(PointInTimeType.REFERENCE_POINT_IN_TIME);
    }

    public HistoryOsmPrimitive getPointInTime(PointInTimeType type) {
        CheckParameterUtil.ensureParameterNotNull((Object)type, "type");
        if (type.equals((Object)PointInTimeType.CURRENT_POINT_IN_TIME)) {
            return this.current;
        }
        if (type.equals((Object)PointInTimeType.REFERENCE_POINT_IN_TIME)) {
            return this.reference;
        }
        return null;
    }

    public boolean isLatest(HistoryOsmPrimitive primitive) {
        return primitive != null && primitive == this.latest;
    }

    public void setReferencePointInTime(int row) {
        if (this.history == null) {
            return;
        }
        if (row == this.history.getNumVersions()) {
            if (this.latest != null) {
                this.setReferencePointInTime(this.latest);
            }
            return;
        }
        if (row < 0 || row > this.history.getNumVersions()) {
            return;
        }
        this.setReferencePointInTime(this.history.get(row));
    }

    public void setCurrentPointInTime(int row) {
        if (this.history == null) {
            return;
        }
        if (row == this.history.getNumVersions()) {
            if (this.latest != null) {
                this.setCurrentPointInTime(this.latest);
            }
            return;
        }
        if (row < 0 || row > this.history.getNumVersions()) {
            return;
        }
        this.setCurrentPointInTime(this.history.get(row));
    }

    public boolean isReferencePointInTime(int row) {
        if (this.history == null) {
            return false;
        }
        if (row == this.history.getNumVersions()) {
            return this.latest == this.reference;
        }
        if (row < 0 || row > this.history.getNumVersions()) {
            return false;
        }
        return this.history.get(row) == this.reference;
    }

    public boolean isCurrentPointInTime(int row) {
        if (this.history == null) {
            return false;
        }
        if (row == this.history.getNumVersions()) {
            return this.latest == this.current;
        }
        if (row < 0 || row > this.history.getNumVersions()) {
            return false;
        }
        return this.history.get(row) == this.current;
    }

    public HistoryOsmPrimitive getPrimitive(int row) {
        if (this.history == null) {
            return null;
        }
        return this.isLatest(row) ? this.latest : this.history.get(row);
    }

    public boolean isLatest(int row) {
        return row >= this.history.getNumVersions();
    }

    public HistoryOsmPrimitive getLatest() {
        return this.latest;
    }

    public Set<String> getKeySet() {
        HashSet<String> keySet = new HashSet<String>();
        if (this.current != null) {
            keySet.addAll(this.current.getTags().keySet());
        }
        if (this.reference != null) {
            keySet.addAll(this.reference.getTags().keySet());
        }
        return keySet;
    }

    protected void setLatest(HistoryOsmPrimitive latest) {
        if (latest == null) {
            if (this.current == this.latest) {
                HistoryOsmPrimitive historyOsmPrimitive = this.current = this.history != null ? this.history.getLatest() : null;
            }
            if (this.reference == this.latest) {
                this.reference = this.history != null ? this.history.getLatest() : null;
            }
            this.latest = null;
        } else {
            if (this.current == this.latest) {
                this.current = latest;
            }
            if (this.reference == this.latest) {
                this.reference = latest;
            }
            this.latest = latest;
        }
        this.fireModelChange();
    }

    public void unlinkAsListener() {
        OsmDataLayer editLayer = MainApplication.getLayerManager().getEditLayer();
        if (editLayer != null) {
            editLayer.data.removeDataSetListener(this);
        }
        MainApplication.getLayerManager().removeActiveLayerChangeListener(this);
    }

    @Override
    public void nodeMoved(NodeMovedEvent event) {
        Node node = event.getNode();
        if (!node.isNew() && node.getId() == this.history.getId()) {
            this.setLatest(new HistoryPrimitiveBuilder().build(node));
        }
    }

    @Override
    public void primitivesAdded(PrimitivesAddedEvent event) {
        for (OsmPrimitive p : event.getPrimitives()) {
            if (!this.canShowAsLatest(p)) continue;
            this.setLatest(new HistoryPrimitiveBuilder().build(p));
        }
    }

    @Override
    public void primitivesRemoved(PrimitivesRemovedEvent event) {
        for (OsmPrimitive p : event.getPrimitives()) {
            if (p.isNew() || p.getId() != this.history.getId()) continue;
            this.setLatest(null);
        }
    }

    @Override
    public void relationMembersChanged(RelationMembersChangedEvent event) {
        Relation r = event.getRelation();
        if (!r.isNew() && r.getId() == this.history.getId()) {
            this.setLatest(new HistoryPrimitiveBuilder().build(r));
        }
    }

    @Override
    public void tagsChanged(TagsChangedEvent event) {
        OsmPrimitive prim = event.getPrimitive();
        if (!prim.isNew() && prim.getId() == this.history.getId()) {
            this.setLatest(new HistoryPrimitiveBuilder().build(prim));
        }
    }

    @Override
    public void wayNodesChanged(WayNodesChangedEvent event) {
        Way way = event.getChangedWay();
        if (!way.isNew() && way.getId() == this.history.getId()) {
            this.setLatest(new HistoryPrimitiveBuilder().build(way));
        }
    }

    @Override
    public void dataChanged(DataChangedEvent event) {
        if (this.history == null) {
            return;
        }
        OsmPrimitive primitive = event.getDataset().getPrimitiveById(this.history.getId(), this.history.getType());
        HistoryOsmPrimitive newLatest = this.canShowAsLatest(primitive) ? new HistoryPrimitiveBuilder().build(primitive) : null;
        this.setLatest(newLatest);
        this.fireModelChange();
    }

    @Override
    public void otherDatasetChange(AbstractDatasetChangedEvent event) {
    }

    @Override
    public void activeOrEditLayerChanged(MainLayerManager.ActiveLayerChangeEvent e) {
        Layer newLayer;
        Layer oldLayer = e.getPreviousActiveLayer();
        if (oldLayer instanceof OsmDataLayer) {
            OsmDataLayer l = (OsmDataLayer)oldLayer;
            l.data.removeDataSetListener(this);
        }
        if (!((newLayer = e.getSource().getActiveLayer()) instanceof OsmDataLayer)) {
            this.latest = null;
            this.fireModelChange();
            return;
        }
        OsmDataLayer l = (OsmDataLayer)newLayer;
        l.data.addDataSetListener(this);
        OsmPrimitive primitive = this.history != null ? l.data.getPrimitiveById(this.history.getId(), this.history.getType()) : null;
        HistoryOsmPrimitive newLatest = this.canShowAsLatest(primitive) ? new HistoryPrimitiveBuilder().build(primitive) : null;
        this.setLatest(newLatest);
        this.fireModelChange();
    }

    static class HistoryPrimitiveBuilder
    implements OsmPrimitiveVisitor {
        private HistoryOsmPrimitive clone;

        HistoryPrimitiveBuilder() {
        }

        @Override
        public void visit(Node n) {
            this.clone = new HistoryNode(n.getId(), n.getVersion(), n.isVisible(), HistoryPrimitiveBuilder.getCurrentUser(), 0L, null, n.getCoor(), false);
            this.clone.setTags(n.getKeys());
        }

        @Override
        public void visit(Relation r) {
            this.clone = new HistoryRelation(r.getId(), (long)r.getVersion(), r.isVisible(), HistoryPrimitiveBuilder.getCurrentUser(), 0L, null, false);
            this.clone.setTags(r.getKeys());
            HistoryRelation hr = (HistoryRelation)this.clone;
            for (RelationMember rm : r.getMembers()) {
                hr.addMember(new RelationMemberData(rm.getRole(), rm.getType(), rm.getUniqueId()));
            }
        }

        @Override
        public void visit(Way w) {
            this.clone = new HistoryWay(w.getId(), (long)w.getVersion(), w.isVisible(), HistoryPrimitiveBuilder.getCurrentUser(), 0L, null, false);
            this.clone.setTags(w.getKeys());
            for (Node n : w.getNodes()) {
                ((HistoryWay)this.clone).addNode(n.getUniqueId());
            }
        }

        private static User getCurrentUser() {
            UserInfo info = UserIdentityManager.getInstance().getUserInfo();
            return info == null ? User.getAnonymous() : User.createOsmUser(info.getId(), info.getDisplayName());
        }

        HistoryOsmPrimitive build(OsmPrimitive primitive) {
            primitive.accept(this);
            return this.clone;
        }
    }
}

