/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.geoimage;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.dialogs.DialogsPanel;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.LayerManager;
import org.openstreetmap.josm.gui.layer.MainLayerManager;
import org.openstreetmap.josm.gui.layer.geoimage.GeoImageLayer;
import org.openstreetmap.josm.gui.layer.geoimage.ImageDisplay;
import org.openstreetmap.josm.gui.layer.geoimage.ImageEntry;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.date.DateUtils;

public final class ImageViewerDialog
extends ToggleDialog
implements LayerManager.LayerChangeListener,
MainLayerManager.ActiveLayerChangeListener {
    private final ImageZoomAction imageZoomAction = new ImageZoomAction();
    private final ImageCenterViewAction imageCenterViewAction = new ImageCenterViewAction();
    private final ImageNextAction imageNextAction = new ImageNextAction();
    private final ImageRemoveAction imageRemoveAction = new ImageRemoveAction();
    private final ImageRemoveFromDiskAction imageRemoveFromDiskAction = new ImageRemoveFromDiskAction();
    private final ImagePreviousAction imagePreviousAction = new ImagePreviousAction();
    private final ImageCollapseAction imageCollapseAction = new ImageCollapseAction();
    private final ImageFirstAction imageFirstAction = new ImageFirstAction();
    private final ImageLastAction imageLastAction = new ImageLastAction();
    private final ImageCopyPathAction imageCopyPathAction = new ImageCopyPathAction();
    private final ImageDisplay imgDisplay = new ImageDisplay();
    private boolean centerView;
    private static volatile ImageViewerDialog dialog;
    private boolean collapseButtonClicked;
    private JButton btnNext;
    private JButton btnPrevious;
    private JButton btnCollapse;
    private JToggleButton tbCentre;
    private transient GeoImageLayer currentLayer;
    private transient ImageEntry currentEntry;

    public static ImageViewerDialog getInstance() {
        if (dialog == null) {
            dialog = new ImageViewerDialog();
        }
        return dialog;
    }

    private ImageViewerDialog() {
        super(I18n.tr("Geotagged Images", new Object[0]), "geoimage", I18n.tr("Display geotagged images", new Object[0]), Shortcut.registerShortcut("tools:geotagged", I18n.tr("Tool: {0}", I18n.tr("Display geotagged images", new Object[0])), 89, 5003), 200);
        this.build();
        MainApplication.getLayerManager().addActiveLayerChangeListener(this);
        MainApplication.getLayerManager().addLayerChangeListener(this);
    }

    private void build() {
        JPanel content = new JPanel(new BorderLayout());
        content.add((Component)this.imgDisplay, "Center");
        Dimension buttonDim = new Dimension(26, 26);
        this.btnPrevious = new JButton(this.imagePreviousAction);
        this.btnPrevious.setPreferredSize(buttonDim);
        this.btnPrevious.setEnabled(false);
        JButton btnDelete = new JButton(this.imageRemoveAction);
        btnDelete.setPreferredSize(buttonDim);
        JButton btnDeleteFromDisk = new JButton(this.imageRemoveFromDiskAction);
        btnDeleteFromDisk.setPreferredSize(buttonDim);
        JButton btnCopyPath = new JButton(this.imageCopyPathAction);
        btnCopyPath.setPreferredSize(buttonDim);
        this.btnNext = new JButton(this.imageNextAction);
        this.btnNext.setPreferredSize(buttonDim);
        this.btnNext.setEnabled(false);
        this.tbCentre = new JToggleButton(this.imageCenterViewAction);
        this.tbCentre.setPreferredSize(buttonDim);
        JButton btnZoomBestFit = new JButton(this.imageZoomAction);
        btnZoomBestFit.setPreferredSize(buttonDim);
        this.btnCollapse = new JButton(this.imageCollapseAction);
        this.btnCollapse.setPreferredSize(new Dimension(20, 20));
        this.btnCollapse.setAlignmentY(0.0f);
        JPanel buttons = new JPanel();
        buttons.add(this.btnPrevious);
        buttons.add(this.btnNext);
        buttons.add(Box.createRigidArea(new Dimension(7, 0)));
        buttons.add(this.tbCentre);
        buttons.add(btnZoomBestFit);
        buttons.add(Box.createRigidArea(new Dimension(7, 0)));
        buttons.add(btnDelete);
        buttons.add(btnDeleteFromDisk);
        buttons.add(Box.createRigidArea(new Dimension(7, 0)));
        buttons.add(btnCopyPath);
        JPanel bottomPane = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 0;
        gc.gridy = 0;
        gc.anchor = 10;
        gc.weightx = 1.0;
        bottomPane.add((Component)buttons, gc);
        gc.gridx = 1;
        gc.gridy = 0;
        gc.anchor = 20;
        gc.weightx = 0.0;
        bottomPane.add((Component)this.btnCollapse, gc);
        content.add((Component)bottomPane, "South");
        this.createLayout(content, false, null);
    }

    @Override
    public void destroy() {
        MainApplication.getLayerManager().removeActiveLayerChangeListener(this);
        MainApplication.getLayerManager().removeLayerChangeListener(this);
        this.imageFirstAction.destroy();
        this.imageLastAction.destroy();
        this.imagePreviousAction.destroy();
        this.imageNextAction.destroy();
        this.imageCenterViewAction.destroy();
        this.imageCollapseAction.destroy();
        this.imageCopyPathAction.destroy();
        this.imageRemoveAction.destroy();
        this.imageRemoveFromDiskAction.destroy();
        this.imageZoomAction.destroy();
        super.destroy();
        dialog = null;
    }

    public static void showImage(GeoImageLayer layer, ImageEntry entry) {
        ImageViewerDialog.getInstance().displayImage(layer, entry);
        if (layer != null) {
            layer.checkPreviousNextButtons();
        } else {
            ImageViewerDialog.setPreviousEnabled(false);
            ImageViewerDialog.setNextEnabled(false);
        }
    }

    public static void setPreviousEnabled(boolean value) {
        ImageViewerDialog.getInstance().btnPrevious.setEnabled(value);
    }

    public static void setNextEnabled(boolean value) {
        ImageViewerDialog.getInstance().btnNext.setEnabled(value);
    }

    public static synchronized boolean setCentreEnabled(boolean value) {
        ImageViewerDialog instance = ImageViewerDialog.getInstance();
        boolean wasEnabled = instance.tbCentre.isEnabled();
        instance.tbCentre.setEnabled(value);
        instance.tbCentre.getAction().actionPerformed(new ActionEvent(instance.tbCentre, 0, null));
        return wasEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayImage(GeoImageLayer layer, ImageEntry entry) {
        StringBuilder osd;
        boolean imageChanged;
        ImageViewerDialog imageViewerDialog = this;
        synchronized (imageViewerDialog) {
            boolean bl = imageChanged = this.currentEntry != entry;
            if (this.centerView && entry != null && MainApplication.isDisplayingMapView() && entry.getPos() != null) {
                MainApplication.getMap().mapView.zoomTo(entry.getPos());
            }
            this.currentLayer = layer;
            this.currentEntry = entry;
        }
        if (entry != null) {
            String pattern;
            DateFormat dtf;
            if (imageChanged) {
                this.imgDisplay.setImage(entry);
            }
            this.setTitle(I18n.tr("Geotagged Images", new Object[0]) + (entry.getFile() != null ? " - " + entry.getFile().getName() : ""));
            osd = new StringBuilder(entry.getFile() != null ? entry.getFile().getName() : "");
            if (entry.getElevation() != null) {
                osd.append(I18n.tr("\nAltitude: {0} m", Math.round(entry.getElevation())));
            }
            if (entry.getSpeed() != null) {
                osd.append(I18n.tr("\nSpeed: {0} km/h", Math.round(entry.getSpeed())));
            }
            if (entry.getExifImgDir() != null) {
                osd.append(I18n.tr("\nDirection {0}\u00b0", Math.round(entry.getExifImgDir())));
            }
            if ((dtf = DateUtils.getDateTimeFormat(3, 2)) instanceof SimpleDateFormat && !(pattern = ((SimpleDateFormat)dtf).toPattern()).contains(".SSS")) {
                dtf = new SimpleDateFormat(pattern.replace(":ss", ":ss.SSS"));
            }
            if (entry.hasExifTime()) {
                osd.append(I18n.tr("\nEXIF time: {0}", dtf.format(entry.getExifTime())));
            }
            if (entry.hasGpsTime()) {
                osd.append(I18n.tr("\nGPS time: {0}", dtf.format(entry.getGpsTime())));
            }
        } else {
            this.setTitle(I18n.tr("Geotagged Images", new Object[0]));
            this.imgDisplay.setImage(null);
            this.imgDisplay.setOsdText("");
            return;
        }
        this.imgDisplay.setOsdText(osd.toString());
        if (!this.isDialogShowing()) {
            this.setIsDocked(false);
            this.showDialog();
        } else if (this.isDocked && this.isCollapsed) {
            this.expand();
            this.dialogsPanel.reconstruct(DialogsPanel.Action.COLLAPSED_TO_DEFAULT, this);
        }
    }

    @Override
    protected boolean dockWhenClosingDetachedDlg() {
        if (this.collapseButtonClicked) {
            this.collapseButtonClicked = false;
            return true;
        }
        return false;
    }

    @Override
    protected void stateChanged() {
        super.stateChanged();
        if (this.btnCollapse != null) {
            this.btnCollapse.setVisible(!this.isDocked);
        }
    }

    public boolean hasImage() {
        return this.currentEntry != null;
    }

    public static ImageEntry getCurrentImage() {
        return ImageViewerDialog.getInstance().currentEntry;
    }

    public static GeoImageLayer getCurrentLayer() {
        return ImageViewerDialog.getInstance().currentLayer;
    }

    public static boolean isCenterView() {
        return ImageViewerDialog.getInstance().centerView;
    }

    @Override
    public void layerAdded(LayerManager.LayerAddEvent e) {
        this.showLayer(e.getAddedLayer());
    }

    @Override
    public void layerRemoving(LayerManager.LayerRemoveEvent e) {
        if (this.currentLayer != null && this.currentLayer.equals(e.getRemovedLayer())) {
            ImageViewerDialog.showImage(null, null);
        }
        if (this.currentLayer != null && e.getRemovedLayer() instanceof GeoImageLayer) {
            this.currentLayer.checkPreviousNextButtons();
        }
    }

    @Override
    public void layerOrderChanged(LayerManager.LayerOrderChangeEvent e) {
    }

    @Override
    public void activeOrEditLayerChanged(MainLayerManager.ActiveLayerChangeEvent e) {
        this.showLayer(e.getSource().getActiveLayer());
    }

    private void showLayer(Layer newLayer) {
        if (this.currentLayer == null && newLayer instanceof GeoImageLayer) {
            ((GeoImageLayer)newLayer).showFirstPhoto();
        }
    }

    private class ImageCollapseAction
    extends JosmAction {
        ImageCollapseAction() {
            super(null, new ImageProvider("dialogs", "collapse"), I18n.tr("Move dialog to the side pane", new Object[0]), null, false, null, false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ImageViewerDialog.this.collapseButtonClicked = true;
            ImageViewerDialog.this.detachedDialog.getToolkit().getSystemEventQueue().postEvent(new WindowEvent(ImageViewerDialog.this.detachedDialog, 201));
        }
    }

    private class ImageCopyPathAction
    extends JosmAction {
        ImageCopyPathAction() {
            super(null, new ImageProvider("copy"), I18n.tr("Copy image path", new Object[0]), Shortcut.registerShortcut("geoimage:copypath", I18n.tr("Geoimage: {0}", I18n.tr("Copy image path", new Object[0])), 67, 5010), false, null, false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ImageViewerDialog.this.currentLayer != null) {
                ImageViewerDialog.this.currentLayer.copyCurrentPhotoPath();
            }
        }
    }

    private class ImageRemoveFromDiskAction
    extends JosmAction {
        ImageRemoveFromDiskAction() {
            super(null, new ImageProvider("dialogs", "geoimage/deletefromdisk"), I18n.tr("Delete image file from disk", new Object[0]), Shortcut.registerShortcut("geoimage:deletefilefromdisk", I18n.tr("Geoimage: {0}", I18n.tr("Delete File from disk", new Object[0])), 127, 5009), false, null, false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ImageViewerDialog.this.currentLayer != null) {
                ImageViewerDialog.this.currentLayer.removeCurrentPhotoFromDisk();
            }
        }
    }

    private class ImageRemoveAction
    extends JosmAction {
        ImageRemoveAction() {
            super(null, new ImageProvider("dialogs", "delete"), I18n.tr("Remove photo from layer", new Object[0]), Shortcut.registerShortcut("geoimage:deleteimagefromlayer", I18n.tr("Geoimage: {0}", I18n.tr("Remove photo from layer", new Object[0])), 127, 5005), false, null, false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ImageViewerDialog.this.currentLayer != null) {
                ImageViewerDialog.this.currentLayer.removeCurrentPhoto();
            }
        }
    }

    private class ImageZoomAction
    extends JosmAction {
        ImageZoomAction() {
            super(null, new ImageProvider("dialogs", "zoom-best-fit"), I18n.tr("Zoom best fit and 1:1", new Object[0]), null, false, null, false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ImageViewerDialog.this.imgDisplay.zoomBestFitOrOne();
        }
    }

    private class ImageCenterViewAction
    extends JosmAction {
        ImageCenterViewAction() {
            super(null, new ImageProvider("dialogs", "centreview"), I18n.tr("Center view", new Object[0]), null, false, null, false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JToggleButton button = (JToggleButton)e.getSource();
            ImageViewerDialog.this.centerView = button.isEnabled() && button.isSelected();
            if (ImageViewerDialog.this.centerView && ImageViewerDialog.this.currentEntry != null && ImageViewerDialog.this.currentEntry.getPos() != null) {
                MainApplication.getMap().mapView.zoomTo(ImageViewerDialog.this.currentEntry.getPos());
            }
        }
    }

    private class ImageLastAction
    extends JosmAction {
        ImageLastAction() {
            super(null, (ImageProvider)null, null, Shortcut.registerShortcut("geoimage:last", I18n.tr("Geoimage: {0}", I18n.tr("Show last Image", new Object[0])), 35, 5003), false, null, false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ImageViewerDialog.this.currentLayer != null) {
                ImageViewerDialog.this.currentLayer.showLastPhoto();
            }
        }
    }

    private class ImageFirstAction
    extends JosmAction {
        ImageFirstAction() {
            super(null, (ImageProvider)null, null, Shortcut.registerShortcut("geoimage:first", I18n.tr("Geoimage: {0}", I18n.tr("Show first Image", new Object[0])), 36, 5003), false, null, false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ImageViewerDialog.this.currentLayer != null) {
                ImageViewerDialog.this.currentLayer.showFirstPhoto();
            }
        }
    }

    private class ImagePreviousAction
    extends JosmAction {
        ImagePreviousAction() {
            super(null, new ImageProvider("dialogs", "previous"), I18n.tr("Previous", new Object[0]), Shortcut.registerShortcut("geoimage:previous", I18n.tr("Geoimage: {0}", I18n.tr("Show previous Image", new Object[0])), 33, 5003), false, null, false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ImageViewerDialog.this.currentLayer != null) {
                ImageViewerDialog.this.currentLayer.showPreviousPhoto();
            }
        }
    }

    private class ImageNextAction
    extends JosmAction {
        ImageNextAction() {
            super(null, new ImageProvider("dialogs", "next"), I18n.tr("Next", new Object[0]), Shortcut.registerShortcut("geoimage:next", I18n.tr("Geoimage: {0}", I18n.tr("Show next Image", new Object[0])), 34, 5003), false, null, false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ImageViewerDialog.this.currentLayer != null) {
                ImageViewerDialog.this.currentLayer.showNextPhoto();
            }
        }
    }
}

