/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.server;

import java.awt.Component;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.io.Capabilities;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.HttpClient;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ApiUrlTestTask
extends PleaseWaitRunnable {
    private final String url;
    private boolean canceled;
    private boolean success;
    private final Component parent;
    private HttpClient connection;

    public ApiUrlTestTask(Component parent, String url) {
        super(parent, I18n.tr("Testing OSM API URL ''{0}''", url), false);
        CheckParameterUtil.ensureParameterNotNull(url, "url");
        this.parent = parent;
        this.url = url;
    }

    protected void alertInvalidUrl(String url) {
        HelpAwareOptionPane.showMessageDialogInEDT(this.parent, I18n.tr("<html>''{0}'' is not a valid OSM API URL.<br>Please check the spelling and validate again.</html>", url), I18n.tr("Invalid API URL", new Object[0]), 0, HelpUtil.ht("/Preferences/Connection#InvalidAPIUrl"));
    }

    protected void alertInvalidCapabilitiesUrl(String url) {
        HelpAwareOptionPane.showMessageDialogInEDT(this.parent, I18n.tr("<html>Failed to build URL ''{0}'' for validating the OSM API server.<br>Please check the spelling of ''{1}'' and validate again.</html>", url, this.getNormalizedApiUrl()), I18n.tr("Invalid API URL", new Object[0]), 0, HelpUtil.ht("/Preferences/Connection#InvalidAPIGetChangesetsUrl"));
    }

    protected void alertConnectionFailed() {
        HelpAwareOptionPane.showMessageDialogInEDT(this.parent, I18n.tr("<html>Failed to connect to the URL ''{0}''.<br>Please check the spelling of ''{1}'' and your Internet connection and validate again.</html>", this.url, this.getNormalizedApiUrl()), I18n.tr("Connection to API failed", new Object[0]), 0, HelpUtil.ht("/Preferences/Connection#ConnectionToAPIFailed"));
    }

    protected void alertInvalidServerResult(int retCode) {
        HelpAwareOptionPane.showMessageDialogInEDT(this.parent, I18n.tr("<html>Failed to retrieve a list of changesets from the OSM API server at<br>''{1}''. The server responded with the return code {0} instead of 200.<br>Please check the spelling of ''{1}'' and validate again.</html>", retCode, this.getNormalizedApiUrl()), I18n.tr("Connection to API failed", new Object[0]), 0, HelpUtil.ht("/Preferences/Connection#InvalidServerResult"));
    }

    protected void alertInvalidCapabilities() {
        HelpAwareOptionPane.showMessageDialogInEDT(this.parent, I18n.tr("<html>The OSM API server at ''{0}'' did not return a valid response.<br>It is likely that ''{0}'' is not an OSM API server.<br>Please check the spelling of ''{0}'' and validate again.</html>", this.getNormalizedApiUrl()), I18n.tr("Connection to API failed", new Object[0]), 0, HelpUtil.ht("/Preferences/Connection#InvalidSettings"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void cancel() {
        this.canceled = true;
        ApiUrlTestTask apiUrlTestTask = this;
        synchronized (apiUrlTestTask) {
            if (this.connection != null) {
                this.connection.disconnect();
            }
        }
    }

    @Override
    protected void finish() {
    }

    protected String getNormalizedApiUrl() {
        String apiUrl = this.url.trim();
        while (apiUrl.endsWith("/")) {
            apiUrl = apiUrl.substring(0, apiUrl.lastIndexOf(47));
        }
        return apiUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void realRun() throws SAXException, IOException, OsmTransferException {
        try {
            URL capabilitiesUrl;
            try {
                new URL(this.getNormalizedApiUrl());
            }
            catch (MalformedURLException e) {
                this.alertInvalidUrl(this.getNormalizedApiUrl());
                return;
            }
            String getCapabilitiesUrl = this.getNormalizedApiUrl() + "/0.6/capabilities";
            try {
                capabilitiesUrl = new URL(getCapabilitiesUrl);
            }
            catch (MalformedURLException e) {
                this.alertInvalidCapabilitiesUrl(getCapabilitiesUrl);
                return;
            }
            ApiUrlTestTask e = this;
            synchronized (e) {
                this.connection = HttpClient.create(capabilitiesUrl);
                this.connection.connect();
            }
            if (this.connection.getResponse().getResponseCode() != 200) {
                this.alertInvalidServerResult(this.connection.getResponse().getResponseCode());
                return;
            }
            try {
                Capabilities.CapabilitiesParser.parse(new InputSource(this.connection.getResponse().getContent()));
            }
            catch (ParserConfigurationException | SAXException e2) {
                Logging.warn(e2);
                this.alertInvalidCapabilities();
                return;
            }
            this.success = true;
        }
        catch (IOException e) {
            if (this.canceled) {
                return;
            }
            Logging.error(e);
            this.alertConnectionFailed();
            return;
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public boolean isSuccess() {
        return this.success;
    }
}

