/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.frame.cls;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.inference.ReasonerPreferences;
import org.protege.editor.owl.ui.editor.OWLObjectEditor;
import org.protege.editor.owl.ui.frame.OWLFrame;
import org.protege.editor.owl.ui.frame.OWLFrameSectionRow;
import org.protege.editor.owl.ui.frame.cls.AbstractOWLClassAxiomFrameSection;
import org.protege.editor.owl.ui.frame.cls.OWLSubClassAxiomFrameSectionRow;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.reasoner.Node;
import org.semanticweb.owlapi.reasoner.OWLReasoner;

public class OWLSubClassAxiomFrameSection
extends AbstractOWLClassAxiomFrameSection<OWLSubClassOfAxiom, OWLClassExpression> {
    private static final String LABEL = "SubClass Of";
    private Set<OWLClassExpression> added = new HashSet<OWLClassExpression>();
    private OWLObjectProperty prop;

    public OWLSubClassAxiomFrameSection(OWLEditorKit editorKit, OWLFrame<OWLClass> frame) {
        super(editorKit, LABEL, "Superclass", (OWLFrame<? extends OWLClassExpression>)frame);
    }

    @Override
    protected void clear() {
        this.added.clear();
    }

    @Override
    protected void addAxiom(OWLSubClassOfAxiom ax, OWLOntology ont) {
        this.addRow(new OWLSubClassAxiomFrameSectionRow(this.getOWLEditorKit(), this, ont, this.getRootObject(), ax));
        this.added.add(ax.getSuperClass());
    }

    @Override
    protected Set<OWLSubClassOfAxiom> getClassAxioms(OWLClassExpression descr, OWLOntology ont) {
        if (!descr.isAnonymous()) {
            return ont.getSubClassAxiomsForSubClass(descr.asOWLClass());
        }
        HashSet<OWLSubClassOfAxiom> axioms = new HashSet<OWLSubClassOfAxiom>();
        for (OWLAxiom ax : ont.getGeneralClassAxioms()) {
            if (!(ax instanceof OWLSubClassOfAxiom) || !((OWLSubClassOfAxiom)ax).getSubClass().equals(descr)) continue;
            axioms.add((OWLSubClassOfAxiom)ax);
        }
        return axioms;
    }

    @Override
    protected void refillInferred() {
        OWLReasoner reasoner = this.getOWLModelManager().getReasoner();
        if (!reasoner.isConsistent()) {
            return;
        }
        if (!reasoner.isSatisfiable(this.getRootObject())) {
            return;
        }
        this.getOWLModelManager().getReasonerPreferences().executeTask(ReasonerPreferences.OptionalInferenceTask.SHOW_INFERRED_SUPER_CLASSES, () -> {
            for (Node inferredSuperClasses : reasoner.getSuperClasses(this.getRootObject(), true)) {
                for (OWLClassExpression inferredSuperClass : inferredSuperClasses) {
                    if (this.added.contains(inferredSuperClass)) continue;
                    this.addInferredRowIfNontrivial(new OWLSubClassAxiomFrameSectionRow(this.getOWLEditorKit(), this, null, this.getRootObject(), this.getOWLModelManager().getOWLDataFactory().getOWLSubClassOfAxiom(this.getRootObject(), inferredSuperClass)));
                    this.added.add(inferredSuperClass);
                }
            }
        });
    }

    @Override
    protected OWLSubClassOfAxiom createAxiom(OWLClassExpression object) {
        return this.getOWLDataFactory().getOWLSubClassOfAxiom(this.getRootObject(), object);
    }

    @Override
    public OWLObjectEditor<OWLClassExpression> getObjectEditor() {
        return this.getOWLEditorKit().getWorkspace().getOWLComponentFactory().getOWLClassDescriptionEditor(null, AxiomType.SUBCLASS_OF);
    }

    @Override
    public boolean canAcceptDrop(List<OWLObject> objects) {
        for (OWLObject obj : objects) {
            if (obj instanceof OWLClassExpression) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean dropObjects(List<OWLObject> objects) {
        ArrayList<AddAxiom> changes = new ArrayList<AddAxiom>();
        for (OWLObject obj : objects) {
            if (obj instanceof OWLClassExpression) {
                Object desc = this.prop != null ? this.getOWLDataFactory().getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)this.prop, (OWLClassExpression)obj) : (OWLClassExpression)obj;
                OWLSubClassOfAxiom ax = this.getOWLDataFactory().getOWLSubClassOfAxiom(this.getRootObject(), desc);
                changes.add(new AddAxiom(this.getOWLModelManager().getActiveOntology(), (OWLAxiom)ax));
                continue;
            }
            if (obj instanceof OWLObjectProperty) {
                this.prop = (OWLObjectProperty)obj;
                continue;
            }
            return false;
        }
        this.getOWLModelManager().applyChanges(changes);
        return true;
    }

    @Override
    protected boolean isResettingChange(OWLOntologyChange change) {
        if (!change.isAxiomChange()) {
            return false;
        }
        OWLAxiom axiom = change.getAxiom();
        if (axiom instanceof OWLSubClassOfAxiom) {
            return ((OWLSubClassOfAxiom)axiom).getSubClass().equals(this.getRootObject());
        }
        return false;
    }

    @Override
    public Comparator<OWLFrameSectionRow<OWLClassExpression, OWLSubClassOfAxiom, OWLClassExpression>> getRowComparator() {
        return new Comparator<OWLFrameSectionRow<OWLClassExpression, OWLSubClassOfAxiom, OWLClassExpression>>(){

            @Override
            public int compare(OWLFrameSectionRow<OWLClassExpression, OWLSubClassOfAxiom, OWLClassExpression> o1, OWLFrameSectionRow<OWLClassExpression, OWLSubClassOfAxiom, OWLClassExpression> o2) {
                int val;
                if (o1.isInferred()) {
                    if (!o2.isInferred()) {
                        return 1;
                    }
                } else if (o2.isInferred()) {
                    return -1;
                }
                if ((val = OWLSubClassAxiomFrameSection.this.getOWLModelManager().getOWLObjectComparator().compare((OWLObject)o1.getAxiom(), (OWLObject)o2.getAxiom())) == 0) {
                    return o1.getOntology().getOntologyID().compareTo(o2.getOntology().getOntologyID());
                }
                return val;
            }
        };
    }
}

