/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.ui.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.protege.editor.core.ProtegeManager;
import org.protege.editor.core.editorkit.EditorKit;
import org.protege.editor.core.editorkit.EditorKitManager;
import org.protege.editor.core.platform.OSUtils;
import org.protege.editor.core.platform.apple.MacUIUtil;
import org.protege.editor.core.prefs.Preferences;
import org.protege.editor.core.prefs.PreferencesManager;
import org.protege.editor.core.ui.util.OpenRequestHandler;

public class UIUtil {
    public static final String FILE_PREFERENCES_KEY = "FILE_PREFERENCES_KEY";
    public static final String CURRENT_FILE_DIRECTORY_KEY = "CURRENT_FILE_DIRECTORY_KEY";
    public static final String ENABLE_TEMP_DIRECTORIES_KEY = "ENABLE_TEMP_DIRECTORIES_KEY";
    public static final String FILE_URI_SCHEME = "file";

    public static String getCurrentFileDirectory() {
        String dir = "~";
        Preferences p = PreferencesManager.getInstance().getApplicationPreferences(FILE_PREFERENCES_KEY);
        dir = p.getString(CURRENT_FILE_DIRECTORY_KEY, dir);
        return dir;
    }

    public static void setCurrentFileDirectory(String dir) {
        Preferences p = PreferencesManager.getInstance().getApplicationPreferences(FILE_PREFERENCES_KEY);
        p.putString(CURRENT_FILE_DIRECTORY_KEY, dir);
    }

    @Deprecated
    public static File openFile(Component parent, String title, Set<String> extensions) {
        return UIUtil.openFile(parent, title, null, extensions);
    }

    public static File openFile(Component parent, String title, final String description, final Set<String> extensions) {
        File f;
        if (OSUtils.isOSX() && parent instanceof Window) {
            return MacUIUtil.openFile((Window)parent, title, extensions);
        }
        JFileChooser fileDialog = new JFileChooser(UIUtil.getCurrentFileDirectory());
        if (extensions != null && !extensions.isEmpty()) {
            fileDialog.setFileFilter(new FileFilter(){

                @Override
                public String getDescription() {
                    return description;
                }

                @Override
                public boolean accept(File f) {
                    if (extensions.isEmpty() || f.isDirectory()) {
                        return true;
                    }
                    String name = f.getName();
                    for (String ext : extensions) {
                        if (!name.toLowerCase().endsWith(ext.toLowerCase())) continue;
                        return true;
                    }
                    return false;
                }
            });
        }
        fileDialog.setDialogType(0);
        int retVal = fileDialog.showOpenDialog(parent);
        if (retVal == 0 && (f = fileDialog.getSelectedFile()) != null) {
            if (f.getParent() != null) {
                UIUtil.setCurrentFileDirectory(f.getParent());
            }
            return f;
        }
        return null;
    }

    @Deprecated
    public static File saveFile(Component parent, String title, Set<String> extensions, String initialName) {
        return UIUtil.saveFile(parent, title, null, extensions, initialName);
    }

    public static File saveFile(Component parent, String title, final String description, final Set<String> extensions, String initialName) {
        Window parentWindow = parent instanceof Window ? (Window)parent : SwingUtilities.getWindowAncestor(parent);
        if (OSUtils.isOSX() && parentWindow != null) {
            return MacUIUtil.saveFile(parentWindow, title, extensions, initialName);
        }
        JFileChooser fileDialog = new JFileChooser(UIUtil.getCurrentFileDirectory());
        fileDialog.setDialogTitle(title);
        if (extensions != null && !extensions.isEmpty()) {
            fileDialog.setFileFilter(new FileFilter(){

                @Override
                public String getDescription() {
                    return description;
                }

                @Override
                public boolean accept(File f) {
                    if (extensions.isEmpty() || f.isDirectory()) {
                        return true;
                    }
                    String name = f.getName();
                    for (String ext : extensions) {
                        if (!name.toLowerCase().endsWith(ext.toLowerCase())) continue;
                        return true;
                    }
                    return false;
                }
            });
        }
        fileDialog.setDialogType(1);
        if (initialName != null) {
            fileDialog.setSelectedFile(new File(initialName));
        }
        int retVal = fileDialog.showSaveDialog(parent);
        File f = null;
        if (retVal == 0 && (f = fileDialog.getSelectedFile()) != null) {
            if (f.getParent() != null) {
                UIUtil.setCurrentFileDirectory(f.getParent());
            }
            return f;
        }
        return null;
    }

    @Deprecated
    public static File saveFile(Window parent, String title, Set<String> extensions) {
        return UIUtil.saveFile(parent, title, null, extensions, null);
    }

    public static File saveFile(Window parent, String title, String description, Set<String> extensions) {
        return UIUtil.saveFile(parent, title, description, extensions, null);
    }

    public static File chooseFolder(Component parent, String title) {
        if (System.getProperty("os.name").contains("OS X")) {
            return MacUIUtil.chooseOSXFolder(parent, title);
        }
        JFileChooser chooser = new JFileChooser();
        File currentDirectory = new File(UIUtil.getCurrentFileDirectory());
        chooser.setSelectedFile(currentDirectory);
        chooser.setDialogTitle(title);
        chooser.setDialogType(0);
        chooser.setFileSelectionMode(1);
        if (chooser.showOpenDialog(parent) == 0) {
            File selectedDirectory = chooser.getSelectedFile();
            if (selectedDirectory != null) {
                UIUtil.setCurrentFileDirectory(selectedDirectory.toString());
            }
            return selectedDirectory;
        }
        return null;
    }

    public static void openRequest(OpenRequestHandler handler) throws Exception {
        EditorKit editorKit;
        ProtegeManager pm = ProtegeManager.getInstance();
        EditorKitManager editorKitManager = pm.getEditorKitManager();
        if (editorKitManager.getEditorKitCount() == 1 && !(editorKit = editorKitManager.getEditorKits().get(0)).hasModifiedDocument()) {
            handler.openInNewWorkspace();
            return;
        }
        int ret = JOptionPane.showConfirmDialog(handler.getCurrentWorkspace(), "Do you want to open the ontology in the current window?", "Open in current window", 1, 3);
        if (ret == 0) {
            handler.openInCurrentWorkspace();
        } else if (ret == 1) {
            handler.openInNewWorkspace();
        }
    }

    public static <T> Collection<T> getComponentsExtending(Component component, Class<? extends T> clazz) {
        ArrayList components = new ArrayList();
        UIUtil.addComponentsExtending(component, clazz, components);
        return components;
    }

    private static <T> void addComponentsExtending(Component component, Class<? extends T> clazz, Collection<T> components) {
        if (component instanceof Container) {
            Container container = (Container)component;
            int nSubcomponents = container.getComponentCount();
            for (int i = 0; i < nSubcomponents; ++i) {
                Component subComponent = container.getComponent(i);
                if (clazz.isAssignableFrom(subComponent.getClass())) {
                    components.add(clazz.cast(subComponent));
                    continue;
                }
                UIUtil.addComponentsExtending(subComponent, clazz, components);
            }
        }
    }

    public static boolean isLocalFile(URI uri) {
        if (uri == null) {
            return false;
        }
        String scheme = uri.getScheme();
        return scheme != null && FILE_URI_SCHEME.equals(scheme.toLowerCase());
    }

    public static boolean isHighContrastOn() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Optional<Boolean> highContrast = Optional.ofNullable((Boolean)toolkit.getDesktopProperty("win.highContrast.on"));
        return highContrast.orElse(false);
    }
}

