/*
 * Decompiled with CFR 0.152.
 */
package gnu.inet.ftp;

import gnu.inet.ftp.DTP;
import gnu.inet.ftp.DTPOutputStream;
import java.io.IOException;
import java.io.OutputStream;

class BlockOutputStream
extends DTPOutputStream {
    static final byte RECORD = -128;
    static final byte EOF = 64;

    BlockOutputStream(DTP dTP, OutputStream outputStream) {
        super(dTP, outputStream);
    }

    @Override
    public void write(int n) throws IOException {
        if (this.transferComplete) {
            return;
        }
        byte[] byArray = new byte[]{-128, 0, 1, (byte)n};
        this.out.write(byArray, 0, 4);
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.transferComplete) {
            return;
        }
        byte[] byArray2 = new byte[n2 + 3];
        byArray2[0] = -128;
        byArray2[1] = (byte)((n2 & 0xFF) >> 8);
        byArray2[2] = (byte)(n2 & 0xFF00);
        System.arraycopy(byArray, n, byArray2, 3, n2);
        this.out.write(byArray2, 0, n2);
    }

    @Override
    public void close() throws IOException {
        byte[] byArray = new byte[]{64, 0, 0};
        this.out.write(byArray, 0, 3);
        super.close();
    }
}

