/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.otp.ic;

import com.ericsson.otp.erlang.OtpConnection;
import com.ericsson.otp.erlang.OtpErlangPid;
import com.ericsson.otp.erlang.OtpErlangRef;
import com.ericsson.otp.erlang.OtpInputStream;
import com.ericsson.otp.erlang.OtpOutputStream;
import com.ericsson.otp.erlang.OtpPeer;
import com.ericsson.otp.erlang.OtpSelf;
import java.util.Dictionary;

public class Environment {
    private OtpSelf self;
    private OtpPeer peer;
    private Object server;
    private String cookie;
    private OtpConnection connection;
    private OtpErlangRef send_ref;
    private OtpErlangRef receive_ref;
    private OtpErlangPid clientP;
    private OtpErlangPid serverP;
    private OtpOutputStream os;
    private OtpInputStream is;
    private boolean stopped;
    private int tag;
    private String operation;
    private String type;
    private OtpErlangRef ref;
    private OtpErlangPid caller;
    private boolean clientT;
    private boolean serverT;

    public Environment(OtpSelf otpSelf, OtpPeer otpPeer, Object object) throws Exception {
        this.init();
        this.clientT = true;
        this.self = otpSelf;
        this.peer = otpPeer;
        this.server = object;
        this.os = new OtpOutputStream();
    }

    public Environment(String string, String string2, String string3, Object object) throws Exception {
        this.init();
        this.clientT = true;
        this.self = new OtpSelf(string, string3);
        this.peer = new OtpPeer(string2);
        this.cookie = string3;
        this.server = object;
        this.os = new OtpOutputStream();
    }

    public Environment(OtpConnection otpConnection, Object object) throws Exception {
        this.init();
        this.clientT = true;
        this.self = otpConnection.self();
        this.peer = otpConnection.peer();
        this.connection = otpConnection;
        this.server = object;
        this.os = new OtpOutputStream();
    }

    public Environment() throws Exception {
        this.init();
        this.serverT = true;
        this.stopped = false;
        this.os = new OtpOutputStream();
    }

    public void connect() throws Exception {
        if (this.connection == null) {
            this.connection = this.self.connect(this.peer);
        }
        this.clientP = this.self.createPid();
        this.send_ref = this.self.createRef();
    }

    public void reconnect() throws Exception {
        if (this.connection.isConnected()) {
            this.connection.close();
        }
        this.connection = this.self.connect(this.peer);
    }

    public void disconnect() {
        this.connection.close();
    }

    public void send() throws Exception {
        if (this.server instanceof String) {
            this.connection.sendBuf((String)this.server, this.os);
        } else {
            this.connection.sendBuf((OtpErlangPid)this.server, this.os);
        }
    }

    public void receive() throws Exception {
        this.is = this.connection.receiveBuf();
        if (this.clientT) {
            this.is.read_tuple_head();
            this.receive_ref = this.is.read_ref();
        }
    }

    public void receive(OtpConnection otpConnection) throws Exception {
        this.is = otpConnection.receiveBuf();
        if (this.clientT) {
            this.is.read_tuple_head();
            this.receive_ref = this.is.read_ref();
        }
    }

    public Object server() {
        return this.server;
    }

    public OtpErlangPid caller_pid() {
        return this.clientP;
    }

    public OtpErlangRef received_ref() {
        return this.receive_ref;
    }

    public void write_client_pid() {
        this.os.write_pid(this.clientP.node(), this.clientP.id(), this.clientP.serial(), this.clientP.creation());
    }

    public void write_client_ref() {
        this.os.write_ref(this.send_ref.node(), this.send_ref.id(), this.send_ref.creation());
    }

    public OtpOutputStream getOs() {
        return this.os;
    }

    public OtpInputStream getIs() {
        return this.is;
    }

    public OtpErlangPid getScaller() {
        return this.caller;
    }

    public OtpErlangRef getSref() {
        return this.ref;
    }

    public void uHead() throws Exception {
        this.uHead(this.is);
    }

    public void uHead(OtpInputStream otpInputStream) throws Exception {
        this.is = otpInputStream;
        this.is.read_tuple_head();
        this.type = this.is.read_atom();
        if (this.type.equals("$gen_call")) {
            this.is.read_tuple_head();
            this.caller = this.is.read_pid();
            this.ref = this.is.read_ref();
            this.tag = this.is.peek();
            switch (this.tag) {
                case 100: 
                case 118: 
                case 119: {
                    this.operation = this.is.read_atom();
                    break;
                }
                default: {
                    this.is.read_tuple_head();
                    this.operation = this.is.read_atom();
                    break;
                }
            }
        } else {
            this.tag = this.is.peek();
            switch (this.tag) {
                case 100: 
                case 118: 
                case 119: {
                    this.operation = this.is.read_atom();
                    break;
                }
                default: {
                    this.is.read_tuple_head();
                    this.operation = this.is.read_atom();
                }
            }
        }
    }

    public int uLabel(Dictionary dictionary) {
        Integer n = (Integer)dictionary.get(this.operation);
        if (n == null) {
            return -1;
        }
        return n;
    }

    public boolean validOp(Dictionary dictionary) {
        return dictionary.get(this.operation) != null;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public void client_stop_server() throws Exception {
        this.os.reset();
        this.os.write_tuple_head(2);
        this.os.write_atom("$gen_cast");
        this.os.write_atom("stop");
        this.send();
    }

    public void server_stop_server() {
        this.stopped = true;
    }

    public void init() {
        this.clientT = false;
        this.serverT = false;
        this.stopped = false;
        this.self = null;
        this.peer = null;
        this.server = null;
        this.cookie = null;
        this.connection = null;
        this.clientP = null;
        this.serverP = null;
        this.send_ref = null;
        this.receive_ref = null;
        this.os = null;
        this.is = null;
        this.tag = -1;
        this.operation = null;
        this.type = null;
    }
}

