/*
 * Decompiled with CFR 0.152.
 */
package accessories.plugins;

import freemind.main.FixedHTMLWriter;
import freemind.main.Resources;
import freemind.modes.MindMapNode;
import freemind.modes.mindmapmode.MindMapController;
import freemind.modes.mindmapmode.hooks.MindMapNodeHookAdapter;
import freemind.view.mindmapview.MapView;
import java.awt.EventQueue;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.ListIterator;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;

public class SplitNode
extends MindMapNodeHookAdapter {
    @Override
    public void invoke(MindMapNode node) {
        super.invoke(node);
        List list = this.getMindMapController().getSelecteds();
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            MindMapNode next = (MindMapNode)listIterator.next();
            this.splitNode(next);
        }
    }

    private void splitNode(MindMapNode node) {
        if (node.isRoot()) {
            return;
        }
        String text = node.toString();
        String[] parts = this.splitNode(text);
        if (parts == null || parts.length == 1) {
            return;
        }
        final MindMapController c = this.getMindMapController();
        int firstPartNumber = 0;
        while (parts[firstPartNumber] == null) {
            ++firstPartNumber;
        }
        c.setNodeText(node, parts[firstPartNumber]);
        MindMapNode parent = node.getParentNode();
        int nodePosition = parent.getChildPosition(node) + 1;
        for (int i = parts.length - 1; i > firstPartNumber; --i) {
            final MindMapNode lowerNode = c.addNewNode(parent, nodePosition, node.isLeft());
            String part = parts[i];
            if (part == null) continue;
            lowerNode.setColor(node.getColor());
            lowerNode.setFont(node.getFont());
            c.setNodeText(lowerNode, part);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MapView mapView = c.getView();
                    mapView.toggleSelected(mapView.getNodeView(lowerNode));
                }
            });
        }
    }

    private String[] splitNode(String text) {
        if (text.startsWith("<html>")) {
            String[] parts = null;
            HTMLEditorKit kit = new HTMLEditorKit();
            HTMLDocument doc = new HTMLDocument();
            StringReader buf = new StringReader(text);
            try {
                kit.read(buf, (Document)doc, 0);
                Element parent = this.getParentElement(doc);
                if (parent == null) {
                    return null;
                }
                int elementCount = parent.getElementCount();
                int notEmptyElementCount = 0;
                parts = new String[elementCount];
                for (int i = 0; i < elementCount; ++i) {
                    int end;
                    Element current = parent.getElement(i);
                    int start = current.getStartOffset();
                    String paragraphText = doc.getText(start, (end = current.getEndOffset()) - start).trim();
                    if (paragraphText.length() <= 0) continue;
                    StringWriter out = new StringWriter();
                    new FixedHTMLWriter((Writer)out, doc, start, end - start).write();
                    String string = out.toString();
                    if (!string.equals("")) {
                        parts[i] = string;
                        ++notEmptyElementCount;
                        continue;
                    }
                    parts[i] = null;
                }
                if (notEmptyElementCount <= 1) {
                    return null;
                }
            }
            catch (IOException e) {
                Resources.getInstance().logException(e);
            }
            catch (BadLocationException e) {
                Resources.getInstance().logException(e);
            }
            return parts;
        }
        return text.split("\n");
    }

    private Element getParentElement(HTMLDocument doc) {
        Element htmlRoot = doc.getDefaultRootElement();
        Element parentCandidate = htmlRoot.getElement(htmlRoot.getElementCount() - 1);
        do {
            if (parentCandidate.getElementCount() <= 1) continue;
            return parentCandidate;
        } while (!(parentCandidate = parentCandidate.getElement(0)).isLeaf() && !parentCandidate.getName().equalsIgnoreCase("p-implied"));
        return null;
    }
}

