/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.java;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.projectRoots.JavaSdkVersion;
import org.jetbrains.kotlin.com.intellij.openapi.projectRoots.JavaVersionService;
import org.jetbrains.kotlin.com.intellij.openapi.util.Comparing;
import org.jetbrains.kotlin.com.intellij.pom.java.LanguageLevel;
import org.jetbrains.kotlin.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.JavaResolveResult;
import org.jetbrains.kotlin.com.intellij.psi.PsiAssignmentExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiConditionalExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpressionList;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethodCallExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceParameterList;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.impl.DebugUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiClassImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.JavaResolveCache;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.ChildRole;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.ElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.JavaElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.java.ExpressionPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.infos.MethodCandidateInfo;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTypesUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.kotlin.com.intellij.util.Function;

public class PsiMethodCallExpressionImpl
extends ExpressionPsiElement
implements PsiMethodCallExpression {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.java.PsiMethodCallExpressionImpl");
    private static final TypeEvaluator ourTypeEvaluator = new TypeEvaluator();

    public PsiMethodCallExpressionImpl() {
        super(JavaElementType.METHOD_CALL_EXPRESSION);
    }

    @Override
    public PsiType getType() {
        return JavaResolveCache.getInstance(this.getProject()).getType(this, ourTypeEvaluator);
    }

    @Override
    public PsiMethod resolveMethod() {
        return (PsiMethod)this.getMethodExpression().resolve();
    }

    @Override
    @NotNull
    public JavaResolveResult resolveMethodGenerics() {
        JavaResolveResult javaResolveResult = this.getMethodExpression().advancedResolve(false);
        if (javaResolveResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiMethodCallExpressionImpl", "resolveMethodGenerics"));
        }
        return javaResolveResult;
    }

    @Override
    public void removeChild(@NotNull ASTNode child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiMethodCallExpressionImpl", "removeChild"));
        }
        if (child == this.getArgumentList()) {
            LOG.error("Cannot delete argument list since it will break contract on argument list notnullity");
        }
        super.removeChild(child);
    }

    @Override
    @NotNull
    public PsiReferenceParameterList getTypeArgumentList() {
        PsiReferenceExpression expression2 = this.getMethodExpression();
        PsiReferenceParameterList result2 = expression2.getParameterList();
        if (result2 != null) {
            PsiReferenceParameterList psiReferenceParameterList = result2;
            if (psiReferenceParameterList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiMethodCallExpressionImpl", "getTypeArgumentList"));
            }
            return psiReferenceParameterList;
        }
        LOG.error("Invalid method call expression. Children:\n" + DebugUtil.psiTreeToString(expression2, false));
        PsiReferenceParameterList psiReferenceParameterList = result2;
        if (psiReferenceParameterList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiMethodCallExpressionImpl", "getTypeArgumentList"));
        }
        return psiReferenceParameterList;
    }

    @Override
    @NotNull
    public PsiType[] getTypeArguments() {
        PsiType[] psiTypeArray = this.getMethodExpression().getTypeParameters();
        if (psiTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiMethodCallExpressionImpl", "getTypeArguments"));
        }
        return psiTypeArray;
    }

    @Override
    @NotNull
    public PsiReferenceExpression getMethodExpression() {
        PsiReferenceExpression psiReferenceExpression = (PsiReferenceExpression)this.findChildByRoleAsPsiElement(91);
        if (psiReferenceExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiMethodCallExpressionImpl", "getMethodExpression"));
        }
        return psiReferenceExpression;
    }

    @Override
    @NotNull
    public PsiExpressionList getArgumentList() {
        PsiExpressionList list2 = (PsiExpressionList)this.findChildByRoleAsPsiElement(73);
        if (list2 == null) {
            LOG.error("Invalid PSI for'" + this.getText() + ". Parent:" + DebugUtil.psiToString(this.getParent(), false));
        }
        PsiExpressionList psiExpressionList = list2;
        if (psiExpressionList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiMethodCallExpressionImpl", "getArgumentList"));
        }
        return psiExpressionList;
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 91: {
                return this.getFirstChildNode();
            }
            case 73: 
        }
        return this.findChildByType(JavaElementType.EXPRESSION_LIST);
    }

    @Override
    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == JavaElementType.EXPRESSION_LIST) {
            return 73;
        }
        if (ElementType.EXPRESSION_BIT_SET.contains(child.getElementType())) {
            return 91;
        }
        return 0;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiMethodCallExpressionImpl", "accept"));
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitMethodCallExpression(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiMethodCallExpression:" + this.getText();
    }

    public static PsiType captureReturnType(PsiMethodCallExpression call2, PsiMethod method, PsiType ret, JavaResolveResult result2, LanguageLevel languageLevel) {
        PsiSubstitutor substitutor2 = result2.getSubstitutor();
        PsiType substitutedReturnType = substitutor2.substitute(ret);
        if (substitutedReturnType == null) {
            return TypeConversionUtil.erasure(ret);
        }
        if (InferenceSession.wasUncheckedConversionPerformed(call2)) {
            return TypeConversionUtil.erasure(substitutedReturnType);
        }
        if (((!languageLevel.isAtLeast(LanguageLevel.JDK_1_8) || call2.getTypeArguments().length > 0) && method.hasTypeParameters() || !method.hasTypeParameters() && JavaVersionService.getInstance().isAtLeast(call2, JavaSdkVersion.JDK_1_8)) && result2 instanceof MethodCandidateInfo && ((MethodCandidateInfo)result2).isApplicable()) {
            PsiType[] args = call2.getArgumentList().getExpressionTypes();
            PsiParameter[] parameters2 = method.getParameterList().getParameters();
            boolean varargs = ((MethodCandidateInfo)result2).getApplicabilityLevel() == 2;
            for (int i = 0; i < args.length; ++i) {
                PsiType parameterType = substitutor2.substitute(PsiTypesUtil.getParameterType(parameters2, i, varargs));
                PsiType expressionType = args[i];
                if (expressionType == null || parameterType == null || !JavaGenericsUtil.isRawToGeneric(parameterType, expressionType)) continue;
                return TypeConversionUtil.erasure(substitutedReturnType);
            }
        }
        if (PsiUtil.isRawSubstitutor(method, substitutor2)) {
            PsiType returnTypeErasure = TypeConversionUtil.erasure(ret);
            if (Comparing.equal(TypeConversionUtil.erasure(substitutedReturnType), returnTypeErasure)) {
                return returnTypeErasure;
            }
        }
        return PsiUtil.captureToplevelWildcards(substitutedReturnType, call2);
    }

    private static class TypeEvaluator
    implements Function<PsiMethodCallExpression, PsiType> {
        private TypeEvaluator() {
        }

        @Override
        @Nullable
        public PsiType fun(PsiMethodCallExpression call2) {
            PsiReferenceExpression methodExpression = call2.getMethodExpression();
            PsiType theOnly = null;
            JavaResolveResult[] results = methodExpression.multiResolve(false);
            LanguageLevel languageLevel = PsiUtil.getLanguageLevel(call2);
            PsiElement callParent = PsiUtil.skipParenthesizedExprUp(call2.getParent());
            Object parentArgList = languageLevel.isAtLeast(LanguageLevel.JDK_1_8) ? (callParent instanceof PsiConditionalExpression && !PsiPolyExpressionUtil.isPolyExpression((PsiExpression)callParent) ? null : PsiTreeUtil.getParentOfType((PsiElement)call2, PsiExpressionList.class)) : null;
            MethodCandidateInfo.CurrentCandidateProperties properties2 = MethodCandidateInfo.getCurrentMethod(parentArgList);
            boolean genericMethodCall = properties2 != null && properties2.getInfo().isToInferApplicability();
            for (int i = 0; i < results.length; ++i) {
                PsiType type2;
                JavaResolveResult candidateInfo = results[i];
                if (genericMethodCall && PsiPolyExpressionUtil.isMethodCallPolyExpression(call2, (PsiMethod)candidateInfo.getElement())) {
                    if (callParent instanceof PsiAssignmentExpression) {
                        return null;
                    }
                    LOG.error("poly expression evaluation during overload resolution");
                }
                if ((type2 = TypeEvaluator.getResultType(call2, methodExpression, candidateInfo, languageLevel)) == null) {
                    return null;
                }
                if (i == 0) {
                    theOnly = type2;
                    continue;
                }
                if (theOnly.equals(type2)) continue;
                return null;
            }
            return PsiClassImplUtil.correctType(theOnly, call2.getResolveScope());
        }

        @Nullable
        private static PsiType getResultType(PsiMethodCallExpression call2, PsiReferenceExpression methodExpression, JavaResolveResult result2, @NotNull LanguageLevel languageLevel) {
            if (languageLevel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiMethodCallExpressionImpl$TypeEvaluator", "getResultType"));
            }
            PsiMethod method = (PsiMethod)result2.getElement();
            if (method == null) {
                return null;
            }
            boolean is15OrHigher = languageLevel.compareTo(LanguageLevel.JDK_1_5) >= 0;
            PsiType getClassReturnType = PsiTypesUtil.patchMethodGetClassReturnType(call2, methodExpression, method, type2 -> type2 != JavaElementType.CLASS, languageLevel);
            if (getClassReturnType != null) {
                return getClassReturnType;
            }
            PsiType ret = method.getReturnType();
            if (ret == null) {
                return null;
            }
            if (ret instanceof PsiClassType) {
                ret = ((PsiClassType)ret).setLanguageLevel(languageLevel);
            }
            if (is15OrHigher) {
                return PsiMethodCallExpressionImpl.captureReturnType(call2, method, ret, result2, languageLevel);
            }
            return TypeConversionUtil.erasure(ret);
        }
    }
}

