/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.intrinsic.functions;

import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.google.common.collect.Lists;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.gnu.trove.THashMap;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.basic.FunctionIntrinsic;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.ArrayFIF;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.AsDynamicFIF;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.ExceptionPropertyIntrinsicFactory;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.FunctionIntrinsicFactory;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.LongOperationFIF;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.NumberAndCharConversionFIF;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.PrimitiveBinaryOperationFIF;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.PrimitiveUnaryOperationFIF;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.ThrowableConstructorIntrinsicFactory;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.TopLevelFIF;
import org.jetbrains.kotlin.js.translate.intrinsic.operation.StringPlusCharFIF;

public final class FunctionIntrinsics {
    @NotNull
    private final Map<FunctionDescriptor, FunctionIntrinsic> intrinsicCache = new THashMap<FunctionDescriptor, FunctionIntrinsic>();
    @NotNull
    private final List<FunctionIntrinsicFactory> factories = Lists.newArrayList();

    public FunctionIntrinsics() {
        this.registerFactories();
    }

    private void registerFactories() {
        this.register(LongOperationFIF.INSTANCE);
        this.register(PrimitiveUnaryOperationFIF.INSTANCE);
        this.register(StringPlusCharFIF.INSTANCE);
        this.register(PrimitiveBinaryOperationFIF.INSTANCE);
        this.register(ArrayFIF.INSTANCE);
        this.register(TopLevelFIF.INSTANCE);
        this.register(NumberAndCharConversionFIF.INSTANCE);
        this.register(ThrowableConstructorIntrinsicFactory.INSTANCE);
        this.register(ExceptionPropertyIntrinsicFactory.INSTANCE);
        this.register(AsDynamicFIF.INSTANCE);
    }

    private void register(@NotNull FunctionIntrinsicFactory instance) {
        this.factories.add(instance);
    }

    @NotNull
    public FunctionIntrinsic getIntrinsic(@NotNull FunctionDescriptor descriptor2) {
        FunctionIntrinsic intrinsic = this.lookUpCache(descriptor2);
        if (intrinsic != null) {
            return intrinsic;
        }
        intrinsic = this.computeAndCacheIntrinsic(descriptor2);
        return intrinsic;
    }

    @Nullable
    private FunctionIntrinsic lookUpCache(@NotNull FunctionDescriptor descriptor2) {
        return this.intrinsicCache.get(descriptor2);
    }

    @NotNull
    private FunctionIntrinsic computeAndCacheIntrinsic(@NotNull FunctionDescriptor descriptor2) {
        FunctionIntrinsic result2 = this.computeIntrinsic(descriptor2);
        this.intrinsicCache.put(descriptor2, result2);
        return result2;
    }

    @NotNull
    private FunctionIntrinsic computeIntrinsic(@NotNull FunctionDescriptor descriptor2) {
        for (FunctionIntrinsicFactory factory2 : this.factories) {
            FunctionIntrinsic intrinsic = factory2.getIntrinsic(descriptor2);
            if (intrinsic == null) continue;
            return intrinsic;
        }
        return FunctionIntrinsic.NO_INTRINSIC;
    }
}

