/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.List;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.DependencySubstitutions;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.initialization.IncludedBuild;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.LocalComponentRegistry;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.tasks.TaskReference;
import org.gradle.composite.internal.IncludedBuildInternal;
import org.gradle.composite.internal.IncludedBuildTaskReference;
import org.gradle.initialization.GradleLauncher;
import org.gradle.internal.Factory;
import org.gradle.internal.Pair;
import org.gradle.internal.component.local.model.DefaultLocalComponentMetadata;
import org.gradle.internal.component.local.model.DefaultProjectComponentIdentifier;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.work.WorkerLeaseRegistry;
import org.gradle.internal.work.WorkerLeaseService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultIncludedBuild
implements IncludedBuildInternal,
Stoppable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultIncludedBuild.class);
    private final File projectDir;
    private final Factory<GradleLauncher> gradleLauncherFactory;
    private final WorkerLeaseRegistry.WorkerLease parentLease;
    private final List<Action<? super DependencySubstitutions>> dependencySubstitutionActions = Lists.newArrayList();
    private boolean resolvedDependencySubstitutions;
    private GradleLauncher gradleLauncher;
    private String name;
    private Set<Pair<ModuleVersionIdentifier, ProjectComponentIdentifier>> availableModules;

    public DefaultIncludedBuild(File projectDir, Factory<GradleLauncher> launcherFactory, WorkerLeaseRegistry.WorkerLease parentLease) {
        this.projectDir = projectDir;
        this.gradleLauncherFactory = launcherFactory;
        this.parentLease = parentLease;
    }

    public File getProjectDir() {
        return this.projectDir;
    }

    public TaskReference task(String path) {
        Preconditions.checkArgument((boolean)path.startsWith(":"), (String)"Task path '%s' is not a qualified task path (e.g. ':task' or ':project:task').", (Object[])new Object[]{path});
        return new IncludedBuildTaskReference(this.getName(), path);
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.getLoadedSettings().getRootProject().getName();
        }
        return this.name;
    }

    public void dependencySubstitution(Action<? super DependencySubstitutions> action) {
        if (this.resolvedDependencySubstitutions) {
            throw new IllegalStateException("Cannot configure included build after dependency substitutions are resolved.");
        }
        this.dependencySubstitutionActions.add(action);
    }

    @Override
    public List<Action<? super DependencySubstitutions>> getRegisteredDependencySubstitutions() {
        this.resolvedDependencySubstitutions = true;
        return this.dependencySubstitutionActions;
    }

    @Override
    public Set<Pair<ModuleVersionIdentifier, ProjectComponentIdentifier>> getAvailableModules() {
        if (this.availableModules == null) {
            GradleInternal gradle = this.getConfiguredBuild();
            this.availableModules = Sets.newLinkedHashSet();
            for (Project project : gradle.getRootProject().getAllprojects()) {
                this.registerProject(this.availableModules, (ProjectInternal)project);
            }
        }
        return this.availableModules;
    }

    private void registerProject(Set<Pair<ModuleVersionIdentifier, ProjectComponentIdentifier>> availableModules, ProjectInternal project) {
        LocalComponentRegistry localComponentRegistry = (LocalComponentRegistry)project.getServices().get(LocalComponentRegistry.class);
        ProjectComponentIdentifier originalIdentifier = DefaultProjectComponentIdentifier.newProjectId((Project)project);
        DefaultLocalComponentMetadata originalComponent = (DefaultLocalComponentMetadata)localComponentRegistry.getComponent(originalIdentifier);
        ProjectComponentIdentifier componentIdentifier = DefaultProjectComponentIdentifier.newProjectId((IncludedBuild)this, (String)project.getPath());
        ModuleVersionIdentifier moduleId = originalComponent.getId();
        LOGGER.info("Registering " + project + " in composite build. Will substitute for module '" + moduleId.getModule() + "'.");
        availableModules.add((Pair<ModuleVersionIdentifier, ProjectComponentIdentifier>)Pair.of((Object)moduleId, (Object)componentIdentifier));
    }

    @Override
    public SettingsInternal getLoadedSettings() {
        return this.getGradleLauncher().getLoadedSettings();
    }

    @Override
    public GradleInternal getConfiguredBuild() {
        return this.getGradleLauncher().getConfiguredBuild();
    }

    @Override
    public void finishBuild() {
        if (this.gradleLauncher == null) {
            return;
        }
        this.getGradleLauncher().finishBuild();
    }

    @Override
    public synchronized void addTasks(Iterable<String> taskPaths) {
        this.getGradleLauncher().scheduleTasks(taskPaths);
    }

    private GradleLauncher getGradleLauncher() {
        if (this.gradleLauncher == null) {
            this.gradleLauncher = (GradleLauncher)this.gradleLauncherFactory.create();
        }
        return this.gradleLauncher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void execute(Iterable<String> tasks, Object listener) {
        final GradleLauncher launcher = this.getGradleLauncher();
        launcher.addListener(listener);
        launcher.scheduleTasks(tasks);
        WorkerLeaseService workerLeaseService = (WorkerLeaseService)this.gradleLauncher.getGradle().getServices().get(WorkerLeaseService.class);
        try {
            workerLeaseService.withSharedLease(this.parentLease, new Runnable(){

                @Override
                public void run() {
                    launcher.executeTasks();
                }
            });
        }
        finally {
            this.markAsNotReusable();
        }
    }

    private void markAsNotReusable() {
        this.gradleLauncher.stop();
        this.gradleLauncher = null;
    }

    public String toString() {
        return String.format("includedBuild[%s]", this.projectDir.getName());
    }

    public void stop() {
        if (this.gradleLauncher != null) {
            this.gradleLauncher.stop();
        }
    }
}

