/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.nativeplatform.internal.incremental;

import com.google.common.base.Objects;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.internal.changedetection.state.FileSnapshot;
import org.gradle.api.internal.changedetection.state.FileSystemSnapshotter;
import org.gradle.internal.file.FileType;
import org.gradle.language.nativeplatform.internal.Expression;
import org.gradle.language.nativeplatform.internal.Include;
import org.gradle.language.nativeplatform.internal.IncludeDirectives;
import org.gradle.language.nativeplatform.internal.IncludeType;
import org.gradle.language.nativeplatform.internal.Macro;
import org.gradle.language.nativeplatform.internal.MacroFunction;
import org.gradle.language.nativeplatform.internal.incremental.MacroLookup;
import org.gradle.language.nativeplatform.internal.incremental.SourceIncludesResolver;
import org.gradle.language.nativeplatform.internal.incremental.TokenLookup;
import org.gradle.language.nativeplatform.internal.incremental.sourceparser.ComplexExpression;
import org.gradle.language.nativeplatform.internal.incremental.sourceparser.SimpleExpression;

public class DefaultSourceIncludesResolver
implements SourceIncludesResolver {
    private final List<File> includePaths;
    private final FileSystemSnapshotter fileSystemSnapshotter;
    private final Map<File, Map<String, IncludeFileImpl>> includeRoots;

    public DefaultSourceIncludesResolver(List<File> includePaths, FileSystemSnapshotter fileSystemSnapshotter) {
        this.includePaths = includePaths;
        this.fileSystemSnapshotter = fileSystemSnapshotter;
        this.includeRoots = new HashMap<File, Map<String, IncludeFileImpl>>();
    }

    @Override
    public SourceIncludesResolver.IncludeResolutionResult resolveInclude(File sourceFile, Include include, MacroLookup visibleMacros) {
        BuildableResult results = new BuildableResult();
        this.resolveExpression(visibleMacros, (Expression)include, new PathResolvingVisitor(sourceFile, results), new TokenLookup());
        return results;
    }

    private void resolveExpression(MacroLookup visibleMacros, Expression expression, ExpressionVisitor visitor, TokenLookup tokenLookup) {
        if (expression.getType() == IncludeType.SYSTEM) {
            visitor.visitSystem(expression);
        } else if (expression.getType() == IncludeType.QUOTED) {
            visitor.visitQuoted(expression);
        } else if (expression.getType() == IncludeType.IDENTIFIER) {
            visitor.visitIdentifier(expression);
        } else if (expression.getType() == IncludeType.ARGS_LIST) {
            visitor.visitTokens(expression);
        } else {
            if (!visitor.startVisit(expression)) {
                return;
            }
            if (expression.getType() == IncludeType.MACRO) {
                this.resolveMacro(visibleMacros, expression, visitor, tokenLookup);
            } else if (expression.getType() == IncludeType.MACRO_FUNCTION) {
                this.resolveMacroFunction(visibleMacros, expression, visitor, tokenLookup);
            } else if (expression.getType() == IncludeType.TOKEN_CONCATENATION) {
                this.resolveTokenConcatenation(visibleMacros, expression, visitor, tokenLookup);
            } else if (expression.getType() == IncludeType.EXPAND_TOKEN_CONCATENATION) {
                this.resolveAndExpandTokenConcatenation(visibleMacros, expression, visitor, tokenLookup);
            } else if (expression.getType() == IncludeType.EXPRESSIONS) {
                this.resolveExpressionSequence(visibleMacros, expression, visitor, tokenLookup);
            } else {
                visitor.visitUnresolved();
            }
        }
    }

    private void resolveExpressionSequence(MacroLookup visibleMacros, Expression expression, ExpressionVisitor visitor, TokenLookup tokenLookup) {
        List expressions = expression.getArguments();
        if (expressions.size() < 2) {
            visitor.visitUnresolved();
            return;
        }
        Expression argListExpression = (Expression)expressions.get(expressions.size() - 1);
        List<Expression> headExpressions = expressions.subList(0, expressions.size() - 1);
        Collection<Expression> args = this.resolveExpressionToTokens(visibleMacros, argListExpression, visitor, tokenLookup);
        for (Expression value : args) {
            this.resolveExpressionSequenceForArgs(visibleMacros, headExpressions, value, visitor, tokenLookup);
        }
    }

    private void resolveExpressionSequenceForArgs(MacroLookup visibleMacros, List<Expression> expressions, Expression args, ExpressionVisitor visitor, TokenLookup tokenLookup) {
        if (args.getType() != IncludeType.ARGS_LIST) {
            visitor.visitUnresolved();
            return;
        }
        Expression macroFunctionExpression = expressions.get(expressions.size() - 1);
        List<Expression> headExpressions = expressions.subList(0, expressions.size() - 1);
        Collection<Expression> identifiers = this.resolveExpressionToTokens(visibleMacros, macroFunctionExpression, visitor, tokenLookup);
        for (Expression value : identifiers) {
            if (value.getType() != IncludeType.IDENTIFIER) {
                visitor.visitUnresolved();
                continue;
            }
            ComplexExpression macroExpression = new ComplexExpression(IncludeType.MACRO_FUNCTION, value.getValue(), args.getArguments());
            if (headExpressions.isEmpty()) {
                this.resolveExpression(visibleMacros, macroExpression, visitor, tokenLookup);
                return;
            }
            Collection<Expression> resolved = this.resolveExpressionToTokens(visibleMacros, macroExpression, visitor, tokenLookup);
            for (Expression newArgs : resolved) {
                this.resolveExpressionSequenceForArgs(visibleMacros, headExpressions, newArgs, visitor, tokenLookup);
            }
        }
    }

    private void resolveTokenConcatenation(MacroLookup visibleMacros, Expression expression, ExpressionVisitor visitor, TokenLookup tokenLookup) {
        Collection<Expression> expressions = this.resolveTokenConcatenationToTokens(visibleMacros, expression, visitor, tokenLookup);
        for (Expression concatExpression : expressions) {
            this.resolveExpression(visibleMacros, concatExpression, visitor, tokenLookup);
        }
    }

    private void resolveAndExpandTokenConcatenation(MacroLookup visibleMacros, Expression expression, ExpressionVisitor visitor, TokenLookup tokenLookup) {
        Collection<Expression> expressions = this.resolveTokenConcatenationToTokens(visibleMacros, expression, visitor, tokenLookup);
        for (Expression concatExpression : expressions) {
            this.resolveExpression(visibleMacros, concatExpression.asMacroExpansion(), visitor, tokenLookup);
        }
    }

    private Collection<Expression> resolveExpressionToTokens(MacroLookup visibleMacros, Expression expression, ExpressionVisitor visitor, TokenLookup tokenLookup) {
        if (expression.getType() == IncludeType.TOKEN_CONCATENATION) {
            return this.resolveTokenConcatenationToTokens(visibleMacros, expression, visitor, tokenLookup);
        }
        if (expression.getType() != IncludeType.MACRO && expression.getType() != IncludeType.MACRO_FUNCTION && expression.getType() != IncludeType.EXPAND_TOKEN_CONCATENATION) {
            return Collections.singletonList(expression);
        }
        if (!tokenLookup.hasTokensFor(expression)) {
            this.resolveExpression(visibleMacros, expression, new CollectTokens(tokenLookup, expression), tokenLookup);
        }
        if (tokenLookup.isUnresolved(expression)) {
            visitor.visitUnresolved();
        }
        return tokenLookup.tokensFor(expression);
    }

    private Collection<Expression> resolveTokenConcatenationToTokens(MacroLookup visibleMacros, Expression expression, ExpressionVisitor visitor, TokenLookup tokenLookup) {
        Expression left = (Expression)expression.getArguments().get(0);
        Expression right = (Expression)expression.getArguments().get(1);
        Collection<Expression> leftValues = this.resolveExpressionToTokens(visibleMacros, left, visitor, tokenLookup);
        Collection<Expression> rightValues = this.resolveExpressionToTokens(visibleMacros, right, visitor, tokenLookup);
        if (leftValues.isEmpty() || rightValues.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Expression> expressions = new ArrayList<Expression>(leftValues.size() * rightValues.size());
        for (Expression leftValue : leftValues) {
            if (leftValue.getType() != IncludeType.IDENTIFIER) {
                Expression rightValue;
                if (rightValues.size() == 1 && (rightValue = rightValues.iterator().next()).getType() == IncludeType.EXPRESSIONS && rightValue.getArguments().isEmpty()) {
                    expressions.add(leftValue);
                    continue;
                }
                visitor.visitUnresolved();
                continue;
            }
            String leftString = leftValue.getValue();
            for (Expression rightValue : rightValues) {
                if (rightValue.getType() == IncludeType.IDENTIFIER) {
                    expressions.add(new SimpleExpression(leftString + rightValue.getValue(), IncludeType.IDENTIFIER));
                    continue;
                }
                if (rightValue.getType() == IncludeType.ARGS_LIST) {
                    expressions.add(new ComplexExpression(IncludeType.MACRO_FUNCTION, leftString, rightValue.getArguments()));
                    continue;
                }
                if (rightValue.getType() == IncludeType.EXPRESSIONS && rightValue.getArguments().isEmpty()) {
                    expressions.add(new SimpleExpression(leftString, IncludeType.IDENTIFIER));
                    continue;
                }
                visitor.visitUnresolved();
            }
        }
        return expressions;
    }

    private void resolveMacro(MacroLookup visibleMacros, Expression expression, ExpressionVisitor visitor, TokenLookup tokenLookup) {
        boolean found = false;
        for (IncludeDirectives includeDirectives : visibleMacros) {
            for (Macro macro : includeDirectives.getMacros()) {
                if (!expression.getValue().equals(macro.getName())) continue;
                found = true;
                this.resolveExpression(visibleMacros, (Expression)macro, visitor, tokenLookup);
            }
        }
        if (!found) {
            visitor.visitIdentifier(new SimpleExpression(expression.getValue(), IncludeType.IDENTIFIER));
        }
    }

    private void resolveMacroFunction(MacroLookup visibleMacros, Expression expression, ExpressionVisitor visitor, TokenLookup tokenLookup) {
        boolean found = false;
        for (IncludeDirectives includeDirectives : visibleMacros) {
            for (MacroFunction macro : includeDirectives.getMacrosFunctions()) {
                if (!expression.getValue().equals(macro.getName())) continue;
                List<Expression> arguments = expression.getArguments();
                if (arguments.isEmpty() && macro.getParameterCount() == 1) {
                    arguments = Collections.singletonList(SimpleExpression.EMPTY_EXPRESSIONS);
                }
                if (macro.getParameterCount() != arguments.size()) continue;
                found = true;
                Expression result = macro.evaluate(arguments);
                this.resolveExpression(visibleMacros, result, visitor, tokenLookup);
            }
        }
        if (!found) {
            visitor.visitUnresolved();
        }
    }

    private List<File> prependSourceDir(File sourceFile, List<File> includePaths) {
        File sourceDir = sourceFile.getParentFile();
        if (includePaths.size() > 1 && includePaths.get(0).equals(sourceDir)) {
            return includePaths;
        }
        ArrayList<File> quotedSearchPath = new ArrayList<File>(includePaths.size() + 1);
        quotedSearchPath.add(sourceDir);
        quotedSearchPath.addAll(includePaths);
        return quotedSearchPath;
    }

    private void searchForDependency(List<File> searchPath, String include, BuildableResult dependencies) {
        for (File searchDir : searchPath) {
            Map<String, IncludeFileImpl> searchedIncludes = this.includeRoots.get(searchDir);
            if (searchedIncludes == null) {
                searchedIncludes = new HashMap<String, IncludeFileImpl>();
                this.includeRoots.put(searchDir, searchedIncludes);
            }
            if (searchedIncludes.containsKey(include)) {
                IncludeFileImpl includeFile = searchedIncludes.get(include);
                if (includeFile.snapshot.getType() != FileType.RegularFile) continue;
                dependencies.resolved(includeFile);
                return;
            }
            File candidate = new File(searchDir, include);
            FileSnapshot fileSnapshot = this.fileSystemSnapshotter.snapshotSelf(candidate);
            IncludeFileImpl includeFile = fileSnapshot.getType() == FileType.RegularFile ? new IncludeFileImpl(candidate, fileSnapshot) : new IncludeFileImpl(null, fileSnapshot);
            searchedIncludes.put(include, includeFile);
            if (fileSnapshot.getType() != FileType.RegularFile) continue;
            dependencies.resolved(includeFile);
            return;
        }
    }

    private class PathResolvingVisitor
    implements ExpressionVisitor {
        private final File sourceFile;
        private final BuildableResult results;
        private final Set<Expression> seen = new HashSet<Expression>();
        Set<String> quoted = new HashSet<String>();
        Set<String> system = new HashSet<String>();

        PathResolvingVisitor(File sourceFile, BuildableResult results) {
            this.sourceFile = sourceFile;
            this.results = results;
        }

        @Override
        public boolean startVisit(Expression expression) {
            return this.seen.add(expression);
        }

        @Override
        public void visitQuoted(Expression value) {
            String path = value.getValue();
            if (!this.quoted.add(path)) {
                return;
            }
            List quotedSearchPath = DefaultSourceIncludesResolver.this.prependSourceDir(this.sourceFile, DefaultSourceIncludesResolver.this.includePaths);
            DefaultSourceIncludesResolver.this.searchForDependency(quotedSearchPath, path, this.results);
        }

        @Override
        public void visitSystem(Expression value) {
            String path = value.getValue();
            if (!this.system.add(path)) {
                return;
            }
            DefaultSourceIncludesResolver.this.searchForDependency(DefaultSourceIncludesResolver.this.includePaths, path, this.results);
        }

        @Override
        public void visitIdentifier(Expression value) {
            this.results.unresolved();
        }

        @Override
        public void visitTokens(Expression tokens) {
            this.results.unresolved();
        }

        @Override
        public void visitUnresolved() {
            this.results.unresolved();
        }
    }

    private static class CollectTokens
    implements ExpressionVisitor {
        private final Set<Expression> seen = new HashSet<Expression>();
        private final TokenLookup tokenLookup;
        private final Expression expression;

        CollectTokens(TokenLookup tokenLookup, Expression expression) {
            this.tokenLookup = tokenLookup;
            this.expression = expression;
        }

        @Override
        public boolean startVisit(Expression expression) {
            return this.seen.add(expression);
        }

        @Override
        public void visitQuoted(Expression value) {
            this.visitTokens(value);
        }

        @Override
        public void visitSystem(Expression value) {
            this.visitTokens(value);
        }

        @Override
        public void visitIdentifier(Expression value) {
            this.visitTokens(value);
        }

        @Override
        public void visitTokens(Expression tokens) {
            this.tokenLookup.addTokensFor(this.expression, tokens);
        }

        @Override
        public void visitUnresolved() {
            this.tokenLookup.unresolved(this.expression);
        }
    }

    private static class BuildableResult
    implements SourceIncludesResolver.IncludeResolutionResult {
        private final Set<SourceIncludesResolver.IncludeFile> files = new LinkedHashSet<SourceIncludesResolver.IncludeFile>();
        private boolean missing;

        private BuildableResult() {
        }

        void resolved(SourceIncludesResolver.IncludeFile includeFile) {
            this.files.add(includeFile);
        }

        void unresolved() {
            this.missing = true;
        }

        @Override
        public boolean isComplete() {
            return !this.missing;
        }

        public Set<SourceIncludesResolver.IncludeFile> getFiles() {
            return this.files;
        }
    }

    private static interface ExpressionVisitor {
        public boolean startVisit(Expression var1);

        public void visitQuoted(Expression var1);

        public void visitSystem(Expression var1);

        public void visitIdentifier(Expression var1);

        public void visitTokens(Expression var1);

        public void visitUnresolved();
    }

    private static class IncludeFileImpl
    implements SourceIncludesResolver.IncludeFile {
        final File file;
        final FileSnapshot snapshot;

        IncludeFileImpl(File file, FileSnapshot snapshot) {
            this.file = file;
            this.snapshot = snapshot;
        }

        @Override
        public File getFile() {
            return this.file;
        }

        @Override
        public FileSnapshot getSnapshot() {
            return this.snapshot;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            IncludeFileImpl other = (IncludeFileImpl)obj;
            return Objects.equal((Object)this.file, (Object)other.file) && this.snapshot.equals(other.snapshot);
        }

        public int hashCode() {
            return this.snapshot.hashCode();
        }
    }
}

