/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.nativeplatform.internal.incremental;

import org.gradle.api.NonNullApi;
import org.gradle.api.internal.TaskOutputsInternal;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.WorkResults;
import org.gradle.cache.PersistentStateCache;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.language.base.internal.tasks.SimpleStaleClassCleaner;
import org.gradle.language.nativeplatform.internal.incremental.CompilationState;
import org.gradle.language.nativeplatform.internal.incremental.IncrementalCompilation;
import org.gradle.nativeplatform.toolchain.internal.NativeCompileSpec;

@NonNullApi
public class IncrementalNativeCompiler<T extends NativeCompileSpec>
implements Compiler<T> {
    private final Compiler<T> delegateCompiler;
    private final TaskOutputsInternal outputs;
    private final PersistentStateCache<CompilationState> compileStateCache;
    private final IncrementalCompilation incrementalCompilation;

    public IncrementalNativeCompiler(TaskOutputsInternal outputs, Compiler<T> delegateCompiler, PersistentStateCache<CompilationState> compileStateCache, IncrementalCompilation incrementalCompilation) {
        this.outputs = outputs;
        this.delegateCompiler = delegateCompiler;
        this.compileStateCache = compileStateCache;
        this.incrementalCompilation = incrementalCompilation;
    }

    public WorkResult execute(T spec) {
        spec.setSourceFileIncludeDirectives(this.incrementalCompilation.getSourceFileIncludeDirectives());
        WorkResult workResult = spec.isIncrementalCompile() ? this.doIncrementalCompile(this.incrementalCompilation, spec) : this.doCleanIncrementalCompile(spec);
        this.compileStateCache.set((Object)this.incrementalCompilation.getFinalState());
        return workResult;
    }

    protected WorkResult doIncrementalCompile(IncrementalCompilation compilation, T spec) {
        spec.setSourceFiles(compilation.getRecompile());
        spec.setRemovedSourceFiles(compilation.getRemoved());
        return this.delegateCompiler.execute(spec);
    }

    protected WorkResult doCleanIncrementalCompile(T spec) {
        boolean deleted = this.cleanPreviousOutputs((NativeCompileSpec)spec);
        WorkResult compileResult = this.delegateCompiler.execute(spec);
        if (deleted && !compileResult.getDidWork()) {
            return WorkResults.didWork((boolean)true);
        }
        return compileResult;
    }

    private boolean cleanPreviousOutputs(NativeCompileSpec spec) {
        SimpleStaleClassCleaner cleaner = new SimpleStaleClassCleaner(this.outputs);
        cleaner.setDestinationDir(spec.getObjectFileDir());
        cleaner.execute();
        return cleaner.getDidWork();
    }
}

