/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.nativeplatform.tasks;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.Incubating;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.TaskFileVarFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;
import org.gradle.internal.Cast;
import org.gradle.internal.operations.logging.BuildOperationLogger;
import org.gradle.internal.operations.logging.BuildOperationLoggerFactory;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.language.nativeplatform.internal.incremental.IncrementalCompilerBuilder;
import org.gradle.nativeplatform.internal.BuildOperationLoggingCompilerDecorator;
import org.gradle.nativeplatform.platform.NativePlatform;
import org.gradle.nativeplatform.platform.internal.NativePlatformInternal;
import org.gradle.nativeplatform.toolchain.NativeToolChain;
import org.gradle.nativeplatform.toolchain.internal.NativeCompileSpec;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainInternal;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;

@Incubating
public abstract class AbstractNativeCompileTask
extends DefaultTask {
    private NativeToolChainInternal toolChain;
    private NativePlatformInternal targetPlatform;
    private boolean positionIndependentCode;
    private boolean debug;
    private boolean optimize;
    private final DirectoryProperty objectFileDir;
    private final ConfigurableFileCollection includes;
    private final ConfigurableFileCollection source;
    private final Map<String, String> macros = new LinkedHashMap<String, String>();
    private final ListProperty<String> compilerArgs;
    private final IncrementalCompilerBuilder.IncrementalCompiler incrementalCompiler;

    public AbstractNativeCompileTask() {
        this.includes = this.getProject().files(new Object[0]);
        this.source = this.getTaskFileVarFactory().newInputFileCollection((Task)this);
        this.objectFileDir = this.newOutputDirectory();
        this.compilerArgs = this.getProject().getObjects().listProperty(String.class);
        this.incrementalCompiler = this.getIncrementalCompilerBuilder().newCompiler((TaskInternal)this, (FileCollection)this.source, (FileCollection)this.includes);
        this.dependsOn(new Object[]{this.includes});
    }

    @Inject
    protected TaskFileVarFactory getTaskFileVarFactory() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected IncrementalCompilerBuilder getIncrementalCompilerBuilder() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected BuildOperationLoggerFactory getOperationLoggerFactory() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected FileCollectionFactory getFileCollectionFactory() {
        throw new UnsupportedOperationException();
    }

    @TaskAction
    public void compile(IncrementalTaskInputs inputs) {
        BuildOperationLogger operationLogger = this.getOperationLoggerFactory().newOperationLogger(this.getName(), this.getTemporaryDir());
        NativeCompileSpec spec = this.createCompileSpec();
        spec.setTargetPlatform((NativePlatform)this.targetPlatform);
        spec.setTempDir(this.getTemporaryDir());
        spec.setObjectFileDir(((Directory)this.objectFileDir.get()).getAsFile());
        spec.include((Iterable)this.includes);
        spec.source((Iterable)this.getSource());
        spec.setMacros(this.getMacros());
        spec.args((List)this.getCompilerArgs().get());
        spec.setPositionIndependentCode(this.isPositionIndependentCode());
        spec.setDebuggable(this.isDebuggable());
        spec.setOptimized(this.isOptimized());
        spec.setIncrementalCompile(inputs.isIncremental());
        spec.setOperationLogger(operationLogger);
        this.configureSpec(spec);
        PlatformToolProvider platformToolProvider = this.toolChain.select(this.targetPlatform);
        this.setDidWork(this.doCompile(spec, platformToolProvider).getDidWork());
    }

    protected void configureSpec(NativeCompileSpec spec) {
    }

    private <T extends NativeCompileSpec> WorkResult doCompile(T spec, PlatformToolProvider platformToolProvider) {
        Class specType = (Class)Cast.uncheckedCast(spec.getClass());
        Compiler baseCompiler = platformToolProvider.newCompiler(specType);
        Compiler incrementalCompiler = this.incrementalCompiler.createCompiler(baseCompiler);
        Compiler loggingCompiler = BuildOperationLoggingCompilerDecorator.wrap(incrementalCompiler);
        return loggingCompiler.execute(spec);
    }

    protected abstract NativeCompileSpec createCompileSpec();

    @Internal
    public NativeToolChain getToolChain() {
        return this.toolChain;
    }

    public void setToolChain(NativeToolChain toolChain) {
        this.toolChain = (NativeToolChainInternal)toolChain;
        this.incrementalCompiler.setToolChain(this.toolChain);
    }

    @Nested
    public NativePlatform getTargetPlatform() {
        return this.targetPlatform;
    }

    public void setTargetPlatform(NativePlatform targetPlatform) {
        this.targetPlatform = (NativePlatformInternal)targetPlatform;
    }

    @Input
    public boolean isPositionIndependentCode() {
        return this.positionIndependentCode;
    }

    public void setPositionIndependentCode(boolean positionIndependentCode) {
        this.positionIndependentCode = positionIndependentCode;
    }

    @Input
    public boolean isDebuggable() {
        return this.debug;
    }

    public void setDebuggable(boolean debug) {
        this.debug = debug;
    }

    @Input
    public boolean isOptimized() {
        return this.optimize;
    }

    public void setOptimized(boolean optimize) {
        this.optimize = optimize;
    }

    @OutputDirectory
    public DirectoryProperty getObjectFileDir() {
        return this.objectFileDir;
    }

    @Internal(value="The paths for include directories are tracked via the includePaths property, the contents are tracked via discovered inputs")
    public ConfigurableFileCollection getIncludes() {
        return this.includes;
    }

    public void includes(Object includeRoots) {
        this.includes.from(new Object[]{includeRoots});
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public ConfigurableFileCollection getSource() {
        return this.source;
    }

    public void source(Object sourceFiles) {
        this.source.from(new Object[]{sourceFiles});
    }

    @Input
    public Map<String, String> getMacros() {
        return this.macros;
    }

    public void setMacros(Map<String, String> macros) {
        this.macros.clear();
        this.macros.putAll(macros);
    }

    @Input
    public ListProperty<String> getCompilerArgs() {
        return this.compilerArgs;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    protected FileCollection getHeaderDependencies() {
        return this.incrementalCompiler.getHeaderFiles();
    }
}

