/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.transport;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.simpleframework.transport.Packet;
import org.simpleframework.transport.PacketAllocator;

class PacketBuilder {
    private PacketAllocator allocator;
    private Packet packet;
    private int size;

    public PacketBuilder() {
        this(3);
    }

    public PacketBuilder(int limit) {
        this(3, 4098);
    }

    public PacketBuilder(int limit, int size) {
        this.allocator = new PacketAllocator(limit, size);
        this.size = size;
    }

    public Packet build() throws IOException {
        Packet local = null;
        if (this.packet != null) {
            int length = this.packet.length();
            if (length <= 0) {
                this.packet.close();
            } else {
                local = this.packet;
            }
            this.packet = null;
        }
        return local;
    }

    public Packet build(ByteBuffer buffer) throws IOException {
        int ready = buffer.remaining();
        if (this.packet != null) {
            return this.build(buffer, this.packet);
        }
        if (ready > this.size) {
            return this.allocator.allocate(buffer);
        }
        if (ready > 0) {
            if (this.packet == null) {
                this.packet = this.allocator.allocate();
            }
            return this.build(buffer, this.packet);
        }
        return null;
    }

    private Packet build(ByteBuffer buffer, Packet packet) throws IOException {
        int ready = buffer.remaining();
        int length = packet.length();
        int space = packet.space();
        if (ready > space) {
            int capacity = buffer.capacity();
            if (length == 0) {
                return this.allocator.allocate(buffer);
            }
            if (space < capacity) {
                if (space > 0) {
                    packet.append(buffer);
                }
                return this.build();
            }
            return this.allocator.allocate(buffer);
        }
        packet.append(buffer);
        if (space == ready) {
            return this.build();
        }
        return null;
    }
}

