/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.annotation.Nullable;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.gradle.internal.SystemProperties;

public class PropertiesUtils {
    public static void store(Properties properties, OutputStream outputStream, @Nullable String comment, Charset charset, String lineSeparator) throws IOException {
        List nonCommentLines;
        String rawContents;
        Object out;
        if (charset.equals(Charsets.ISO_8859_1)) {
            out = new ByteArrayOutputStream();
            properties.store((OutputStream)out, comment);
            rawContents = new String(out.toByteArray(), Charsets.ISO_8859_1);
        } else {
            out = new StringWriter();
            properties.store((Writer)out, comment);
            rawContents = ((StringWriter)out).toString();
        }
        String systemLineSeparator = SystemProperties.getInstance().getLineSeparator();
        ArrayList lines = Lists.newArrayList((Iterable)Splitter.on((String)systemLineSeparator).omitEmptyStrings().split((CharSequence)rawContents));
        int lastCommentLine = -1;
        int len = lines.size();
        for (int lineNo = 0; lineNo < len; ++lineNo) {
            String line = (String)lines.get(lineNo);
            if (!line.startsWith("#")) continue;
            lastCommentLine = lineNo;
        }
        if (lastCommentLine != -1) {
            lines.remove(lastCommentLine);
            nonCommentLines = lines.subList(lastCommentLine, lines.size());
        } else {
            nonCommentLines = lines;
        }
        Collections.sort(nonCommentLines);
        String contents = Joiner.on((String)lineSeparator).join((Iterable)lines);
        outputStream.write(contents.getBytes(charset));
    }
}

