/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.properties;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Queue;
import javax.annotation.Nullable;
import org.gradle.api.GradleException;
import org.gradle.api.NonNullApi;
import org.gradle.api.internal.tasks.DefaultTaskInputPropertySpec;
import org.gradle.api.internal.tasks.PropertySpecFactory;
import org.gradle.api.internal.tasks.TaskValidationContext;
import org.gradle.api.internal.tasks.ValidatingValue;
import org.gradle.api.internal.tasks.ValidationAction;
import org.gradle.api.internal.tasks.properties.AbstractBeanNode;
import org.gradle.api.internal.tasks.properties.PropertyMetadata;
import org.gradle.api.internal.tasks.properties.PropertyMetadataStore;
import org.gradle.api.internal.tasks.properties.PropertyValue;
import org.gradle.api.internal.tasks.properties.PropertyValueVisitor;
import org.gradle.api.internal.tasks.properties.PropertyVisitor;
import org.gradle.api.internal.tasks.properties.PropertyWalker;
import org.gradle.api.internal.tasks.properties.TypeMetadata;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.internal.Factory;
import org.gradle.internal.UncheckedException;
import org.gradle.util.DeferredUtil;
import org.gradle.util.DeprecationLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonNullApi
public class DefaultPropertyWalker
implements PropertyWalker {
    private final PropertyMetadataStore propertyMetadataStore;

    public DefaultPropertyWalker(PropertyMetadataStore propertyMetadataStore) {
        this.propertyMetadataStore = propertyMetadataStore;
    }

    @Override
    public void visitProperties(PropertySpecFactory specFactory, PropertyVisitor visitor, Object bean) {
        ArrayDeque<PropertyNode> queue = new ArrayDeque<PropertyNode>();
        queue.add(new PropertyNode(null, bean));
        while (!queue.isEmpty()) {
            Object nested;
            TypeMetadata nestedTypeMetadata;
            PropertyNode node = (PropertyNode)queue.remove();
            if (node.isIterable(nestedTypeMetadata = this.propertyMetadataStore.getTypeMetadata((nested = node.getBean()).getClass()))) {
                Iterable nestedBeans = (Iterable)nested;
                int count = 0;
                for (Object nestedBean : nestedBeans) {
                    String nestedPropertyName = node.getQualifiedPropertyName("$" + count++);
                    queue.add(new PropertyNode(nestedPropertyName, nestedBean));
                }
                continue;
            }
            DefaultPropertyWalker.visitProperties(node, nestedTypeMetadata, queue, visitor, specFactory);
        }
    }

    private static void visitProperties(PropertyNode node, TypeMetadata typeMetadata, Queue<PropertyNode> queue, PropertyVisitor visitor, PropertySpecFactory specFactory) {
        DefaultPropertyWalker.visitImplementation(node, visitor, specFactory);
        for (PropertyMetadata propertyMetadata : typeMetadata.getPropertiesMetadata()) {
            PropertyValueVisitor propertyValueVisitor = propertyMetadata.getPropertyValueVisitor();
            if (propertyValueVisitor == null) continue;
            String propertyName = node.getQualifiedPropertyName(propertyMetadata.getFieldName());
            Object bean = node.getBean();
            DefaultPropertyValue propertyValue = new DefaultPropertyValue(propertyName, propertyMetadata.getAnnotations(), bean, propertyMetadata.getMethod());
            propertyValueVisitor.visitPropertyValue(propertyValue, visitor, specFactory);
            if (!propertyValue.isAnnotationPresent(Nested.class)) continue;
            try {
                Object nested = propertyValue.getValue();
                if (nested != null) {
                    queue.add(new PropertyNode(propertyName, nested));
                    continue;
                }
                if (propertyValue.isOptional()) continue;
                visitor.visitInputProperty(specFactory.createInputPropertySpec(propertyName, new AbsentPropertyValue()));
            }
            catch (Exception e) {
                visitor.visitInputProperty(specFactory.createInputPropertySpec(propertyName, new InvalidPropertyValue(e)));
            }
        }
    }

    private static void visitImplementation(PropertyNode node, PropertyVisitor visitor, PropertySpecFactory specFactory) {
        if (!node.isRoot()) {
            DefaultTaskInputPropertySpec implementation = specFactory.createInputPropertySpec(node.getQualifiedPropertyName("class"), new ImplementationPropertyValue(node.getBean().getClass()));
            implementation.optional(false);
            visitor.visitInputProperty(implementation);
        }
    }

    private static class InvalidPropertyValue
    implements ValidatingValue {
        private final Exception exception;

        public InvalidPropertyValue(Exception exception) {
            this.exception = exception;
        }

        @Nullable
        public Object call() {
            return null;
        }

        public void validate(String propertyName, boolean optional, ValidationAction valueValidator, TaskValidationContext context) {
            throw UncheckedException.throwAsUncheckedException((Throwable)this.exception);
        }
    }

    private static class AbsentPropertyValue
    implements ValidatingValue {
        private AbsentPropertyValue() {
        }

        @Nullable
        public Object call() {
            return null;
        }

        public void validate(String propertyName, boolean optional, ValidationAction valueValidator, TaskValidationContext context) {
            context.recordValidationMessage(TaskValidationContext.Severity.ERROR, String.format("No value has been specified for property '%s'.", propertyName));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ImplementationPropertyValue
    implements ValidatingValue {
        private final Class<?> beanClass;

        public ImplementationPropertyValue(Class<?> beanClass) {
            this.beanClass = beanClass;
        }

        @Override
        public Object call() {
            return this.beanClass;
        }

        @Override
        public void validate(String propertyName, boolean optional, ValidationAction valueValidator, TaskValidationContext context) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultPropertyValue
    implements PropertyValue {
        private final String propertyName;
        private final List<Annotation> annotations;
        private final Object bean;
        private final Method method;
        private final Supplier<Object> valueSupplier = Suppliers.memoize((Supplier)new Supplier<Object>(){

            @Nullable
            public Object get() {
                Object value = DeprecationLogger.whileDisabled((Factory)new Factory<Object>(){

                    public Object create() {
                        try {
                            return DefaultPropertyValue.this.method.invoke(DefaultPropertyValue.this.bean, new Object[0]);
                        }
                        catch (InvocationTargetException e) {
                            throw UncheckedException.throwAsUncheckedException((Throwable)e.getCause());
                        }
                        catch (Exception e) {
                            throw new GradleException(String.format("Could not call %s.%s() on %s", DefaultPropertyValue.this.method.getDeclaringClass().getSimpleName(), DefaultPropertyValue.this.method.getName(), DefaultPropertyValue.this.bean), (Throwable)e);
                        }
                    }
                });
                return value instanceof Provider ? ((Provider)value).getOrNull() : value;
            }
        });

        public DefaultPropertyValue(String propertyName, List<Annotation> annotations, Object bean, Method method) {
            this.propertyName = propertyName;
            this.annotations = ImmutableList.copyOf(annotations);
            this.bean = bean;
            this.method = method;
            method.setAccessible(true);
        }

        @Override
        public String getPropertyName() {
            return this.propertyName;
        }

        @Override
        public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
            return this.getAnnotation(annotationType) != null;
        }

        @Override
        @Nullable
        public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
            for (Annotation annotation : this.annotations) {
                if (!annotationType.equals(annotation.annotationType())) continue;
                return (A)((Annotation)annotationType.cast(annotation));
            }
            return null;
        }

        @Override
        public boolean isOptional() {
            return this.isAnnotationPresent(Optional.class);
        }

        @Override
        @Nullable
        public Object getValue() {
            return this.valueSupplier.get();
        }

        @Override
        @Nullable
        public Object call() {
            return this.getValue();
        }

        @Override
        public void validate(String propertyName, boolean optional, ValidationAction valueValidator, TaskValidationContext context) {
            Object unpacked = DeferredUtil.unpack(this.getValue());
            if (unpacked == null) {
                if (!optional) {
                    context.recordValidationMessage(TaskValidationContext.Severity.ERROR, String.format("No value has been specified for property '%s'.", propertyName));
                }
            } else {
                valueValidator.validate(propertyName, unpacked, context, TaskValidationContext.Severity.ERROR);
            }
        }
    }

    private static class PropertyNode
    extends AbstractBeanNode {
        private final Object bean;

        public PropertyNode(@Nullable String parentPropertyName, Object bean) {
            super(parentPropertyName, Preconditions.checkNotNull((Object)bean, (Object)("Null is not allowed as nested property '" + parentPropertyName + "'")).getClass());
            this.bean = bean;
        }

        public Object getBean() {
            return this.bean;
        }
    }
}

