// **********************************************************************
//
// Copyright (c) 2003-2017 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.7.0
//
// <auto-generated>
//
// Generated from file `Metrics.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

#ifndef __Glacier2_Metrics_h__
#define __Glacier2_Metrics_h__

#include <IceUtil/PushDisableWarnings.h>
#include <Ice/ProxyF.h>
#include <Ice/ObjectF.h>
#include <Ice/ValueF.h>
#include <Ice/Exception.h>
#include <Ice/LocalObject.h>
#include <Ice/StreamHelpers.h>
#include <Ice/Comparable.h>
#include <Ice/Proxy.h>
#include <Ice/Object.h>
#include <Ice/GCObject.h>
#include <Ice/Value.h>
#include <Ice/Incoming.h>
#include <Ice/FactoryTableInit.h>
#include <IceUtil/ScopedArray.h>
#include <Ice/Optional.h>
#include <Ice/ExceptionHelpers.h>
#include <Ice/Metrics.h>
#include <IceUtil/UndefSysMacros.h>
#include <Glacier2/Config.h>

#ifndef ICE_IGNORE_VERSION
#   if ICE_INT_VERSION / 100 != 307
#       error Ice version mismatch!
#   endif
#   if ICE_INT_VERSION % 100 > 50
#       error Beta header file detected
#   endif
#   if ICE_INT_VERSION % 100 < 0
#       error Ice patch level mismatch!
#   endif
#endif

#ifndef GLACIER2_API
#   if defined(ICE_STATIC_LIBS)
#       define GLACIER2_API /**/
#   elif defined(GLACIER2_API_EXPORTS)
#       define GLACIER2_API ICE_DECLSPEC_EXPORT
#   else
#       define GLACIER2_API ICE_DECLSPEC_IMPORT
#   endif
#endif

#ifdef ICE_CPP11_MAPPING // C++11 mapping

namespace IceMX
{

class SessionMetrics;

}

namespace IceMX
{

class ICE_CLASS(GLACIER2_API) SessionMetrics : public ::Ice::ValueHelper<SessionMetrics, ::IceMX::Metrics>
{
public:

    ICE_MEMBER(GLACIER2_API) virtual ~SessionMetrics();

    SessionMetrics() = default;

    SessionMetrics(const SessionMetrics&) = default;
    SessionMetrics(SessionMetrics&&) = default;
    SessionMetrics& operator=(const SessionMetrics&) = default;
    SessionMetrics& operator=(SessionMetrics&&) = default;

    SessionMetrics(const ::std::string& iceP_id, long long int iceP_total, int iceP_current, long long int iceP_totalLifetime, int iceP_failures, int iceP_forwardedClient, int iceP_forwardedServer, int iceP_routingTableSize, int iceP_queuedClient, int iceP_queuedServer, int iceP_overriddenClient, int iceP_overriddenServer) :
        Ice::ValueHelper<::IceMX::SessionMetrics, ::IceMX::Metrics>(::std::move(iceP_id), iceP_total, iceP_current, iceP_totalLifetime, iceP_failures),
        forwardedClient(iceP_forwardedClient),
        forwardedServer(iceP_forwardedServer),
        routingTableSize(iceP_routingTableSize),
        queuedClient(iceP_queuedClient),
        queuedServer(iceP_queuedServer),
        overriddenClient(iceP_overriddenClient),
        overriddenServer(iceP_overriddenServer)
    {
    }

    std::tuple<const ::std::string&, const long long int&, const int&, const long long int&, const int&, const int&, const int&, const int&, const int&, const int&, const int&, const int&> ice_tuple() const
    {
        return std::tie(id, total, current, totalLifetime, failures, forwardedClient, forwardedServer, routingTableSize, queuedClient, queuedServer, overriddenClient, overriddenServer);
    }

    ICE_MEMBER(GLACIER2_API) static const ::std::string& ice_staticId();

    int forwardedClient = 0;
    int forwardedServer = 0;
    int routingTableSize = 0;
    int queuedClient = 0;
    int queuedServer = 0;
    int overriddenClient = 0;
    int overriddenServer = 0;
};

static SessionMetrics _iceS_SessionMetrics_init;

}

namespace IceMX
{

}

namespace Ice
{

template<typename S>
struct StreamWriter<::IceMX::SessionMetrics, S>
{
    static void write(S* ostr, const ::IceMX::SessionMetrics& v)
    {
        ostr->writeAll(v.forwardedClient, v.forwardedServer, v.routingTableSize, v.queuedClient, v.queuedServer, v.overriddenClient, v.overriddenServer);
    }
};

template<typename S>
struct StreamReader<::IceMX::SessionMetrics, S>
{
    static void read(S* istr, ::IceMX::SessionMetrics& v)
    {
        istr->readAll(v.forwardedClient, v.forwardedServer, v.routingTableSize, v.queuedClient, v.queuedServer, v.overriddenClient, v.overriddenServer);
    }
};

}

namespace IceMX
{

using SessionMetricsPtr = ::std::shared_ptr<SessionMetrics>;

}

#else // C++98 mapping

namespace IceProxy
{

namespace IceMX
{

class SessionMetrics;
GLACIER2_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< ::IceProxy::IceMX::SessionMetrics>&);
GLACIER2_API ::IceProxy::Ice::Object* upCast(::IceProxy::IceMX::SessionMetrics*);

}

}

namespace IceMX
{

class SessionMetrics;
GLACIER2_API ::Ice::Object* upCast(::IceMX::SessionMetrics*);
typedef ::IceInternal::Handle< ::IceMX::SessionMetrics> SessionMetricsPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceMX::SessionMetrics> SessionMetricsPrx;
typedef SessionMetricsPrx SessionMetricsPrxPtr;
GLACIER2_API void _icePatchObjectPtr(SessionMetricsPtr&, const ::Ice::ObjectPtr&);

}

namespace IceMX
{

}

namespace IceProxy
{

namespace IceMX
{

class ICE_CLASS(GLACIER2_API) SessionMetrics : public virtual ::Ice::Proxy<SessionMetrics, ::IceProxy::IceMX::Metrics>
{
public:

    ICE_MEMBER(GLACIER2_API) static const ::std::string& ice_staticId();

protected:

    ICE_MEMBER(GLACIER2_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
};

}

}

namespace IceMX
{

class GLACIER2_API SessionMetrics : public ::IceMX::Metrics
{
public:

    typedef SessionMetricsPrx ProxyType;
    typedef SessionMetricsPtr PointerType;

    virtual ~SessionMetrics();

    SessionMetrics() :
        forwardedClient(0),
        forwardedServer(0),
        routingTableSize(0),
        queuedClient(0),
        queuedServer(0),
        overriddenClient(0),
        overriddenServer(0)
    {
    }

    SessionMetrics(const ::std::string& iceP_id, ::Ice::Long iceP_total, ::Ice::Int iceP_current, ::Ice::Long iceP_totalLifetime, ::Ice::Int iceP_failures, ::Ice::Int iceP_forwardedClient, ::Ice::Int iceP_forwardedServer, ::Ice::Int iceP_routingTableSize, ::Ice::Int iceP_queuedClient, ::Ice::Int iceP_queuedServer, ::Ice::Int iceP_overriddenClient, ::Ice::Int iceP_overriddenServer) :
        ::IceMX::Metrics(iceP_id, iceP_total, iceP_current, iceP_totalLifetime, iceP_failures),
        forwardedClient(iceP_forwardedClient),
        forwardedServer(iceP_forwardedServer),
        routingTableSize(iceP_routingTableSize),
        queuedClient(iceP_queuedClient),
        queuedServer(iceP_queuedServer),
        overriddenClient(iceP_overriddenClient),
        overriddenServer(iceP_overriddenServer)
    {
    }

    virtual ::Ice::ObjectPtr ice_clone() const;

    virtual bool ice_isA(const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual const ::std::string& ice_id(const ::Ice::Current& = ::Ice::emptyCurrent) const;

    static const ::std::string& ice_staticId();

    static ::Ice::ValueFactoryPtr ice_factory();

protected:

    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);

public:

    ::Ice::Int forwardedClient;
    ::Ice::Int forwardedServer;
    ::Ice::Int routingTableSize;
    ::Ice::Int queuedClient;
    ::Ice::Int queuedServer;
    ::Ice::Int overriddenClient;
    ::Ice::Int overriddenServer;
};
static ::Ice::ValueFactoryPtr _iceS_SessionMetrics_init = ::IceMX::SessionMetrics::ice_factory();

inline bool operator==(const SessionMetrics& lhs, const SessionMetrics& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const SessionMetrics& lhs, const SessionMetrics& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}

}

namespace Ice
{

template<typename S>
struct StreamWriter< ::IceMX::SessionMetrics, S>
{
    static void write(S* ostr, const ::IceMX::SessionMetrics& v)
    {
        ostr->write(v.forwardedClient);
        ostr->write(v.forwardedServer);
        ostr->write(v.routingTableSize);
        ostr->write(v.queuedClient);
        ostr->write(v.queuedServer);
        ostr->write(v.overriddenClient);
        ostr->write(v.overriddenServer);
    }
};

template<typename S>
struct StreamReader< ::IceMX::SessionMetrics, S>
{
    static void read(S* istr, ::IceMX::SessionMetrics& v)
    {
        istr->read(v.forwardedClient);
        istr->read(v.forwardedServer);
        istr->read(v.routingTableSize);
        istr->read(v.queuedClient);
        istr->read(v.queuedServer);
        istr->read(v.overriddenClient);
        istr->read(v.overriddenServer);
    }
};

}

namespace IceMX
{

}

#endif

#include <IceUtil/PopDisableWarnings.h>
#endif
