/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceGridGUI.LiveDeployment;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.looks.BorderStyle;
import com.jgoodies.looks.HeaderStyle;
import com.zeroc.IceGrid.ServerDescriptor;
import com.zeroc.IceGrid.ServerState;
import com.zeroc.IceGridGUI.Coordinator;
import com.zeroc.IceGridGUI.LiveActions;
import com.zeroc.IceGridGUI.LiveDeployment.CommunicatorEditor;
import com.zeroc.IceGridGUI.LiveDeployment.Server;
import com.zeroc.IceGridGUI.LiveDeployment.TableField;
import com.zeroc.IceGridGUI.Utils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;

class ServerEditor
extends CommunicatorEditor {
    private Coordinator _coordinator;
    private JTextField _currentState = new JTextField(20);
    private JCheckBox _enabled = new JCheckBox("Enabled");
    private JTextField _currentPid = new JTextField(20);
    private JTextField _application = new JTextField(20);
    private JButton _gotoApplication;
    private JTextField _exe = new JTextField(20);
    private JTextField _iceVersion = new JTextField(20);
    private JTextField _pwd = new JTextField(20);
    private JTextField _user = new JTextField(20);
    private JTextField _activation = new JTextField(20);
    private JTextField _activationTimeout = new JTextField(20);
    private JTextField _deactivationTimeout = new JTextField(20);
    private JCheckBox _allocatable = new JCheckBox("Allocatable");
    private TableField _envs = new TableField("Name", "Value");
    private JTextField _options = new JTextField(20);
    private JCheckBox _applicationDistrib = new JCheckBox("Depends on the application distribution");
    private JTextField _icepatch = new JTextField(20);
    private JTextField _directories = new JTextField(20);
    private JToolBar _toolBar;

    @Override
    public JToolBar getToolBar() {
        if (this._toolBar == null) {
            this._toolBar = new ToolBar();
        }
        return this._toolBar;
    }

    ServerEditor(Coordinator c) {
        this._coordinator = c;
        this._currentState.setEditable(false);
        this._enabled.setEnabled(false);
        this._currentPid.setEditable(false);
        this._application.setEditable(false);
        this._exe.setEditable(false);
        this._iceVersion.setEditable(false);
        this._pwd.setEditable(false);
        this._activation.setEditable(false);
        this._activationTimeout.setEditable(false);
        this._deactivationTimeout.setEditable(false);
        this._options.setEditable(false);
        this._user.setEditable(false);
        this._allocatable.setEnabled(false);
        this._applicationDistrib.setEnabled(false);
        this._icepatch.setEditable(false);
        this._directories.setEditable(false);
        AbstractAction gotoApplication = new AbstractAction("", Utils.getIcon("/icons/16x16/goto.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((Server)ServerEditor.this._target).openDefinition();
            }
        };
        gotoApplication.putValue("ShortDescription", "View/Edit this application");
        this._gotoApplication = new JButton(gotoApplication);
    }

    void show(Server server) {
        Server previousServer = (Server)this._target;
        this._target = server;
        ServerState state = server.getState();
        ServerDescriptor descriptor = server.getServerDescriptor();
        final Utils.Resolver resolver = server.getResolver();
        if (state == null) {
            this._currentState.setText("Unknown");
            this._enabled.setSelected(false);
            this._currentPid.setText("");
            this.clearRuntimeProperties("Unknown");
        } else {
            this._currentState.setText(state.toString());
            this._enabled.setSelected(server.isEnabled());
            int pid = server.getPid();
            if (pid == 0) {
                this._currentPid.setText("");
            } else {
                this._currentPid.setText(Integer.toString(pid));
            }
            int iceIntVersion = server.getIceVersion();
            if (state == ServerState.Active && (iceIntVersion == 0 || iceIntVersion >= 30300)) {
                this.showRuntimeProperties(previousServer);
            } else {
                this.clearRuntimeProperties("");
            }
        }
        this._application.setText(resolver.find("application"));
        super.show(descriptor, server.getProperties(), resolver);
        this._exe.setText(resolver.substitute(descriptor.exe));
        this._iceVersion.setText(resolver.substitute(descriptor.iceVersion));
        this._pwd.setText(resolver.substitute(descriptor.pwd));
        Utils.Stringifier stringifier = new Utils.Stringifier(){

            @Override
            public String toString(Object obj) {
                return resolver.substitute((String)obj);
            }
        };
        Utils.StringifyResult r = Utils.stringify(descriptor.options, stringifier, " ");
        this._options.setText(r.returnValue);
        this._options.setToolTipText(r.toolTip);
        this._envs.setEnvs(descriptor.envs, resolver);
        this._user.setText(resolver.substitute(descriptor.user));
        this._activation.setText(resolver.substitute(descriptor.activation));
        this._activationTimeout.setText(resolver.substitute(descriptor.activationTimeout));
        this._deactivationTimeout.setText(resolver.substitute(descriptor.deactivationTimeout));
        this._allocatable.setSelected(descriptor.allocatable);
        this._applicationDistrib.setSelected(descriptor.applicationDistrib);
        this._icepatch.setText(resolver.substitute(resolver.substitute(descriptor.distrib.icepatch)));
        r = Utils.stringify(descriptor.distrib.directories, stringifier, ", ");
        this._directories.setText(r.returnValue);
        String toolTip = "<html>Include only these directories";
        if (r.toolTip != null) {
            toolTip = toolTip + ":<br>" + r.toolTip;
        }
        toolTip = toolTip + "</html>";
        this._directories.setToolTipText(toolTip);
    }

    @Override
    protected void appendProperties(DefaultFormBuilder builder) {
        builder.appendSeparator("Runtime Status");
        builder.append("State");
        builder.append((Component)this._currentState, 3);
        builder.nextLine();
        builder.append("", (Component)this._enabled);
        builder.nextLine();
        builder.append("Process Id");
        builder.append((Component)this._currentPid, 3);
        builder.nextLine();
        this.appendRuntimeProperties(builder);
        builder.appendSeparator("Configuration");
        builder.append("Application");
        builder.append(this._application);
        builder.append(this._gotoApplication);
        builder.nextLine();
        this.appendDescriptorProperties(builder);
        builder.appendSeparator("Activation");
        builder.append("Path to Executable");
        builder.append((Component)this._exe, 3);
        builder.nextLine();
        builder.append("Ice Version");
        builder.append((Component)this._iceVersion, 3);
        builder.nextLine();
        builder.append("Working Directory");
        builder.append((Component)this._pwd, 3);
        builder.nextLine();
        builder.append("Command Arguments");
        builder.append((Component)this._options, 3);
        builder.nextLine();
        builder.append("Run as");
        builder.append((Component)this._user, 3);
        builder.nextLine();
        builder.append("Environment Variables");
        builder.nextLine();
        builder.append("");
        builder.nextLine();
        builder.append("");
        builder.nextLine();
        builder.append("");
        builder.nextRow(-6);
        CellConstraints cc = new CellConstraints();
        JScrollPane scrollPane = new JScrollPane(this._envs);
        builder.add((Component)scrollPane, cc.xywh(builder.getColumn(), builder.getRow(), 3, 7));
        builder.nextRow(6);
        builder.nextLine();
        builder.append("Activation Mode");
        builder.append((Component)this._activation, 3);
        builder.nextLine();
        builder.append("Activation Timeout");
        builder.append((Component)this._activationTimeout, 3);
        builder.nextLine();
        builder.append("Deactivation Timeout");
        builder.append((Component)this._deactivationTimeout, 3);
        builder.nextLine();
        builder.append("", (Component)this._allocatable);
        builder.nextLine();
        JComponent c = builder.appendSeparator("Distribution");
        c.setToolTipText("Files specific to this server");
        builder.append("", (Component)this._applicationDistrib);
        builder.nextLine();
        builder.append("IcePatch2 Proxy");
        builder.append((Component)this._icepatch, 3);
        builder.nextLine();
        builder.append("Directories");
        builder.append((Component)this._directories, 3);
        builder.nextLine();
    }

    @Override
    protected void buildPropertiesPanel() {
        super.buildPropertiesPanel();
        this._propertiesPanel.setName("Server Properties");
    }

    private class ToolBar
    extends JToolBar {
        private ToolBar() {
            this.putClientProperty("jgoodies.headerStyle", HeaderStyle.SINGLE);
            this.putClientProperty("Plastic.borderStyle", BorderStyle.SEPARATOR);
            this.setFloatable(false);
            this.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
            LiveActions la = ServerEditor.this._coordinator.getLiveActionsForMenu();
            this.add(la.get(0));
            this.add(la.get(1));
            this.addSeparator();
            this.add(la.get(2));
            this.add(la.get(3));
        }
    }
}

