/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.shrink;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.shrink.ResizeAction;
import org.elasticsearch.action.admin.indices.shrink.ResizeType;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ObjectParser;

public class ResizeRequest
extends AcknowledgedRequest<ResizeRequest>
implements IndicesRequest {
    public static final ObjectParser<ResizeRequest, Void> PARSER = new ObjectParser("resize_request", null);
    private CreateIndexRequest targetIndexRequest;
    private String sourceIndex;
    private ResizeType type = ResizeType.SHRINK;

    ResizeRequest() {
    }

    public ResizeRequest(String targetIndex, String sourceIndex) {
        this.targetIndexRequest = new CreateIndexRequest(targetIndex);
        this.sourceIndex = sourceIndex;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException;
        ActionRequestValidationException actionRequestValidationException = validationException = this.targetIndexRequest == null ? null : this.targetIndexRequest.validate();
        if (this.sourceIndex == null) {
            validationException = ValidateActions.addValidationError("source index is missing", validationException);
        }
        if (this.targetIndexRequest == null) {
            validationException = ValidateActions.addValidationError("target index request is missing", validationException);
        }
        if (!this.targetIndexRequest.settings().getByPrefix("index.sort.").isEmpty()) {
            validationException = ValidateActions.addValidationError("can't override index sort when resizing an index", validationException);
        }
        if (this.type == ResizeType.SPLIT && !IndexMetaData.INDEX_NUMBER_OF_SHARDS_SETTING.exists(this.targetIndexRequest.settings())) {
            validationException = ValidateActions.addValidationError("index.number_of_shards is required for split operations", validationException);
        }
        return validationException;
    }

    public void setSourceIndex(String index) {
        this.sourceIndex = index;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.targetIndexRequest = new CreateIndexRequest();
        this.targetIndexRequest.readFrom(in);
        this.sourceIndex = in.readString();
        this.type = in.getVersion().onOrAfter(ResizeAction.COMPATIBILITY_VERSION) ? in.readEnum(ResizeType.class) : ResizeType.SHRINK;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.targetIndexRequest.writeTo(out);
        out.writeString(this.sourceIndex);
        if (out.getVersion().onOrAfter(ResizeAction.COMPATIBILITY_VERSION)) {
            out.writeEnum(this.type);
        }
    }

    @Override
    public String[] indices() {
        return new String[]{this.sourceIndex};
    }

    @Override
    public IndicesOptions indicesOptions() {
        return IndicesOptions.lenientExpandOpen();
    }

    public void setTargetIndex(CreateIndexRequest targetIndexRequest) {
        this.targetIndexRequest = Objects.requireNonNull(targetIndexRequest, "target index request must not be null");
    }

    public CreateIndexRequest getTargetIndexRequest() {
        return this.targetIndexRequest;
    }

    public String getSourceIndex() {
        return this.sourceIndex;
    }

    public void setWaitForActiveShards(ActiveShardCount waitForActiveShards) {
        this.getTargetIndexRequest().waitForActiveShards(waitForActiveShards);
    }

    public void setWaitForActiveShards(int waitForActiveShards) {
        this.setWaitForActiveShards(ActiveShardCount.from(waitForActiveShards));
    }

    public void setResizeType(ResizeType type) {
        this.type = Objects.requireNonNull(type);
    }

    public ResizeType getResizeType() {
        return this.type;
    }

    static {
        PARSER.declareField((parser, request, context) -> request.getTargetIndexRequest().settings(parser.map()), new ParseField("settings", new String[0]), ObjectParser.ValueType.OBJECT);
        PARSER.declareField((parser, request, context) -> request.getTargetIndexRequest().aliases(parser.map()), new ParseField("aliases", new String[0]), ObjectParser.ValueType.OBJECT);
    }
}

