/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.composite;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeAggregator;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeKey;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeValuesSourceConfig;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.internal.SearchContext;

class CompositeAggregationFactory
extends AggregatorFactory<CompositeAggregationFactory> {
    private final int size;
    private final CompositeValuesSourceConfig[] sources;
    private final List<String> sourceNames;
    private final CompositeKey afterKey;

    CompositeAggregationFactory(String name, SearchContext context, AggregatorFactory<?> parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metaData, int size, CompositeValuesSourceConfig[] sources, List<String> sourceNames, CompositeKey afterKey) throws IOException {
        super(name, context, parent, subFactoriesBuilder, metaData);
        this.size = size;
        this.sources = sources;
        this.sourceNames = sourceNames;
        this.afterKey = afterKey;
    }

    @Override
    protected Aggregator createInternal(Aggregator parent, boolean collectsFromSingleBucket, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        return new CompositeAggregator(this.name, this.factories, this.context, parent, pipelineAggregators, metaData, this.size, this.sources, this.sourceNames, this.afterKey);
    }
}

