/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Set;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.NodeState;

public class PendingDependencies {
    private boolean noLongerPending;
    private final Set<NodeState> affectedComponents;

    public static PendingDependencies pending() {
        return new PendingDependencies(Sets.newLinkedHashSet(), false);
    }

    public static PendingDependencies notPending() {
        return new PendingDependencies(Collections.<NodeState>emptySet(), true);
    }

    private PendingDependencies(Set<NodeState> nodeStates, boolean noLongerPending) {
        this.affectedComponents = nodeStates;
        this.noLongerPending = noLongerPending;
    }

    void addNode(NodeState state) {
        if (this.noLongerPending) {
            throw new IllegalStateException("Cannot add a pending node for a dependency which is not pending");
        }
        this.affectedComponents.add(state);
    }

    void turnIntoHardDependencies() {
        this.noLongerPending = true;
        for (NodeState affectedComponent : this.affectedComponents) {
            affectedComponent.resetSelectionState();
        }
    }

    public boolean isPending() {
        return !this.noLongerPending;
    }
}

