/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.swift.plugins;

import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.attributes.Usage;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.model.ObjectFactory;
import org.gradle.language.cpp.CppBinary;
import org.gradle.language.internal.DefaultBinaryCollection;
import org.gradle.language.internal.NativeComponentFactory;
import org.gradle.language.nativeplatform.internal.toolchains.ToolChainSelector;
import org.gradle.language.swift.SwiftApplication;
import org.gradle.language.swift.SwiftExecutable;
import org.gradle.language.swift.SwiftPlatform;
import org.gradle.language.swift.internal.DefaultSwiftApplication;
import org.gradle.language.swift.plugins.SwiftBasePlugin;
import org.gradle.language.swift.tasks.SwiftCompile;
import org.gradle.util.GUtil;

@Incubating
public class SwiftApplicationPlugin
implements Plugin<ProjectInternal> {
    private final NativeComponentFactory componentFactory;
    private final ToolChainSelector toolChainSelector;

    @Inject
    public SwiftApplicationPlugin(NativeComponentFactory componentFactory, ToolChainSelector toolChainSelector) {
        this.componentFactory = componentFactory;
        this.toolChainSelector = toolChainSelector;
    }

    public void apply(ProjectInternal project) {
        project.getPluginManager().apply(SwiftBasePlugin.class);
        final ConfigurationContainer configurations = project.getConfigurations();
        final DefaultSwiftApplication application = this.componentFactory.newInstance(SwiftApplication.class, DefaultSwiftApplication.class, "main");
        project.getExtensions().add(SwiftApplication.class, "application", (Object)application);
        project.getComponents().add((Object)application);
        application.getModule().set((Object)GUtil.toCamelCase((CharSequence)project.getName()));
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                ObjectFactory objectFactory = project.getObjects();
                ToolChainSelector.Result<SwiftPlatform> result = SwiftApplicationPlugin.this.toolChainSelector.select(SwiftPlatform.class);
                SwiftExecutable debugExecutable = application.addExecutable("debug", true, false, true, result.getTargetPlatform(), result.getToolChain(), result.getPlatformToolProvider());
                SwiftExecutable releaseExecutable = application.addExecutable("release", true, true, false, result.getTargetPlatform(), result.getToolChain(), result.getPlatformToolProvider());
                SwiftCompile compileDebug = (SwiftCompile)((Object)debugExecutable.getCompileTask().get());
                SwiftCompile compileRelease = (SwiftCompile)((Object)releaseExecutable.getCompileTask().get());
                Configuration implementation = application.getImplementationDependencies();
                Configuration debugApiElements = (Configuration)configurations.maybeCreate("debugSwiftApiElements");
                debugApiElements.extendsFrom(new Configuration[]{implementation});
                debugApiElements.setCanBeResolved(false);
                debugApiElements.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)objectFactory.named(Usage.class, "swift-api"));
                debugApiElements.getAttributes().attribute(CppBinary.DEBUGGABLE_ATTRIBUTE, (Object)debugExecutable.isDebuggable());
                debugApiElements.getAttributes().attribute(CppBinary.OPTIMIZED_ATTRIBUTE, (Object)debugExecutable.isOptimized());
                debugApiElements.getOutgoing().artifact((Object)compileDebug.getModuleFile());
                Configuration releaseApiElements = (Configuration)configurations.maybeCreate("releaseSwiftApiElements");
                releaseApiElements.extendsFrom(new Configuration[]{implementation});
                releaseApiElements.setCanBeResolved(false);
                releaseApiElements.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)objectFactory.named(Usage.class, "swift-api"));
                releaseApiElements.getAttributes().attribute(CppBinary.DEBUGGABLE_ATTRIBUTE, (Object)releaseExecutable.isDebuggable());
                releaseApiElements.getAttributes().attribute(CppBinary.OPTIMIZED_ATTRIBUTE, (Object)releaseExecutable.isOptimized());
                releaseApiElements.getOutgoing().artifact((Object)compileRelease.getModuleFile());
                application.getDevelopmentBinary().set((Object)debugExecutable);
                ((DefaultBinaryCollection)application.getBinaries()).realizeNow();
            }
        });
    }
}

