#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: dbus
version: 0.10.15
id: dbus-0.10.15-5FUswPqHNC92Ani4Cv3fbe
key: dbus-0.10.15-5FUswPqHNC92Ani4Cv3fbe
license: GPL-3
maintainer: Andrey Sverdlichenko <blaze@ruddy.ru>
stability: experimental
homepage: https://github.com/rblaze/haskell-dbus#readme
synopsis: A client library for the D-Bus IPC system.
description:
    D-Bus is a simple, message-based protocol for inter-process
    communication, which allows applications to interact with other parts of
    the machine and the user'\''s session using remote procedure calls.
    .
    D-Bus is a essential part of the modern Linux desktop, where it replaces
    earlier protocols such as CORBA and DCOP.
    .
    This library is an implementation of the D-Bus protocol in Haskell. It
    can be used to add D-Bus support to Haskell applications, without the
    awkward interfaces common to foreign bindings.
    .
    Example: connect to the session bus, and get a list of active names.
    .
    @
    &#x7b;-\# LANGUAGE OverloadedStrings \#-&#x7d;
    .
    import Data.List (sort)
    import DBus
    import DBus.Client
    .
    main = do
    &#x20;   client <- connectSession
    &#x20;   //
    &#x20;   \-- Request a list of connected clients from the bus
    &#x20;   reply <- call_ client (methodCall \"\/org\/freedesktop\/DBus\" \"org.freedesktop.DBus\" \"ListNames\")
    &#x20;       &#x7b; methodCallDestination = Just \"org.freedesktop.DBus\"
    &#x20;       &#x7d;
    &#x20;   //
    &#x20;   \-- org.freedesktop.DBus.ListNames() returns a single value, which is
    &#x20;   \-- a list of names (here represented as [String])
    &#x20;   let Just names = fromVariant (methodReturnBody reply !! 0)
    &#x20;   //
    &#x20;   \-- Print each name on a line, sorted so reserved names are below
    &#x20;   \-- temporary names.
    &#x20;   mapM_ putStrLn (sort names)
    @
    .
    >$ ghc --make list-names.hs
    >$ ./list-names
    >:1.0
    >:1.1
    >:1.10
    >:1.106
    >:1.109
    >:1.110
    >ca.desrt.dconf
    >org.freedesktop.DBus
    >org.freedesktop.Notifications
    >org.freedesktop.secrets
    >org.gnome.ScreenSaver
category: Network, Desktop
author: John Millikin <john@john-millikin.com>
exposed: True
indefinite: False
exposed-modules:
    DBus DBus.Client DBus.Internal.Address DBus.Internal.Message
    DBus.Internal.Types DBus.Internal.Wire DBus.Introspection
    DBus.Socket DBus.Transport
abi: 5e8b039c42906b0ffd8297e4fe0a423c
trusted: False
import-dirs: /usr/lib/ghc-8.2.2/site-local/dbus-0.10.15
library-dirs: /usr/lib/ghc-8.2.2/site-local/dbus-0.10.15
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.2.2/dbus-0.10.15
hs-libraries: HSdbus-0.10.15-5FUswPqHNC92Ani4Cv3fbe
depends:
    base-4.10.1.0 bytestring-0.10.8.2
    cereal-0.5.4.0-HHG4trmDAey7tG5Rc3nyML containers-0.5.10.2
    deepseq-1.4.3.0 libxml-sax-0.7.5-CZNJ7yMYetWDObZtx2BxlB
    network-2.6.3.3-BsPhUcUvmHlbFKWY24Oor
    parsec-3.1.11-1k1VJixRpBgKJgdIEz2OP7
    random-1.1-LLUGZ7T9DqQ5vN0Jbcd0We
    text-1.2.3.0-6107d52Rn3mLJ1xgqHMkbj transformers-0.5.2.0
    unix-2.7.2.2 vector-0.12.0.1-JlawpRjIcMJIYPJVsWriIA
    xml-types-0.3.6-8U94ZZax169GYLVDpT1mig
abi-depends: base-4.10.1.0=0ea45191c57c268b2351cb731ab6a0d6
             bytestring-0.10.8.2=4b2726b654ceeff6535e698a2a1e724e
             cereal-0.5.4.0-HHG4trmDAey7tG5Rc3nyML=ed459ea038cbdb253abe2c011f65c556
             containers-0.5.10.2=0f9db0d1b935cacba444aac19f4cb54d
             deepseq-1.4.3.0=e843b5d736cc095915bf2399fddf152e
             libxml-sax-0.7.5-CZNJ7yMYetWDObZtx2BxlB=68088c31c378626ce9ceb6931c5387fd
             network-2.6.3.3-BsPhUcUvmHlbFKWY24Oor=f013b5448241bfbc78fb9f4b90b2582b
             parsec-3.1.11-1k1VJixRpBgKJgdIEz2OP7=5b8a6db8c81629fde3a12212030372e3
             random-1.1-LLUGZ7T9DqQ5vN0Jbcd0We=368a9f817c8c1b290191231dd0d81d85
             text-1.2.3.0-6107d52Rn3mLJ1xgqHMkbj=b7726d921cac66adc5c8f9f66f5b25f0
             transformers-0.5.2.0=b5dee110a615d751493b7ce1c6f95946
             unix-2.7.2.2=3df01ca0d7640dab598065ff1b1cffeb
             vector-0.12.0.1-JlawpRjIcMJIYPJVsWriIA=137c9db50bf637e10c6e6dd9e685ce59
             xml-types-0.3.6-8U94ZZax169GYLVDpT1mig=d5c752ba65b163e7bdddd7a60950098d
haddock-interfaces: /usr/share/doc/haskell-dbus/html/dbus.haddock
haddock-html: /usr/share/doc/haskell-dbus/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

