/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.common;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.ingest.AbstractProcessor;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Processor;

public final class JsonProcessor
extends AbstractProcessor {
    public static final String TYPE = "json";
    private final String field;
    private final String targetField;
    private final boolean addToRoot;

    JsonProcessor(String tag, String field, String targetField, boolean addToRoot) {
        super(tag);
        this.field = field;
        this.targetField = targetField;
        this.addToRoot = addToRoot;
    }

    public String getField() {
        return this.field;
    }

    public String getTargetField() {
        return this.targetField;
    }

    boolean isAddToRoot() {
        return this.addToRoot;
    }

    public void execute(IngestDocument document) throws Exception {
        Object fieldValue = document.getFieldValue(this.field, Object.class);
        BytesArray bytesRef = fieldValue == null ? new BytesArray("null") : new BytesArray(fieldValue.toString());
        try (XContentParser parser = JsonXContent.jsonXContent.createParser(NamedXContentRegistry.EMPTY, (BytesReference)bytesRef);){
            XContentParser.Token token = parser.nextToken();
            Object value = null;
            if (token == XContentParser.Token.VALUE_NULL) {
                value = null;
            } else if (token == XContentParser.Token.VALUE_STRING) {
                value = parser.text();
            } else if (token == XContentParser.Token.VALUE_NUMBER) {
                value = parser.numberValue();
            } else if (token == XContentParser.Token.VALUE_BOOLEAN) {
                value = parser.booleanValue();
            } else if (token == XContentParser.Token.START_OBJECT) {
                value = parser.map();
            } else if (token == XContentParser.Token.START_ARRAY) {
                value = parser.list();
            } else if (token == XContentParser.Token.VALUE_EMBEDDED_OBJECT) {
                throw new IllegalArgumentException("cannot read binary value");
            }
            if (this.addToRoot && value instanceof Map) {
                for (Map.Entry entry : ((Map)value).entrySet()) {
                    document.setFieldValue((String)entry.getKey(), entry.getValue());
                }
            } else {
                if (this.addToRoot) {
                    throw new IllegalArgumentException("cannot add non-map fields to root of document");
                }
                document.setFieldValue(this.targetField, value);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String getType() {
        return TYPE;
    }

    public static final class Factory
    implements Processor.Factory {
        public JsonProcessor create(Map<String, Processor.Factory> registry, String processorTag, Map<String, Object> config) throws Exception {
            String field = ConfigurationUtils.readStringProperty((String)JsonProcessor.TYPE, (String)processorTag, config, (String)"field");
            String targetField = ConfigurationUtils.readOptionalStringProperty((String)JsonProcessor.TYPE, (String)processorTag, config, (String)"target_field");
            boolean addToRoot = ConfigurationUtils.readBooleanProperty((String)JsonProcessor.TYPE, (String)processorTag, config, (String)"add_to_root", (boolean)false);
            if (addToRoot && targetField != null) {
                throw ConfigurationUtils.newConfigurationException((String)JsonProcessor.TYPE, (String)processorTag, (String)"target_field", (String)"Cannot set a target field while also setting `add_to_root` to true");
            }
            if (targetField == null) {
                targetField = field;
            }
            return new JsonProcessor(processorTag, field, targetField, addToRoot);
        }
    }
}

