/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dependencies;

import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencyConstraint;
import org.gradle.api.artifacts.MutableVersionConstraint;
import org.gradle.api.artifacts.VersionConstraint;
import org.gradle.api.internal.artifacts.dependencies.DefaultMutableVersionConstraint;

public class DefaultDependencyConstraint
implements DependencyConstraint {
    private final String group;
    private final String name;
    private final MutableVersionConstraint versionConstraint;

    public DefaultDependencyConstraint(String group, String name, String version) {
        this.group = group;
        this.name = name;
        this.versionConstraint = new DefaultMutableVersionConstraint(version);
    }

    private DefaultDependencyConstraint(String group, String name, MutableVersionConstraint versionConstraint) {
        this.group = group;
        this.name = name;
        this.versionConstraint = versionConstraint;
    }

    @Nullable
    public String getGroup() {
        return this.group;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public String getVersion() {
        return this.versionConstraint.getPreferredVersion();
    }

    public int hashCode() {
        int result = this.group != null ? this.group.hashCode() : 0;
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.versionConstraint.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DependencyConstraint that = (DependencyConstraint)o;
        return this.contentEquals((Dependency)that);
    }

    public boolean contentEquals(Dependency dependency) {
        if (this == dependency) {
            return true;
        }
        if (dependency == null || this.getClass() != dependency.getClass()) {
            return false;
        }
        DefaultDependencyConstraint that = (DefaultDependencyConstraint)dependency;
        return StringUtils.equals((String)this.group, (String)that.getGroup()) && StringUtils.equals((String)this.name, (String)that.getName()) && this.versionConstraint.equals(that.versionConstraint);
    }

    public DependencyConstraint copy() {
        return new DefaultDependencyConstraint(this.group, this.name, this.versionConstraint);
    }

    public void version(Action<? super MutableVersionConstraint> configureAction) {
        configureAction.execute((Object)this.versionConstraint);
    }

    public VersionConstraint getVersionConstraint() {
        return this.versionConstraint;
    }
}

