/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import java.util.List;
import org.gradle.api.artifacts.VersionConstraint;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.artifacts.component.ProjectComponentSelector;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.component.external.model.DefaultModuleComponentSelector;
import org.gradle.internal.component.external.model.ExternalDependencyDescriptor;
import org.gradle.internal.component.external.model.ModuleDependencyMetadata;
import org.gradle.internal.component.local.model.DefaultProjectDependencyMetadata;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.ExcludeMetadata;
import org.gradle.internal.component.model.IvyArtifactName;

public class ConfigurationDependencyMetadataWrapper
implements ModuleDependencyMetadata {
    private final ConfigurationMetadata configuration;
    private final ModuleComponentIdentifier componentId;
    private final ExternalDependencyDescriptor delegate;

    public ConfigurationDependencyMetadataWrapper(ConfigurationMetadata configuration, ModuleComponentIdentifier componentId, ExternalDependencyDescriptor delegate) {
        this.configuration = configuration;
        this.componentId = componentId;
        this.delegate = delegate;
    }

    @Override
    public List<ConfigurationMetadata> selectConfigurations(ImmutableAttributes consumerAttributes, ComponentResolveMetadata targetComponent, AttributesSchemaInternal consumerSchema) {
        return this.delegate.getMetadataForConfigurations(consumerAttributes, consumerSchema, (ComponentIdentifier)this.componentId, this.configuration, targetComponent);
    }

    @Override
    public List<IvyArtifactName> getArtifacts() {
        return this.delegate.getConfigurationArtifacts(this.configuration);
    }

    @Override
    public List<ExcludeMetadata> getExcludes() {
        return this.delegate.getConfigurationExcludes(this.configuration.getHierarchy());
    }

    @Override
    public DependencyMetadata withTarget(ComponentSelector target) {
        if (target instanceof ModuleComponentSelector) {
            ModuleComponentSelector moduleTarget = (ModuleComponentSelector)target;
            ModuleComponentSelector newSelector = DefaultModuleComponentSelector.newSelector(moduleTarget.getGroup(), moduleTarget.getModule(), moduleTarget.getVersionConstraint());
            if (newSelector.equals(this.getSelector())) {
                return this;
            }
            return this.withRequested(newSelector);
        }
        if (target instanceof ProjectComponentSelector) {
            ProjectComponentSelector projectTarget = (ProjectComponentSelector)target;
            return new DefaultProjectDependencyMetadata(projectTarget, this);
        }
        throw new IllegalArgumentException("Unexpected selector provided: " + target);
    }

    @Override
    public ModuleDependencyMetadata withRequestedVersion(VersionConstraint requestedVersion) {
        ModuleComponentSelector selector = this.getSelector();
        if (requestedVersion.equals(selector.getVersionConstraint())) {
            return this;
        }
        ModuleComponentSelector newSelector = DefaultModuleComponentSelector.newSelector(selector.getGroup(), selector.getModule(), requestedVersion);
        return this.withRequested(newSelector);
    }

    private ModuleDependencyMetadata withRequested(ModuleComponentSelector newSelector) {
        ExternalDependencyDescriptor newDelegate = this.delegate.withRequested(newSelector);
        return new ConfigurationDependencyMetadataWrapper(this.configuration, this.componentId, newDelegate);
    }

    @Override
    public ModuleComponentSelector getSelector() {
        return this.delegate.getSelector();
    }

    @Override
    public boolean isChanging() {
        return this.delegate.isChanging();
    }

    @Override
    public boolean isTransitive() {
        return this.delegate.isTransitive();
    }

    @Override
    public boolean isPending() {
        return this.delegate.isOptional();
    }
}

