/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.intrinsics;

import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IntrinsicMethod;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IntrinsicMethods;
import org.jetbrains.kotlin.com.google.common.collect.Maps;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.resolve.DescriptorUtils;

class IntrinsicsMap {
    private final Map<Key, IntrinsicMethod> intrinsicsMap = Maps.newHashMap();

    IntrinsicsMap() {
    }

    private static int valueParameterCountForKey(@NotNull CallableMemberDescriptor member) {
        if (member instanceof PropertyDescriptor) {
            return -1;
        }
        return member.getValueParameters().size();
    }

    public void registerIntrinsic(@NotNull FqName owner, @Nullable FqNameUnsafe receiverParameter, @NotNull String name, int valueParameterCount, @NotNull IntrinsicMethod impl) {
        this.intrinsicsMap.put(new Key(owner.toUnsafe(), receiverParameter, name, valueParameterCount), impl);
    }

    @Nullable
    public IntrinsicMethod getIntrinsic(@NotNull CallableMemberDescriptor descriptor2) {
        Key key = new Key(DescriptorUtils.getFqName(descriptor2.getContainingDeclaration()), IntrinsicsMap.getReceiverParameterFqName(descriptor2), descriptor2.getName().asString(), IntrinsicsMap.valueParameterCountForKey(descriptor2));
        return this.intrinsicsMap.get(key);
    }

    @Nullable
    private static FqNameUnsafe getReceiverParameterFqName(@NotNull CallableMemberDescriptor descriptor2) {
        ReceiverParameterDescriptor receiverParameter = descriptor2.getExtensionReceiverParameter();
        if (receiverParameter == null) {
            return null;
        }
        ClassifierDescriptor classifier2 = receiverParameter.getType().getConstructor().getDeclarationDescriptor();
        if (classifier2 == null) {
            return null;
        }
        if (classifier2 instanceof TypeParameterDescriptor) {
            return IntrinsicMethods.RECEIVER_PARAMETER_FQ_NAME;
        }
        return DescriptorUtils.getFqName(classifier2);
    }

    private static final class Key {
        private final FqNameUnsafe owner;
        private final FqNameUnsafe receiverParameter;
        private final String name;
        private final int valueParameterCount;

        private Key(@NotNull FqNameUnsafe owner, @Nullable FqNameUnsafe receiverParameter, @NotNull String name, int valueParameterCount) {
            this.owner = owner;
            this.receiverParameter = receiverParameter;
            this.name = name;
            this.valueParameterCount = valueParameterCount;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            if (this.valueParameterCount != key.valueParameterCount) {
                return false;
            }
            if (!this.name.equals(key.name)) {
                return false;
            }
            if (!this.owner.equals(key.owner)) {
                return false;
            }
            return !(this.receiverParameter == null ? key.receiverParameter != null : !this.receiverParameter.equals(key.receiverParameter));
        }

        public int hashCode() {
            int result2 = this.owner.hashCode();
            result2 = 31 * result2 + this.name.hashCode();
            result2 = 31 * result2 + this.valueParameterCount;
            result2 = 31 * result2 + (this.receiverParameter != null ? this.receiverParameter.hashCode() : 0);
            return result2;
        }
    }
}

