/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.intrinsic.operation;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.translate.callTranslator.CallInfo;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.basic.FunctionIntrinsic;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.FunctionIntrinsicFactory;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.TopLevelFIF;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0007B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/js/translate/intrinsic/operation/StringPlusCharFIF;", "Lorg/jetbrains/kotlin/js/translate/intrinsic/functions/factories/FunctionIntrinsicFactory;", "()V", "getIntrinsic", "Lorg/jetbrains/kotlin/js/translate/intrinsic/functions/basic/FunctionIntrinsic;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "StringPlusAnyIntrinsic", "js.translator"})
public final class StringPlusCharFIF
implements FunctionIntrinsicFactory {
    public static final StringPlusCharFIF INSTANCE;

    @Override
    @Nullable
    public FunctionIntrinsic getIntrinsic(@NotNull FunctionDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        String fqName2 = DescriptorUtilsKt.getFqNameUnsafe(descriptor2).asString();
        if (Intrinsics.areEqual((Object)fqName2, (Object)"kotlin.String.plus") ^ true && Intrinsics.areEqual((Object)fqName2, (Object)"kotlin.plus") ^ true) {
            return null;
        }
        ReceiverParameterDescriptor receiverParameterDescriptor = descriptor2.getDispatchReceiverParameter();
        if (receiverParameterDescriptor == null) {
            receiverParameterDescriptor = descriptor2.getExtensionReceiverParameter();
        }
        if (receiverParameterDescriptor == null) {
            return null;
        }
        KotlinType leftType = receiverParameterDescriptor.getType();
        return KotlinBuiltIns.isStringOrNullableString(leftType) ? (FunctionIntrinsic)new StringPlusAnyIntrinsic(TypeUtils.isNullableType(leftType)) : null;
    }

    private StringPlusCharFIF() {
    }

    static {
        StringPlusCharFIF stringPlusCharFIF;
        INSTANCE = stringPlusCharFIF = new StringPlusCharFIF();
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/js/translate/intrinsic/operation/StringPlusCharFIF$StringPlusAnyIntrinsic;", "Lorg/jetbrains/kotlin/js/translate/intrinsic/functions/basic/FunctionIntrinsic;", "leftTypeNullable", "", "(Z)V", "apply", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "callInfo", "Lorg/jetbrains/kotlin/js/translate/callTranslator/CallInfo;", "arguments", "", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "js.translator"})
    private static final class StringPlusAnyIntrinsic
    extends FunctionIntrinsic {
        private final boolean leftTypeNullable;

        @Override
        @NotNull
        public JsExpression apply(@NotNull CallInfo callInfo, @NotNull List<? extends JsExpression> arguments2, @NotNull TranslationContext context) {
            boolean hasNonNullArg;
            KotlinType kotlinType;
            Intrinsics.checkParameterIsNotNull((Object)callInfo, (String)"callInfo");
            Intrinsics.checkParameterIsNotNull(arguments2, (String)"arguments");
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            JsExpression jsExpression = callInfo.getDispatchReceiver();
            if (jsExpression == null && (jsExpression = callInfo.getExtensionReceiver()) == null) {
                Intrinsics.throwNpe();
            }
            JsExpression receiver = jsExpression;
            BindingContext bindingContext = context.bindingContext();
            Call call2 = callInfo.getResolvedCall().getCall();
            Intrinsics.checkExpressionValueIsNotNull((Object)call2, (String)"callInfo.resolvedCall.call");
            KtExpression ktExpression = call2.getValueArguments().get(0).getArgumentExpression();
            if (ktExpression == null) {
                Intrinsics.throwNpe();
            }
            if ((kotlinType = bindingContext.getType(ktExpression)) == null) {
                ValueParameterDescriptor valueParameterDescriptor = callInfo.getResolvedCall().getResultingDescriptor().getValueParameters().get(0);
                Intrinsics.checkExpressionValueIsNotNull((Object)valueParameterDescriptor, (String)"callInfo.resolvedCall.re\u2026riptor.valueParameters[0]");
                kotlinType = valueParameterDescriptor.getType();
            }
            KotlinType rightType = kotlinType;
            boolean rightTypeNullable = TypeUtils.isNullableType(rightType);
            boolean bl = hasNonNullArg = !this.leftTypeNullable || !rightTypeNullable;
            JsExpression rightExpr = KotlinBuiltIns.isChar(rightType) ? JsAstUtils.charToString(arguments2.get(0)) : (KotlinBuiltIns.isStringOrNullableString(rightType) && hasNonNullArg ? arguments2.get(0) : TopLevelFIF.TO_STRING.apply(arguments2.get(0), (List<? extends JsExpression>)CollectionsKt.emptyList(), context));
            return new JsBinaryOperation(JsBinaryOperator.ADD, receiver, rightExpr);
        }

        public StringPlusAnyIntrinsic(boolean leftTypeNullable) {
            this.leftTypeNullable = leftTypeNullable;
        }
    }
}

