/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.bib2gls;

import com.dickimawbooks.bib2gls.Bib2Gls;
import com.dickimawbooks.bib2gls.Bib2GlsAbbrev;
import com.dickimawbooks.bib2gls.Bib2GlsDualAbbrev;
import com.dickimawbooks.bib2gls.Bib2GlsDualEntry;
import com.dickimawbooks.bib2gls.Bib2GlsDualEntryAbbrev;
import com.dickimawbooks.bib2gls.Bib2GlsDualSymbol;
import com.dickimawbooks.bib2gls.Bib2GlsEntry;
import com.dickimawbooks.bib2gls.Bib2GlsIndex;
import com.dickimawbooks.bib2gls.Bib2GlsSymbol;
import com.dickimawbooks.bib2gls.GlsResource;
import com.dickimawbooks.texparserlib.Group;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.bib.At;
import com.dickimawbooks.texparserlib.bib.BibData;
import com.dickimawbooks.texparserlib.bib.BibEntry;
import com.dickimawbooks.texparserlib.bib.BibParser;
import com.dickimawbooks.texparserlib.bib.BibPreamble;
import com.dickimawbooks.texparserlib.bib.BibTeXSyntaxException;
import com.dickimawbooks.texparserlib.bib.BibValueList;
import java.io.IOException;

public class Bib2GlsAt
extends At {
    private GlsResource resource;

    public Bib2GlsAt(GlsResource glsResource) {
        this.resource = glsResource;
    }

    @Override
    protected void process(TeXParser teXParser, TeXObjectList teXObjectList, TeXObject teXObject, TeXObject teXObject2) throws IOException {
        BibData bibData;
        if (!(teXObject instanceof TeXObjectList)) {
            throw new BibTeXSyntaxException(teXParser, "bibtex.error.expecting_or", new String[]{"{", "("});
        }
        BibParser bibParser = (BibParser)teXParser.getListener();
        Bib2Gls bib2Gls = (Bib2Gls)bibParser.getTeXApp();
        String string = teXObjectList.toString(teXParser).trim().toLowerCase();
        if (string.equals("entry")) {
            bibData = new Bib2GlsEntry(bib2Gls);
        } else if (string.equals("index")) {
            bibData = new Bib2GlsIndex(bib2Gls);
        } else if (string.equals("acronym") || string.equals("abbreviation")) {
            bibData = new Bib2GlsAbbrev(bib2Gls, string);
        } else if (string.equals("symbol") || string.equals("number")) {
            bibData = new Bib2GlsSymbol(bib2Gls, string);
        } else if (string.equals("dualentry")) {
            bibData = new Bib2GlsDualEntry(bib2Gls);
        } else if (string.equals("dualentryabbreviation")) {
            bibData = new Bib2GlsDualEntryAbbrev(bib2Gls);
        } else if (string.equals("dualabbreviation") || string.equals("dualacronym")) {
            bibData = new Bib2GlsDualAbbrev(bib2Gls, string);
        } else if (string.equals("dualsymbol") || string.equals("dualnumber")) {
            bibData = new Bib2GlsDualSymbol(bib2Gls, string);
        } else {
            bibData = BibData.createBibData(string);
            if (bibData instanceof BibEntry) {
                bib2Gls.warning(teXParser, bib2Gls.getMessage("warning.ignoring.unknown.entry.type", string));
            }
        }
        try {
            ((BibData)bibData).parseContents(teXParser, (TeXObjectList)teXObject, teXObject2);
        }
        catch (BibTeXSyntaxException bibTeXSyntaxException) {
            String string2 = null;
            StringBuilder stringBuilder = null;
            if (bibData instanceof BibEntry) {
                string2 = ((BibEntry)bibData).getId();
                if (this.containsSpecialChars(string2)) {
                    bib2Gls.warning(teXParser, bib2Gls.getMessage("warning.spchars.id", string2));
                }
                if (!bib2Gls.fontSpecLoaded() && this.containsExtendedChars(string2)) {
                    bib2Gls.warning(teXParser, bib2Gls.getMessage("warning.notbasiclatin.id", string2));
                }
            }
            stringBuilder = new StringBuilder();
            for (TeXObject teXObject3 : (TeXObjectList)teXObject) {
                stringBuilder.append(teXObject3.toString(teXParser));
                if (!(teXObject3 instanceof Group)) continue;
                break;
            }
            if (stringBuilder != null && stringBuilder.length() > 0) {
                if (string2 == null) {
                    throw new IOException(bib2Gls.getMessage("error.bib.contents.parse.before", ((BibData)bibData).getEntryType(), bibTeXSyntaxException.getMessage(bib2Gls), stringBuilder), bibTeXSyntaxException);
                }
                throw new IOException(bib2Gls.getMessage("error.bib.contents.parse.data.before", ((BibData)bibData).getEntryType(), string2, bibTeXSyntaxException.getMessage(bib2Gls), stringBuilder), bibTeXSyntaxException);
            }
            if (string2 != null) {
                throw new IOException(bib2Gls.getMessage("error.bib.contents.parse.data", ((BibData)bibData).getEntryType(), string2, bibTeXSyntaxException.getMessage(bib2Gls)), bibTeXSyntaxException);
            }
            throw new IOException(bib2Gls.getMessage("error.bib.contents.parse", ((BibData)bibData).getEntryType(), bibTeXSyntaxException.getMessage(bib2Gls)), bibTeXSyntaxException);
        }
        if (bibData instanceof BibPreamble) {
            BibValueList bibValueList = ((BibPreamble)bibData).getPreamble();
            TeXObjectList teXObjectList2 = bibValueList.expand(teXParser);
            this.resource.setPreamble(teXObjectList2.toString(teXParser), bibValueList);
        } else if (bibData instanceof Bib2GlsEntry) {
            bibData.initAlias(teXParser);
        }
        bibParser.addBibData(bibData);
    }

    protected boolean containsSpecialChars(String string) {
        int n;
        int n2 = string.length();
        for (int i = 0; i < n2; i += Character.charCount(n)) {
            n = string.codePointAt(i);
            if (n != 36 && n != 94 && n != 126 && n != 35 && n != 123 && n != 125 && n != 95 && n != 38 && n != 92 && n != 37) continue;
            return true;
        }
        return false;
    }

    protected boolean containsExtendedChars(String string) {
        int n;
        int n2 = string.length();
        for (int i = 0; i < n2; i += Character.charCount(n)) {
            n = string.codePointAt(i);
            if (n <= 127) continue;
            return true;
        }
        return false;
    }
}

