/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib;

import com.dickimawbooks.texparserlib.ActiveChar;
import com.dickimawbooks.texparserlib.AssignedMacro;
import com.dickimawbooks.texparserlib.Expandable;
import com.dickimawbooks.texparserlib.Macro;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import java.io.IOException;

public class AssignedActiveChar
extends ActiveChar {
    private TeXObject underlying;
    private int charCode;

    public AssignedActiveChar(int n, TeXObject teXObject) {
        this.charCode = n;
        this.underlying = teXObject;
        if (teXObject instanceof Macro) {
            Macro macro = (Macro)teXObject;
            this.setAllowsPrefix(macro.getAllowsPrefix());
            this.setShort(macro.isShort());
            this.setSyntax(macro.getSyntax());
        }
    }

    @Override
    public int getCharCode() {
        return this.charCode;
    }

    @Override
    public Object clone() {
        return new AssignedActiveChar(this.getCharCode(), (TeXObject)this.underlying.clone());
    }

    @Override
    public boolean isPar() {
        return this.underlying.isPar();
    }

    @Override
    protected void setPrefix(byte by) {
        if (this.underlying instanceof Macro) {
            Macro macro = (Macro)this.underlying;
            macro.setPrefix(by);
            super.setPrefix(by);
        }
    }

    @Override
    protected void clearPrefix() {
        if (this.underlying instanceof Macro) {
            ((Macro)this.underlying).clearPrefix();
            super.clearPrefix();
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || !(object instanceof TeXObject)) {
            return false;
        }
        if (object instanceof AssignedMacro) {
            return this.underlying.equals(((AssignedMacro)object).getUnderlying());
        }
        return this.underlying.equals(object);
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        this.underlying.process(teXParser);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        this.underlying.process(teXParser, teXObjectList);
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser) throws IOException {
        if (!(this.underlying instanceof Expandable)) {
            return null;
        }
        return ((Expandable)((Object)this.underlying)).expandonce(teXParser);
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        if (!(this.underlying instanceof Expandable)) {
            return null;
        }
        return ((Expandable)((Object)this.underlying)).expandonce(teXParser, teXObjectList);
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser) throws IOException {
        if (!(this.underlying instanceof Expandable)) {
            return null;
        }
        return ((Expandable)((Object)this.underlying)).expandfully(teXParser);
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        if (!(this.underlying instanceof Expandable)) {
            return null;
        }
        return ((Expandable)((Object)this.underlying)).expandfully(teXParser, teXObjectList);
    }

    @Override
    public String toString(TeXParser teXParser) {
        StringBuilder stringBuilder = new StringBuilder(2);
        try {
            stringBuilder.appendCodePoint(this.charCode);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return String.format("%c", Character.valueOf((char)this.charCode));
        }
        return stringBuilder.toString();
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(2);
        stringBuilder.appendCodePoint(this.getCharCode());
        return stringBuilder.toString();
    }

    @Override
    public TeXObjectList string(TeXParser teXParser) throws IOException {
        TeXObjectList teXObjectList = new TeXObjectList();
        teXObjectList.add(teXParser.getListener().getOther(this.charCode));
        return teXObjectList;
    }
}

