/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib;

import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import java.io.IOException;

public abstract class CharObject
implements TeXObject {
    protected int charCode;

    public CharObject(int n) {
        this.setCharCode(n);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CharObject) || object == null) {
            return false;
        }
        return ((CharObject)object).getCharCode() == this.getCharCode();
    }

    @Override
    public abstract Object clone();

    @Override
    public String toString(TeXParser teXParser) {
        StringBuilder stringBuilder = new StringBuilder(2);
        int n = teXParser.getSettings().getCharCode(this.getCharCode());
        if (n == -1) {
            n = this.getCharCode();
        }
        try {
            stringBuilder.appendCodePoint(n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuilder.appendCodePoint(this.getCharCode());
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return String.format("%s[%s]", this.getClass().getSimpleName(), this.format());
    }

    @Override
    public String format() {
        StringBuilder stringBuilder = new StringBuilder(2);
        stringBuilder.appendCodePoint(this.getCharCode());
        return stringBuilder.toString();
    }

    @Override
    public TeXObjectList string(TeXParser teXParser) throws IOException {
        TeXObjectList teXObjectList = new TeXObjectList();
        teXObjectList.add(this);
        return teXObjectList;
    }

    public int getCharCode() {
        return this.charCode;
    }

    public void setCharCode(int n) {
        this.charCode = n;
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        int n = teXParser.getSettings().getCharCode(this.charCode);
        teXParser.getListener().getWriteable().writeCodePoint(n == -1 ? this.charCode : n);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        this.process(teXParser);
    }

    @Override
    public boolean isPar() {
        return false;
    }
}

