/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib;

import com.dickimawbooks.texparserlib.CharObject;
import com.dickimawbooks.texparserlib.Expandable;
import com.dickimawbooks.texparserlib.Numerical;
import com.dickimawbooks.texparserlib.Register;
import com.dickimawbooks.texparserlib.TeXNumber;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import java.io.IOException;

public class CountRegister
extends Register
implements TeXNumber {
    private int value = 0;

    public CountRegister(String string) {
        this(string, 0);
    }

    public CountRegister(String string, int n) {
        super(string);
        this.setValue(n);
    }

    public void setValue(int n) {
        this.value = n;
    }

    @Override
    public void setValue(TeXParser teXParser, Numerical numerical) throws TeXSyntaxException {
        this.setValue(numerical.number(teXParser));
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public int number(TeXParser teXParser) throws TeXSyntaxException {
        return this.value;
    }

    @Override
    public TeXObject the(TeXParser teXParser) {
        return teXParser.string("" + this.value);
    }

    public void advance() {
        ++this.value;
    }

    @Override
    public void advance(TeXParser teXParser, Numerical numerical) throws TeXSyntaxException {
        this.value += numerical.number(teXParser);
    }

    @Override
    public void divide(int n) {
        this.value /= n;
    }

    @Override
    public void multiply(int n) {
        this.value *= n;
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        TeXObject teXObject;
        TeXObject teXObject2 = teXParser.popStack(teXParser, true);
        if (teXObject2 instanceof Expandable && (teXObject = ((Expandable)((Object)teXObject2)).expandfully(teXParser)) != null) {
            teXParser.addAll(teXObject);
            teXObject2 = teXParser.popStack(teXParser, true);
        }
        if (teXObject2 instanceof CharObject && ((CharObject)teXObject2).getCharCode() == 61 && (teXObject2 = teXParser.popStack(teXParser, true)) instanceof Expandable && (teXObject = ((Expandable)((Object)teXObject2)).expandfully(teXParser)) != null) {
            teXParser.addAll(teXObject);
            teXObject2 = teXParser.popStack(teXParser, true);
        }
        if (teXObject2 instanceof Register) {
            this.value = ((Register)teXObject2).number(teXParser);
            return;
        }
        teXParser.push(teXObject2);
        teXObject = teXParser.popNumber();
        this.value = teXObject.getValue();
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject;
        TeXObject teXObject2 = teXObjectList.popStack(teXParser, true);
        if (teXObject2 instanceof Expandable && (teXObject = ((Expandable)((Object)teXObject2)).expandfully(teXParser, teXObjectList)) != null) {
            teXObjectList.addAll(teXObject);
            teXObject2 = teXObjectList.popStack(teXParser, true);
        }
        if (teXObject2 instanceof CharObject && ((CharObject)teXObject2).getCharCode() == 61 && (teXObject2 = teXObjectList.popStack(teXParser, true)) instanceof Expandable && (teXObject = ((Expandable)((Object)teXObject2)).expandfully(teXParser, teXObjectList)) != null) {
            teXObjectList.addAll(teXObject);
            teXObject2 = teXObjectList.popStack(teXParser, true);
        }
        if (teXObject2 instanceof Register) {
            this.value = ((Register)teXObject2).number(teXParser);
            return;
        }
        teXObjectList.push(teXObject2);
        teXObject = teXObjectList.popNumber(teXParser);
        this.value = teXObject.getValue();
    }

    @Override
    public Object clone() {
        CountRegister countRegister = new CountRegister(this.getName(), this.value);
        countRegister.allocation = this.allocation;
        return countRegister;
    }

    @Override
    public String toString() {
        return String.format("%s[name=%s,value=%d]", this.getClass().getSimpleName(), this.getName(), this.value);
    }
}

