/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.probsoln;

import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.GenericCommand;
import com.dickimawbooks.texparserlib.TeXCsRef;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.latex.KeyValList;
import com.dickimawbooks.texparserlib.latex.LaTeXParserListener;
import com.dickimawbooks.texparserlib.latex.LaTeXSty;
import com.dickimawbooks.texparserlib.latex.probsoln.DefProblem;
import com.dickimawbooks.texparserlib.latex.probsoln.ForEachProblem;
import com.dickimawbooks.texparserlib.latex.probsoln.NewProblem;
import com.dickimawbooks.texparserlib.latex.probsoln.OnlyProblem;
import com.dickimawbooks.texparserlib.latex.probsoln.OnlySolution;
import com.dickimawbooks.texparserlib.latex.probsoln.ProbSolnData;
import com.dickimawbooks.texparserlib.latex.probsoln.ProbSolnDatabase;
import com.dickimawbooks.texparserlib.latex.probsoln.ProbSolnException;
import com.dickimawbooks.texparserlib.latex.probsoln.Question;
import com.dickimawbooks.texparserlib.latex.probsoln.Solution;
import com.dickimawbooks.texparserlib.latex.probsoln.TextEnum;
import com.dickimawbooks.texparserlib.latex.probsoln.UseProblem;
import com.dickimawbooks.texparserlib.primitives.NewIf;
import java.io.IOException;
import java.util.HashMap;
import java.util.Set;

public class ProbSolnSty
extends LaTeXSty {
    private String currentDb = "default";
    private HashMap<String, ProbSolnDatabase> databases = new HashMap();

    public ProbSolnSty(KeyValList keyValList, LaTeXParserListener laTeXParserListener) throws IOException {
        super(keyValList, "probsoln", laTeXParserListener);
        ProbSolnDatabase probSolnDatabase = new ProbSolnDatabase("default");
        this.databases.put("default", probSolnDatabase);
    }

    @Override
    public void addDefinitions() {
        this.registerControlSequence(new DefProblem(this));
        this.registerControlSequence(new OnlyProblem());
        this.registerControlSequence(new OnlySolution());
        this.registerControlSequence(new UseProblem(this));
        this.registerControlSequence(new NewProblem(this));
        this.registerControlSequence(new Question());
        this.registerControlSequence(new TextEnum());
        this.registerControlSequence(new ForEachProblem(this));
        if (this.getParser().getControlSequence("solution") == null) {
            this.registerControlSequence(new Solution());
        }
        this.registerControlSequence(new GenericCommand("solutionname", null, this.getListener().createString("Solution")));
        TeXObjectList teXObjectList = new TeXObjectList();
        teXObjectList.add(new TeXCsRef("let"));
        teXObjectList.add(new TeXCsRef("ifshowanswers"));
        teXObjectList.add(new TeXCsRef("iftrue"));
        this.registerControlSequence(new GenericCommand(true, "showanswers", null, teXObjectList));
        teXObjectList = new TeXObjectList();
        teXObjectList.add(new TeXCsRef("let"));
        teXObjectList.add(new TeXCsRef("ifshowanswers"));
        teXObjectList.add(new TeXCsRef("iffalse"));
        this.registerControlSequence(new GenericCommand(true, "hideanswers", null, teXObjectList));
    }

    @Override
    public void processOption(String string) throws IOException {
        if (string.equals("answers")) {
            this.getListener().getControlSequence("showanswerstrue").process(this.getParser());
        } else if (string.equals("noanswers")) {
            this.getListener().getControlSequence("showanswersfalse").process(this.getParser());
        } else if (string.equals("usedefaultargs")) {
            this.getListener().getControlSequence("usedefaultprobargstrue").process(this.getParser());
        } else if (string.equals("usenodefaultargs")) {
            this.getListener().getControlSequence("usedefaultprobargsfalse").process(this.getParser());
        }
    }

    public boolean useDefaultArgs() {
        ControlSequence controlSequence = this.getListener().getControlSequence("ifusedefaultprobargs");
        return this.getListener().isIfTrue(controlSequence);
    }

    @Override
    protected void preOptions() throws IOException {
        NewIf.createConditional(this.getListener().getParser(), "ifshowanswers");
        NewIf.createConditional(this.getListener().getParser(), "ifusedefaultprobargs");
    }

    public ProbSolnDatabase getDatabase(String string) throws ProbSolnException {
        ProbSolnDatabase probSolnDatabase = this.databases.get(string);
        if (probSolnDatabase == null) {
            throw new ProbSolnException(this.getParser(), "probsoln.no_such_db", string);
        }
        return probSolnDatabase;
    }

    public ProbSolnData getProblem(String string, String string2) throws ProbSolnException {
        ProbSolnData probSolnData = (ProbSolnData)this.getDatabase(string2).get(string);
        if (probSolnData == null) {
            throw new ProbSolnException(this.getParser(), "probsoln.no_such_entry_in_db", new String[]{string, string2});
        }
        return probSolnData;
    }

    public void addDatabase(String string) throws ProbSolnException {
        if (this.databases.containsKey(string)) {
            throw new ProbSolnException(this.getParser(), "probsoln.db_exists", string);
        }
        ProbSolnDatabase probSolnDatabase = new ProbSolnDatabase(string);
        this.databases.put(string, probSolnDatabase);
    }

    public void moveProblem(String string, String string2, String string3) throws ProbSolnException {
        ProbSolnDatabase probSolnDatabase = this.databases.get(string2);
        if (probSolnDatabase == null) {
            throw new ProbSolnException(this.getParser(), "probsoln.no_such_db", string2);
        }
        ProbSolnData probSolnData = (ProbSolnData)probSolnDatabase.remove(string);
        if (probSolnData == null) {
            throw new ProbSolnException(this.getParser(), "probsoln.no_such_entry_in_db", new String[]{string, string2});
        }
        probSolnDatabase = this.databases.get(string3);
        if (probSolnDatabase == null) {
            throw new ProbSolnException(this.getParser(), "probsoln.no_such_db", string3);
        }
        probSolnDatabase.put(string, probSolnData);
    }

    public Set<String> getDatabaseLabels() {
        return this.databases.keySet();
    }

    public int getDatabaseCount() {
        return this.databases.size();
    }

    public void addProblem(ProbSolnData probSolnData) throws ProbSolnException {
        ProbSolnDatabase probSolnDatabase = this.getDatabase(this.currentDb);
        probSolnDatabase.put(probSolnData.getName(), probSolnData);
    }
}

