/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util.repository;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.eclipse.aether.repository.Authentication;
import org.eclipse.aether.repository.AuthenticationContext;
import org.eclipse.aether.repository.AuthenticationDigest;

final class SecretAuthentication
implements Authentication {
    private static final Object[] KEYS = new Object[16];
    private final String key;
    private final char[] value;
    private final int secretHash;

    public SecretAuthentication(String key2, String value) {
        this(value != null ? value.toCharArray() : null, key2);
    }

    public SecretAuthentication(String key2, char[] value) {
        this(SecretAuthentication.copy(value), key2);
    }

    private SecretAuthentication(char[] value, String key2) {
        this.key = Objects.requireNonNull(key2, "authentication key cannot be null");
        if (key2.length() == 0) {
            throw new IllegalArgumentException("authentication key cannot be empty");
        }
        this.secretHash = Arrays.hashCode(value) ^ KEYS[0].hashCode();
        this.value = this.xor(value);
    }

    private static char[] copy(char[] chars2) {
        return chars2 != null ? (char[])chars2.clone() : null;
    }

    private char[] xor(char[] chars2) {
        if (chars2 != null) {
            int mask = System.identityHashCode(this);
            for (int i = 0; i < chars2.length; ++i) {
                int key2 = KEYS[(i >> 1) % KEYS.length].hashCode();
                int n = i;
                chars2[n] = (char)(chars2[n] ^ ((i & 1) == 0 ? key2 & 0xFFFF : (key2 ^= mask) >>> 16));
            }
        }
        return chars2;
    }

    private static void clear(char[] chars2) {
        if (chars2 != null) {
            for (int i = 0; i < chars2.length; ++i) {
                chars2[i] = '\u0000';
            }
        }
    }

    @Override
    public void fill(AuthenticationContext context, String key2, Map<String, String> data2) {
        char[] secret = SecretAuthentication.copy(this.value);
        this.xor(secret);
        context.put(this.key, secret);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void digest(AuthenticationDigest digest) {
        char[] secret = SecretAuthentication.copy(this.value);
        try {
            this.xor(secret);
            digest.update(this.key);
            digest.update(secret);
        }
        finally {
            SecretAuthentication.clear(secret);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        SecretAuthentication that = (SecretAuthentication)obj;
        if (!SecretAuthentication.eq(this.key, that.key) || this.secretHash != that.secretHash) {
            return false;
        }
        char[] secret = SecretAuthentication.copy(this.value);
        char[] thatSecret = SecretAuthentication.copy(that.value);
        try {
            this.xor(secret);
            that.xor(thatSecret);
            boolean bl = Arrays.equals(secret, thatSecret);
            return bl;
        }
        finally {
            SecretAuthentication.clear(secret);
            SecretAuthentication.clear(thatSecret);
        }
    }

    private static <T> boolean eq(T s1, T s2) {
        return s1 != null ? s1.equals(s2) : s2 == null;
    }

    public int hashCode() {
        int hash2 = 17;
        hash2 = hash2 * 31 + this.key.hashCode();
        hash2 = hash2 * 31 + this.secretHash;
        return hash2;
    }

    public String toString() {
        return this.key + "=" + (this.value != null ? "***" : "null");
    }

    static {
        for (int i = 0; i < KEYS.length; ++i) {
            SecretAuthentication.KEYS[i] = new Object();
        }
    }
}

