/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.util;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.util.InvalidJarHeaderException;

public class JarFile
extends java.util.jar.JarFile
implements Closeable {
    private static final byte[] ZIP_ENTRY_HEADER_SIGNATURE = new byte[]{80, 75, 3, 4};

    public JarFile(String name) throws IOException {
        super(name);
        this.verifyZipHeader(new File(name));
    }

    public JarFile(String name, boolean verify) throws IOException {
        super(name, verify);
        this.verifyZipHeader(new File(name));
    }

    public JarFile(File file) throws IOException {
        super(file);
        this.verifyZipHeader(file);
    }

    public JarFile(File file, boolean verify) throws IOException {
        super(file, verify);
        this.verifyZipHeader(file);
    }

    public JarFile(File file, boolean verify, int mode) throws IOException {
        super(file, verify, mode);
        this.verifyZipHeader(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyZipHeader(File file) throws IOException {
        if (!JNLPRuntime.isIgnoreHeaders()) {
            try (FileInputStream s = new FileInputStream(file);){
                byte[] buffer = new byte[ZIP_ENTRY_HEADER_SIGNATURE.length];
                for (int i = 0; i < buffer.length; ++i) {
                    buffer[i] = 0;
                }
                int toRead = ZIP_ENTRY_HEADER_SIGNATURE.length;
                int readSoFar = 0;
                int n = 0;
                while ((n = ((InputStream)s).read(buffer, readSoFar, buffer.length - readSoFar)) != -1 && (readSoFar += n) != toRead) {
                }
                for (int i = 0; i < buffer.length; ++i) {
                    if (buffer[i] == ZIP_ENTRY_HEADER_SIGNATURE[i]) continue;
                    throw new InvalidJarHeaderException("Jar " + file.getName() + " do not heave valid header. You can skip this check by -Xignoreheaders");
                }
            }
        }
    }
}

