/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texosquery;

import com.dickimawbooks.texosquery.FileListType;
import com.dickimawbooks.texosquery.FileSortComparator;
import com.dickimawbooks.texosquery.FileSortType;
import com.dickimawbooks.texosquery.QueryAction;
import com.dickimawbooks.texosquery.QueryActionType;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.Format;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TeXOSQuery
implements Serializable {
    private final QueryAction[] AVAILABLE_ACTIONS = new QueryAction[]{new QueryAction("cwd", "c", QueryActionType.FILE_ACTION, "Display current working directory"){

        public String action() {
            return TeXOSQuery.this.getCwd();
        }
    }, new QueryAction("userhome", "m", QueryActionType.FILE_ACTION, "Display user's home directory"){

        public String action() {
            return TeXOSQuery.this.getUserHome();
        }
    }, new QueryAction("tmpdir", "t", QueryActionType.FILE_ACTION, "Display temporary directory"){

        public String action() {
            return TeXOSQuery.this.getTmpDir();
        }
    }, new QueryAction("osname", "o", QueryActionType.GENERAL_ACTION, "Display OS name"){

        public String action() {
            return TeXOSQuery.this.getOSname();
        }
    }, new QueryAction("osversion", "r", QueryActionType.GENERAL_ACTION, "Display OS version"){

        public String action() {
            return TeXOSQuery.this.getOSversion();
        }
    }, new QueryAction("osarch", "a", QueryActionType.GENERAL_ACTION, "Display OS architecture"){

        public String action() {
            return TeXOSQuery.this.getOSarch();
        }
    }, new QueryAction("pdfnow", "n", QueryActionType.GENERAL_ACTION, "Display current date-time in PDF format"){

        public String action() {
            return TeXOSQuery.this.pdfnow();
        }
    }, new QueryAction("locale", "L", QueryActionType.LOCALE_ACTION, "Display POSIX locale information"){

        public String action() {
            return TeXOSQuery.this.getLocale(Locale.getDefault());
        }
    }, new QueryAction("locale-lcs", "l", QueryActionType.LOCALE_ACTION, "Display POSIX style locale information with lower case codeset"){

        public String action() {
            return TeXOSQuery.this.getLocale(Locale.getDefault(), true);
        }
    }, new QueryAction("codeset", "cs", QueryActionType.GENERAL_ACTION, "Display the codeset", 2){

        public String action() {
            return TeXOSQuery.this.escapeFileName(TeXOSQuery.this.getCodeSet(false));
        }
    }, new QueryAction("codeset-lcs", "C", QueryActionType.GENERAL_ACTION, "Lower case codeset with hyphens stripped", 2){

        public String action() {
            return TeXOSQuery.this.escapeFileName(TeXOSQuery.this.getCodeSet(true));
        }
    }, new QueryAction("bcp47", "b", QueryActionType.LOCALE_ACTION, "Display locale as BCP47 tag", 2){

        public String action() {
            return TeXOSQuery.this.escapeFileName(TeXOSQuery.this.getLanguageTag(null));
        }
    }, new QueryAction("numeric", "N", 1, 0, "[locale]", QueryActionType.LOCALE_ACTION, "Display locale numeric information", 2){

        public String action() {
            return TeXOSQuery.this.getNumericalInfo(this.getOptionalArgument(0));
        }
    }, new QueryAction("locale-data", "D", 1, 0, "[locale]", QueryActionType.LOCALE_ACTION, "Display all available locale information", 2){

        public String action() {
            return TeXOSQuery.this.getLocaleData(this.getOptionalArgument(0));
        }
    }, new QueryAction("date-time", "M", QueryActionType.GENERAL_ACTION, "Display all the current date-time data", 2){

        public String action() {
            return TeXOSQuery.this.getDateTimeData();
        }
    }, new QueryAction("time-zones", "Z", 1, 0, "[locale]", QueryActionType.LOCALE_ACTION, "Display all available time zone information", 2){

        public String action() {
            return TeXOSQuery.this.getTimeZones(this.getOptionalArgument(0));
        }
    }, new QueryAction("pdfdate", "d", 0, 1, "<file>", QueryActionType.FILE_ACTION, "Display date stamp of <file> in PDF format"){

        public String action() {
            return TeXOSQuery.this.pdfDate(TeXOSQuery.this.fileFromTeXPath(this.getRequiredArgument(0)));
        }
    }, new QueryAction("filesize", "s", 0, 1, "<file>", QueryActionType.FILE_ACTION, "Display size of <file> in bytes"){

        public String action() {
            return TeXOSQuery.this.getFileLength(TeXOSQuery.this.fileFromTeXPath(this.getRequiredArgument(0)));
        }
    }, new QueryAction("list", "i", 1, 2, "<sep> <dir> [<sort>]", QueryActionType.FILE_ACTION, String.format("Display list of all files in <dir> separated by <sep>. If <sort> is omitted, the default order is used otherwise <sort> may be one of the following: %s", FileSortType.getFileSortOptions())){

        public String action() {
            return TeXOSQuery.this.getFileList(this.getRequiredArgument(0), new File(TeXOSQuery.this.fromTeXPath(this.getRequiredArgument(1))), FileSortType.getFileSortType(this.getOptionalArgument(0)), FileListType.FILE_LIST_ANY);
        }
    }, new QueryAction("filterlist", "f", 1, 3, "<sep> <regex> <dir> [<sort>]", QueryActionType.FILE_ACTION, String.format("Display list of files in <dir> that fully match <regex> separated by <sep>. If <sort> is omitted, the default order is used otherwise <sort> may be one of the following: %s", FileSortType.getFileSortOptions())){

        public String action() {
            return TeXOSQuery.this.getFilterFileList(this.getRequiredArgument(0), this.getRequiredArgument(1), new File(TeXOSQuery.this.fromTeXPath(this.getRequiredArgument(2))), FileSortType.getFileSortType(this.getOptionalArgument(0)), FileListType.FILE_LIST_ANY);
        }
    }, new QueryAction("list-dir", "id", 1, 2, "<sep> <dir> [<sort>]", QueryActionType.FILE_ACTION, String.format("Display list of all sub-directories in <dir> separated by <sep>. If <sort> is omitted, the default order is used otherwise <sort> may be one of the following: %s", FileSortType.getFileSortOptions())){

        public String action() {
            return TeXOSQuery.this.getFileList(this.getRequiredArgument(0), new File(TeXOSQuery.this.fromTeXPath(this.getRequiredArgument(1))), FileSortType.getFileSortType(this.getOptionalArgument(0)), FileListType.FILE_LIST_DIRECTORIES_ONLY);
        }
    }, new QueryAction("filterlist-dir", "fd", 1, 3, "<sep> <regex> <dir> [<sort>]", QueryActionType.FILE_ACTION, String.format("Display list of sub-directories in <dir> that fully match <regex> separated by <sep>. If <sort> is omitted, the default order is used otherwise <sort> may be one of the following: %s", FileSortType.getFileSortOptions())){

        public String action() {
            return TeXOSQuery.this.getFilterFileList(this.getRequiredArgument(0), this.getRequiredArgument(1), new File(TeXOSQuery.this.fromTeXPath(this.getRequiredArgument(2))), FileSortType.getFileSortType(this.getOptionalArgument(0)), FileListType.FILE_LIST_DIRECTORIES_ONLY);
        }
    }, new QueryAction("list-regular", "ir", 1, 2, "<sep> <dir> [<sort>]", QueryActionType.FILE_ACTION, String.format("Display list of all regular files in <dir> separated by <sep>. If <sort> is omitted, the default order is used otherwise <sort> may be one of the following: %s", FileSortType.getFileSortOptions())){

        public String action() {
            return TeXOSQuery.this.getFileList(this.getRequiredArgument(0), new File(TeXOSQuery.this.fromTeXPath(this.getRequiredArgument(1))), FileSortType.getFileSortType(this.getOptionalArgument(0)), FileListType.FILE_LIST_REGULAR_FILES_ONLY);
        }
    }, new QueryAction("filterlist-regular", "fr", 1, 3, "<sep> <regex> <dir> [<sort>]", QueryActionType.FILE_ACTION, String.format("Display list of regular files in <dir> that fully match <regex> separated by <sep>. If <sort> is omitted, the default order is used otherwise <sort> may be one of the following: %s", FileSortType.getFileSortOptions())){

        public String action() {
            return TeXOSQuery.this.getFilterFileList(this.getRequiredArgument(0), this.getRequiredArgument(1), new File(TeXOSQuery.this.fromTeXPath(this.getRequiredArgument(2))), FileSortType.getFileSortType(this.getOptionalArgument(0)), FileListType.FILE_LIST_REGULAR_FILES_ONLY);
        }
    }, new QueryAction("walk", "w", 1, 3, "<sep> <regex> <dir> [<sort>]", QueryActionType.FILE_ACTION, String.format("Display list of regular non-hidden files in <dir> (descending sub-directories) that fully match <regex> separated by <sep>. The starting directory <dir> may not be outside the current working directory. This action is not available for texosquery-jre5. If <sort> is omitted, the default order is used otherwise <sort> may be one of the following: %s", FileSortType.getFileSortOptions()), 2){

        public String action() {
            return TeXOSQuery.this.walk(this.getRequiredArgument(0), this.getRequiredArgument(1), new File(TeXOSQuery.this.fromTeXPath(this.getRequiredArgument(2))), FileSortType.getFileSortType(this.getOptionalArgument(0)));
        }
    }, new QueryAction("uri", "u", 0, 1, "<file>", QueryActionType.FILE_ACTION, "Display the URI of <file>"){

        public String action() {
            return TeXOSQuery.this.fileURI(TeXOSQuery.this.fileFromTeXPath(this.getRequiredArgument(0)));
        }
    }, new QueryAction("path", "p", 0, 1, "<file>", QueryActionType.FILE_ACTION, "Display the canonical path of <file>"){

        public String action() {
            return TeXOSQuery.this.filePath(TeXOSQuery.this.fileFromTeXPath(this.getRequiredArgument(0)));
        }
    }, new QueryAction("dirname", "e", 0, 1, "<file>", QueryActionType.FILE_ACTION, "Display the canonical path of the parent of <file>"){

        public String action() {
            return TeXOSQuery.this.parentPath(TeXOSQuery.this.fileFromTeXPath(this.getRequiredArgument(0)));
        }
    }};
    private String name;
    public static final int DEFAULT_COMPATIBLE = 2;
    private static final String VERSION_NUMBER = "1.6";
    private static final String VERSION_DATE = "2017-06-20";
    private static final char BACKSLASH = '\\';
    private static final long ZERO = 0L;
    private Date now = new Date();
    protected static final char OPENIN_UNSET = '\u0000';
    protected static final char OPENIN_A = 'a';
    protected static final char OPENIN_R = 'r';
    protected static final char OPENIN_P = 'p';
    private char openin = '\u0000';
    private File texmfoutput = null;
    private String stripFilePrefix = null;
    private String pathRegExp = null;
    private String pathReplacement = null;
    private String stripURIPrefix = null;
    private String uriRegExp = null;
    private String uriReplacement = null;
    private String fileEncoding = null;
    private int debugLevel = 0;
    public static final int DEFAULT_DEBUG_LEVEL = 3;
    public static final int DEBUG_ERROR_LEVEL = 1;
    public static final int DEBUG_STACK_TRACE_LEVEL = 2;
    public static final int DEBUG_INFO_LEVEL = 3;
    private int compatible = 2;
    private static final int MAX_DIGIT_FORMAT = 10;
    private static final char DOLLAR_CHAR = '$';
    private static final char CENT_CHAR = '\u00a2';
    private static final char POUND_CHAR = '\u00a3';
    private static final String POUND_STRING = "\u00a3";
    private static final char CURRENCY_CHAR = '\u00a4';
    private static final char YEN_CHAR = '\u00a5';
    private static final char ECU_CHAR = '\u20a0';
    private static final char COLON_CURRENCY_CHAR = '\u20a1';
    private static final char CRUZEIRO_CHAR = '\u20a2';
    private static final char FRANC_CHAR = '\u20a3';
    private static final char LIRA_CHAR = '\u20a4';
    private static final char MILL_CURRENCY_CHAR = '\u20a5';
    private static final char NAIRA_CHAR = '\u20a6';
    private static final char PESETA_CHAR = '\u20a7';
    private static final char LEGACY_RUPEE_CHAR = '\u20a8';
    private static final char WON_CHAR = '\u20a9';
    private static final char NEW_SHEQEL_CHAR = '\u20aa';
    private static final char DONG_CHAR = '\u20ab';
    private static final char EURO_CHAR = '\u20ac';
    private static final char KIP_CHAR = '\u20ad';
    private static final char TUGRIK_CHAR = '\u20ae';
    private static final char DRACHMA_CHAR = '\u20af';
    private static final char GERMAN_PENNY_CHAR = '\u20b0';
    private static final char PESO_CHAR = '\u20b1';
    private static final char GUARANI_CHAR = '\u20b2';
    private static final char AUSTRAL_CHAR = '\u20b3';
    private static final char HRYVNIA_CHAR = '\u20b4';
    private static final char CEDI_CHAR = '\u20b5';
    private static final char LIVRE_TOURNOIS_CHAR = '\u20b6';
    private static final char SPESMILO_CHAR = '\u20b7';
    private static final char TENGE_CHAR = '\u20b8';
    private static final char RUPEE_CHAR = '\u20b9';
    private static final char TURKISH_LIRA_CHAR = '\u20ba';
    private static final char NORDIC_MARK_CHAR = '\u20bb';
    private static final char MANAT_CHAR = '\u20bc';
    private static final char RUBLE_CHAR = '\u20bd';
    private static final char PERMILLE_CHAR = '\u2030';

    public TeXOSQuery(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String kpsewhich(String string) throws IOException, InterruptedException {
        Process process = new ProcessBuilder("kpsewhich", string).start();
        int n = process.waitFor();
        String string2 = null;
        if (n == 0) {
            InputStream inputStream = process.getInputStream();
            if (inputStream == null) {
                throw new IOException(String.format("Unable to open input stream from process: kpsewhich '%s'", string));
            }
            BufferedReader bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                string2 = bufferedReader.readLine();
            }
            finally {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
        } else {
            throw new IOException(String.format("\"kpsewhich '%s'\" failed with exit code: %d", string, n));
        }
        return string2;
    }

    public void debug(String string, int n) {
        if (this.debugLevel >= n) {
            System.err.println(String.format("%s: %s", this.name, string));
        }
    }

    public void debug(String string) {
        this.debug(string, 1);
    }

    public void info(String string) {
        this.debug(string, 3);
    }

    public void debug(String string, Throwable throwable, int n, int n2) {
        this.debug(string, n);
        if (throwable != null) {
            this.debug(throwable.getMessage(), n);
            if (this.debugLevel >= n2) {
                throwable.printStackTrace();
            }
        }
    }

    public void debug(String string, Throwable throwable) {
        this.debug(string, throwable, 1, 2);
    }

    protected boolean isFileInTree(File file, File file2) throws IOException {
        if (file == null || file2 == null) {
            return false;
        }
        file = file.getCanonicalFile();
        file2 = file2.getCanonicalFile();
        for (File file3 = file.getParentFile(); file3 != null; file3 = file3.getParentFile()) {
            if (!file3.equals(file2)) continue;
            return true;
        }
        return false;
    }

    public boolean isHidden(File file) {
        try {
            return file.getCanonicalFile().isHidden();
        }
        catch (IOException iOException) {
            this.debug(String.format("Unable to convert file to a canonical path: ", file.toString()), iOException);
            return true;
        }
    }

    public char openinFallbackValue() {
        return 'a';
    }

    public boolean isReadPermitted(File file) {
        if (file == null || !file.exists()) {
            return false;
        }
        try {
            Object object;
            if (this.openin == '\u0000') {
                try {
                    object = this.kpsewhich("-var-value=openin_any");
                    if ("a".equals(object)) {
                        this.openin = (char)97;
                    } else if ("r".equals(object)) {
                        this.openin = (char)114;
                    } else if ("p".equals(object)) {
                        this.openin = (char)112;
                    } else {
                        this.openin = this.openinFallbackValue();
                        this.debug(String.format("Invalid openin_any value: %s%nUsing fallback value: %s", object, Character.valueOf(this.openin)));
                    }
                }
                catch (Exception exception) {
                    this.debug("Can't determine openin value, assuming 'p'", exception);
                    this.openin = (char)112;
                }
                if (this.openin == 'p') {
                    object = null;
                    try {
                        object = System.getenv("TEXMFOUTPUT");
                    }
                    catch (SecurityException securityException) {
                        this.debug("Can't query TEXMFOUTPUT", securityException);
                    }
                    if (object != null && !"".equals(object)) {
                        this.texmfoutput = new File(this.fromTeXPath((String)object));
                        if (!this.texmfoutput.exists()) {
                            this.debug(String.format("TEXMFOUTPUT doesn't exist, ignoring: %s", this.texmfoutput.toString()));
                            this.texmfoutput = null;
                        } else if (!this.texmfoutput.isDirectory()) {
                            this.debug(String.format("TEXMFOUTPUT isn't a directory, ignoring: %s", this.texmfoutput.toString()));
                            this.texmfoutput = null;
                        } else if (!this.texmfoutput.canRead()) {
                            this.debug(String.format("TEXMFOUTPUT doesn't have read permission, ignoring: %s", this.texmfoutput.toString()));
                            this.texmfoutput = null;
                        }
                    }
                }
            }
            switch (this.openin) {
                case 'a': {
                    return file.canRead();
                }
                case 'p': {
                    if (this.isFileInTree(file, this.texmfoutput)) {
                        return file.canRead();
                    }
                    if (file.isAbsolute()) {
                        this.debug(String.format("Read access forbidden by openin_any=%c (has absolute path outside TEXMFOUTPUT): %s", Character.valueOf(this.openin), file));
                        return false;
                    }
                    object = new File(this.getSystemProperty("user.dir", "."));
                    if (file.getParentFile() != null && !this.isFileInTree(file, (File)object)) {
                        this.debug(String.format("Read access forbidden by openin_any=%c (outside cwd path): %s", Character.valueOf(this.openin), file));
                        return false;
                    }
                }
                case 'r': {
                    if (!this.isHidden(file)) break;
                    this.debug(String.format("Read access forbidden by openin_any=%c (hidden file): %s", Character.valueOf(this.openin), file));
                    return false;
                }
                default: {
                    this.debug(String.format("Invalid openin value: %d", Character.valueOf(this.openin)));
                    return false;
                }
            }
            return file.canRead();
        }
        catch (Exception exception) {
            this.debug(String.format("Read permission check failed: %s", file), exception);
            return false;
        }
    }

    public String getSystemProperty(String string, String string2) {
        try {
            return System.getProperty(string, string2);
        }
        catch (SecurityException securityException) {
            this.debug(String.format("Unable to access property: %s", string), securityException);
            return string2;
        }
    }

    public String escapeSpChars(String string, boolean bl) {
        int n;
        if (this.compatible < 2) {
            return TeXOSQuery.escapeHash(string);
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = string.length();
        for (int i = 0; i < n2; i += Character.charCount(n)) {
            n = string.codePointAt(i);
            stringBuilder.append(this.escapeSpChars(n, bl));
        }
        return stringBuilder.toString();
    }

    public String escapeFileName(String string) {
        return this.escapeSpChars(string, false);
    }

    public String escapeText(String string) {
        return this.escapeSpChars(string, true);
    }

    public String escapeText(int n) {
        return this.escapeSpChars(n, true);
    }

    public String escapeSpChars(int n, boolean bl) {
        return this.escapeSpChars(n, bl ? "t" : "f");
    }

    public String escapeSpChars(int n, String string) {
        switch (n) {
            case 33: {
                return String.format("\\%sexc ", string);
            }
            case 34: {
                return String.format("\\%sdqt ", string);
            }
            case 35: {
                return String.format("\\%shsh ", string);
            }
            case 36: {
                return String.format("\\%sdol ", string);
            }
            case 37: {
                return String.format("\\%spct ", string);
            }
            case 38: {
                return String.format("\\%samp ", string);
            }
            case 39: {
                return String.format("\\%sapo ", string);
            }
            case 40: {
                return String.format("\\%sopb ", string);
            }
            case 41: {
                return String.format("\\%sclb ", string);
            }
            case 42: {
                return String.format("\\%sast ", string);
            }
            case 43: {
                return String.format("\\%spls ", string);
            }
            case 44: {
                return String.format("\\%scom ", string);
            }
            case 45: {
                return String.format("\\%shyn ", string);
            }
            case 46: {
                return String.format("\\%sdot ", string);
            }
            case 47: {
                return String.format("\\%sslh ", string);
            }
            case 58: {
                return String.format("\\%scln ", string);
            }
            case 59: {
                return String.format("\\%sscl ", string);
            }
            case 60: {
                return String.format("\\%sles ", string);
            }
            case 61: {
                return String.format("\\%seql ", string);
            }
            case 62: {
                return String.format("\\%sgre ", string);
            }
            case 63: {
                return String.format("\\%sque ", string);
            }
            case 64: {
                return String.format("\\%satc ", string);
            }
            case 91: {
                return String.format("\\%sosb ", string);
            }
            case 92: {
                return String.format("\\%sbks ", string);
            }
            case 93: {
                return String.format("\\%scsb ", string);
            }
            case 94: {
                return String.format("\\%scir ", string);
            }
            case 95: {
                return String.format("\\%susc ", string);
            }
            case 96: {
                return String.format("\\%sgrv ", string);
            }
            case 123: {
                return String.format("\\%slbr ", string);
            }
            case 125: {
                return String.format("\\%srbr ", string);
            }
            case 126: {
                return String.format("\\%stld ", string);
            }
            case 32: {
                return String.format("\\%sspc ", string);
            }
            case 127: {
                return "";
            }
            case 9: {
                return "^^I";
            }
            case 10: 
            case 12: 
            case 13: {
                return " ";
            }
        }
        if (n < 32) {
            return "";
        }
        if (n >= 32 && n <= 126) {
            return String.format("%c", n);
        }
        return String.format("\\%swrp{%c}", string, n);
    }

    public static String escapeHash(String string) {
        return string.replaceAll("#", "\\\\#");
    }

    public static String escapeHash(char c) {
        return String.format("%s", c == '#' ? "\\#" : Character.valueOf(c));
    }

    public String getOSname() {
        return this.getSystemProperty("os.name", "");
    }

    public String getOSarch() {
        return this.getSystemProperty("os.arch", "");
    }

    public String getOSversion() {
        return this.escapeFileName(this.getSystemProperty("os.version", ""));
    }

    public String toTeXPath(String string) {
        if (string == null) {
            try {
                throw new NullPointerException();
            }
            catch (NullPointerException nullPointerException) {
                this.debug("null file name", nullPointerException);
                return "";
            }
        }
        if (File.separatorChar == '\\') {
            string = string.replaceAll("\\\\", "/");
        }
        if (this.stripFilePrefix != null && string.startsWith(this.stripFilePrefix)) {
            string = string.substring(this.stripFilePrefix.length());
        } else if (this.pathRegExp != null && this.pathReplacement != null) {
            string = string.replaceFirst(this.pathRegExp, this.pathReplacement);
        }
        return this.escapeFileName(string);
    }

    public String fromTeXPath(String string) {
        if (string == null) {
            try {
                throw new NullPointerException();
            }
            catch (NullPointerException nullPointerException) {
                this.debug("null file name", nullPointerException);
                return "";
            }
        }
        if (this.compatible < 2) {
            if (File.separatorChar == '\\') {
                return string.replaceAll("/", "\\\\");
            }
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = string.length();
        int n2 = 1;
        for (int i = 0; i < n; i += n2) {
            int n3;
            int n4 = string.codePointAt(i);
            n2 = Character.charCount(n4);
            int n5 = i + n2;
            int n6 = n3 = n5 < n ? string.codePointAt(n5) : 0;
            if (n4 == 47) {
                stringBuilder.appendCodePoint(File.separatorChar);
            }
            if (n4 == 92) {
                if (File.separatorChar != '\\' && n3 == 92) {
                    stringBuilder.appendCodePoint(n4);
                    i = n5;
                    n2 = Character.charCount(n3);
                    continue;
                }
                if (n3 != 47) continue;
                stringBuilder.appendCodePoint(47);
                i = n5;
                n2 = Character.charCount(n3);
                continue;
            }
            stringBuilder.appendCodePoint(n4);
        }
        return stringBuilder.toString();
    }

    public File fileFromTeXPath(String string) {
        File file = new File(string = this.fromTeXPath(string));
        if (!file.exists() && file.getParent() == null) {
            try {
                String string2 = this.kpsewhich(string);
                if (string2 != null && !"".equals(string2)) {
                    file = new File(this.fromTeXPath(string2));
                }
            }
            catch (Exception exception) {
                this.debug(String.format("kpsewhich couldn't find the file: %s", string), exception);
            }
        }
        return file;
    }

    public String getUserHome() {
        File file = new File(this.getSystemProperty("user.home", ""));
        if (!this.isReadPermitted(file)) {
            this.debug("Read access not permitted for the home directory");
            return "";
        }
        return this.toTeXPath(file.getAbsolutePath());
    }

    public String getCwd() {
        File file = new File(this.getSystemProperty("user.dir", "."));
        if (!this.isReadPermitted(file)) {
            this.debug("Read access not permitted for the current directory");
            return "";
        }
        return this.toTeXPath(file.getAbsolutePath());
    }

    public String getTmpDir() {
        String string = this.getSystemProperty("java.io.tmpdir", "");
        if ("".equals(string)) {
            return "";
        }
        File file = new File(string);
        if (!this.isReadPermitted(file)) {
            this.debug(String.format("Read access not permitted for directory: %s", file));
            return "";
        }
        return this.toTeXPath(string);
    }

    public int getWeekYear(Calendar calendar) {
        return calendar.get(1);
    }

    private int getDayOfWeekIndex(int n) {
        switch (n) {
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 3;
            }
            case 5: {
                return 4;
            }
            case 6: {
                return 5;
            }
            case 7: {
                return 6;
            }
            case 1: {
                return 7;
            }
        }
        try {
            throw new IllegalArgumentException(String.format("Invalid day of week index: %d", n));
        }
        catch (Exception exception) {
            this.debug(exception.getMessage(), exception);
            return 0;
        }
    }

    public String getDateTimeData() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(this.now.getTime());
        int n = calendar.get(11);
        int n2 = n == 0 ? 24 : n;
        int n3 = calendar.get(10);
        int n4 = n3 == 0 ? 12 : n3;
        TimeZone timeZone = calendar.getTimeZone();
        boolean bl = timeZone.inDaylightTime(this.now);
        int n5 = calendar.get(15);
        if (bl) {
            n5 += calendar.get(16);
        }
        int n6 = n5 / 60000;
        int n7 = n6 / 60;
        return String.format("{%d}{%d}{%d}{%d}{%d}{%d}{%d}{%d}{%d}{%d}{%d}{%d}{%d}{%d}{%d}{%d}{%d}{%d}{{%d}{%d}{%s}{%d}}", calendar.get(0), calendar.get(1), this.getWeekYear(calendar), calendar.get(2) + 1, calendar.get(3), calendar.get(4), calendar.get(6), calendar.get(5), calendar.get(8), this.getDayOfWeekIndex(calendar.get(7)), calendar.get(9), n, n2, n3, n4, calendar.get(12), calendar.get(13), calendar.get(14), n7, n6 %= 60, timeZone.getID(), bl ? 1 : 0);
    }

    public String getTimeZones(String string) {
        Locale locale = string == null || "".equals(string) ? Locale.getDefault() : this.getLocale(string);
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray = TimeZone.getAvailableIDs();
        for (int i = 0; i < stringArray.length; ++i) {
            TimeZone timeZone = TimeZone.getTimeZone(stringArray[i]);
            stringBuilder.append(String.format("{{%s}{%s}{%s}{%s}{%s}}", this.escapeFileName(timeZone.getID()), this.escapeText(timeZone.getDisplayName(false, 0, locale)), this.escapeText(timeZone.getDisplayName(false, 1, locale)), this.escapeText(timeZone.getDisplayName(true, 0, locale)), this.escapeText(timeZone.getDisplayName(true, 1, locale))));
        }
        return stringBuilder.toString();
    }

    public String pdfnow() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(this.now.getTime());
        return this.pdfDate(calendar);
    }

    public String pdfDate(Calendar calendar) {
        String string = String.format("%1$tz", calendar);
        if (this.compatible < 2) {
            return String.format("D:%1$tY%1$tm%1td%1$tH%1$tM%1$tS%2$s'%3$s'", calendar, string.substring(0, 3), string.substring(3));
        }
        return String.format("\\pdfd %s", this.escapeFileName(String.format(":%1$tY%1$tm%1td%1$tH%1$tM%1$tS%2$s'%3$s'", calendar, string.substring(0, 3), string.substring(3))));
    }

    public String pdfDate(File file) {
        try {
            if (!file.exists()) {
                this.debug(String.format("Unable to get timestamp for file (no such file): %s", file.toString()));
                return "";
            }
            if (!this.isReadPermitted(file)) {
                this.debug(String.format("No read access for file: %s", file));
                return "";
            }
            long l = file.lastModified();
            if (l > 0L) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeInMillis(l);
                return this.pdfDate(calendar);
            }
            this.debug(String.format("Unable to get timestamp for file (I/O error): %s", file.toString()));
        }
        catch (Exception exception) {
            this.debug(String.format("Unable to get timestamp for file: %s", file.toString()), exception);
        }
        return "";
    }

    public String getFileLength(File file) {
        try {
            if (!file.exists()) {
                this.debug(String.format("Unable to get the size of file (no such file): %s", file.toString()));
                return "";
            }
            if (!this.isReadPermitted(file)) {
                this.debug(String.format("No read access for file: %s", file));
                return "";
            }
            return String.format("%d", file.length());
        }
        catch (Exception exception) {
            this.debug(String.format("Unable to get the size of file: %s", file.toString()), exception);
            return "";
        }
    }

    public void sortFileList(String[] stringArray, File file, FileSortType fileSortType) {
        Arrays.sort(stringArray, new FileSortComparator(file, fileSortType));
    }

    protected File checkDirectoryListing(File file) throws IOException {
        return file;
    }

    public String getFileList(String string, File file, FileSortType fileSortType, FileListType fileListType) {
        return this.getFilterFileList(string, ".*", file, fileSortType, fileListType);
    }

    public String getFilterFileList(String string, final String string2, File file, FileSortType fileSortType, final FileListType fileListType) {
        if (file == null) {
            this.debug("Unable to list contents (null directory)");
            return "";
        }
        if (!file.exists()) {
            this.debug(String.format("Unable to list contents (no such directory): %s", file.toString()));
            return "";
        }
        if (!file.isDirectory()) {
            this.debug(String.format("Unable to list contents (not a directory): %s", file.toString()));
            return "";
        }
        try {
            file = this.checkDirectoryListing(file);
        }
        catch (Exception exception) {
            this.debug(String.format("Unable to list contents of: %s", file.getAbsolutePath()), exception);
            return "";
        }
        if (!this.isReadPermitted(file)) {
            this.debug(String.format("No read access for directory: %s", file));
            return "";
        }
        if (string2 == null || "".equals(string2)) {
            this.debug("Null or empty regular expression in getFilterFileList");
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String[] stringArray = file.list(new FilenameFilter(){

                public boolean accept(File file, String string) {
                    File file2 = new File(file, string);
                    if (!TeXOSQuery.this.isReadPermitted(file2)) {
                        TeXOSQuery.this.debug(String.format("No read access for file: %s", file2));
                        return false;
                    }
                    switch (fileListType) {
                        case FILE_LIST_DIRECTORIES_ONLY: {
                            if (file2.isDirectory()) break;
                            return false;
                        }
                        case FILE_LIST_REGULAR_FILES_ONLY: {
                            if (!file2.isDirectory()) break;
                            return false;
                        }
                    }
                    return string.matches(string2);
                }
            });
            if (stringArray != null) {
                if (fileSortType != FileSortType.FILE_SORT_DEFAULT) {
                    this.sortFileList(stringArray, file, fileSortType);
                }
                for (int i = 0; i < stringArray.length; ++i) {
                    if (i > 0) {
                        stringBuilder.append(string);
                    }
                    if (stringArray[i].contains(string)) {
                        stringBuilder.append(String.format("{%s}", this.escapeFileName(stringArray[i])));
                        continue;
                    }
                    stringBuilder.append(this.escapeFileName(stringArray[i]));
                }
            }
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            this.debug(String.format("Unable to list contents of '%s' using regex: %s", file.toString(), string2), exception);
            return "";
        }
    }

    public String walk(String string, String string2, File file, FileSortType fileSortType) {
        this.debug("walk requires at least JRE 7 version");
        return "";
    }

    public String fileURI(File file) {
        if (file == null) {
            this.debug("null file passed to fileURI");
            return "";
        }
        if (!file.exists()) {
            this.debug(String.format("can't obtain URI of file (no such file): %s", file.toString()));
            return "";
        }
        if (!this.isReadPermitted(file)) {
            this.debug(String.format("No read access for file: %s", file));
            return "";
        }
        try {
            String string = file.getCanonicalFile().toURI().toString();
            if (this.stripURIPrefix != null && string.startsWith("file:/" + this.stripURIPrefix)) {
                string = "file:/" + string.substring(6 + this.stripURIPrefix.length());
            } else if (this.uriRegExp != null && this.uriReplacement != null) {
                string = string.replaceFirst(this.uriRegExp, this.uriReplacement);
            }
            return this.escapeFileName(string);
        }
        catch (Exception exception) {
            this.debug(String.format("Can't obtain URI of file: %s", file.toString()), exception);
            return "";
        }
    }

    public String filePath(File file) {
        if (file == null) {
            this.debug("null file passed to filePath");
            return "";
        }
        if (!file.exists()) {
            this.debug(String.format("Can't obtain full file path (no such file): %s", file.toString()));
            return "";
        }
        if (!this.isReadPermitted(file)) {
            this.debug(String.format("Can't obtain full file path (no read access): %s", file.toString()));
            return "";
        }
        try {
            return this.toTeXPath(file.getCanonicalPath());
        }
        catch (Exception exception) {
            this.debug(String.format("Can't obtain full path for file: %s", file.toString()), exception);
            return "";
        }
    }

    public String parentPath(File file) {
        if (file == null) {
            this.debug("null file passed to filePath");
            return "";
        }
        if (!file.exists()) {
            this.debug(String.format("Can't obtain full parent path for file (no such file): %s", file.toString()));
            return "";
        }
        if (!this.isReadPermitted(file)) {
            this.debug(String.format("Can't obtain full path for file (no read access): %s", file.toString()));
            return "";
        }
        try {
            File file2 = file.getCanonicalFile().getParentFile();
            if (file2 == null) {
                this.debug(String.format("No parent found for file: %s", file.toString()));
                return "";
            }
            return this.toTeXPath(file2.getAbsolutePath());
        }
        catch (Exception exception) {
            this.debug(String.format("Can't obtain full parent path for file: %s", file.toString()), exception);
            return "";
        }
    }

    public String getScript(Locale locale) {
        return null;
    }

    public String getLanguageTag(Locale locale) {
        String string;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        String string2 = locale.getLanguage();
        String string3 = locale.getCountry();
        if (string3 != null && !"".equals(string3)) {
            string2 = String.format("%s-%s", string2, string3);
        }
        if ((string = locale.getVariant()) != null && !"".equals(string)) {
            string2 = String.format("%s-%s", string2, string);
        }
        return string2;
    }

    public String getLocale(Locale locale) {
        return this.getLocale(locale, false);
    }

    public String getLocale(Locale locale, boolean bl) {
        String string = "";
        if (locale == null) {
            this.debug("null locale");
            return "";
        }
        String string2 = locale.getLanguage();
        if (string2 == null) {
            this.debug(String.format("No language for locale: %s", locale.toString()));
        } else {
            string = string2;
        }
        String string3 = locale.getCountry();
        if (string3 == null || "".equals(string3)) {
            this.info(String.format("No region for locale: %s", locale.toString()));
        } else {
            string = "".equals(string) ? string3 : string.concat("-").concat(string3);
        }
        String string4 = this.getCodeSet(bl);
        string = string.concat(".").concat(string4);
        String string5 = this.getScript(locale);
        if (string5 == null || "".equals(string5)) {
            this.info(String.format("No script available for locale: %s", locale.toString()));
        } else {
            string = string.concat("@").concat(string5);
        }
        return this.escapeFileName(string);
    }

    public String getCodeSet(boolean bl) {
        String string = this.fileEncoding != null ? this.fileEncoding : this.getSystemProperty("file.encoding", "UTF-8");
        if (bl) {
            string = string.toLowerCase().replaceAll("-", "");
        }
        return string;
    }

    public String getRegionAlpha2Code(int n) {
        switch (n) {
            case 4: {
                return "AF";
            }
            case 8: {
                return "AL";
            }
            case 10: {
                return "AQ";
            }
            case 12: {
                return "DZ";
            }
            case 16: {
                return "AS";
            }
            case 20: {
                return "AD";
            }
            case 24: {
                return "AO";
            }
            case 28: {
                return "AG";
            }
            case 31: {
                return "AZ";
            }
            case 32: {
                return "AR";
            }
            case 36: {
                return "AU";
            }
            case 40: {
                return "AT";
            }
            case 44: {
                return "BS";
            }
            case 48: {
                return "BH";
            }
            case 50: {
                return "BD";
            }
            case 51: {
                return "AM";
            }
            case 52: {
                return "BB";
            }
            case 56: {
                return "BE";
            }
            case 60: {
                return "BM";
            }
            case 64: {
                return "BT";
            }
            case 68: {
                return "BO";
            }
            case 70: {
                return "BA";
            }
            case 72: {
                return "BW";
            }
            case 74: {
                return "BV";
            }
            case 76: {
                return "BR";
            }
            case 84: {
                return "BZ";
            }
            case 86: {
                return "IO";
            }
            case 90: {
                return "SB";
            }
            case 92: {
                return "VG";
            }
            case 96: {
                return "BN";
            }
            case 100: {
                return "BG";
            }
            case 104: {
                return "MM";
            }
            case 108: {
                return "BI";
            }
            case 112: {
                return "BY";
            }
            case 116: {
                return "KH";
            }
            case 120: {
                return "CM";
            }
            case 124: {
                return "CA";
            }
            case 132: {
                return "CV";
            }
            case 136: {
                return "KY";
            }
            case 140: {
                return "CF";
            }
            case 144: {
                return "LK";
            }
            case 148: {
                return "TD";
            }
            case 152: {
                return "CL";
            }
            case 156: {
                return "CN";
            }
            case 158: {
                return "TW";
            }
            case 162: {
                return "CX";
            }
            case 166: {
                return "CC";
            }
            case 170: {
                return "CO";
            }
            case 174: {
                return "KM";
            }
            case 175: {
                return "YT";
            }
            case 178: {
                return "CG";
            }
            case 180: {
                return "CD";
            }
            case 184: {
                return "CK";
            }
            case 188: {
                return "CR";
            }
            case 191: {
                return "HR";
            }
            case 192: {
                return "CU";
            }
            case 196: {
                return "CY";
            }
            case 203: {
                return "CZ";
            }
            case 204: {
                return "BJ";
            }
            case 208: {
                return "DK";
            }
            case 212: {
                return "DM";
            }
            case 214: {
                return "DO";
            }
            case 218: {
                return "EC";
            }
            case 222: {
                return "SV";
            }
            case 226: {
                return "GQ";
            }
            case 231: {
                return "ET";
            }
            case 232: {
                return "ER";
            }
            case 233: {
                return "EE";
            }
            case 234: {
                return "FO";
            }
            case 238: {
                return "FK";
            }
            case 239: {
                return "GS";
            }
            case 242: {
                return "FJ";
            }
            case 246: {
                return "FI";
            }
            case 248: {
                return "AX";
            }
            case 250: {
                return "FR";
            }
            case 254: {
                return "GF";
            }
            case 258: {
                return "PF";
            }
            case 260: {
                return "TF";
            }
            case 262: {
                return "DJ";
            }
            case 266: {
                return "GA";
            }
            case 268: {
                return "GE";
            }
            case 270: {
                return "GM";
            }
            case 275: {
                return "PS";
            }
            case 276: {
                return "DE";
            }
            case 288: {
                return "GH";
            }
            case 292: {
                return "GI";
            }
            case 296: {
                return "KI";
            }
            case 300: {
                return "GR";
            }
            case 304: {
                return "GL";
            }
            case 308: {
                return "GD";
            }
            case 312: {
                return "GP";
            }
            case 316: {
                return "GU";
            }
            case 320: {
                return "GT";
            }
            case 324: {
                return "GN";
            }
            case 328: {
                return "GY";
            }
            case 332: {
                return "HT";
            }
            case 334: {
                return "HM";
            }
            case 336: {
                return "VA";
            }
            case 340: {
                return "HN";
            }
            case 344: {
                return "HK";
            }
            case 348: {
                return "HU";
            }
            case 352: {
                return "IS";
            }
            case 356: {
                return "IN";
            }
            case 360: {
                return "ID";
            }
            case 364: {
                return "IR";
            }
            case 368: {
                return "IQ";
            }
            case 372: {
                return "IE";
            }
            case 376: {
                return "IL";
            }
            case 380: {
                return "IT";
            }
            case 384: {
                return "CI";
            }
            case 388: {
                return "JM";
            }
            case 392: {
                return "JP";
            }
            case 398: {
                return "KZ";
            }
            case 400: {
                return "JO";
            }
            case 404: {
                return "KE";
            }
            case 408: {
                return "KP";
            }
            case 410: {
                return "KR";
            }
            case 414: {
                return "KW";
            }
            case 417: {
                return "KG";
            }
            case 418: {
                return "LA";
            }
            case 422: {
                return "LB";
            }
            case 426: {
                return "LS";
            }
            case 428: {
                return "LV";
            }
            case 430: {
                return "LR";
            }
            case 434: {
                return "LY";
            }
            case 438: {
                return "LI";
            }
            case 440: {
                return "LT";
            }
            case 442: {
                return "LU";
            }
            case 446: {
                return "MO";
            }
            case 450: {
                return "MG";
            }
            case 454: {
                return "MW";
            }
            case 458: {
                return "MY";
            }
            case 462: {
                return "MV";
            }
            case 466: {
                return "ML";
            }
            case 470: {
                return "MT";
            }
            case 474: {
                return "MQ";
            }
            case 478: {
                return "MR";
            }
            case 480: {
                return "MU";
            }
            case 484: {
                return "MX";
            }
            case 492: {
                return "MC";
            }
            case 496: {
                return "MN";
            }
            case 498: {
                return "MD";
            }
            case 499: {
                return "ME";
            }
            case 500: {
                return "MS";
            }
            case 504: {
                return "MA";
            }
            case 508: {
                return "MZ";
            }
            case 512: {
                return "OM";
            }
            case 516: {
                return "NA";
            }
            case 520: {
                return "NR";
            }
            case 524: {
                return "NP";
            }
            case 528: {
                return "NL";
            }
            case 531: {
                return "CW";
            }
            case 533: {
                return "AW";
            }
            case 534: {
                return "SX";
            }
            case 535: {
                return "BQ";
            }
            case 540: {
                return "NC";
            }
            case 548: {
                return "VU";
            }
            case 554: {
                return "NZ";
            }
            case 558: {
                return "NI";
            }
            case 562: {
                return "NE";
            }
            case 566: {
                return "NG";
            }
            case 570: {
                return "NU";
            }
            case 574: {
                return "NF";
            }
            case 578: {
                return "NO";
            }
            case 580: {
                return "MP";
            }
            case 581: {
                return "UM";
            }
            case 583: {
                return "FM";
            }
            case 584: {
                return "MH";
            }
            case 585: {
                return "PW";
            }
            case 586: {
                return "PK";
            }
            case 591: {
                return "PA";
            }
            case 598: {
                return "PG";
            }
            case 600: {
                return "PY";
            }
            case 604: {
                return "PE";
            }
            case 608: {
                return "PH";
            }
            case 612: {
                return "PN";
            }
            case 616: {
                return "PL";
            }
            case 620: {
                return "PT";
            }
            case 624: {
                return "GW";
            }
            case 626: {
                return "TL";
            }
            case 630: {
                return "PR";
            }
            case 634: {
                return "QA";
            }
            case 638: {
                return "RE";
            }
            case 642: {
                return "RO";
            }
            case 643: {
                return "RU";
            }
            case 646: {
                return "RW";
            }
            case 652: {
                return "BL";
            }
            case 654: {
                return "SH";
            }
            case 659: {
                return "KN";
            }
            case 660: {
                return "AI";
            }
            case 662: {
                return "LC";
            }
            case 663: {
                return "MF";
            }
            case 666: {
                return "PM";
            }
            case 670: {
                return "VC";
            }
            case 674: {
                return "SM";
            }
            case 678: {
                return "ST";
            }
            case 682: {
                return "SA";
            }
            case 686: {
                return "SN";
            }
            case 688: {
                return "RS";
            }
            case 690: {
                return "SC";
            }
            case 694: {
                return "SL";
            }
            case 702: {
                return "SG";
            }
            case 703: {
                return "SK";
            }
            case 704: {
                return "VN";
            }
            case 705: {
                return "SI";
            }
            case 706: {
                return "SO";
            }
            case 710: {
                return "ZA";
            }
            case 716: {
                return "ZW";
            }
            case 724: {
                return "ES";
            }
            case 728: {
                return "SS";
            }
            case 729: {
                return "SD";
            }
            case 732: {
                return "EH";
            }
            case 740: {
                return "SR";
            }
            case 744: {
                return "SJ";
            }
            case 748: {
                return "SZ";
            }
            case 752: {
                return "SE";
            }
            case 756: {
                return "CH";
            }
            case 760: {
                return "SY";
            }
            case 762: {
                return "TJ";
            }
            case 764: {
                return "TH";
            }
            case 768: {
                return "TG";
            }
            case 772: {
                return "TK";
            }
            case 776: {
                return "TO";
            }
            case 780: {
                return "TT";
            }
            case 784: {
                return "AE";
            }
            case 788: {
                return "TN";
            }
            case 792: {
                return "TR";
            }
            case 795: {
                return "TM";
            }
            case 796: {
                return "TC";
            }
            case 798: {
                return "TV";
            }
            case 800: {
                return "UG";
            }
            case 804: {
                return "UA";
            }
            case 807: {
                return "MK";
            }
            case 818: {
                return "EG";
            }
            case 826: {
                return "GB";
            }
            case 831: {
                return "GG";
            }
            case 832: {
                return "JE";
            }
            case 833: {
                return "IM";
            }
            case 834: {
                return "TZ";
            }
            case 840: {
                return "US";
            }
            case 850: {
                return "VI";
            }
            case 854: {
                return "BF";
            }
            case 858: {
                return "UY";
            }
            case 860: {
                return "UZ";
            }
            case 862: {
                return "VE";
            }
            case 876: {
                return "WF";
            }
            case 882: {
                return "WS";
            }
            case 887: {
                return "YE";
            }
            case 894: {
                return "ZM";
            }
        }
        this.debug(String.format("Unrecognised numeric region code: %d", n));
        return String.format("%d", n);
    }

    public Locale getLocale(String string) {
        Pattern pattern = Pattern.compile("(?:([a-z]{2,3}(?:-[a-z]{2,3})*))+(?:-[A-Z][a-z]{3})?(?:-([A-Z]{2}|[0-9]{3}))?(?:-([a-zA-Z0-9]{5,8}|[0-9][a-zA-Z0-9]{3}))?(?:-.)*");
        Matcher matcher = pattern.matcher(string);
        if (matcher.matches()) {
            String string2 = matcher.group(1);
            String string3 = matcher.group(2);
            String string4 = matcher.group(3);
            try {
                string3 = this.getRegionAlpha2Code(Integer.parseInt(string3));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (string3 == null) {
                return new Locale(string2);
            }
            if (string4 == null) {
                return new Locale(string2, string3);
            }
            return new Locale(string2, string3, string4);
        }
        this.debug(String.format("Can't parse language tag: %s", string));
        String[] stringArray = string.split("-", 1);
        return new Locale(stringArray[0]);
    }

    public String getNumericalInfo(String string) {
        Locale locale = string == null || "".equals(string) ? Locale.getDefault() : this.getLocale(string);
        DecimalFormatSymbols decimalFormatSymbols = DecimalFormatSymbols.getInstance(locale);
        String string2 = decimalFormatSymbols.getInternationalCurrencySymbol();
        String string3 = decimalFormatSymbols.getCurrencySymbol();
        String string4 = string2;
        String string5 = locale.getCountry();
        if (string5 != null && !"".equals(string5)) {
            if (string5.equals("GG") || string5.equals("GGY") || string5.equals("831")) {
                string4 = "GGP";
                string3 = POUND_STRING;
            } else if (string5.equals("JE") || string5.equals("JEY") || string5.equals("832")) {
                string4 = "JEP";
                string3 = POUND_STRING;
            } else if (string5.equals("IM") || string5.equals("IMN") || string5.equals("833")) {
                string4 = "IMP";
                string3 = String.format("M%s", POUND_STRING);
            } else if (string5.equals("KI") || string5.equals("KIR") || string5.equals("296")) {
                string4 = "KID";
                string3 = "$";
            } else if (string5.equals("TV") || string5.equals("TUV") || string5.equals("798")) {
                string4 = "TVD";
                string3 = "$";
            }
        }
        String string6 = this.getTeXCurrency(string3);
        NumberFormat numberFormat = NumberFormat.getNumberInstance(locale);
        return String.format("{%s}{%s}{%s}{%s}{%d}{%s}{%s}{%s}{%s}{%s}", this.escapeFileName(this.getLanguageTag(locale)), this.escapeText(decimalFormatSymbols.getGroupingSeparator()), this.escapeText(decimalFormatSymbols.getDecimalSeparator()), this.escapeText(decimalFormatSymbols.getExponentSeparator()), numberFormat.isGroupingUsed() ? 1 : 0, string2, string4, this.escapeText(string3), string6, this.escapeText(decimalFormatSymbols.getMonetaryDecimalSeparator()));
    }

    public String getTeXCurrency(String string) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = string.length();
        block36: for (int i = 0; i < n2; i += Character.charCount(n)) {
            n = string.codePointAt(i);
            switch (n) {
                case 36: {
                    stringBuilder.append("\\texosquerycurrency{dollar}");
                    continue block36;
                }
                case 162: {
                    stringBuilder.append("\\texosquerycurrency{cent}");
                    continue block36;
                }
                case 163: {
                    stringBuilder.append("\\texosquerycurrency{pound}");
                    continue block36;
                }
                case 164: {
                    stringBuilder.append("\\texosquerycurrency{sign}");
                    continue block36;
                }
                case 165: {
                    stringBuilder.append("\\texosquerycurrency{yen}");
                    continue block36;
                }
                case 8352: {
                    stringBuilder.append("\\texosquerycurrency{ecu}");
                    continue block36;
                }
                case 8353: {
                    stringBuilder.append("\\texosquerycurrency{colon}");
                    continue block36;
                }
                case 8354: {
                    stringBuilder.append("\\texosquerycurrency{cruzeiro}");
                    continue block36;
                }
                case 8355: {
                    stringBuilder.append("\\texosquerycurrency{franc}");
                    continue block36;
                }
                case 8356: {
                    stringBuilder.append("\\texosquerycurrency{lira}");
                    continue block36;
                }
                case 8357: {
                    stringBuilder.append("\\texosquerycurrency{mill}");
                    continue block36;
                }
                case 8358: {
                    stringBuilder.append("\\texosquerycurrency{naira}");
                    continue block36;
                }
                case 8359: {
                    stringBuilder.append("\\texosquerycurrency{peseta}");
                    continue block36;
                }
                case 8360: 
                case 8377: {
                    stringBuilder.append("\\texosquerycurrency{rupee}");
                    continue block36;
                }
                case 8361: {
                    stringBuilder.append("\\texosquerycurrency{won}");
                    continue block36;
                }
                case 8362: {
                    stringBuilder.append("\\texosquerycurrency{newsheqel}");
                    continue block36;
                }
                case 8363: {
                    stringBuilder.append("\\texosquerycurrency{dong}");
                    continue block36;
                }
                case 8364: {
                    stringBuilder.append("\\texosquerycurrency{euro}");
                    continue block36;
                }
                case 8365: {
                    stringBuilder.append("\\texosquerycurrency{kip}");
                    continue block36;
                }
                case 8366: {
                    stringBuilder.append("\\texosquerycurrency{tugrik}");
                    continue block36;
                }
                case 8367: {
                    stringBuilder.append("\\texosquerycurrency{drachma}");
                    continue block36;
                }
                case 8368: {
                    stringBuilder.append("\\texosquerycurrency{germanpenny}");
                    continue block36;
                }
                case 8369: {
                    stringBuilder.append("\\texosquerycurrency{peso}");
                    continue block36;
                }
                case 8370: {
                    stringBuilder.append("\\texosquerycurrency{guarani}");
                    continue block36;
                }
                case 8371: {
                    stringBuilder.append("\\texosquerycurrency{austral}");
                    continue block36;
                }
                case 8372: {
                    stringBuilder.append("\\texosquerycurrency{hryvnia}");
                    continue block36;
                }
                case 8373: {
                    stringBuilder.append("\\texosquerycurrency{cedi}");
                    continue block36;
                }
                case 8374: {
                    stringBuilder.append("\\texosquerycurrency{livretournois}");
                    continue block36;
                }
                case 8375: {
                    stringBuilder.append("\\texosquerycurrency{spesmilo}");
                    continue block36;
                }
                case 8376: {
                    stringBuilder.append("\\texosquerycurrency{tenge}");
                    continue block36;
                }
                case 8378: {
                    stringBuilder.append("\\texosquerycurrency{turkishlira}");
                    continue block36;
                }
                case 8379: {
                    stringBuilder.append("\\texosquerycurrency{nordicmark}");
                    continue block36;
                }
                case 8380: {
                    stringBuilder.append("\\texosquerycurrency{manat}");
                    continue block36;
                }
                case 8381: {
                    stringBuilder.append("\\texosquerycurrency{ruble}");
                    continue block36;
                }
            }
            stringBuilder.append(this.escapeText(n));
        }
        return stringBuilder.toString();
    }

    public String getStandaloneMonths(Calendar calendar, Locale locale) {
        DateFormatSymbols dateFormatSymbols = DateFormatSymbols.getInstance(locale);
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray = dateFormatSymbols.getMonths();
        for (int i = 0; i < 12; ++i) {
            stringBuilder.append(String.format("{%s}", this.escapeText(stringArray[i])));
        }
        return stringBuilder.toString();
    }

    public String getStandaloneShortMonths(Calendar calendar, Locale locale) {
        DateFormatSymbols dateFormatSymbols = DateFormatSymbols.getInstance(locale);
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray = dateFormatSymbols.getShortMonths();
        for (int i = 0; i < 12; ++i) {
            stringBuilder.append(String.format("{%s}", this.escapeText(stringArray[i])));
        }
        return stringBuilder.toString();
    }

    public String getStandaloneWeekdays(Calendar calendar, Locale locale) {
        DateFormatSymbols dateFormatSymbols = DateFormatSymbols.getInstance(locale);
        String[] stringArray = dateFormatSymbols.getWeekdays();
        return String.format("{%s}{%s}{%s}{%s}{%s}{%s}{%s}", this.escapeText(stringArray[2]), this.escapeText(stringArray[3]), this.escapeText(stringArray[4]), this.escapeText(stringArray[5]), this.escapeText(stringArray[6]), this.escapeText(stringArray[7]), this.escapeText(stringArray[1]));
    }

    public String getStandaloneShortWeekdays(Calendar calendar, Locale locale) {
        DateFormatSymbols dateFormatSymbols = DateFormatSymbols.getInstance(locale);
        String[] stringArray = dateFormatSymbols.getShortWeekdays();
        return String.format("{%s}{%s}{%s}{%s}{%s}{%s}{%s}", this.escapeText(stringArray[2]), this.escapeText(stringArray[3]), this.escapeText(stringArray[4]), this.escapeText(stringArray[5]), this.escapeText(stringArray[6]), this.escapeText(stringArray[7]), this.escapeText(stringArray[1]));
    }

    public String formatDateTimePattern(Format format) {
        SimpleDateFormat simpleDateFormat = null;
        try {
            simpleDateFormat = (SimpleDateFormat)format;
            if (simpleDateFormat == null) {
                throw new NullPointerException();
            }
        }
        catch (Exception exception) {
            this.debug(String.format("Invalid argument: %s", format), exception);
            return "";
        }
        String string = simpleDateFormat.toPattern();
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        int n3 = string.length();
        int n4 = 1;
        block6: for (int i = 0; i < n3; i += n4) {
            int n5;
            int n6 = string.codePointAt(i);
            n4 = Character.charCount(n6);
            int n7 = i + n4;
            int n8 = n5 = n7 < n3 ? string.codePointAt(n7) : 0;
            if (bl) {
                if (n6 == 39) {
                    if (n5 != 39) {
                        stringBuilder.append('}');
                        bl = false;
                        continue;
                    }
                    stringBuilder.append("\\patapo ");
                    i = n7;
                    n4 = Character.charCount(n5);
                    continue;
                }
                stringBuilder.append(this.escapeText(n6));
                continue;
            }
            if (n6 == n) {
                ++n2;
                continue;
            }
            switch (n6) {
                case 39: {
                    if (n != 0) {
                        stringBuilder.append(String.format("\\patdtf{%d}{%c}", n2, n));
                        n = 0;
                        n2 = 0;
                    }
                    stringBuilder.append("\\patstr{");
                    bl = true;
                    continue block6;
                }
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 75: 
                case 76: 
                case 77: 
                case 83: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 97: 
                case 100: 
                case 104: 
                case 107: 
                case 109: 
                case 115: 
                case 117: 
                case 119: 
                case 121: 
                case 122: {
                    n = n6;
                    n2 = 1;
                    continue block6;
                }
                default: {
                    if (n == 0) {
                        stringBuilder.append(this.escapeText(n6));
                    } else {
                        stringBuilder.append(String.format("\\patdtf{%d}{%c}%s", n2, n, this.escapeText(n6)));
                    }
                    n = 0;
                    n2 = 0;
                }
            }
        }
        if (n != 0) {
            stringBuilder.append(String.format("\\patdtf{%d}{%c}", n2, n));
        }
        return stringBuilder.toString();
    }

    public String formatNumberPattern(Format format) {
        DecimalFormat decimalFormat = null;
        try {
            decimalFormat = (DecimalFormat)format;
            if (decimalFormat == null) {
                throw new NullPointerException();
            }
        }
        catch (Exception exception) {
            this.debug(String.format("Invalid argument: %s", format), exception);
            return "";
        }
        String string = decimalFormat.toPattern();
        String string2 = null;
        String string3 = null;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        int n = string.length();
        int n2 = 1;
        for (int i = 0; i < n; i += n2) {
            int n3;
            int n4 = string.codePointAt(i);
            n2 = Character.charCount(n4);
            int n5 = i + n2;
            int n6 = n3 = n5 < n ? string.codePointAt(n5) : 0;
            if (bl) {
                if (n4 == 39) {
                    stringBuilder.appendCodePoint(n4);
                    if (n3 == 39) {
                        stringBuilder.appendCodePoint(n3);
                        i = n5;
                        n2 = Character.charCount(n3);
                        continue;
                    }
                    bl = false;
                    continue;
                }
                stringBuilder.appendCodePoint(n4);
                continue;
            }
            if (n4 == 39) {
                bl = true;
                stringBuilder.appendCodePoint(n4);
                continue;
            }
            if (n4 == 59) {
                if (string2 == null) {
                    string2 = stringBuilder.toString();
                    stringBuilder = new StringBuilder();
                    continue;
                }
                this.debug(String.format("Too many ; found in pattern: %s", string));
                continue;
            }
            stringBuilder.appendCodePoint(n4);
        }
        if (string2 == null) {
            string2 = stringBuilder.toString();
        } else if (stringBuilder.length() > 0) {
            string3 = stringBuilder.toString();
        }
        if (string3 == null) {
            return String.format("\\patnumfmt{%s}", this.formatNumberSubPattern(string2));
        }
        return String.format("\\patpmnumfmt{%s}{%s}", this.formatNumberSubPattern(string2), this.formatNumberSubPattern(string3));
    }

    private String formatNumberSubPattern(String string) {
        if (string == null || "".equals(string)) {
            return "";
        }
        Pattern pattern = Pattern.compile("(.*(?:[^'](?:'')+){0,1})(\u00a4{1,2})(.*)");
        Matcher matcher = pattern.matcher(string);
        if (matcher.matches()) {
            return this.formatCurrencyPattern(matcher.group(1), matcher.group(2).length() == 2, matcher.group(3));
        }
        pattern = Pattern.compile("(.*(?:[^'](?:'')+){0,1})([%\u2030])(.*)");
        matcher = pattern.matcher(string);
        if (matcher.matches()) {
            boolean bl = "%".equals(matcher.group(2));
            return this.formatPercentagePattern(matcher.group(1), matcher.group(3), bl ? "patppct" : "patppml", bl ? "patspct" : "patspml");
        }
        return this.formatNumericPattern(string);
    }

    private String formatCurrencyPattern(String string, boolean bl, String string2) {
        if (string2 == null || "".equals(string2)) {
            string = this.formatNumericPattern(string);
            if (bl) {
                return String.format("\\patsicur{%s}{}", string);
            }
            return String.format("\\patscur{%s}{}", string);
        }
        if (string == null || "".equals(string)) {
            string2 = this.formatNumericPattern(string2);
            if (bl) {
                return String.format("\\patpicur{%s}{}", string2);
            }
            return String.format("\\patpcur{%s}{}", string2);
        }
        string = this.formatNumericPattern(string);
        string2 = this.formatNumericPattern(string2);
        if (string.matches(".*[0#].*")) {
            if (bl) {
                return String.format("\\patsicur{%s}{%s}", string, string2);
            }
            return String.format("\\patscur{%s}{%s}", string, string2);
        }
        if (bl) {
            return String.format("\\patpicur{%s}{%s}", string2, string);
        }
        return String.format("\\patpcur{%s}{%s}", string2, string);
    }

    private String formatPercentagePattern(String string, String string2, String string3, String string4) {
        if (string2 == null || "".equals(string2)) {
            string = this.formatNumericPattern(string);
            return String.format("\\%s{%s}{}", string4, string);
        }
        if (string == null || "".equals(string)) {
            string2 = this.formatNumericPattern(string2);
            return String.format("\\%s{%s}{}", string3, string2);
        }
        string = this.formatNumericPattern(string);
        string2 = this.formatNumericPattern(string2);
        if (string.matches(".*[0#].*")) {
            return String.format("\\%s{%s}{%s}", string4, string, string2);
        }
        return String.format("\\%s{%s}{%s}", string3, string2, string);
    }

    private String formatNumericPattern(String string) {
        if (string == null || "".equals(string)) {
            return "";
        }
        Pattern pattern = Pattern.compile("(.*(?:[^'](?:'')+?){0,1})(E.*)?");
        Matcher matcher = pattern.matcher(string);
        if (!matcher.matches()) {
            this.debug(String.format("Can't match number format sub-pattern '%s' against regexp: %s", string, pattern));
            return "";
        }
        String string2 = matcher.group(1);
        String string3 = matcher.group(2);
        if (string2 == null && string3 == null) {
            return "";
        }
        if (string3 == null) {
            return this.formatDecimalPattern(string2);
        }
        return String.format("\\patsinumfmt{%s}{%s}", this.formatDecimalPattern(string2), this.formatIntegerPattern(string3, true));
    }

    private String formatDecimalPattern(String string) {
        Pattern pattern = Pattern.compile("(.*?(?:[^'](?:'')){0,1})(?:\\.(.*))?");
        Matcher matcher = pattern.matcher(string);
        if (!matcher.matches()) {
            this.debug(String.format("Can't match decimal pattern '%s' against regexp: %s", string, pattern));
            return "";
        }
        String string2 = matcher.group(1);
        String string3 = matcher.group(2);
        if (string2 == null && string3 == null) {
            return "";
        }
        if (string3 == null) {
            return this.formatIntegerPattern(string2, true);
        }
        return String.format("\\patdecfmt{%s}{%s}", this.formatIntegerPattern(string2, true), this.formatIntegerPattern(string3, false));
    }

    private String formatIntegerPattern(String string, boolean bl) {
        int n;
        int n2;
        int n3;
        int n4;
        boolean bl2 = false;
        int n5 = 0;
        int n6 = -1;
        int n7 = string.length();
        int n8 = 1;
        for (n4 = 0; n4 < n7; n4 += n8) {
            n3 = string.codePointAt(n4);
            n8 = Character.charCount(n3);
            n2 = n4 + n8;
            int n9 = n = n2 < n7 ? string.codePointAt(n2) : 0;
            if (bl2) {
                if (n3 != 39 || n == 39) continue;
                bl2 = false;
                n4 = n2;
                n8 = Character.charCount(n);
                continue;
            }
            if (n3 == 39) {
                bl2 = true;
                continue;
            }
            if (n3 == 35 || n3 == 48) {
                ++n5;
                if (n6 <= -1) continue;
                ++n6;
                continue;
            }
            if (n3 != 44) continue;
            n6 = 0;
        }
        n4 = bl ? 10 : 0;
        bl2 = false;
        StringBuilder stringBuilder = new StringBuilder();
        n3 = string.length();
        n2 = 1;
        block8: for (n8 = 0; n8 < n3; n8 += n2) {
            n = string.codePointAt(n8);
            n2 = Character.charCount(n);
            int n10 = n8 + n2;
            int n11 = n10 < n3 ? string.codePointAt(n10) : 0;
            switch (n) {
                case 39: {
                    if (!bl2) {
                        bl2 = true;
                        stringBuilder.append("\\patstr{");
                        continue block8;
                    }
                    if (n11 == 39) {
                        stringBuilder.append("\\patapo ");
                        n8 = n10;
                        n2 = Character.charCount(n11);
                        continue block8;
                    }
                    stringBuilder.append("}");
                    bl2 = false;
                    continue block8;
                }
                case 48: {
                    if (bl) {
                        if (n4 <= 10) {
                            if (n4 > n5) {
                                while (n4 > n5) {
                                    stringBuilder.append("\\patdgtnz ");
                                    if (n6 > 0 && (n4 - 1) % n6 == 0) {
                                        stringBuilder.append("\\patngp ");
                                    }
                                    --n4;
                                }
                                stringBuilder.append("\\patdgt ");
                            } else {
                                stringBuilder.append("\\patdgt ");
                            }
                        }
                        --n4;
                        continue block8;
                    }
                    if (++n4 > 10) continue block8;
                    if (n4 == n5) {
                        stringBuilder.append("\\patdgt ");
                        while (n4 < 10) {
                            stringBuilder.append("\\patdgtnz ");
                            ++n4;
                        }
                        continue block8;
                    }
                    stringBuilder.append("\\patdgt ");
                    continue block8;
                }
                case 35: {
                    if (bl) {
                        if (n4 <= 10) {
                            if (n4 > n5) {
                                while (n4 > n5) {
                                    stringBuilder.append("\\patdgtnz ");
                                    if (n6 > 0 && (n4 - 1) % n6 == 0) {
                                        stringBuilder.append("\\patngp ");
                                    }
                                    --n4;
                                }
                                stringBuilder.append("\\patdgtnz ");
                            } else {
                                stringBuilder.append("\\patdgtnz ");
                            }
                        }
                        --n4;
                        continue block8;
                    }
                    if (++n4 > 10) continue block8;
                    if (n4 == n5) {
                        stringBuilder.append("\\patdgtnz ");
                        while (n4 < 10) {
                            stringBuilder.append("\\patdgtnz ");
                            ++n4;
                        }
                        continue block8;
                    }
                    stringBuilder.append("\\patdgtnz ");
                    continue block8;
                }
                case 45: {
                    stringBuilder.append("\\patmsg ");
                    continue block8;
                }
                case 44: {
                    if (n4 > n5) continue block8;
                    stringBuilder.append("\\patngp ");
                    continue block8;
                }
                default: {
                    stringBuilder.append(this.escapeText(n));
                }
            }
        }
        return stringBuilder.toString();
    }

    public String getLocaleData(String string) {
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        Locale locale = string == null || "".equals(string) ? Locale.getDefault() : this.getLocale(string);
        String string7 = locale.getDisplayLanguage();
        if (string7 == null) {
            string7 = "";
        }
        if ((string6 = locale.getDisplayLanguage(locale)) == null) {
            string6 = "";
        }
        if ((string5 = locale.getDisplayCountry()) == null) {
            string5 = "";
        }
        if ((string4 = locale.getDisplayCountry(locale)) == null) {
            string4 = "";
        }
        if ((string3 = locale.getDisplayVariant()) == null) {
            string3 = "";
        }
        if ((string2 = locale.getDisplayVariant(locale)) == null) {
            string2 = "";
        }
        String string8 = String.format("{%s}{%s}{%s}{%s}{%s}{%s}{%s}", this.escapeFileName(this.getLanguageTag(locale)), this.escapeText(string7), this.escapeText(string6), this.escapeText(string5), this.escapeText(string4), this.escapeText(string3), this.escapeText(string2));
        DateFormat dateFormat = DateFormat.getDateInstance(0, locale);
        DateFormat dateFormat2 = DateFormat.getDateInstance(1, locale);
        DateFormat dateFormat3 = DateFormat.getDateInstance(2, locale);
        DateFormat dateFormat4 = DateFormat.getDateInstance(3, locale);
        DateFormat dateFormat5 = DateFormat.getTimeInstance(0, locale);
        DateFormat dateFormat6 = DateFormat.getTimeInstance(1, locale);
        DateFormat dateFormat7 = DateFormat.getTimeInstance(2, locale);
        DateFormat dateFormat8 = DateFormat.getTimeInstance(3, locale);
        DateFormat dateFormat9 = DateFormat.getDateTimeInstance(0, 0, locale);
        DateFormat dateFormat10 = DateFormat.getDateTimeInstance(1, 1, locale);
        DateFormat dateFormat11 = DateFormat.getDateTimeInstance(2, 2, locale);
        DateFormat dateFormat12 = DateFormat.getDateTimeInstance(3, 3, locale);
        int n = 0;
        Calendar calendar = Calendar.getInstance(locale);
        calendar.setTimeInMillis(this.now.getTime());
        switch (calendar.getFirstDayOfWeek()) {
            case 2: {
                n = 0;
                break;
            }
            case 3: {
                n = 1;
                break;
            }
            case 4: {
                n = 2;
                break;
            }
            case 5: {
                n = 3;
                break;
            }
            case 6: {
                n = 4;
                break;
            }
            case 7: {
                n = 5;
                break;
            }
            case 1: {
                n = 6;
            }
        }
        String string9 = String.format("{%s}{%s}{%s}{%s}{%d}", this.escapeText(dateFormat.format(this.now)), this.escapeText(dateFormat2.format(this.now)), this.escapeText(dateFormat3.format(this.now)), this.escapeText(dateFormat4.format(this.now)), n);
        String string10 = String.format("{%s}{%s}{%s}{%s}", this.formatDateTimePattern(dateFormat), this.formatDateTimePattern(dateFormat2), this.formatDateTimePattern(dateFormat3), this.formatDateTimePattern(dateFormat4));
        String string11 = String.format("{%s}{%s}{%s}{%s}", this.escapeText(dateFormat5.format(this.now)), this.escapeText(dateFormat6.format(this.now)), this.escapeText(dateFormat7.format(this.now)), this.escapeText(dateFormat8.format(this.now)));
        String string12 = String.format("{%s}{%s}{%s}{%s}", this.formatDateTimePattern(dateFormat5), this.formatDateTimePattern(dateFormat6), this.formatDateTimePattern(dateFormat7), this.formatDateTimePattern(dateFormat8));
        String string13 = String.format("{%s}{%s}{%s}{%s}", this.escapeText(dateFormat9.format(this.now)), this.escapeText(dateFormat10.format(this.now)), this.escapeText(dateFormat11.format(this.now)), this.escapeText(dateFormat12.format(this.now)));
        String string14 = String.format("{%s}{%s}{%s}{%s}", this.formatDateTimePattern(dateFormat9), this.formatDateTimePattern(dateFormat10), this.formatDateTimePattern(dateFormat11), this.formatDateTimePattern(dateFormat12));
        DateFormatSymbols dateFormatSymbols = DateFormatSymbols.getInstance(locale);
        String[] stringArray = dateFormatSymbols.getWeekdays();
        String string15 = String.format("{%s}{%s}{%s}{%s}{%s}{%s}{%s}", this.escapeText(stringArray[2]), this.escapeText(stringArray[3]), this.escapeText(stringArray[4]), this.escapeText(stringArray[5]), this.escapeText(stringArray[6]), this.escapeText(stringArray[7]), this.escapeText(stringArray[1]));
        stringArray = dateFormatSymbols.getShortWeekdays();
        String string16 = String.format("{%s}{%s}{%s}{%s}{%s}{%s}{%s}", this.escapeText(stringArray[2]), this.escapeText(stringArray[3]), this.escapeText(stringArray[4]), this.escapeText(stringArray[5]), this.escapeText(stringArray[6]), this.escapeText(stringArray[7]), this.escapeText(stringArray[1]));
        StringBuilder stringBuilder = new StringBuilder();
        stringArray = dateFormatSymbols.getMonths();
        for (int i = 0; i < 12; ++i) {
            stringBuilder.append(String.format("{%s}", this.escapeText(stringArray[i])));
        }
        StringBuilder stringBuilder2 = new StringBuilder();
        stringArray = dateFormatSymbols.getShortMonths();
        for (int i = 0; i < 12; ++i) {
            stringBuilder2.append(String.format("{%s}", this.escapeText(stringArray[i])));
        }
        DecimalFormatSymbols decimalFormatSymbols = DecimalFormatSymbols.getInstance(locale);
        String string17 = decimalFormatSymbols.getInternationalCurrencySymbol();
        String string18 = decimalFormatSymbols.getCurrencySymbol();
        String string19 = string17;
        String string20 = locale.getCountry();
        if (string20 != null && !"".equals(string20)) {
            if (string20.equals("GG") || string20.equals("GGY") || string20.equals("831")) {
                string19 = "GGP";
                string18 = POUND_STRING;
            } else if (string20.equals("JE") || string20.equals("JEY") || string20.equals("832")) {
                string19 = "JEP";
                string18 = POUND_STRING;
            } else if (string20.equals("IM") || string20.equals("IMN") || string20.equals("833")) {
                string19 = "IMP";
                string18 = String.format("M%s", POUND_STRING);
            } else if (string20.equals("KI") || string20.equals("KIR") || string20.equals("296")) {
                string19 = "KID";
                string18 = "$";
            } else if (string20.equals("TV") || string20.equals("TUV") || string20.equals("798")) {
                string19 = "TVD";
                string18 = "$";
            }
        }
        String string21 = this.getTeXCurrency(string18);
        NumberFormat numberFormat = NumberFormat.getNumberInstance(locale);
        NumberFormat numberFormat2 = NumberFormat.getIntegerInstance(locale);
        NumberFormat numberFormat3 = NumberFormat.getCurrencyInstance(locale);
        NumberFormat numberFormat4 = NumberFormat.getPercentInstance(locale);
        String string22 = String.format("{%s}{%s}{%s}{%d}{%s}{%s}{%s}{%s}{%s}{%s}{%s}", this.escapeText(decimalFormatSymbols.getGroupingSeparator()), this.escapeText(decimalFormatSymbols.getDecimalSeparator()), this.escapeText(decimalFormatSymbols.getExponentSeparator()), numberFormat.isGroupingUsed() ? 1 : 0, string17, string19, this.escapeText(string18), string21, this.escapeText(decimalFormatSymbols.getMonetaryDecimalSeparator()), this.escapeText(decimalFormatSymbols.getPercent()), this.escapeText(decimalFormatSymbols.getPerMill()));
        String string23 = String.format("{%s}{%s}{%s}{%s}", this.formatNumberPattern(numberFormat), this.formatNumberPattern(numberFormat2), this.formatNumberPattern(numberFormat3), this.formatNumberPattern(numberFormat4));
        return String.format("{%s}{%s}{%s}{%s}{%s}{%s}{%s}{%s}{%s}{%s}{%s}{%s}{%s}{%s}{%s}{%s}{%s}", string8, string9, string10, string11, string12, string13, string14, string15, string16, stringBuilder, stringBuilder2, this.getStandaloneWeekdays(calendar, locale), this.getStandaloneShortWeekdays(calendar, locale), this.getStandaloneMonths(calendar, locale), this.getStandaloneShortMonths(calendar, locale), string22, string23);
    }

    protected void syntax() {
        System.out.println(String.format("Usage: %s [<options>] <actions>", this.name));
        System.out.println();
        System.out.println("Cross-platform OS query application");
        System.out.println("for use with TeX's shell escape.");
        System.out.println();
        System.out.println("Each query displays the result in a single line.");
        System.out.println("An empty string is printed if the requested");
        System.out.println("information is unavailable or not permitted.");
        System.out.println("Multiple actions group the results.");
        System.out.println();
        System.out.println("See the manual (texdoc texosquery) for further details.");
        System.out.println();
        System.out.println("Options:");
        System.out.println();
        System.out.println("-h or --help or -help");
        System.out.println("\tDisplay this help message and exit.");
        System.out.println();
        System.out.println("-v or --version or -version");
        System.out.println("\tDisplay version information and exit.");
        System.out.println();
        System.out.println("--nodebug");
        System.out.println("\tNo debugging messages (default)");
        System.out.println();
        System.out.println("--debug [<n>] or -debug [<n>]");
        System.out.println("\tDisplay debugging messages on STDOUT.");
        System.out.println("\t<n> should be an integer:");
        System.out.println("\t0: no debugging (same as --nodebug)");
        System.out.println("\t1: basic debugging messages");
        System.out.println("\t2: additionally display stack trace.");
        System.out.println(String.format("\tIf omitted %d is assumed", 3));
        System.out.println();
        System.out.println("--compatible <n> or -compat <n>");
        System.out.println("\tCompatibility setting.");
        System.out.println("\t<n> should be \"latest\" (default) or an integer:");
        for (int i = 0; i < 2; ++i) {
            System.out.println(String.format("\t%d: version 1.%d", i, i));
        }
        System.out.println();
        System.out.println("--encoding <charset> or -enc <charset>");
        System.out.println("\tSet the file encoding to <charset>.");
        System.out.println();
        System.out.println("--default-encoding or -defenc");
        System.out.println("\tUse the default file encoding.");
        System.out.println();
        System.out.println("--strip-path-prefix <prefix> or -sp <prefix>");
        System.out.println("\tStrip the given prefix from returned path names.");
        System.out.println("\tCan't be used with --replace-path.");
        System.out.println();
        System.out.println("--nostrip-path-prefix");
        System.out.println("\tCancel the effect of --strip-path-prefix.");
        System.out.println();
        System.out.println("--replace-path <regex> <replacement> or -rp <regex> <replacement>");
        System.out.println("\tSubstitutes the first occurrence of <regex> with");
        System.out.println("\t<replacement> in any returned path names.");
        System.out.println("\tCan't be used with --strip-path-prefix.");
        System.out.println();
        System.out.println("--noreplace-path");
        System.out.println("\tCancel the effect of --replace-path.");
        System.out.println();
        System.out.println("--strip-uri-prefix <prefix> or -su <prefix>");
        System.out.println("\tReplace 'file:/<prefix>' with 'file:/'");
        System.out.println("\tfrom returned URIs.");
        System.out.println("\tCan't be used with --replace-uri.");
        System.out.println();
        System.out.println("--nostrip-uri-prefix");
        System.out.println("\tCancel the effect of --strip-uri-prefix.");
        System.out.println();
        System.out.println("--replace-uri <regex> <replacement> or -ru <regex> <replacement>");
        System.out.println("\tSubstitutes the first occurrence of <regex> with");
        System.out.println("\t<replacement> in any returned URIs.");
        System.out.println("\tCan't be used with --strip-uri-prefix.");
        System.out.println();
        System.out.println("--noreplace-uri");
        System.out.println("\tCancel the effect of --replace-uri.");
        System.out.println();
        System.out.println();
        System.out.println("General actions:");
        System.out.println();
        for (QueryAction queryAction : this.AVAILABLE_ACTIONS) {
            if (queryAction.getType() != QueryActionType.GENERAL_ACTION) continue;
            System.out.println(queryAction.help());
        }
        System.out.println();
        System.out.println("Locale actions:");
        System.out.println();
        for (QueryAction queryAction : this.AVAILABLE_ACTIONS) {
            if (queryAction.getType() != QueryActionType.LOCALE_ACTION) continue;
            System.out.println(queryAction.help());
        }
        System.out.println();
        System.out.println("File actions:");
        System.out.println();
        System.out.println("Paths should use / for the directory divider.");
        System.out.println("TeX's openin_any setting is checked before attempting");
        System.out.println("to access file information.");
        System.out.println();
        for (QueryAction queryAction : this.AVAILABLE_ACTIONS) {
            if (queryAction.getType() != QueryActionType.FILE_ACTION) continue;
            System.out.println(queryAction.help());
        }
    }

    protected void version() {
        System.out.println(String.format("%s %s %s", this.name, VERSION_NUMBER, VERSION_DATE));
        System.out.println("Copyright 2016 Nicola Talbot");
        System.out.println("License LPPL 1.3+ (http://ctan.org/license/lppl1.3)");
    }

    protected void print(int n, String string) {
        if (this.compatible == 0) {
            System.out.println(string);
        } else if (n > 1) {
            System.out.println(String.format("{%s}", string));
        } else {
            System.out.println(string);
        }
    }

    private QueryAction getAction(String string) {
        for (int i = 0; i < this.AVAILABLE_ACTIONS.length; ++i) {
            if (!this.AVAILABLE_ACTIONS[i].isAction(string)) continue;
            return this.AVAILABLE_ACTIONS[i].copy();
        }
        return null;
    }

    public static int parseArgVal(String[] stringArray, int n, Object[] objectArray) {
        String[] stringArray2 = stringArray[n].startsWith("--") ? stringArray[n].split("=", 2) : new String[]{stringArray[n]};
        objectArray[0] = stringArray2[0];
        if (stringArray2.length == 2) {
            objectArray[1] = stringArray2[1];
            return n;
        }
        if (n == stringArray.length - 1 || stringArray[n + 1].startsWith("-")) {
            objectArray[1] = null;
            return n;
        }
        objectArray[1] = stringArray[++n];
        return n;
    }

    public static int parseArgInt(String[] stringArray, int n, Object[] objectArray) {
        n = TeXOSQuery.parseArgVal(stringArray, n, objectArray);
        if (objectArray[1] != null) {
            try {
                objectArray[1] = new Integer((String)objectArray[1]);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException(String.format("Invalid '%s' value: %s", objectArray[0], objectArray[1]), numberFormatException);
            }
        }
        return n;
    }

    public static boolean isArg(String string, String string2, String string3) {
        return string.equals("-" + string2) || string.equals("--" + string3) || string.startsWith("--" + string3 + "=");
    }

    public static boolean isArg(String string, String string2) {
        return string.equals("--" + string2) || string.startsWith("--" + string2 + "=");
    }

    public void processArgs(String[] stringArray) {
        Object object;
        int n;
        Vector<Object> vector = new Vector<Object>();
        Object[] objectArray = new Object[2];
        for (n = 0; n < stringArray.length; ++n) {
            object = this.getAction(stringArray[n]);
            if (object != null) {
                try {
                    n = ((QueryAction)object).parseArgs(stringArray, n) - 1;
                    vector.add(object);
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.debug(illegalArgumentException.getMessage(), illegalArgumentException);
                    throw illegalArgumentException;
                }
                catch (Throwable throwable) {
                    this.debug(throwable.getMessage(), throwable);
                    throw new IllegalArgumentException(throwable.getMessage(), throwable);
                }
            }
            if (stringArray[n].equals("-h") || stringArray[n].equals("--help") || stringArray[n].equals("-help")) {
                this.syntax();
                System.exit(0);
                continue;
            }
            if (stringArray[n].equals("-v") || stringArray[n].equals("--version") || stringArray[n].equals("-version")) {
                this.version();
                System.exit(0);
                continue;
            }
            if (stringArray[n].equals("--nodebug")) {
                if (vector.size() > 0) {
                    throw new IllegalArgumentException(String.format("Options must come before actions. Found option: %s", stringArray[n]));
                }
                this.debugLevel = 0;
                continue;
            }
            if (TeXOSQuery.isArg(stringArray[n], "debug", "debug")) {
                if (vector.size() > 0) {
                    throw new IllegalArgumentException(String.format("Options must come before actions. Found option: %s", stringArray[n]));
                }
                n = TeXOSQuery.parseArgInt(stringArray, n, objectArray);
                if (objectArray[1] == null) {
                    this.debugLevel = 3;
                    continue;
                }
                this.debugLevel = (Integer)objectArray[1];
                if (this.debugLevel >= 0) continue;
                throw new IllegalArgumentException(String.format("Invalid debug level: %s", stringArray[n]));
            }
            if (TeXOSQuery.isArg(stringArray[n], "compat", "compatible")) {
                if (vector.size() > 0) {
                    throw new IllegalArgumentException(String.format("Options must come before actions. Found option: %s", stringArray[n]));
                }
                n = TeXOSQuery.parseArgVal(stringArray, n, objectArray);
                if (objectArray[1] == null) {
                    throw new IllegalArgumentException(String.format("<level> expected after: %s", stringArray[n]));
                }
                if (objectArray[1].equals("latest")) {
                    this.compatible = 2;
                    continue;
                }
                try {
                    this.compatible = Integer.parseInt((String)objectArray[1]);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException(String.format("Invalid %s argument (\"latest\" or %d to %d required): %s", objectArray[0], 0, 2, objectArray[1]), numberFormatException);
                }
            }
            if (TeXOSQuery.isArg(stringArray[n], "sp", "strip-path-prefix")) {
                if (vector.size() > 0) {
                    throw new IllegalArgumentException(String.format("Options must come before actions. Found option: %s", stringArray[n]));
                }
                if (this.pathRegExp != null) {
                    throw new IllegalArgumentException(String.format("Option clash: %s and --replace-path", stringArray[n]));
                }
                n = TeXOSQuery.parseArgVal(stringArray, n, objectArray);
                if (objectArray[1] == null) {
                    throw new IllegalArgumentException(String.format("<prefix> expected after: %s", stringArray[n]));
                }
                this.stripFilePrefix = (String)objectArray[1];
                continue;
            }
            if (TeXOSQuery.isArg(stringArray[n], "nostrip-path-prefix")) {
                if (vector.size() > 0) {
                    throw new IllegalArgumentException(String.format("Options must come before actions. Found option: %s", stringArray[n]));
                }
                this.stripFilePrefix = null;
                continue;
            }
            if (TeXOSQuery.isArg(stringArray[n], "rp", "replace-path")) {
                if (vector.size() > 0) {
                    throw new IllegalArgumentException(String.format("Options must come before actions. Found option: %s", stringArray[n]));
                }
                if (this.stripFilePrefix != null) {
                    throw new IllegalArgumentException(String.format("Option clash: --strip-path-prefix and %s", stringArray[n]));
                }
                n = TeXOSQuery.parseArgVal(stringArray, n, objectArray);
                this.pathRegExp = (String)objectArray[1];
                if (this.pathRegExp == null) {
                    throw new IllegalArgumentException(String.format("<regex> <replacement> expected after: %s", stringArray[n]));
                }
                n = TeXOSQuery.parseArgVal(stringArray, n, objectArray);
                this.pathReplacement = (String)objectArray[1];
                if (this.pathReplacement != null) continue;
                throw new IllegalArgumentException(String.format("<replacement> expected after: %s %s", stringArray[n], this.pathRegExp));
            }
            if (TeXOSQuery.isArg(stringArray[n], "noreplace-path")) {
                if (vector.size() > 0) {
                    throw new IllegalArgumentException(String.format("Options must come before actions. Found option: %s", stringArray[n]));
                }
                this.pathRegExp = null;
                this.pathReplacement = null;
                continue;
            }
            if (TeXOSQuery.isArg(stringArray[n], "su", "strip-uri-prefix")) {
                if (vector.size() > 0) {
                    throw new IllegalArgumentException(String.format("Options must come before actions. Found option: %s", stringArray[n]));
                }
                if (this.uriRegExp != null) {
                    throw new IllegalArgumentException(String.format("Option clash: %s and --replace-uri", stringArray[n]));
                }
                n = TeXOSQuery.parseArgVal(stringArray, n, objectArray);
                if (objectArray[1] == null) {
                    throw new IllegalArgumentException(String.format("<prefix> expected after: %s", stringArray[n]));
                }
                this.stripURIPrefix = (String)objectArray[1];
                continue;
            }
            if (TeXOSQuery.isArg(stringArray[n], "nostrip-uri-prefix")) {
                if (vector.size() > 0) {
                    throw new IllegalArgumentException(String.format("Options must come before actions. Found option: %s", stringArray[n]));
                }
                this.stripURIPrefix = null;
                continue;
            }
            if (TeXOSQuery.isArg(stringArray[n], "ru", "replace-uri")) {
                if (vector.size() > 0) {
                    throw new IllegalArgumentException(String.format("Options must come before actions. Found option: %s", stringArray[n]));
                }
                if (this.stripURIPrefix != null) {
                    throw new IllegalArgumentException(String.format("Option clash: --strip-uri-prefix and %s", stringArray[n]));
                }
                n = TeXOSQuery.parseArgVal(stringArray, n, objectArray);
                this.uriRegExp = (String)objectArray[1];
                if (this.uriRegExp == null) {
                    throw new IllegalArgumentException(String.format("<regex> <replacement> expected after: %s", stringArray[n]));
                }
                n = TeXOSQuery.parseArgVal(stringArray, n, objectArray);
                this.uriReplacement = (String)objectArray[1];
                if (this.uriReplacement != null) continue;
                throw new IllegalArgumentException(String.format("<replacement> expected after: %s %s", stringArray[n], this.uriRegExp));
            }
            if (TeXOSQuery.isArg(stringArray[n], "noreplace-uri")) {
                if (vector.size() > 0) {
                    throw new IllegalArgumentException(String.format("Options must come before actions. Found option: %s", stringArray[n]));
                }
                this.uriRegExp = null;
                this.uriReplacement = null;
                continue;
            }
            if (TeXOSQuery.isArg(stringArray[n], "enc", "encoding")) {
                if (vector.size() > 0) {
                    throw new IllegalArgumentException(String.format("Options must come before actions. Found option: %s", stringArray[n]));
                }
                n = TeXOSQuery.parseArgVal(stringArray, n, objectArray);
                if (objectArray[1] == null) {
                    throw new IllegalArgumentException(String.format("<charset> expected after: %s", stringArray[n]));
                }
                this.fileEncoding = (String)objectArray[1];
                continue;
            }
            if (TeXOSQuery.isArg(stringArray[n], "defenc", "default-encoding")) {
                if (vector.size() > 0) {
                    throw new IllegalArgumentException(String.format("Options must come before actions. Found option: %s", stringArray[n]));
                }
                this.fileEncoding = null;
                continue;
            }
            throw new IllegalArgumentException(String.format("Unknown option: %s%nTry %s --help", stringArray[n], this.name));
        }
        n = vector.size();
        if (n == 0) {
            throw new IllegalArgumentException(String.format("One or more actions required.%nTry %s --help", this.name));
        }
        if (this.fileEncoding != null) {
            try {
                object = new PrintStream((OutputStream)new FileOutputStream(FileDescriptor.out), true, this.fileEncoding);
                System.setOut((PrintStream)object);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new IllegalArgumentException("VM does not support encoding " + this.fileEncoding, unsupportedEncodingException);
            }
        }
        for (QueryAction queryAction : vector) {
            try {
                this.print(n, queryAction.doAction(this.compatible));
            }
            catch (Throwable throwable) {
                System.err.println("Fatal error: " + throwable.getMessage());
                if (this.debugLevel < 2) {
                    System.err.println(String.format("Use --debug %d to obtain stack trace", 2));
                }
                this.debug(String.format("Action failed: %s", queryAction.getInvocation()), throwable);
                System.exit(1);
            }
        }
    }
}

