/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphics2d;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class ArrayPath
implements Shape {
    private double[] xPoints;
    private double[] yPoints;
    private int nPoints;
    private boolean closed;
    private int resolution;

    public ArrayPath(double[] xPoints, double[] yPoints, int nPoints, boolean closed, int resolution) {
        this.xPoints = xPoints;
        this.yPoints = yPoints;
        this.nPoints = nPoints;
        this.closed = closed;
        this.resolution = resolution;
    }

    public boolean contains(double x, double y) {
        return false;
    }

    public boolean contains(double x, double y, double w, double h) {
        return false;
    }

    public boolean contains(Point2D p) {
        return this.contains(p.getX(), p.getY());
    }

    public boolean contains(Rectangle2D r) {
        return this.contains(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public boolean intersects(double x, double y, double w, double h) {
        return true;
    }

    public boolean intersects(Rectangle2D r) {
        return this.intersects(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return this.getPathIterator(at);
    }

    public Rectangle2D getBounds2D() {
        double x1;
        double x2;
        double y1;
        double y2;
        int i = this.nPoints;
        if (i > 0) {
            y1 = y2 = this.yPoints[--i];
            x1 = x2 = this.xPoints[i];
            while (i > 0) {
                double y = this.yPoints[--i];
                double x = this.xPoints[i];
                if (x < x1) {
                    x1 = x;
                }
                if (y < y1) {
                    y1 = y;
                }
                if (x > x2) {
                    x2 = x;
                }
                if (!(y > y2)) continue;
                y2 = y;
            }
        } else {
            y2 = 0.0;
            x2 = 0.0;
            y1 = 0.0;
            x1 = 0.0;
        }
        return new Rectangle2D.Double(x1, y1, x2 - x1, y2 - y1);
    }

    public Rectangle getBounds() {
        return this.getBounds2D().getBounds();
    }

    public PathIterator getPathIterator(AffineTransform t) {
        double[] transformedXPoints = this.xPoints;
        double[] transformedYPoints = this.yPoints;
        if (t != null) {
            transformedXPoints = new double[this.nPoints];
            transformedYPoints = new double[this.nPoints];
            Point2D.Double s = new Point2D.Double();
            Point2D.Double d = new Point2D.Double();
            for (int i = 0; i < this.nPoints; ++i) {
                ((Point2D)s).setLocation(this.xPoints[i], this.yPoints[i]);
                t.transform(s, d);
                transformedXPoints[i] = ((Point2D)d).getX();
                transformedYPoints[i] = ((Point2D)d).getY();
            }
        }
        return new ArrayPathIterator(transformedXPoints, transformedYPoints, this.nPoints, this.closed, this.resolution);
    }

    private class ArrayPathIterator
    implements PathIterator {
        private double[] xPoints;
        private double[] yPoints;
        private double lastX;
        private double lastY;
        private int nPoints;
        private boolean closed;
        private int resolution;
        private int currentPoint;
        private boolean isDone;

        private ArrayPathIterator(double[] xPoints, double[] yPoints, int nPoints, boolean closed, int resolution) {
            this.xPoints = xPoints;
            this.yPoints = yPoints;
            this.nPoints = nPoints;
            this.closed = closed;
            this.resolution = resolution;
            this.currentPoint = 0;
            this.isDone = nPoints == 0;
        }

        public boolean isDone() {
            return this.isDone;
        }

        public void next() {
            ++this.currentPoint;
            while (this.currentPoint < this.nPoints - 1 && Math.abs(this.xPoints[this.currentPoint] - this.lastX) < (double)this.resolution && Math.abs(this.yPoints[this.currentPoint] - this.lastY) < (double)this.resolution) {
                ++this.currentPoint;
            }
            if (this.closed && this.currentPoint == this.nPoints - 1 && Math.abs(this.xPoints[this.currentPoint] - this.xPoints[0]) < (double)this.resolution && Math.abs(this.yPoints[this.currentPoint] - this.yPoints[0]) < (double)this.resolution) {
                ++this.currentPoint;
            }
            this.isDone = this.closed ? this.currentPoint > this.nPoints : this.currentPoint >= this.nPoints;
        }

        public int currentSegment(double[] coords) {
            if (this.closed && this.currentPoint == this.nPoints) {
                return 4;
            }
            coords[0] = this.lastX = this.xPoints[this.currentPoint];
            coords[1] = this.lastY = this.yPoints[this.currentPoint];
            return this.currentPoint == 0 ? 0 : 1;
        }

        public int currentSegment(float[] coords) {
            if (this.closed && this.currentPoint == this.nPoints) {
                return 4;
            }
            this.lastX = this.xPoints[this.currentPoint];
            this.lastY = this.yPoints[this.currentPoint];
            coords[0] = (float)this.lastX;
            coords[1] = (float)this.lastY;
            return this.currentPoint == 0 ? 0 : 1;
        }

        public int getWindingRule() {
            return 1;
        }
    }
}

