/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.viewcontroller;

import com.eteks.sweethome3d.model.Content;
import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.HomeDoorOrWindow;
import com.eteks.sweethome3d.model.HomeFurnitureGroup;
import com.eteks.sweethome3d.model.HomeLight;
import com.eteks.sweethome3d.model.HomeMaterial;
import com.eteks.sweethome3d.model.HomePieceOfFurniture;
import com.eteks.sweethome3d.model.HomeTexture;
import com.eteks.sweethome3d.model.Selectable;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.viewcontroller.ContentManager;
import com.eteks.sweethome3d.viewcontroller.Controller;
import com.eteks.sweethome3d.viewcontroller.DialogView;
import com.eteks.sweethome3d.viewcontroller.ModelMaterialsController;
import com.eteks.sweethome3d.viewcontroller.TextureChoiceController;
import com.eteks.sweethome3d.viewcontroller.View;
import com.eteks.sweethome3d.viewcontroller.ViewFactory;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HomeFurnitureController
implements Controller {
    private final Home home;
    private final UserPreferences preferences;
    private final ViewFactory viewFactory;
    private final ContentManager contentManager;
    private final UndoableEditSupport undoSupport;
    private final PropertyChangeSupport propertyChangeSupport;
    private TextureChoiceController textureController;
    private ModelMaterialsController modelMaterialsController;
    private DialogView homeFurnitureView;
    private Content icon;
    private String name;
    private String description;
    private BigDecimal price;
    private Boolean nameVisible;
    private Float x;
    private Float y;
    private Float elevation;
    private Integer angleInDegrees;
    private Float angle;
    private boolean rollAndPitchEditable;
    private Float roll;
    private Float pitch;
    private FurnitureHorizontalAxis horizontalAxis;
    private Float width;
    private Float proportionalWidth;
    private Float depth;
    private Float proportionalDepth;
    private Float height;
    private Float proportionalHeight;
    private boolean proportional;
    private Integer color;
    private FurniturePaint paint;
    private FurnitureShininess shininess;
    private Boolean visible;
    private Boolean modelMirrored;
    private Boolean basePlanItem;
    private boolean basePlanItemEnabled;
    private boolean lightPowerEditable;
    private Float lightPower;
    private boolean resizable;
    private boolean deformable;
    private boolean widthDepthDeformable;
    private boolean texturable;
    private boolean visibleEditable;

    public HomeFurnitureController(Home home, UserPreferences userPreferences, ViewFactory viewFactory, UndoableEditSupport undoableEditSupport) {
        this(home, userPreferences, viewFactory, null, undoableEditSupport);
    }

    public HomeFurnitureController(Home home, UserPreferences userPreferences, ViewFactory viewFactory, ContentManager contentManager, UndoableEditSupport undoableEditSupport) {
        this.home = home;
        this.preferences = userPreferences;
        this.viewFactory = viewFactory;
        this.contentManager = contentManager;
        this.undoSupport = undoableEditSupport;
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.updateProperties();
    }

    public TextureChoiceController getTextureController() {
        if (this.textureController == null && this.contentManager != null) {
            this.textureController = new TextureChoiceController(this.preferences.getLocalizedString(HomeFurnitureController.class, "textureTitle", new Object[0]), this.preferences, this.viewFactory, this.contentManager);
            this.textureController.addPropertyChangeListener(TextureChoiceController.Property.TEXTURE, new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    HomeFurnitureController.this.setPaint(FurniturePaint.TEXTURED);
                }
            });
        }
        return this.textureController;
    }

    public ModelMaterialsController getModelMaterialsController() {
        if (this.modelMaterialsController == null && this.contentManager != null) {
            this.modelMaterialsController = new ModelMaterialsController(this.preferences.getLocalizedString(HomeFurnitureController.class, "modelMaterialsTitle", new Object[0]), this.preferences, this.viewFactory, this.contentManager);
            this.modelMaterialsController.addPropertyChangeListener(ModelMaterialsController.Property.MATERIALS, new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    HomeFurnitureController.this.setPaint(FurniturePaint.MODEL_MATERIALS);
                }
            });
            PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (HomeFurnitureController.this.getWidth() != null && HomeFurnitureController.this.getDepth() != null && HomeFurnitureController.this.getHeight() != null) {
                        HomeFurnitureController.this.modelMaterialsController.setModelSize(HomeFurnitureController.this.getWidth().floatValue(), HomeFurnitureController.this.getDepth().floatValue(), HomeFurnitureController.this.getHeight().floatValue());
                    }
                }
            };
            this.addPropertyChangeListener(Property.WIDTH, propertyChangeListener);
            this.addPropertyChangeListener(Property.DEPTH, propertyChangeListener);
            this.addPropertyChangeListener(Property.HEIGHT, propertyChangeListener);
        }
        return this.modelMaterialsController;
    }

    @Override
    public DialogView getView() {
        if (this.homeFurnitureView == null) {
            this.homeFurnitureView = this.viewFactory.createHomeFurnitureView(this.preferences, this);
        }
        return this.homeFurnitureView;
    }

    public void displayView(View view) {
        this.getView().displayView(view);
    }

    public void addPropertyChangeListener(Property property, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(property.name(), propertyChangeListener);
    }

    public void removePropertyChangeListener(Property property, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(property.name(), propertyChangeListener);
    }

    protected void updateProperties() {
        List<HomePieceOfFurniture> list = Home.getFurnitureSubList(this.home.getSelectedItems());
        TextureChoiceController textureChoiceController = this.getTextureController();
        ModelMaterialsController modelMaterialsController = this.getModelMaterialsController();
        if (list.isEmpty()) {
            this.setIcon(null);
            this.setName(null);
            this.setNameVisible(null);
            this.setDescription(null);
            this.setPrice(null);
            this.setX(null);
            this.setY(null);
            this.setElevation(null);
            this.basePlanItemEnabled = false;
            this.setAngleInDegrees(null);
            this.setRoll(null);
            this.setPitch(null);
            this.setHorizontalAxis(null);
            this.rollAndPitchEditable = false;
            this.setWidth(null, true, false, false);
            this.setDepth(null, true, false, false);
            this.setHeight(null, true, false);
            this.setColor(null);
            if (textureChoiceController != null) {
                textureChoiceController.setTexture(null);
            }
            if (modelMaterialsController != null) {
                modelMaterialsController.setMaterials(null);
                modelMaterialsController.setModel(null);
                modelMaterialsController.setModelCreator(null);
            }
            this.setPaint(null);
            this.setShininess(null);
            this.visibleEditable = false;
            this.setVisible(null);
            this.setModelMirrored(null);
            this.lightPowerEditable = false;
            this.setLightPower(null);
            this.setResizable(true);
            this.setDeformable(true);
            this.setTexturable(true);
            this.setProportional(false);
        } else {
            HomePieceOfFurniture homePieceOfFurniture;
            int n;
            int n2;
            int n3;
            Object object;
            Object object2;
            int n4;
            Object object3;
            int n5;
            int n6;
            Serializable serializable;
            int n7;
            int n8;
            HomePieceOfFurniture homePieceOfFurniture2 = list.get(0);
            Content content = homePieceOfFurniture2.getIcon();
            if (content != null) {
                for (int i = 1; i < list.size(); ++i) {
                    if (content.equals(list.get(i).getIcon())) continue;
                    content = null;
                    break;
                }
            }
            this.setIcon(content);
            String string = homePieceOfFurniture2.getName();
            if (string != null) {
                for (int i = 1; i < list.size(); ++i) {
                    if (string.equals(list.get(i).getName())) continue;
                    string = null;
                    break;
                }
            }
            this.setName(string);
            Boolean bl = homePieceOfFurniture2.isNameVisible();
            for (int i = 1; i < list.size(); ++i) {
                if (bl.booleanValue() == list.get(i).isNameVisible()) continue;
                bl = null;
                break;
            }
            this.setNameVisible(bl);
            String string2 = homePieceOfFurniture2.getDescription();
            if (string2 != null) {
                for (int i = 1; i < list.size(); ++i) {
                    if (string2.equals(list.get(i).getDescription())) continue;
                    string2 = null;
                    break;
                }
            }
            this.setDescription(string2);
            BigDecimal bigDecimal = homePieceOfFurniture2.getPrice();
            if (bigDecimal != null) {
                for (int i = 1; i < list.size(); ++i) {
                    if (bigDecimal.equals(list.get(i).getPrice())) continue;
                    bigDecimal = null;
                    break;
                }
            }
            this.setPrice(bigDecimal);
            Float f = Float.valueOf(homePieceOfFurniture2.getX());
            for (int i = 1; i < list.size(); ++i) {
                if (f.floatValue() == list.get(i).getX()) continue;
                f = null;
                break;
            }
            this.setX(f);
            Float f2 = Float.valueOf(homePieceOfFurniture2.getY());
            for (int i = 1; i < list.size(); ++i) {
                if (f2.floatValue() == list.get(i).getY()) continue;
                f2 = null;
                break;
            }
            this.setY(f2);
            Float f3 = Float.valueOf(homePieceOfFurniture2.getElevation());
            for (n8 = 1; n8 < list.size(); ++n8) {
                if (f3.floatValue() == list.get(n8).getElevation()) continue;
                f3 = null;
                break;
            }
            this.setElevation(f3);
            n8 = !homePieceOfFurniture2.isDoorOrWindow() ? 1 : 0;
            for (int i = 1; n8 == 0 && i < list.size(); ++i) {
                if (list.get(i).isDoorOrWindow()) continue;
                n8 = 1;
            }
            this.basePlanItemEnabled = n8;
            Boolean bl2 = !homePieceOfFurniture2.isMovable();
            for (int i = 1; i < list.size(); ++i) {
                if (bl2 == !list.get(i).isMovable()) continue;
                bl2 = null;
                break;
            }
            this.setBasePlanItem(bl2);
            Float f4 = Float.valueOf(homePieceOfFurniture2.getAngle());
            for (n7 = 1; n7 < list.size(); ++n7) {
                if (f4.floatValue() == list.get(n7).getAngle()) continue;
                f4 = null;
                break;
            }
            this.setAngle(f4);
            n7 = 1;
            for (int i = 0; n7 != 0 && i < list.size(); ++i) {
                serializable = list.get(i);
                n7 = ((HomePieceOfFurniture)serializable).isHorizontallyRotatable() && ((HomePieceOfFurniture)serializable).getStaircaseCutOutShape() == null ? 1 : 0;
            }
            this.rollAndPitchEditable = n7;
            if (this.rollAndPitchEditable) {
                Float f5 = Float.valueOf(homePieceOfFurniture2.getRoll());
                for (int i = 1; i < list.size(); ++i) {
                    if (f5.floatValue() == list.get(i).getRoll()) continue;
                    f5 = null;
                    break;
                }
                this.setRoll(f5);
                serializable = Float.valueOf(homePieceOfFurniture2.getPitch());
                for (n6 = 1; n6 < list.size(); ++n6) {
                    if (((Float)serializable).floatValue() == list.get(n6).getPitch()) continue;
                    serializable = null;
                    break;
                }
                this.setPitch((Float)serializable);
                if (f5 == null && serializable == null || f5 != null && f5.floatValue() != 0.0f && serializable != null && ((Float)serializable).floatValue() != 0.0f || f5 != null && f5.floatValue() == 0.0f && serializable != null && ((Float)serializable).floatValue() == 0.0f) {
                    this.setHorizontalAxis(null);
                } else if (f5 == null && serializable != null && ((Float)serializable).floatValue() == 0.0f || f5 != null && f5.floatValue() != 0.0f) {
                    this.setHorizontalAxis(FurnitureHorizontalAxis.ROLL);
                } else {
                    this.setHorizontalAxis(FurnitureHorizontalAxis.PITCH);
                }
            } else {
                this.setRoll(null);
                this.setPitch(null);
                this.setHorizontalAxis(null);
            }
            Float f6 = Float.valueOf(homePieceOfFurniture2.getWidth());
            for (int i = 1; i < list.size(); ++i) {
                if (f6.floatValue() == list.get(i).getWidth()) continue;
                f6 = null;
                break;
            }
            this.setWidth(f6, true, false, false);
            Float f7 = Float.valueOf(homePieceOfFurniture2.getDepth());
            for (n6 = 1; n6 < list.size(); ++n6) {
                if (f7.floatValue() == list.get(n6).getDepth()) continue;
                f7 = null;
                break;
            }
            this.setDepth(f7, true, false, false);
            Float f8 = Float.valueOf(homePieceOfFurniture2.getHeight());
            for (int i = 1; i < list.size(); ++i) {
                if (f8.floatValue() == list.get(i).getHeight()) continue;
                f8 = null;
                break;
            }
            this.setHeight(f8, true, false);
            List<HomePieceOfFurniture> list2 = this.getFurnitureWithoutGroups(list);
            HomePieceOfFurniture homePieceOfFurniture3 = list2.get(0);
            Integer n9 = homePieceOfFurniture3.getColor();
            if (n9 != null) {
                for (int i = 1; i < list2.size(); ++i) {
                    if (n9.equals(list2.get(i).getColor())) continue;
                    n9 = null;
                    break;
                }
            }
            this.setColor(n9);
            HomeTexture homeTexture = homePieceOfFurniture3.getTexture();
            if (homeTexture != null) {
                for (int i = 1; i < list2.size(); ++i) {
                    if (homeTexture.equals(list2.get(i).getTexture())) continue;
                    homeTexture = null;
                    break;
                }
            }
            if (textureChoiceController != null) {
                textureChoiceController.setTexture(homeTexture);
            }
            Object[] objectArray = homePieceOfFurniture3.getModelMaterials();
            Content content2 = homePieceOfFurniture3.getModel();
            String string3 = homePieceOfFurniture3.getCreator();
            if (content2 != null) {
                for (n5 = 1; n5 < list2.size(); ++n5) {
                    HomePieceOfFurniture homePieceOfFurniture4 = list2.get(n5);
                    if (Arrays.equals(objectArray, homePieceOfFurniture4.getModelMaterials()) && content2 == homePieceOfFurniture4.getModel()) continue;
                    objectArray = null;
                    content2 = null;
                    string3 = null;
                    break;
                }
            }
            if (modelMaterialsController != null) {
                modelMaterialsController.setMaterials((HomeMaterial[])objectArray);
                modelMaterialsController.setModel(content2);
                modelMaterialsController.setModelCreator(string3);
                modelMaterialsController.setModelSize(homePieceOfFurniture3.getWidth(), homePieceOfFurniture3.getDepth(), homePieceOfFurniture3.getHeight());
                modelMaterialsController.setModelRotation(homePieceOfFurniture3.getModelRotation());
                modelMaterialsController.setBackFaceShown(homePieceOfFurniture3.isBackFaceShown());
            }
            n5 = 1;
            for (int i = 0; i < list2.size(); ++i) {
                object3 = list2.get(i);
                if (object3.getColor() == null && object3.getTexture() == null && object3.getModelMaterials() == null) continue;
                n5 = 0;
                break;
            }
            if (n9 != null) {
                this.setPaint(FurniturePaint.COLORED);
            } else if (homeTexture != null) {
                this.setPaint(FurniturePaint.TEXTURED);
            } else if (objectArray != null) {
                this.setPaint(FurniturePaint.MODEL_MATERIALS);
            } else if (n5 != 0) {
                this.setPaint(FurniturePaint.DEFAULT);
            } else {
                this.setPaint(null);
            }
            Float f9 = homePieceOfFurniture3.getShininess();
            object3 = f9 == null ? FurnitureShininess.DEFAULT : (f9.floatValue() == 0.0f ? FurnitureShininess.MATT : FurnitureShininess.SHINY);
            for (n4 = 1; n4 < list2.size(); ++n4) {
                object2 = list2.get(n4);
                if (f9 == ((HomePieceOfFurniture)object2).getShininess() && (f9 == null || f9.equals(((HomePieceOfFurniture)object2).getShininess()))) continue;
                object3 = null;
                break;
            }
            this.setShininess((FurnitureShininess)((Object)object3));
            n4 = 1;
            object2 = this.home.getFurniture();
            for (HomePieceOfFurniture homePieceOfFurniture5 : list) {
                if (object2.contains(homePieceOfFurniture5)) continue;
                n4 = 0;
                break;
            }
            this.visibleEditable = n4;
            if (n4 != 0) {
                object = homePieceOfFurniture2.isVisible();
                for (int i = 1; i < list.size(); ++i) {
                    if (((Boolean)object).booleanValue() == list.get(i).isVisible()) continue;
                    object = null;
                    break;
                }
                this.setVisible((Boolean)object);
            } else {
                this.setVisible(null);
            }
            object = homePieceOfFurniture2.isModelMirrored();
            for (n3 = 1; n3 < list.size(); ++n3) {
                if (((Boolean)object).booleanValue() == list.get(n3).isModelMirrored()) continue;
                object = null;
                break;
            }
            this.setModelMirrored((Boolean)object);
            n3 = homePieceOfFurniture2 instanceof HomeLight;
            for (int i = 1; n3 != 0 && i < list.size(); ++i) {
                n3 = list.get(i) instanceof HomeLight;
            }
            this.lightPowerEditable = n3;
            if (n3 != 0) {
                Float f10 = Float.valueOf(((HomeLight)homePieceOfFurniture2).getPower());
                for (n2 = 1; n2 < list.size(); n2 += 1) {
                    if (f10.floatValue() == ((HomeLight)list.get(n2)).getPower()) continue;
                    f10 = null;
                    break;
                }
                this.setLightPower(f10);
            } else {
                this.setLightPower(null);
            }
            Boolean bl3 = homePieceOfFurniture2.isResizable();
            for (n2 = 1; n2 < list.size(); n2 += 1) {
                if (bl3.booleanValue() == list.get(n2).isResizable()) continue;
                bl3 = null;
                break;
            }
            this.setResizable(bl3 != null && bl3 != false);
            n2 = 1;
            block28: for (n = 0; n2 && n < list.size(); ++n) {
                homePieceOfFurniture = list.get(n);
                if (homePieceOfFurniture instanceof HomeFurnitureGroup) {
                    for (HomePieceOfFurniture homePieceOfFurniture6 : ((HomeFurnitureGroup)homePieceOfFurniture).getAllFurniture()) {
                        if (homePieceOfFurniture6.isDeformable() && !homePieceOfFurniture6.isHorizontallyRotated()) continue;
                        n2 = 0;
                        continue block28;
                    }
                    continue;
                }
                n2 = homePieceOfFurniture.isDeformable();
            }
            this.setDeformable(n2 != 0);
            if (!this.isDeformable()) {
                this.setProportional(true);
            }
            this.widthDepthDeformable = true;
            for (n = 0; this.widthDepthDeformable && n < list.size(); ++n) {
                homePieceOfFurniture = list.get(n);
                this.widthDepthDeformable = homePieceOfFurniture.isWidthDepthDeformable();
            }
            Boolean bl4 = homePieceOfFurniture2.isTexturable();
            for (int i = 1; i < list.size(); ++i) {
                if (bl4.booleanValue() == list.get(i).isTexturable()) continue;
                bl4 = null;
                break;
            }
            this.setTexturable(bl4 == null || bl4 != false);
        }
    }

    private List<HomePieceOfFurniture> getFurnitureWithoutGroups(List<HomePieceOfFurniture> list) {
        ArrayList<HomePieceOfFurniture> arrayList = new ArrayList<HomePieceOfFurniture>();
        for (HomePieceOfFurniture homePieceOfFurniture : list) {
            if (homePieceOfFurniture instanceof HomeFurnitureGroup) {
                arrayList.addAll(this.getFurnitureWithoutGroups(((HomeFurnitureGroup)homePieceOfFurniture).getFurniture()));
                continue;
            }
            arrayList.add(homePieceOfFurniture);
        }
        return arrayList;
    }

    public boolean isPropertyEditable(Property property) {
        switch (property) {
            case DESCRIPTION: 
            case PRICE: {
                return false;
            }
            case ROLL: 
            case PITCH: {
                return this.isRollAndPitchEditable();
            }
            case LIGHT_POWER: {
                return this.isLightPowerEditable();
            }
            case VISIBLE: {
                return this.visibleEditable;
            }
        }
        return true;
    }

    private void setIcon(Content content) {
        if (content != this.icon) {
            Content content2 = this.icon;
            this.icon = content;
            this.propertyChangeSupport.firePropertyChange(Property.ICON.name(), content2, content);
        }
    }

    public Content getIcon() {
        return this.icon;
    }

    public void setName(String string) {
        if (string != this.name) {
            String string2 = this.name;
            this.name = string;
            this.propertyChangeSupport.firePropertyChange(Property.NAME.name(), string2, string);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setNameVisible(Boolean bl) {
        if (bl != this.nameVisible) {
            Boolean bl2 = this.nameVisible;
            this.nameVisible = bl;
            this.propertyChangeSupport.firePropertyChange(Property.NAME_VISIBLE.name(), bl2, bl);
        }
    }

    public Boolean getNameVisible() {
        return this.nameVisible;
    }

    public void setDescription(String string) {
        if (string != this.description) {
            String string2 = this.description;
            this.description = string;
            this.propertyChangeSupport.firePropertyChange(Property.DESCRIPTION.name(), string2, string);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setPrice(BigDecimal bigDecimal) {
        if (bigDecimal != this.price) {
            BigDecimal bigDecimal2 = this.price;
            this.price = bigDecimal;
            this.propertyChangeSupport.firePropertyChange(Property.PRICE.name(), bigDecimal2, bigDecimal);
        }
    }

    public BigDecimal getPrice() {
        return this.price;
    }

    public void setX(Float f) {
        if (f != this.x) {
            Float f2 = this.x;
            this.x = f;
            this.propertyChangeSupport.firePropertyChange(Property.X.name(), f2, f);
        }
    }

    public Float getX() {
        return this.x;
    }

    public void setY(Float f) {
        if (f != this.y) {
            Float f2 = this.y;
            this.y = f;
            this.propertyChangeSupport.firePropertyChange(Property.Y.name(), f2, f);
        }
    }

    public Float getY() {
        return this.y;
    }

    public void setElevation(Float f) {
        if (f != this.elevation) {
            Float f2 = this.elevation;
            this.elevation = f;
            this.propertyChangeSupport.firePropertyChange(Property.ELEVATION.name(), f2, f);
        }
    }

    public Float getElevation() {
        return this.elevation;
    }

    public void setAngleInDegrees(Integer n) {
        this.setAngleInDegrees(n, true);
    }

    private void setAngleInDegrees(Integer n, boolean bl) {
        if (n != this.angleInDegrees) {
            Integer n2 = this.angleInDegrees;
            this.angleInDegrees = n;
            this.propertyChangeSupport.firePropertyChange(Property.ANGLE_IN_DEGREES.name(), n2, n);
            if (bl) {
                if (this.angleInDegrees == null) {
                    this.setAngle(null, false);
                } else {
                    this.setAngle(new Float(Math.toRadians(this.angleInDegrees.intValue())), false);
                }
            }
        }
    }

    public Integer getAngleInDegrees() {
        return this.angleInDegrees;
    }

    public void setAngle(Float f) {
        this.setAngle(f, true);
    }

    public void setAngle(Float f, boolean bl) {
        if (f != this.angle) {
            Float f2 = this.angle;
            this.angle = f;
            this.propertyChangeSupport.firePropertyChange(Property.ANGLE.name(), f2, f);
            if (bl) {
                if (f == null) {
                    this.setAngleInDegrees(null, false);
                } else {
                    this.setAngleInDegrees((int)(Math.round(Math.toDegrees(f.floatValue())) + 360L) % 360, false);
                }
            }
        }
    }

    public Float getAngle() {
        return this.angle;
    }

    public boolean isRollAndPitchEditable() {
        return this.rollAndPitchEditable;
    }

    public void setRoll(Float f) {
        if (f != this.roll) {
            Float f2 = this.roll;
            this.roll = f;
            this.propertyChangeSupport.firePropertyChange(Property.ROLL.name(), f2, f);
        }
    }

    public Float getRoll() {
        return this.roll;
    }

    public void setPitch(Float f) {
        if (f != this.pitch) {
            Float f2 = this.pitch;
            this.pitch = f;
            this.propertyChangeSupport.firePropertyChange(Property.PITCH.name(), f2, f);
        }
    }

    public Float getPitch() {
        return this.pitch;
    }

    public void setHorizontalAxis(FurnitureHorizontalAxis furnitureHorizontalAxis) {
        if (furnitureHorizontalAxis != this.horizontalAxis) {
            FurnitureHorizontalAxis furnitureHorizontalAxis2 = this.horizontalAxis;
            this.horizontalAxis = furnitureHorizontalAxis;
            this.propertyChangeSupport.firePropertyChange(Property.HORIZONTAL_AXIS.name(), (Object)furnitureHorizontalAxis2, (Object)furnitureHorizontalAxis);
        }
    }

    public FurnitureHorizontalAxis getHorizontalAxis() {
        return this.horizontalAxis;
    }

    public boolean isBasePlanItemEnabled() {
        return this.basePlanItemEnabled;
    }

    public boolean isBasePlanItemEditable() {
        return this.basePlanItemEnabled;
    }

    public void setBasePlanItem(Boolean bl) {
        if (bl != this.basePlanItem) {
            Boolean bl2 = this.basePlanItem;
            this.basePlanItem = bl;
            this.propertyChangeSupport.firePropertyChange(Property.BASE_PLAN_ITEM.name(), bl2, bl);
        }
    }

    public Boolean getBasePlanItem() {
        return this.basePlanItem;
    }

    public void setWidth(Float f) {
        this.setWidth(f, false, this.isProportional() || !this.widthDepthDeformable, this.isProportional());
    }

    private void setWidth(Float f, boolean bl, boolean bl2, boolean bl3) {
        Float f2;
        Float f3 = f2 = f != null ? Float.valueOf(Math.max(f.floatValue(), 0.001f)) : null;
        if (f2 == f || f2 != null && f2.equals(f) || !bl) {
            this.proportionalWidth = f;
        }
        if (f2 == null && this.width != null || f2 != null && !f2.equals(this.width)) {
            Float f4 = this.width;
            this.width = f2;
            this.propertyChangeSupport.firePropertyChange(Property.WIDTH.name(), f4, f2);
            if (f4 != null && f2 != null) {
                float f5 = f2.floatValue() / f4.floatValue();
                if (bl2 && this.proportionalDepth != null) {
                    this.setDepth(Float.valueOf(this.proportionalDepth.floatValue() * f5), true, false, false);
                }
                if (bl3 && this.proportionalHeight != null) {
                    this.setHeight(Float.valueOf(this.proportionalHeight.floatValue() * f5), true, false);
                }
            } else {
                if (bl2) {
                    this.setDepth(null, false, false, false);
                }
                if (bl3) {
                    this.setHeight(null, false, false);
                }
            }
        }
    }

    public Float getWidth() {
        return this.width;
    }

    public void setDepth(Float f) {
        this.setDepth(f, false, this.isProportional() || !this.widthDepthDeformable, this.isProportional());
    }

    private void setDepth(Float f, boolean bl, boolean bl2, boolean bl3) {
        Float f2;
        Float f3 = f2 = f != null ? Float.valueOf(Math.max(f.floatValue(), 0.001f)) : null;
        if (f2 == f || f2 != null && f2.equals(f) || !bl) {
            this.proportionalDepth = f;
        }
        if (f2 == null && this.depth != null || f2 != null && !f2.equals(this.depth)) {
            Float f4 = this.depth;
            this.depth = f2;
            this.propertyChangeSupport.firePropertyChange(Property.DEPTH.name(), f4, f2);
            if (f4 != null && f2 != null) {
                float f5 = f2.floatValue() / f4.floatValue();
                if (bl2 && this.proportionalWidth != null) {
                    this.setWidth(Float.valueOf(this.proportionalWidth.floatValue() * f5), true, false, false);
                }
                if (bl3 && this.proportionalHeight != null) {
                    this.setHeight(Float.valueOf(this.proportionalHeight.floatValue() * f5), true, false);
                }
            } else {
                if (bl2) {
                    this.setWidth(null, false, false, false);
                }
                if (bl3) {
                    this.setHeight(null, false, false);
                }
            }
        }
    }

    public Float getDepth() {
        return this.depth;
    }

    public void setHeight(Float f) {
        this.setHeight(f, false, this.isProportional());
    }

    private void setHeight(Float f, boolean bl, boolean bl2) {
        Float f2;
        Float f3 = f2 = f != null ? Float.valueOf(Math.max(f.floatValue(), 0.001f)) : null;
        if (f2 == f || f2 != null && f2.equals(f) || !bl) {
            this.proportionalHeight = f;
        }
        if (f2 == null && this.height != null || f2 != null && !f2.equals(this.height)) {
            Float f4 = this.height;
            this.height = f2;
            this.propertyChangeSupport.firePropertyChange(Property.HEIGHT.name(), f4, f2);
            if (bl2) {
                if (f4 != null && f2 != null) {
                    float f5 = f2.floatValue() / f4.floatValue();
                    if (this.proportionalWidth != null) {
                        this.setWidth(Float.valueOf(this.proportionalWidth.floatValue() * f5), true, false, false);
                    }
                    if (this.proportionalDepth != null) {
                        this.setDepth(Float.valueOf(this.proportionalDepth.floatValue() * f5), true, false, false);
                    }
                } else {
                    this.setWidth(null, false, false, false);
                    this.setDepth(null, false, false, false);
                }
            }
        }
    }

    public Float getHeight() {
        return this.height;
    }

    public void setProportional(boolean bl) {
        if (bl != this.proportional) {
            boolean bl2 = this.proportional;
            this.proportional = bl;
            this.propertyChangeSupport.firePropertyChange(Property.PROPORTIONAL.name(), bl2, bl);
        }
    }

    public boolean isProportional() {
        return this.proportional;
    }

    public void setColor(Integer n) {
        if (n != this.color) {
            Integer n2 = this.color;
            this.color = n;
            this.propertyChangeSupport.firePropertyChange(Property.COLOR.name(), n2, n);
        }
    }

    public Integer getColor() {
        return this.color;
    }

    public void setPaint(FurniturePaint furniturePaint) {
        if (furniturePaint != this.paint) {
            FurniturePaint furniturePaint2 = this.paint;
            this.paint = furniturePaint;
            this.propertyChangeSupport.firePropertyChange(Property.PAINT.name(), (Object)furniturePaint2, (Object)furniturePaint);
        }
    }

    public FurniturePaint getPaint() {
        return this.paint;
    }

    public void setShininess(FurnitureShininess furnitureShininess) {
        if (furnitureShininess != this.shininess) {
            FurnitureShininess furnitureShininess2 = this.shininess;
            this.shininess = furnitureShininess;
            this.propertyChangeSupport.firePropertyChange(Property.SHININESS.name(), (Object)furnitureShininess2, (Object)furnitureShininess);
        }
    }

    public FurnitureShininess getShininess() {
        return this.shininess;
    }

    public void setVisible(Boolean bl) {
        if (bl != this.visible) {
            Boolean bl2 = this.visible;
            this.visible = bl;
            this.propertyChangeSupport.firePropertyChange(Property.VISIBLE.name(), bl2, bl);
        }
    }

    public Boolean getVisible() {
        return this.visible;
    }

    public void setModelMirrored(Boolean bl) {
        if (bl != this.modelMirrored) {
            Boolean bl2 = this.modelMirrored;
            this.modelMirrored = bl;
            this.propertyChangeSupport.firePropertyChange(Property.MODEL_MIRRORED.name(), bl2, bl);
        }
    }

    public Boolean getModelMirrored() {
        return this.modelMirrored;
    }

    public boolean isLightPowerEditable() {
        return this.lightPowerEditable;
    }

    public Float getLightPower() {
        return this.lightPower;
    }

    public void setLightPower(Float f) {
        if (f != this.lightPower) {
            Float f2 = this.lightPower;
            this.lightPower = f;
            this.propertyChangeSupport.firePropertyChange(Property.LIGHT_POWER.name(), f2, f);
        }
    }

    private void setResizable(boolean bl) {
        if (bl != this.resizable) {
            boolean bl2 = this.resizable;
            this.resizable = bl;
            this.propertyChangeSupport.firePropertyChange(Property.RESIZABLE.name(), bl2, bl);
        }
    }

    public boolean isResizable() {
        return this.resizable;
    }

    private void setDeformable(boolean bl) {
        if (bl != this.deformable) {
            boolean bl2 = this.deformable;
            this.deformable = bl;
            this.propertyChangeSupport.firePropertyChange(Property.DEFORMABLE.name(), bl2, bl);
        }
    }

    public boolean isDeformable() {
        return this.deformable;
    }

    private void setTexturable(boolean bl) {
        if (bl != this.texturable) {
            boolean bl2 = this.texturable;
            this.texturable = bl;
            this.propertyChangeSupport.firePropertyChange(Property.TEXTURABLE.name(), bl2, bl);
        }
    }

    public boolean isTexturable() {
        return this.texturable;
    }

    public void modifyFurniture() {
        List<Selectable> list = this.home.getSelectedItems();
        List<HomePieceOfFurniture> list2 = Home.getFurnitureSubList(list);
        if (!list2.isEmpty()) {
            Serializable serializable;
            boolean bl;
            String string = this.getName();
            Boolean bl2 = this.getNameVisible();
            String string2 = this.getDescription();
            BigDecimal bigDecimal = this.getPrice();
            Float f = this.getX();
            Float f2 = this.getY();
            Float f3 = this.getElevation();
            Float f4 = this.getAngle();
            Float f5 = this.getRoll();
            Float f6 = this.getPitch();
            FurnitureHorizontalAxis furnitureHorizontalAxis = this.getHorizontalAxis();
            Boolean bl3 = this.getBasePlanItem();
            Float f7 = this.getWidth();
            Float f8 = this.getDepth();
            Float f9 = this.getHeight();
            boolean bl4 = this.isProportional();
            FurniturePaint furniturePaint = this.getPaint();
            Integer n = furniturePaint == FurniturePaint.COLORED ? this.getColor() : null;
            TextureChoiceController textureChoiceController = this.getTextureController();
            HomeTexture homeTexture = textureChoiceController != null && furniturePaint == FurniturePaint.TEXTURED ? textureChoiceController.getTexture() : null;
            ModelMaterialsController modelMaterialsController = this.getModelMaterialsController();
            HomeMaterial[] homeMaterialArray = modelMaterialsController != null && furniturePaint == FurniturePaint.MODEL_MATERIALS ? modelMaterialsController.getMaterials() : null;
            boolean bl5 = bl = this.getShininess() == FurnitureShininess.DEFAULT;
            Float f10 = this.getShininess() == FurnitureShininess.SHINY ? new Float(0.5f) : (this.getShininess() == FurnitureShininess.MATT ? new Float(0.0f) : null);
            Boolean bl6 = this.getVisible();
            Boolean bl7 = this.getModelMirrored();
            Float f11 = this.getLightPower();
            ModifiedPieceOfFurniture[] modifiedPieceOfFurnitureArray = new ModifiedPieceOfFurniture[list2.size()];
            for (int i = 0; i < modifiedPieceOfFurnitureArray.length; ++i) {
                serializable = list2.get(i);
                modifiedPieceOfFurnitureArray[i] = serializable instanceof HomeLight ? new ModifiedLight((HomeLight)serializable) : (serializable instanceof HomeDoorOrWindow ? new ModifiedDoorOrWindow((HomeDoorOrWindow)serializable) : (serializable instanceof HomeFurnitureGroup ? new ModifiedFurnitureGroup((HomeFurnitureGroup)serializable) : new ModifiedPieceOfFurniture((HomePieceOfFurniture)serializable)));
            }
            HomeFurnitureController.doModifyFurniture(modifiedPieceOfFurnitureArray, string, bl2, string2, bigDecimal, f, f2, f3, f4, f5, f6, furnitureHorizontalAxis, bl3, f7, f8, f9, bl4, furniturePaint, n, homeTexture, homeMaterialArray, bl, f10, bl6, bl7, f11);
            if (this.undoSupport != null) {
                List<Selectable> list3 = this.home.getSelectedItems();
                serializable = new FurnitureModificationUndoableEdit(this.home, this.preferences, list, list3, modifiedPieceOfFurnitureArray, string, bl2, string2, bigDecimal, f, f2, f3, f4, f5, f6, furnitureHorizontalAxis, bl3, f7, f8, f9, bl4, furniturePaint, n, homeTexture, homeMaterialArray, bl, f10, bl6, bl7, f11);
                this.undoSupport.postEdit((UndoableEdit)((Object)serializable));
            }
            if (string != null) {
                this.preferences.addAutoCompletionString("HomePieceOfFurnitureName", string);
            }
            if (string2 != null) {
                this.preferences.addAutoCompletionString("HomePieceOfFurnitureDescription", string2);
            }
        }
    }

    private static void doModifyFurniture(ModifiedPieceOfFurniture[] modifiedPieceOfFurnitureArray, String string, Boolean bl, String string2, BigDecimal bigDecimal, Float f, Float f2, Float f3, Float f4, Float f5, Float f6, FurnitureHorizontalAxis furnitureHorizontalAxis, Boolean bl2, Float f7, Float f8, Float f9, boolean bl3, FurniturePaint furniturePaint, Integer n, HomeTexture homeTexture, HomeMaterial[] homeMaterialArray, boolean bl4, Float f10, Boolean bl5, Boolean bl6, Float f11) {
        for (ModifiedPieceOfFurniture modifiedPieceOfFurniture : modifiedPieceOfFurnitureArray) {
            HomePieceOfFurniture homePieceOfFurniture = modifiedPieceOfFurniture.getPieceOfFurniture();
            if (string != null) {
                homePieceOfFurniture.setName(string);
            }
            if (bl != null) {
                homePieceOfFurniture.setNameVisible(bl);
            }
            if (string2 != null) {
                homePieceOfFurniture.setDescription(string2);
            }
            if (bigDecimal != null && !(homePieceOfFurniture instanceof HomeFurnitureGroup)) {
                homePieceOfFurniture.setPrice(bigDecimal);
            }
            if (f != null) {
                homePieceOfFurniture.setX(f.floatValue());
            }
            if (f2 != null) {
                homePieceOfFurniture.setY(f2.floatValue());
            }
            if (f3 != null) {
                homePieceOfFurniture.setElevation(f3.floatValue());
            }
            if (f4 != null) {
                homePieceOfFurniture.setAngle(f4.floatValue());
            }
            if (furnitureHorizontalAxis != null) {
                switch (furnitureHorizontalAxis) {
                    case ROLL: {
                        if (f5 == null) break;
                        homePieceOfFurniture.setRoll(f5.floatValue());
                        homePieceOfFurniture.setPitch(0.0f);
                        break;
                    }
                    case PITCH: {
                        if (f6 == null) break;
                        homePieceOfFurniture.setPitch(f6.floatValue());
                        homePieceOfFurniture.setRoll(0.0f);
                    }
                }
            }
            if (bl2 != null && !homePieceOfFurniture.isDoorOrWindow()) {
                homePieceOfFurniture.setMovable(bl2 == false);
            }
            if (homePieceOfFurniture.isResizable()) {
                boolean bl7;
                float f12 = homePieceOfFurniture.getWidth();
                float f13 = homePieceOfFurniture.getDepth();
                boolean bl8 = bl7 = !bl3 && homePieceOfFurniture.isDeformable();
                if (bl7) {
                    if (f7 != null) {
                        homePieceOfFurniture.setWidth(f7.floatValue());
                    } else if (f8 != null && !homePieceOfFurniture.isWidthDepthDeformable()) {
                        homePieceOfFurniture.setWidth(homePieceOfFurniture.getWidth() * f8.floatValue() / f13);
                    }
                    if (f8 != null) {
                        homePieceOfFurniture.setDepth(f8.floatValue());
                    } else if (f7 != null && !homePieceOfFurniture.isWidthDepthDeformable()) {
                        homePieceOfFurniture.setDepth(homePieceOfFurniture.getDepth() * f7.floatValue() / f12);
                    }
                    if (f9 != null) {
                        homePieceOfFurniture.setHeight(f9.floatValue());
                    }
                } else if (f7 != null) {
                    homePieceOfFurniture.scale(f7.floatValue() / homePieceOfFurniture.getWidth());
                } else if (f8 != null) {
                    homePieceOfFurniture.scale(f8.floatValue() / homePieceOfFurniture.getDepth());
                } else if (f9 != null) {
                    homePieceOfFurniture.scale(f9.floatValue() / homePieceOfFurniture.getHeight());
                }
                if (bl6 != null) {
                    homePieceOfFurniture.setModelMirrored(bl6);
                }
            }
            if (homePieceOfFurniture.isTexturable()) {
                if (furniturePaint != null) {
                    switch (furniturePaint) {
                        case DEFAULT: {
                            homePieceOfFurniture.setColor(null);
                            homePieceOfFurniture.setTexture(null);
                            homePieceOfFurniture.setModelMaterials(null);
                            break;
                        }
                        case COLORED: {
                            homePieceOfFurniture.setColor(n);
                            homePieceOfFurniture.setTexture(null);
                            homePieceOfFurniture.setModelMaterials(null);
                            break;
                        }
                        case TEXTURED: {
                            homePieceOfFurniture.setColor(null);
                            homePieceOfFurniture.setTexture(homeTexture);
                            homePieceOfFurniture.setModelMaterials(null);
                            break;
                        }
                        case MODEL_MATERIALS: {
                            homePieceOfFurniture.setColor(null);
                            homePieceOfFurniture.setTexture(null);
                            homePieceOfFurniture.setModelMaterials(homeMaterialArray);
                        }
                    }
                }
                if (bl4) {
                    homePieceOfFurniture.setShininess(null);
                } else if (f10 != null) {
                    homePieceOfFurniture.setShininess(f10);
                }
            }
            if (bl5 != null) {
                homePieceOfFurniture.setVisible(bl5);
            }
            if (f11 == null) continue;
            ((HomeLight)homePieceOfFurniture).setPower(f11.floatValue());
        }
    }

    private static void undoModifyFurniture(ModifiedPieceOfFurniture[] modifiedPieceOfFurnitureArray) {
        for (ModifiedPieceOfFurniture modifiedPieceOfFurniture : modifiedPieceOfFurnitureArray) {
            modifiedPieceOfFurniture.reset();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ModifiedFurnitureGroup
    extends ModifiedPieceOfFurniture {
        private final float[] groupFurnitureX;
        private final float[] groupFurnitureY;
        private final float[] groupFurnitureWidth;
        private final float[] groupFurnitureDepth;
        private final Integer[] groupFurnitureColor;
        private final HomeTexture[] groupFurnitureTexture;
        private final HomeMaterial[][] groupFurnitureModelMaterials;
        private final Float[] groupFurnitureShininess;

        public ModifiedFurnitureGroup(HomeFurnitureGroup homeFurnitureGroup) {
            super(homeFurnitureGroup);
            List<HomePieceOfFurniture> list = this.getGroupFurniture(homeFurnitureGroup);
            this.groupFurnitureX = new float[list.size()];
            this.groupFurnitureY = new float[list.size()];
            this.groupFurnitureWidth = new float[list.size()];
            this.groupFurnitureDepth = new float[list.size()];
            this.groupFurnitureColor = new Integer[list.size()];
            this.groupFurnitureTexture = new HomeTexture[list.size()];
            this.groupFurnitureShininess = new Float[list.size()];
            this.groupFurnitureModelMaterials = new HomeMaterial[list.size()][];
            for (int i = 0; i < list.size(); ++i) {
                HomePieceOfFurniture homePieceOfFurniture = list.get(i);
                this.groupFurnitureX[i] = homePieceOfFurniture.getX();
                this.groupFurnitureY[i] = homePieceOfFurniture.getY();
                this.groupFurnitureWidth[i] = homePieceOfFurniture.getWidth();
                this.groupFurnitureDepth[i] = homePieceOfFurniture.getDepth();
                this.groupFurnitureColor[i] = homePieceOfFurniture.getColor();
                this.groupFurnitureTexture[i] = homePieceOfFurniture.getTexture();
                this.groupFurnitureShininess[i] = homePieceOfFurniture.getShininess();
                this.groupFurnitureModelMaterials[i] = homePieceOfFurniture.getModelMaterials();
            }
        }

        @Override
        public void reset() {
            super.reset();
            HomeFurnitureGroup homeFurnitureGroup = (HomeFurnitureGroup)this.getPieceOfFurniture();
            List<HomePieceOfFurniture> list = this.getGroupFurniture(homeFurnitureGroup);
            for (int i = 0; i < list.size(); ++i) {
                HomePieceOfFurniture homePieceOfFurniture = list.get(i);
                if (homeFurnitureGroup.isResizable()) {
                    homePieceOfFurniture.setX(this.groupFurnitureX[i]);
                    homePieceOfFurniture.setY(this.groupFurnitureY[i]);
                    homePieceOfFurniture.setWidth(this.groupFurnitureWidth[i]);
                    homePieceOfFurniture.setDepth(this.groupFurnitureDepth[i]);
                }
                if (!homeFurnitureGroup.isTexturable() || homePieceOfFurniture instanceof HomeFurnitureGroup) continue;
                homePieceOfFurniture.setColor(this.groupFurnitureColor[i]);
                homePieceOfFurniture.setTexture(this.groupFurnitureTexture[i]);
                homePieceOfFurniture.setModelMaterials(this.groupFurnitureModelMaterials[i]);
                homePieceOfFurniture.setShininess(this.groupFurnitureShininess[i]);
            }
        }

        private List<HomePieceOfFurniture> getGroupFurniture(HomeFurnitureGroup homeFurnitureGroup) {
            ArrayList<HomePieceOfFurniture> arrayList = new ArrayList<HomePieceOfFurniture>();
            for (HomePieceOfFurniture homePieceOfFurniture : homeFurnitureGroup.getFurniture()) {
                arrayList.add(homePieceOfFurniture);
                if (!(homePieceOfFurniture instanceof HomeFurnitureGroup)) continue;
                arrayList.addAll(this.getGroupFurniture((HomeFurnitureGroup)homePieceOfFurniture));
            }
            return arrayList;
        }
    }

    private static class ModifiedLight
    extends ModifiedPieceOfFurniture {
        private final float power;

        public ModifiedLight(HomeLight homeLight) {
            super(homeLight);
            this.power = homeLight.getPower();
        }

        public void reset() {
            super.reset();
            ((HomeLight)this.getPieceOfFurniture()).setPower(this.power);
        }
    }

    private static class ModifiedDoorOrWindow
    extends ModifiedPieceOfFurniture {
        private final boolean boundToWall;

        public ModifiedDoorOrWindow(HomeDoorOrWindow homeDoorOrWindow) {
            super(homeDoorOrWindow);
            this.boundToWall = homeDoorOrWindow.isBoundToWall();
        }

        public void reset() {
            super.reset();
            ((HomeDoorOrWindow)this.getPieceOfFurniture()).setBoundToWall(this.boundToWall);
        }
    }

    private static class ModifiedPieceOfFurniture {
        private final HomePieceOfFurniture piece;
        private final String name;
        private final boolean nameVisible;
        private final String description;
        private final BigDecimal price;
        private final float x;
        private final float y;
        private final float elevation;
        private final float angle;
        private final float roll;
        private final float pitch;
        private final boolean movable;
        private final float width;
        private final float depth;
        private final float height;
        private final Integer color;
        private final HomeTexture texture;
        private final HomeMaterial[] modelMaterials;
        private final Float shininess;
        private final boolean visible;
        private final boolean modelMirrored;

        public ModifiedPieceOfFurniture(HomePieceOfFurniture homePieceOfFurniture) {
            this.piece = homePieceOfFurniture;
            this.name = homePieceOfFurniture.getName();
            this.nameVisible = homePieceOfFurniture.isNameVisible();
            this.description = homePieceOfFurniture.getDescription();
            this.price = homePieceOfFurniture.getPrice();
            this.x = homePieceOfFurniture.getX();
            this.y = homePieceOfFurniture.getY();
            this.elevation = homePieceOfFurniture.getElevation();
            this.angle = homePieceOfFurniture.getAngle();
            this.roll = homePieceOfFurniture.getRoll();
            this.pitch = homePieceOfFurniture.getPitch();
            this.movable = homePieceOfFurniture.isMovable();
            this.width = homePieceOfFurniture.getWidth();
            this.depth = homePieceOfFurniture.getDepth();
            this.height = homePieceOfFurniture.getHeight();
            this.color = homePieceOfFurniture.getColor();
            this.texture = homePieceOfFurniture.getTexture();
            this.modelMaterials = homePieceOfFurniture.getModelMaterials();
            this.shininess = homePieceOfFurniture.getShininess();
            this.visible = homePieceOfFurniture.isVisible();
            this.modelMirrored = homePieceOfFurniture.isModelMirrored();
        }

        public HomePieceOfFurniture getPieceOfFurniture() {
            return this.piece;
        }

        public void reset() {
            this.piece.setName(this.name);
            this.piece.setNameVisible(this.nameVisible);
            this.piece.setDescription(this.description);
            if (!(this.piece instanceof HomeFurnitureGroup)) {
                this.piece.setPrice(this.price);
            }
            this.piece.setX(this.x);
            this.piece.setY(this.y);
            this.piece.setElevation(this.elevation);
            this.piece.setAngle(this.angle);
            if (this.piece.isHorizontallyRotatable()) {
                this.piece.setRoll(this.roll);
                this.piece.setPitch(this.pitch);
            }
            this.piece.setMovable(this.movable);
            if (this.piece.isResizable()) {
                this.piece.setWidth(this.width);
                this.piece.setDepth(this.depth);
                this.piece.setHeight(this.height);
                this.piece.setModelMirrored(this.modelMirrored);
            }
            if (this.piece.isTexturable()) {
                this.piece.setColor(this.color);
                this.piece.setTexture(this.texture);
                this.piece.setModelMaterials(this.modelMaterials);
                this.piece.setShininess(this.shininess);
            }
            this.piece.setVisible(this.visible);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FurnitureModificationUndoableEdit
    extends AbstractUndoableEdit {
        private final Home home;
        private final UserPreferences preferences;
        private final ModifiedPieceOfFurniture[] modifiedFurniture;
        private final List<Selectable> oldSelection;
        private final List<Selectable> newSelection;
        private final String name;
        private final Boolean nameVisible;
        private final String description;
        private final BigDecimal price;
        private final Float x;
        private final Float y;
        private final Float elevation;
        private final Float angle;
        private final Float roll;
        private final Float pitch;
        private final FurnitureHorizontalAxis horizontalAxis;
        private final Boolean basePlanItem;
        private final Float width;
        private final Float depth;
        private final Float height;
        private final boolean proportional;
        private final FurniturePaint paint;
        private final Integer color;
        private final HomeTexture texture;
        private final HomeMaterial[] modelMaterials;
        private final boolean defaultShininess;
        private final Float shininess;
        private final Boolean visible;
        private final Boolean modelMirrored;
        private final Float lightPower;

        private FurnitureModificationUndoableEdit(Home home, UserPreferences userPreferences, List<Selectable> list, List<Selectable> list2, ModifiedPieceOfFurniture[] modifiedPieceOfFurnitureArray, String string, Boolean bl, String string2, BigDecimal bigDecimal, Float f, Float f2, Float f3, Float f4, Float f5, Float f6, FurnitureHorizontalAxis furnitureHorizontalAxis, Boolean bl2, Float f7, Float f8, Float f9, boolean bl3, FurniturePaint furniturePaint, Integer n, HomeTexture homeTexture, HomeMaterial[] homeMaterialArray, boolean bl4, Float f10, Boolean bl5, Boolean bl6, Float f11) {
            this.home = home;
            this.preferences = userPreferences;
            this.oldSelection = list;
            this.newSelection = list2;
            this.modifiedFurniture = modifiedPieceOfFurnitureArray;
            this.name = string;
            this.nameVisible = bl;
            this.description = string2;
            this.price = bigDecimal;
            this.x = f;
            this.y = f2;
            this.elevation = f3;
            this.angle = f4;
            this.roll = f5;
            this.pitch = f6;
            this.horizontalAxis = furnitureHorizontalAxis;
            this.basePlanItem = bl2;
            this.width = f7;
            this.depth = f8;
            this.height = f9;
            this.proportional = bl3;
            this.paint = furniturePaint;
            this.color = n;
            this.texture = homeTexture;
            this.modelMaterials = homeMaterialArray;
            this.defaultShininess = bl4;
            this.shininess = f10;
            this.visible = bl5;
            this.modelMirrored = bl6;
            this.lightPower = f11;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            HomeFurnitureController.undoModifyFurniture(this.modifiedFurniture);
            this.home.setSelectedItems(this.oldSelection);
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            HomeFurnitureController.doModifyFurniture(this.modifiedFurniture, this.name, this.nameVisible, this.description, this.price, this.x, this.y, this.elevation, this.angle, this.roll, this.pitch, this.horizontalAxis, this.basePlanItem, this.width, this.depth, this.height, this.proportional, this.paint, this.color, this.texture, this.modelMaterials, this.defaultShininess, this.shininess, this.visible, this.modelMirrored, this.lightPower);
            this.home.setSelectedItems(this.newSelection);
        }

        @Override
        public String getPresentationName() {
            return this.preferences.getLocalizedString(HomeFurnitureController.class, "undoModifyFurnitureName", new Object[0]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FurnitureHorizontalAxis {
        ROLL,
        PITCH;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FurnitureShininess {
        DEFAULT,
        MATT,
        SHINY;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FurniturePaint {
        DEFAULT,
        COLORED,
        TEXTURED,
        MODEL_MATERIALS;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Property {
        ICON,
        NAME,
        NAME_VISIBLE,
        DESCRIPTION,
        PRICE,
        X,
        Y,
        ELEVATION,
        BASE_PLAN_ITEM,
        ANGLE,
        ANGLE_IN_DEGREES,
        ROLL,
        PITCH,
        HORIZONTAL_AXIS,
        WIDTH,
        DEPTH,
        HEIGHT,
        PROPORTIONAL,
        COLOR,
        PAINT,
        SHININESS,
        VISIBLE,
        MODEL_MIRRORED,
        LIGHT_POWER,
        RESIZABLE,
        DEFORMABLE,
        TEXTURABLE;

    }
}

