/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.editorActions.AutoHardWrapHandler;
import com.intellij.codeInsight.editorActions.JavaLikeQuoteHandler;
import com.intellij.codeInsight.editorActions.MultiCharQuoteHandler;
import com.intellij.codeInsight.editorActions.QuoteHandler;
import com.intellij.codeInsight.editorActions.QuoteHandlerEP;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.codeInsight.highlighting.BraceMatcher;
import com.intellij.codeInsight.highlighting.BraceMatchingUtil;
import com.intellij.codeInsight.highlighting.NontrivialBraceMatcher;
import com.intellij.codeInsight.template.impl.editorActions.TypedActionHandlerBase;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.LanguageQuoteHandling;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.actionSystem.ActionPlan;
import com.intellij.openapi.editor.actionSystem.TypedActionHandler;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypedHandler
extends TypedActionHandlerBase {
    private static final Set<Character> COMPLEX_CHARS = new HashSet<Character>(Arrays.asList(Character.valueOf('\n'), Character.valueOf('\t'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('{'), Character.valueOf('}'), Character.valueOf('\"'), Character.valueOf('\'')));
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.editorActions.TypedHandler");
    private static final Map<FileType, QuoteHandler> quoteHandlers = new HashMap<FileType, QuoteHandler>();
    private static final Map<Class<? extends Language>, QuoteHandler> ourBaseLanguageQuoteHandlers = new HashMap<Class<? extends Language>, QuoteHandler>();

    public TypedHandler(TypedActionHandler originalHandler) {
        super(originalHandler);
    }

    @Nullable
    public static QuoteHandler getQuoteHandler(@NotNull PsiFile file2, @NotNull Editor editor) {
        FileType fileFileType;
        FileType fileType;
        QuoteHandler quoteHandler;
        if (file2 == null) {
            TypedHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            TypedHandler.$$$reportNull$$$0(1);
        }
        if ((quoteHandler = TypedHandler.getQuoteHandlerForType(fileType = TypedHandler.getFileType(file2, editor))) == null && (fileFileType = file2.getFileType()) != fileType) {
            quoteHandler = TypedHandler.getQuoteHandlerForType(fileFileType);
        }
        if (quoteHandler == null) {
            return TypedHandler.getLanguageQuoteHandler(file2.getViewProvider().getBaseLanguage());
        }
        return quoteHandler;
    }

    public static QuoteHandler getLanguageQuoteHandler(Language baseLanguage) {
        for (Map.Entry<Class<? extends Language>, QuoteHandler> entry : ourBaseLanguageQuoteHandlers.entrySet()) {
            if (!entry.getKey().isInstance(baseLanguage)) continue;
            return entry.getValue();
        }
        return (QuoteHandler)LanguageQuoteHandling.INSTANCE.forLanguage(baseLanguage);
    }

    private static FileType getFileType(@NotNull PsiFile file2, @NotNull Editor editor) {
        LanguageFileType associatedFileType;
        if (file2 == null) {
            TypedHandler.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            TypedHandler.$$$reportNull$$$0(3);
        }
        FileType fileType = file2.getFileType();
        Language language = PsiUtilBase.getLanguageInEditor((Editor)editor, (Project)file2.getProject());
        if (language != null && language != PlainTextLanguage.INSTANCE && (associatedFileType = language.getAssociatedFileType()) != null) {
            fileType = associatedFileType;
        }
        return fileType;
    }

    public static void registerBaseLanguageQuoteHandler(@NotNull Class<? extends Language> languageClass, @NotNull QuoteHandler quoteHandler) {
        if (languageClass == null) {
            TypedHandler.$$$reportNull$$$0(4);
        }
        if (quoteHandler == null) {
            TypedHandler.$$$reportNull$$$0(5);
        }
        ourBaseLanguageQuoteHandlers.put(languageClass, quoteHandler);
    }

    public static QuoteHandler getQuoteHandlerForType(@NotNull FileType fileType) {
        if (fileType == null) {
            TypedHandler.$$$reportNull$$$0(6);
        }
        if (!quoteHandlers.containsKey(fileType)) {
            QuoteHandlerEP[] handlerEPs;
            QuoteHandler handler2 = null;
            for (QuoteHandlerEP ep : handlerEPs = (QuoteHandlerEP[])Extensions.getExtensions(QuoteHandlerEP.EP_NAME)) {
                if (!ep.fileType.equals(fileType.getName())) continue;
                handler2 = ep.getHandler();
                break;
            }
            quoteHandlers.put(fileType, handler2);
        }
        return quoteHandlers.get(fileType);
    }

    @Deprecated
    public static void registerQuoteHandler(@NotNull FileType fileType, @NotNull QuoteHandler quoteHandler) {
        if (fileType == null) {
            TypedHandler.$$$reportNull$$$0(7);
        }
        if (quoteHandler == null) {
            TypedHandler.$$$reportNull$$$0(8);
        }
        quoteHandlers.put(fileType, quoteHandler);
    }

    @Override
    public void beforeExecute(@NotNull Editor editor, char c, @NotNull DataContext context, @NotNull ActionPlan plan) {
        if (editor == null) {
            TypedHandler.$$$reportNull$$$0(9);
        }
        if (context == null) {
            TypedHandler.$$$reportNull$$$0(10);
        }
        if (plan == null) {
            TypedHandler.$$$reportNull$$$0(11);
        }
        if (COMPLEX_CHARS.contains(Character.valueOf(c)) || Character.isSurrogate(c)) {
            return;
        }
        if (editor.isInsertMode()) {
            int offset = plan.getCaretOffset();
            plan.replace(offset, offset, String.valueOf(c));
        }
        super.beforeExecute(editor, c, context, plan);
    }

    public void execute(final @NotNull Editor originalEditor, final char charTyped, final @NotNull DataContext dataContext) {
        PsiFile originalFile;
        Project project;
        if (originalEditor == null) {
            TypedHandler.$$$reportNull$$$0(12);
        }
        if (dataContext == null) {
            TypedHandler.$$$reportNull$$$0(13);
        }
        if ((project = (Project)CommonDataKeys.PROJECT.getData(dataContext)) == null || (originalFile = PsiUtilBase.getPsiFileInEditor((Editor)originalEditor, (Project)project)) == null) {
            if (this.myOriginalHandler != null) {
                this.myOriginalHandler.execute(originalEditor, charTyped, dataContext);
            }
            return;
        }
        if (!EditorModificationUtil.checkModificationAllowed((Editor)originalEditor)) {
            return;
        }
        final PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project);
        final Document originalDocument = originalEditor.getDocument();
        originalEditor.getCaretModel().runForEachCaret(new CaretAction(){

            public void perform(Caret caret) {
                TypedHandlerDelegate.Result result2;
                Editor editor;
                if (psiDocumentManager.isDocumentBlockedByPsi(originalDocument)) {
                    psiDocumentManager.doPostponedOperationsAndUnblockDocument(originalDocument);
                }
                PsiFile file2 = (editor = TypedHandler.injectedEditorIfCharTypedIsSignificant(charTyped, originalEditor, originalFile)) == originalEditor ? originalFile : psiDocumentManager.getPsiFile(editor.getDocument());
                TypedHandlerDelegate[] delegates = (TypedHandlerDelegate[])Extensions.getExtensions((ExtensionPointName)TypedHandlerDelegate.EP_NAME);
                if (caret == originalEditor.getCaretModel().getPrimaryCaret()) {
                    boolean handled = false;
                    TypedHandlerDelegate[] typedHandlerDelegateArray = delegates;
                    int n = typedHandlerDelegateArray.length;
                    for (int i = 0; i < n; ++i) {
                        TypedHandlerDelegate delegate = typedHandlerDelegateArray[i];
                        result2 = delegate.checkAutoPopup(charTyped, project, editor, file2);
                        boolean bl = handled = result2 == TypedHandlerDelegate.Result.STOP;
                        if (result2 != TypedHandlerDelegate.Result.CONTINUE) break;
                    }
                    if (!handled) {
                        TypedHandler.autoPopupCompletion(editor, charTyped, project, file2);
                        TypedHandler.autoPopupParameterInfo(editor, charTyped, project, file2);
                    }
                }
                if (!editor.isInsertMode()) {
                    TypedHandler.type(originalEditor, charTyped);
                    return;
                }
                for (TypedHandlerDelegate delegate : delegates) {
                    TypedHandlerDelegate.Result result3 = delegate.beforeSelectionRemoved(charTyped, project, editor, file2);
                    if (result3 == TypedHandlerDelegate.Result.STOP) {
                        return;
                    }
                    if (result3 == TypedHandlerDelegate.Result.DEFAULT) break;
                }
                EditorModificationUtil.deleteSelectedText((Editor)editor);
                FileType fileType = TypedHandler.getFileType(file2, editor);
                for (TypedHandlerDelegate delegate : delegates) {
                    result2 = delegate.beforeCharTyped(charTyped, project, editor, file2, fileType);
                    if (result2 == TypedHandlerDelegate.Result.STOP) {
                        return;
                    }
                    if (result2 == TypedHandlerDelegate.Result.DEFAULT) break;
                }
                if (')' == charTyped || ']' == charTyped || '}' == charTyped ? FileTypes.PLAIN_TEXT != fileType && TypedHandler.handleRParen(editor, fileType, charTyped) : ('\"' == charTyped || '\'' == charTyped || '`' == charTyped) && TypedHandler.handleQuote(editor, charTyped, file2)) {
                    return;
                }
                long modificationStampBeforeTyping = editor.getDocument().getModificationStamp();
                TypedHandler.type(originalEditor, charTyped);
                AutoHardWrapHandler.getInstance().wrapLineIfNecessary(originalEditor, dataContext, modificationStampBeforeTyping);
                if (('(' == charTyped || '[' == charTyped || '{' == charTyped) && CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET && fileType != FileTypes.PLAIN_TEXT) {
                    TypedHandler.handleAfterLParen(editor, fileType, charTyped);
                } else if ('}' == charTyped) {
                    TypedHandler.indentClosingBrace(project, editor);
                } else if (')' == charTyped) {
                    TypedHandler.indentClosingParenth(project, editor);
                }
                for (TypedHandlerDelegate delegate : delegates) {
                    TypedHandlerDelegate.Result result4 = delegate.charTyped(charTyped, project, editor, file2);
                    if (result4 == TypedHandlerDelegate.Result.STOP) {
                        return;
                    }
                    if (result4 == TypedHandlerDelegate.Result.DEFAULT) break;
                }
                if ('{' == charTyped) {
                    TypedHandler.indentOpenedBrace(project, editor);
                } else if ('(' == charTyped) {
                    TypedHandler.indentOpenedParenth(project, editor);
                }
            }
        });
    }

    private static void type(Editor editor, char charTyped) {
        CommandProcessor.getInstance().setCurrentCommandName(EditorBundle.message((String)"typing.in.editor.command.name", (Object[])new Object[0]));
        EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)String.valueOf(charTyped), (boolean)true, (boolean)true);
    }

    private static void autoPopupParameterInfo(@NotNull Editor editor, char charTyped, @NotNull Project project, @NotNull PsiFile file2) {
        if (editor == null) {
            TypedHandler.$$$reportNull$$$0(14);
        }
        if (project == null) {
            TypedHandler.$$$reportNull$$$0(15);
        }
        if (file2 == null) {
            TypedHandler.$$$reportNull$$$0(16);
        }
        if (!(charTyped != '(' && charTyped != ',' || TypedHandler.isInsideStringLiteral(editor, file2))) {
            AutoPopupController.getInstance(project).autoPopupParameterInfo(editor, null);
        }
    }

    public static void autoPopupCompletion(@NotNull Editor editor, char charTyped, @NotNull Project project, @NotNull PsiFile file2) {
        if (editor == null) {
            TypedHandler.$$$reportNull$$$0(17);
        }
        if (project == null) {
            TypedHandler.$$$reportNull$$$0(18);
        }
        if (file2 == null) {
            TypedHandler.$$$reportNull$$$0(19);
        }
        if (charTyped == '.' || TypedHandler.isAutoPopup(editor, file2, charTyped)) {
            AutoPopupController.getInstance(project).autoPopupMemberLookup(editor, null);
        }
    }

    public static void commitDocumentIfCurrentCaretIsNotTheFirstOne(@NotNull Editor editor, @NotNull Project project) {
        if (editor == null) {
            TypedHandler.$$$reportNull$$$0(20);
        }
        if (project == null) {
            TypedHandler.$$$reportNull$$$0(21);
        }
        if (ContainerUtil.getFirstItem((List)editor.getCaretModel().getAllCarets()) != editor.getCaretModel().getCurrentCaret()) {
            PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
        }
    }

    private static boolean isAutoPopup(@NotNull Editor editor, @NotNull PsiFile file2, char charTyped) {
        PsiElement element;
        int offset;
        if (editor == null) {
            TypedHandler.$$$reportNull$$$0(22);
        }
        if (file2 == null) {
            TypedHandler.$$$reportNull$$$0(23);
        }
        if ((offset = editor.getCaretModel().getOffset() - 1) >= 0 && (element = file2.findElementAt(offset)) != null) {
            List allContributors = CompletionContributor.forLanguage((Language)element.getLanguage());
            List availableContributors = DumbService.getInstance((Project)file2.getProject()).filterByDumbAwareness((Collection)allContributors);
            for (CompletionContributor contributor : availableContributors) {
                if (!contributor.invokeAutoPopup(element, charTyped)) continue;
                LOG.debug(contributor + " requested completion autopopup when typing '" + charTyped + "'");
                return true;
            }
        }
        return false;
    }

    private static boolean isInsideStringLiteral(@NotNull Editor editor, @NotNull PsiFile file2) {
        int offset;
        PsiElement element;
        if (editor == null) {
            TypedHandler.$$$reportNull$$$0(24);
        }
        if (file2 == null) {
            TypedHandler.$$$reportNull$$$0(25);
        }
        if ((element = file2.findElementAt(offset = editor.getCaretModel().getOffset())) == null) {
            return false;
        }
        ParserDefinition definition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(element.getLanguage());
        if (definition != null) {
            ASTNode parentNode;
            TokenSet stringLiteralElements = definition.getStringLiteralElements();
            ASTNode node = element.getNode();
            if (node == null) {
                return false;
            }
            IElementType elementType = node.getElementType();
            if (stringLiteralElements.contains(elementType)) {
                return true;
            }
            PsiElement parent = element.getParent();
            if (parent != null && (parentNode = parent.getNode()) != null && stringLiteralElements.contains(parentNode.getElementType())) {
                return true;
            }
        }
        return false;
    }

    @NotNull
    public static Editor injectedEditorIfCharTypedIsSignificant(char charTyped, @NotNull Editor editor, @NotNull PsiFile oldFile) {
        if (editor == null) {
            TypedHandler.$$$reportNull$$$0(26);
        }
        if (oldFile == null) {
            TypedHandler.$$$reportNull$$$0(27);
        }
        Editor editor2 = TypedHandler.injectedEditorIfCharTypedIsSignificant((int)charTyped, editor, oldFile);
        if (editor2 == null) {
            TypedHandler.$$$reportNull$$$0(28);
        }
        return editor2;
    }

    @NotNull
    public static Editor injectedEditorIfCharTypedIsSignificant(int charTyped, @NotNull Editor editor, @NotNull PsiFile oldFile) {
        if (editor == null) {
            TypedHandler.$$$reportNull$$$0(29);
        }
        if (oldFile == null) {
            TypedHandler.$$$reportNull$$$0(30);
        }
        int offset = editor.getCaretModel().getOffset();
        for (DocumentWindow documentWindow : InjectedLanguageUtil.getCachedInjectedDocuments(oldFile)) {
            PsiFile injectedFile;
            if (!documentWindow.isValid() || !documentWindow.containsRange(offset, offset) || (injectedFile = PsiDocumentManager.getInstance((Project)oldFile.getProject()).getPsiFile((Document)documentWindow)) == null) continue;
            Editor injectedEditor = InjectedLanguageUtil.getInjectedEditorForInjectedFile(editor, injectedFile);
            TextRange hostRange = documentWindow.getHostRange(offset);
            CharSequence sequence = editor.getDocument().getCharsSequence();
            if ((sequence.length() <= offset || charTyped == Character.codePointAt(sequence, offset)) && (hostRange == null || !hostRange.contains(offset))) continue;
            Editor editor2 = injectedEditor;
            if (editor2 == null) {
                TypedHandler.$$$reportNull$$$0(31);
            }
            return editor2;
        }
        Editor editor3 = editor;
        if (editor3 == null) {
            TypedHandler.$$$reportNull$$$0(32);
        }
        return editor3;
    }

    private static void handleAfterLParen(@NotNull Editor editor, @NotNull FileType fileType, char lparenChar) {
        boolean matched;
        int lparenOffset;
        boolean atEndOfDocument;
        if (editor == null) {
            TypedHandler.$$$reportNull$$$0(33);
        }
        if (fileType == null) {
            TypedHandler.$$$reportNull$$$0(34);
        }
        int offset = editor.getCaretModel().getOffset();
        HighlighterIterator iterator = ((EditorEx)editor).getHighlighter().createIterator(offset);
        boolean bl = atEndOfDocument = offset == editor.getDocument().getTextLength();
        if (!atEndOfDocument) {
            iterator.retreat();
        }
        if (iterator.atEnd()) {
            return;
        }
        BraceMatcher braceMatcher = BraceMatchingUtil.getBraceMatcher(fileType, iterator);
        if (iterator.atEnd()) {
            return;
        }
        IElementType braceTokenType = iterator.getTokenType();
        CharSequence fileText = editor.getDocument().getCharsSequence();
        if (!braceMatcher.isLBraceToken(iterator, fileText, fileType)) {
            return;
        }
        if (!iterator.atEnd()) {
            iterator.advance();
            if (!iterator.atEnd() && !BraceMatchingUtil.isPairedBracesAllowedBeforeTypeInFileType(braceTokenType, iterator.getTokenType(), fileType)) {
                return;
            }
            iterator.retreat();
        }
        if ((lparenOffset = BraceMatchingUtil.findLeftmostLParen(iterator, braceTokenType, fileText, fileType)) < 0) {
            lparenOffset = 0;
        }
        if (!(matched = BraceMatchingUtil.matchBrace(fileText, fileType, iterator = ((EditorEx)editor).getHighlighter().createIterator(lparenOffset), true, true))) {
            String text;
            if (lparenChar == '(') {
                text = ")";
            } else if (lparenChar == '[') {
                text = "]";
            } else if (lparenChar == '<') {
                text = ">";
            } else if (lparenChar == '{') {
                text = "}";
            } else {
                throw new AssertionError((Object)("Unknown char " + lparenChar));
            }
            editor.getDocument().insertString(offset, (CharSequence)text);
        }
    }

    public static boolean handleRParen(@NotNull Editor editor, @NotNull FileType fileType, char charTyped) {
        boolean matched;
        CharSequence text;
        if (editor == null) {
            TypedHandler.$$$reportNull$$$0(35);
        }
        if (fileType == null) {
            TypedHandler.$$$reportNull$$$0(36);
        }
        if (!CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        if (offset == editor.getDocument().getTextLength()) {
            return false;
        }
        HighlighterIterator iterator = ((EditorEx)editor).getHighlighter().createIterator(offset);
        if (iterator.atEnd()) {
            return false;
        }
        if (iterator.getEnd() - iterator.getStart() != 1 || editor.getDocument().getCharsSequence().charAt(iterator.getStart()) != charTyped) {
            return false;
        }
        BraceMatcher braceMatcher = BraceMatchingUtil.getBraceMatcher(fileType, iterator);
        if (!braceMatcher.isRBraceToken(iterator, text = editor.getDocument().getCharsSequence(), fileType)) {
            return false;
        }
        IElementType tokenType = iterator.getTokenType();
        iterator.retreat();
        IElementType lparenTokenType = braceMatcher.getOppositeBraceTokenType(tokenType);
        int lparenthOffset = BraceMatchingUtil.findLeftmostLParen(iterator, lparenTokenType, text, fileType);
        if (lparenthOffset < 0) {
            if (braceMatcher instanceof NontrivialBraceMatcher) {
                for (IElementType t : ((NontrivialBraceMatcher)braceMatcher).getOppositeBraceTokenTypes(tokenType)) {
                    if (t != lparenTokenType && (lparenthOffset = BraceMatchingUtil.findLeftmostLParen(iterator, t, text, fileType)) >= 0) break;
                }
            }
            if (lparenthOffset < 0) {
                return false;
            }
        }
        if (!(matched = BraceMatchingUtil.matchBrace(text, fileType, iterator = ((EditorEx)editor).getHighlighter().createIterator(lparenthOffset), true, true))) {
            return false;
        }
        EditorModificationUtil.moveCaretRelatively((Editor)editor, (int)1);
        return true;
    }

    private static boolean handleQuote(@NotNull Editor editor, char quote, @NotNull PsiFile file2) {
        CharSequence closingQuote;
        if (editor == null) {
            TypedHandler.$$$reportNull$$$0(37);
        }
        if (file2 == null) {
            TypedHandler.$$$reportNull$$$0(38);
        }
        if (!CodeInsightSettings.getInstance().AUTOINSERT_PAIR_QUOTE) {
            return false;
        }
        QuoteHandler quoteHandler = TypedHandler.getQuoteHandler(file2, editor);
        if (quoteHandler == null) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        Document document = editor.getDocument();
        CharSequence chars = document.getCharsSequence();
        int length = document.getTextLength();
        if (TypedHandler.isTypingEscapeQuote(editor, quoteHandler, offset)) {
            return false;
        }
        if (offset < length && chars.charAt(offset) == quote && TypedHandler.isClosingQuote(editor, quoteHandler, offset)) {
            EditorModificationUtil.moveCaretRelatively((Editor)editor, (int)1);
            return true;
        }
        HighlighterIterator iterator = ((EditorEx)editor).getHighlighter().createIterator(offset);
        if (!iterator.atEnd()) {
            IElementType tokenType = iterator.getTokenType();
            if (quoteHandler instanceof JavaLikeQuoteHandler) {
                try {
                    if (!((JavaLikeQuoteHandler)quoteHandler).isAppropriateElementTypeForLiteral(tokenType)) {
                        return false;
                    }
                }
                catch (AbstractMethodError abstractMethodError) {
                    // empty catch block
                }
            }
        }
        TypedHandler.type(editor, quote);
        offset = editor.getCaretModel().getOffset();
        if (quoteHandler instanceof MultiCharQuoteHandler && (closingQuote = TypedHandler.getClosingQuote(editor, (MultiCharQuoteHandler)quoteHandler, offset)) != null && TypedHandler.hasNonClosedLiterals(editor, quoteHandler, offset - 1) && (offset == document.getTextLength() || !Character.isUnicodeIdentifierPart(document.getCharsSequence().charAt(offset)))) {
            document.insertString(offset, closingQuote);
            return true;
        }
        if (TypedHandler.isOpeningQuote(editor, quoteHandler, offset - 1) && TypedHandler.hasNonClosedLiterals(editor, quoteHandler, offset - 1) && (offset == document.getTextLength() || !Character.isUnicodeIdentifierPart(document.getCharsSequence().charAt(offset)))) {
            document.insertString(offset, (CharSequence)String.valueOf(quote));
        }
        return true;
    }

    private static boolean isClosingQuote(@NotNull Editor editor, @NotNull QuoteHandler quoteHandler, int offset) {
        HighlighterIterator iterator;
        if (editor == null) {
            TypedHandler.$$$reportNull$$$0(39);
        }
        if (quoteHandler == null) {
            TypedHandler.$$$reportNull$$$0(40);
        }
        if ((iterator = ((EditorEx)editor).getHighlighter().createIterator(offset)).atEnd()) {
            LOG.assertTrue(false);
            return false;
        }
        return quoteHandler.isClosingQuote(iterator, offset);
    }

    @Nullable
    private static CharSequence getClosingQuote(@NotNull Editor editor, @NotNull MultiCharQuoteHandler quoteHandler, int offset) {
        HighlighterIterator iterator;
        if (editor == null) {
            TypedHandler.$$$reportNull$$$0(41);
        }
        if (quoteHandler == null) {
            TypedHandler.$$$reportNull$$$0(42);
        }
        if ((iterator = ((EditorEx)editor).getHighlighter().createIterator(offset)).atEnd()) {
            LOG.assertTrue(false);
            return null;
        }
        return quoteHandler.getClosingQuote(iterator, offset);
    }

    private static boolean isOpeningQuote(@NotNull Editor editor, @NotNull QuoteHandler quoteHandler, int offset) {
        HighlighterIterator iterator;
        if (editor == null) {
            TypedHandler.$$$reportNull$$$0(43);
        }
        if (quoteHandler == null) {
            TypedHandler.$$$reportNull$$$0(44);
        }
        if ((iterator = ((EditorEx)editor).getHighlighter().createIterator(offset)).atEnd()) {
            LOG.assertTrue(false);
            return false;
        }
        return quoteHandler.isOpeningQuote(iterator, offset);
    }

    private static boolean hasNonClosedLiterals(@NotNull Editor editor, @NotNull QuoteHandler quoteHandler, int offset) {
        HighlighterIterator iterator;
        if (editor == null) {
            TypedHandler.$$$reportNull$$$0(45);
        }
        if (quoteHandler == null) {
            TypedHandler.$$$reportNull$$$0(46);
        }
        if ((iterator = ((EditorEx)editor).getHighlighter().createIterator(offset)).atEnd()) {
            LOG.assertTrue(false);
            return false;
        }
        return quoteHandler.hasNonClosedLiteral(editor, iterator, offset);
    }

    private static boolean isTypingEscapeQuote(@NotNull Editor editor, @NotNull QuoteHandler quoteHandler, int offset) {
        if (editor == null) {
            TypedHandler.$$$reportNull$$$0(47);
        }
        if (quoteHandler == null) {
            TypedHandler.$$$reportNull$$$0(48);
        }
        if (offset == 0) {
            return false;
        }
        CharSequence chars = editor.getDocument().getCharsSequence();
        int offset1 = CharArrayUtil.shiftBackward((CharSequence)chars, (int)(offset - 1), (String)"\\");
        int slashCount = offset - 1 - offset1;
        return slashCount % 2 != 0 && TypedHandler.isInsideLiteral(editor, quoteHandler, offset);
    }

    private static boolean isInsideLiteral(@NotNull Editor editor, @NotNull QuoteHandler quoteHandler, int offset) {
        if (editor == null) {
            TypedHandler.$$$reportNull$$$0(49);
        }
        if (quoteHandler == null) {
            TypedHandler.$$$reportNull$$$0(50);
        }
        if (offset == 0) {
            return false;
        }
        HighlighterIterator iterator = ((EditorEx)editor).getHighlighter().createIterator(offset - 1);
        if (iterator.atEnd()) {
            LOG.assertTrue(false);
            return false;
        }
        return quoteHandler.isInsideLiteral(iterator);
    }

    private static void indentClosingBrace(@NotNull Project project, @NotNull Editor editor) {
        if (project == null) {
            TypedHandler.$$$reportNull$$$0(51);
        }
        if (editor == null) {
            TypedHandler.$$$reportNull$$$0(52);
        }
        TypedHandler.indentBrace(project, editor, '}');
    }

    static void indentOpenedBrace(@NotNull Project project, @NotNull Editor editor) {
        if (project == null) {
            TypedHandler.$$$reportNull$$$0(53);
        }
        if (editor == null) {
            TypedHandler.$$$reportNull$$$0(54);
        }
        TypedHandler.indentBrace(project, editor, '{');
    }

    private static void indentOpenedParenth(@NotNull Project project, @NotNull Editor editor) {
        if (project == null) {
            TypedHandler.$$$reportNull$$$0(55);
        }
        if (editor == null) {
            TypedHandler.$$$reportNull$$$0(56);
        }
        TypedHandler.indentBrace(project, editor, '(');
    }

    private static void indentClosingParenth(@NotNull Project project, @NotNull Editor editor) {
        if (project == null) {
            TypedHandler.$$$reportNull$$$0(57);
        }
        if (editor == null) {
            TypedHandler.$$$reportNull$$$0(58);
        }
        TypedHandler.indentBrace(project, editor, ')');
    }

    private static void indentBrace(@NotNull Project project, @NotNull Editor editor, char braceChar) {
        if (project == null) {
            TypedHandler.$$$reportNull$$$0(59);
        }
        if (editor == null) {
            TypedHandler.$$$reportNull$$$0(60);
        }
        int offset = editor.getCaretModel().getOffset() - 1;
        Document document = editor.getDocument();
        CharSequence chars = document.getCharsSequence();
        if (offset < 0 || chars.charAt(offset) != braceChar) {
            return;
        }
        int spaceStart = CharArrayUtil.shiftBackward((CharSequence)chars, (int)(offset - 1), (String)" \t");
        if (spaceStart < 0 || chars.charAt(spaceStart) == '\n' || chars.charAt(spaceStart) == '\r') {
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
            documentManager.commitDocument(document);
            PsiFile file2 = documentManager.getPsiFile(document);
            if (file2 == null || !file2.isWritable()) {
                return;
            }
            PsiElement element = file2.findElementAt(offset);
            if (element == null) {
                return;
            }
            EditorHighlighter highlighter = ((EditorEx)editor).getHighlighter();
            HighlighterIterator iterator = highlighter.createIterator(offset);
            FileType fileType = file2.getFileType();
            BraceMatcher braceMatcher = BraceMatchingUtil.getBraceMatcher(fileType, iterator);
            boolean rBraceToken = braceMatcher.isRBraceToken(iterator, chars, fileType);
            boolean isBrace = braceMatcher.isLBraceToken(iterator, chars, fileType) || rBraceToken;
            int lBraceOffset = -1;
            if (CodeInsightSettings.getInstance().REFORMAT_BLOCK_ON_RBRACE && rBraceToken && braceMatcher.isStructuralBrace(iterator, chars, fileType) && offset > 0) {
                lBraceOffset = BraceMatchingUtil.findLeftLParen(highlighter.createIterator(offset - 1), braceMatcher.getOppositeBraceTokenType(iterator.getTokenType()), editor.getDocument().getCharsSequence(), fileType);
            }
            if (element.getNode() != null && isBrace) {
                int finalLBraceOffset = lBraceOffset;
                ApplicationManager.getApplication().runWriteAction(() -> {
                    if (project == null) {
                        TypedHandler.$$$reportNull$$$0(61);
                    }
                    if (editor == null) {
                        TypedHandler.$$$reportNull$$$0(62);
                    }
                    try {
                        int newOffset;
                        if (finalLBraceOffset != -1) {
                            RangeMarker marker = document.createRangeMarker(offset, offset + 1);
                            CodeStyleManager.getInstance((Project)project).reformatRange((PsiElement)file2, finalLBraceOffset, offset, true);
                            newOffset = marker.getStartOffset();
                            marker.dispose();
                        } else {
                            newOffset = CodeStyleManager.getInstance((Project)project).adjustLineIndent(file2, offset);
                        }
                        editor.getCaretModel().moveToOffset(newOffset + 1);
                        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                        editor.getSelectionModel().removeSelection();
                    }
                    catch (IncorrectOperationException e) {
                        LOG.error((Throwable)e);
                    }
                });
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 28: 
            case 31: 
            case 32: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 28: 
            case 31: 
            case 32: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: 
            case 9: 
            case 14: 
            case 17: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 29: 
            case 33: 
            case 35: 
            case 37: 
            case 39: 
            case 41: 
            case 43: 
            case 45: 
            case 47: 
            case 49: 
            case 52: 
            case 54: 
            case 56: 
            case 58: 
            case 60: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageClass";
                break;
            }
            case 5: 
            case 8: 
            case 40: 
            case 42: 
            case 44: 
            case 46: 
            case 48: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quoteHandler";
                break;
            }
            case 6: 
            case 7: 
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plan";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalEditor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 15: 
            case 18: 
            case 21: 
            case 51: 
            case 53: 
            case 55: 
            case 57: 
            case 59: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldFile";
                break;
            }
            case 28: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/editorActions/TypedHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/editorActions/TypedHandler";
                break;
            }
            case 28: 
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "injectedEditorIfCharTypedIsSignificant";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getQuoteHandler";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFileType";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "registerBaseLanguageQuoteHandler";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getQuoteHandlerForType";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "registerQuoteHandler";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "beforeExecute";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "autoPopupParameterInfo";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "autoPopupCompletion";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "commitDocumentIfCurrentCaretIsNotTheFirstOne";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isAutoPopup";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isInsideStringLiteral";
                break;
            }
            case 26: 
            case 27: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "injectedEditorIfCharTypedIsSignificant";
                break;
            }
            case 28: 
            case 31: 
            case 32: {
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "handleAfterLParen";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "handleRParen";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "handleQuote";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "isClosingQuote";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getClosingQuote";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "isOpeningQuote";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "hasNonClosedLiterals";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "isTypingEscapeQuote";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "isInsideLiteral";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "indentClosingBrace";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "indentOpenedBrace";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "indentOpenedParenth";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "indentClosingParenth";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "indentBrace";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "lambda$indentBrace$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 28: 
            case 31: 
            case 32: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

