/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.conversion.impl;

import com.intellij.conversion.ArtifactsSettings;
import com.intellij.conversion.CannotConvertException;
import com.intellij.conversion.ComponentManagerSettings;
import com.intellij.conversion.ConversionProcessor;
import com.intellij.conversion.ConverterProvider;
import com.intellij.conversion.ModuleSettings;
import com.intellij.conversion.ProjectConverter;
import com.intellij.conversion.ProjectLibrariesSettings;
import com.intellij.conversion.ProjectSettings;
import com.intellij.conversion.RunManagerSettings;
import com.intellij.conversion.WorkspaceSettings;
import com.intellij.conversion.impl.ConversionContextImpl;
import com.intellij.openapi.components.StorageScheme;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ConversionRunner {
    private final ConverterProvider myProvider;
    private final ConversionContextImpl myContext;
    private final ConversionProcessor<ModuleSettings> myModuleFileConverter;
    private final ConversionProcessor<ProjectSettings> myProjectFileConverter;
    private final ConversionProcessor<WorkspaceSettings> myWorkspaceConverter;
    private boolean myProcessProjectFile;
    private boolean myProcessWorkspaceFile;
    private boolean myProcessRunConfigurations;
    private boolean myProcessProjectLibraries;
    private boolean myArtifacts;
    private final List<File> myModulesFilesToProcess = new ArrayList<File>();
    private final ProjectConverter myConverter;
    private final ConversionProcessor<RunManagerSettings> myRunConfigurationsConverter;
    private final ConversionProcessor<ProjectLibrariesSettings> myProjectLibrariesConverter;
    private final ConversionProcessor<ArtifactsSettings> myArtifactsConverter;

    public ConversionRunner(ConverterProvider provider, ConversionContextImpl context) {
        this.myProvider = provider;
        this.myContext = context;
        this.myConverter = provider.createConverter(context);
        this.myModuleFileConverter = this.myConverter.createModuleFileConverter();
        this.myProjectFileConverter = this.myConverter.createProjectFileConverter();
        this.myWorkspaceConverter = this.myConverter.createWorkspaceFileConverter();
        this.myRunConfigurationsConverter = this.myConverter.createRunConfigurationsConverter();
        this.myProjectLibrariesConverter = this.myConverter.createProjectLibrariesConverter();
        this.myArtifactsConverter = this.myConverter.createArtifactsConverter();
    }

    public boolean isConversionNeeded() throws CannotConvertException {
        if (this.myContext.isConversionAlreadyPerformed(this.myProvider)) {
            return false;
        }
        this.myProcessProjectFile = this.myContext.getStorageScheme() == StorageScheme.DEFAULT && this.myProjectFileConverter != null && this.myProjectFileConverter.isConversionNeeded(this.myContext.getProjectSettings());
        this.myProcessWorkspaceFile = this.myWorkspaceConverter != null && this.myContext.getWorkspaceFile().exists() && this.myWorkspaceConverter.isConversionNeeded(this.myContext.getWorkspaceSettings());
        this.myModulesFilesToProcess.clear();
        if (this.myModuleFileConverter != null) {
            for (File moduleFile : this.myContext.getModuleFiles()) {
                if (!moduleFile.exists() || !this.myModuleFileConverter.isConversionNeeded(this.myContext.getModuleSettings(moduleFile))) continue;
                this.myModulesFilesToProcess.add(moduleFile);
            }
        }
        this.myProcessRunConfigurations = this.myRunConfigurationsConverter != null && this.myRunConfigurationsConverter.isConversionNeeded(this.myContext.getRunManagerSettings());
        this.myProcessProjectLibraries = this.myProjectLibrariesConverter != null && this.myProjectLibrariesConverter.isConversionNeeded(this.myContext.getProjectLibrariesSettings());
        this.myArtifacts = this.myArtifactsConverter != null && this.myArtifactsConverter.isConversionNeeded(this.myContext.getArtifactsSettings());
        return this.myProcessProjectFile || this.myProcessWorkspaceFile || this.myProcessRunConfigurations || this.myProcessProjectLibraries || !this.myModulesFilesToProcess.isEmpty() || this.myConverter.isConversionNeeded();
    }

    public boolean isModuleConversionNeeded(File moduleFile) throws CannotConvertException {
        return this.myModuleFileConverter != null && this.myModuleFileConverter.isConversionNeeded(this.myContext.getModuleSettings(moduleFile));
    }

    public Collection<File> getCreatedFiles() {
        return this.myConverter.getCreatedFiles();
    }

    public Set<File> getAffectedFiles() {
        ComponentManagerSettings settings;
        HashSet<File> affectedFiles = new HashSet<File>();
        if (this.myProcessProjectFile) {
            affectedFiles.add(this.myContext.getProjectFile());
        }
        if (this.myProcessWorkspaceFile) {
            affectedFiles.add(this.myContext.getWorkspaceFile());
        }
        affectedFiles.addAll(this.myModulesFilesToProcess);
        try {
            if (this.myProcessRunConfigurations) {
                affectedFiles.addAll(this.myContext.getRunManagerSettings().getAffectedFiles());
            }
            if (this.myProcessProjectLibraries) {
                affectedFiles.addAll(this.myContext.getProjectLibrariesSettings().getAffectedFiles());
            }
            if (this.myArtifacts) {
                affectedFiles.addAll(this.myContext.getArtifactsSettings().getAffectedFiles());
            }
        }
        catch (CannotConvertException cannotConvertException) {
            // empty catch block
        }
        if (!this.myProvider.canDetermineIfConversionAlreadyPerformedByProjectFiles() && (settings = this.myContext.getProjectFileVersionSettings()) != null) {
            affectedFiles.add(settings.getFile());
        }
        affectedFiles.addAll(this.myConverter.getAdditionalAffectedFiles());
        return affectedFiles;
    }

    public void preProcess() throws CannotConvertException {
        if (this.myProcessProjectFile) {
            this.myProjectFileConverter.preProcess(this.myContext.getProjectSettings());
        }
        if (this.myProcessWorkspaceFile) {
            this.myWorkspaceConverter.preProcess(this.myContext.getWorkspaceSettings());
        }
        for (File moduleFile : this.myModulesFilesToProcess) {
            this.myModuleFileConverter.preProcess(this.myContext.getModuleSettings(moduleFile));
        }
        if (this.myProcessRunConfigurations) {
            this.myRunConfigurationsConverter.preProcess(this.myContext.getRunManagerSettings());
        }
        if (this.myProcessProjectLibraries) {
            this.myProjectLibrariesConverter.preProcess(this.myContext.getProjectLibrariesSettings());
        }
        if (this.myArtifacts) {
            this.myArtifactsConverter.preProcess(this.myContext.getArtifactsSettings());
        }
        this.myConverter.preProcessingFinished();
    }

    public void process() throws CannotConvertException {
        if (this.myProcessProjectFile) {
            this.myProjectFileConverter.process(this.myContext.getProjectSettings());
        }
        if (this.myProcessWorkspaceFile) {
            this.myWorkspaceConverter.process(this.myContext.getWorkspaceSettings());
        }
        for (File moduleFile : this.myModulesFilesToProcess) {
            this.myModuleFileConverter.process(this.myContext.getModuleSettings(moduleFile));
        }
        if (this.myProcessRunConfigurations) {
            this.myRunConfigurationsConverter.process(this.myContext.getRunManagerSettings());
        }
        if (this.myProcessProjectLibraries) {
            this.myProjectLibrariesConverter.process(this.myContext.getProjectLibrariesSettings());
        }
        if (this.myArtifacts) {
            this.myArtifactsConverter.process(this.myContext.getArtifactsSettings());
        }
        this.myConverter.processingFinished();
    }

    public void postProcess() throws CannotConvertException {
        if (this.myProcessProjectFile) {
            this.myProjectFileConverter.postProcess(this.myContext.getProjectSettings());
        }
        if (this.myProcessWorkspaceFile) {
            this.myWorkspaceConverter.postProcess(this.myContext.getWorkspaceSettings());
        }
        for (File moduleFile : this.myModulesFilesToProcess) {
            this.myModuleFileConverter.postProcess(this.myContext.getModuleSettings(moduleFile));
        }
        if (this.myProcessRunConfigurations) {
            this.myRunConfigurationsConverter.postProcess(this.myContext.getRunManagerSettings());
        }
        if (this.myProcessProjectLibraries) {
            this.myProjectLibrariesConverter.postProcess(this.myContext.getProjectLibrariesSettings());
        }
        if (this.myArtifacts) {
            this.myArtifactsConverter.postProcess(this.myContext.getArtifactsSettings());
        }
        this.myConverter.postProcessingFinished();
    }

    public ConverterProvider getProvider() {
        return this.myProvider;
    }

    public static List<File> getReadOnlyFiles(Collection<File> affectedFiles) {
        ArrayList<File> result2 = new ArrayList<File>();
        for (File file2 : affectedFiles) {
            if (file2.canWrite()) continue;
            result2.add(file2);
        }
        return result2;
    }

    public void convertModule(File moduleFile) throws CannotConvertException {
        ModuleSettings settings = this.myContext.getModuleSettings(moduleFile);
        this.myModuleFileConverter.preProcess(settings);
        this.myModuleFileConverter.process(settings);
        this.myModuleFileConverter.postProcess(settings);
    }
}

