/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.runners;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.Component;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FakeRerunAction
extends AnAction {
    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            FakeRerunAction.$$$reportNull$$$0(0);
        }
        Presentation presentation = event.getPresentation();
        ExecutionEnvironment environment = this.getEnvironment(event);
        if (environment != null) {
            presentation.setText(ExecutionBundle.message((String)"rerun.configuration.action.name", (Object[])new Object[]{StringUtil.escapeMnemonics((String)environment.getRunProfile().getName())}));
            presentation.setIcon(ExecutionManagerImpl.isProcessRunning(this.getDescriptor(event)) ? AllIcons.Actions.Restart : environment.getExecutor().getIcon());
            presentation.setEnabled(this.isEnabled(event));
            return;
        }
        presentation.setEnabled(false);
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        ExecutionEnvironment environment;
        if (event == null) {
            FakeRerunAction.$$$reportNull$$$0(1);
        }
        if ((environment = this.getEnvironment(event)) != null) {
            ExecutionUtil.restart((ExecutionEnvironment)environment);
        }
    }

    @Nullable
    protected RunContentDescriptor getDescriptor(AnActionEvent event) {
        return (RunContentDescriptor)event.getData(LangDataKeys.RUN_CONTENT_DESCRIPTOR);
    }

    @Nullable
    protected ExecutionEnvironment getEnvironment(@NotNull AnActionEvent event) {
        ExecutionEnvironment environment;
        if (event == null) {
            FakeRerunAction.$$$reportNull$$$0(2);
        }
        if ((environment = (ExecutionEnvironment)event.getData(LangDataKeys.EXECUTION_ENVIRONMENT)) == null) {
            JComponent component;
            RunContentDescriptor contentDescriptor;
            Project project = event.getProject();
            RunContentDescriptor runContentDescriptor = contentDescriptor = project == null ? null : ExecutionManager.getInstance((Project)project).getContentManager().getSelectedContent();
            if (contentDescriptor != null && (component = contentDescriptor.getComponent()) != null) {
                environment = (ExecutionEnvironment)LangDataKeys.EXECUTION_ENVIRONMENT.getData(DataManager.getInstance().getDataContext((Component)component));
            }
        }
        return environment;
    }

    protected boolean isEnabled(AnActionEvent event) {
        RunContentDescriptor descriptor2 = this.getDescriptor(event);
        ProcessHandler processHandler2 = descriptor2 == null ? null : descriptor2.getProcessHandler();
        ExecutionEnvironment environment = this.getEnvironment(event);
        Project project = FakeRerunAction.getEventProject((AnActionEvent)event);
        if (environment == null || project == null) {
            return false;
        }
        RunnerAndConfigurationSettings settings = environment.getRunnerAndConfigurationSettings();
        return !(DumbService.isDumb((Project)project) && settings != null && !settings.getType().isDumbAware() || ExecutorRegistry.getInstance().isStarting(environment) || processHandler2 != null && processHandler2.isProcessTerminating());
    }

    public boolean isDumbAware() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "event";
        objectArray2[1] = "com/intellij/execution/runners/FakeRerunAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getEnvironment";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

