/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner.events;

import com.intellij.execution.testframework.sm.runner.events.TreeNodeEvent;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessage;
import jetbrains.buildServer.messages.serviceMessages.TestFailed;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestFailedEvent
extends TreeNodeEvent {
    private final String myLocalizedFailureMessage;
    private final String myStacktrace;
    private final boolean myTestError;
    private final String myComparisonFailureActualText;
    private final String myComparisonFailureExpectedText;
    private final String myExpectedFilePath;
    private final String myActualFilePath;
    private final long myDurationMillis;
    private boolean myExpectedFileTemp;
    private boolean myActualFileTemp;

    public TestFailedEvent(@NotNull TestFailed testFailed, boolean testError) {
        if (testFailed == null) {
            TestFailedEvent.$$$reportNull$$$0(0);
        }
        this(testFailed, testError, null);
    }

    public TestFailedEvent(@NotNull TestFailed testFailed, boolean testError, @Nullable String expectedFilePath) {
        if (testFailed == null) {
            TestFailedEvent.$$$reportNull$$$0(1);
        }
        this(testFailed, testError, expectedFilePath, null);
    }

    public TestFailedEvent(@NotNull TestFailed testFailed, boolean testError, @Nullable String expectedFilePath, @Nullable String actualFilePath) {
        if (testFailed == null) {
            TestFailedEvent.$$$reportNull$$$0(2);
        }
        super(testFailed.getTestName(), TreeNodeEvent.getNodeId((ServiceMessage)testFailed));
        if (testFailed.getFailureMessage() == null) {
            throw new NullPointerException();
        }
        this.myLocalizedFailureMessage = testFailed.getFailureMessage();
        this.myStacktrace = testFailed.getStacktrace();
        this.myTestError = testError;
        this.myExpectedFilePath = expectedFilePath;
        String expected = testFailed.getExpected();
        if (expected == null && expectedFilePath != null) {
            try {
                expected = FileUtil.loadFile((File)new File(expectedFilePath));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.myComparisonFailureExpectedText = expected;
        this.myActualFilePath = actualFilePath;
        String actual = testFailed.getActual();
        if (actual == null && actualFilePath != null) {
            try {
                actual = FileUtil.loadFile((File)new File(actualFilePath));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.myComparisonFailureActualText = actual;
        Map attributes = testFailed.getAttributes();
        this.myDurationMillis = TestFailedEvent.parseDuration((String)attributes.get("duration"));
        this.myActualFileTemp = Boolean.parseBoolean((String)attributes.get("actualIsTempFile"));
        this.myExpectedFileTemp = Boolean.parseBoolean((String)attributes.get("expectedIsTempFile"));
    }

    public boolean isExpectedFileTemp() {
        return this.myExpectedFileTemp;
    }

    public boolean isActualFileTemp() {
        return this.myActualFileTemp;
    }

    private static long parseDuration(@Nullable String durationStr) {
        if (!StringUtil.isEmpty((String)durationStr)) {
            try {
                return Long.parseLong(durationStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1L;
    }

    public TestFailedEvent(@NotNull String testName, @NotNull String localizedFailureMessage, @Nullable String stackTrace, boolean testError, @Nullable String comparisonFailureActualText, @Nullable String comparisonFailureExpectedText) {
        if (testName == null) {
            TestFailedEvent.$$$reportNull$$$0(3);
        }
        if (localizedFailureMessage == null) {
            TestFailedEvent.$$$reportNull$$$0(4);
        }
        this(testName, null, localizedFailureMessage, stackTrace, testError, comparisonFailureActualText, comparisonFailureExpectedText, null, null, false, false, -1L);
    }

    public TestFailedEvent(@Nullable String testName, @Nullable String id, @NotNull String localizedFailureMessage, @Nullable String stackTrace, boolean testError, @Nullable String comparisonFailureActualText, @Nullable String comparisonFailureExpectedText, @Nullable String expectedFilePath, @Nullable String actualFilePath, boolean expectedFileTemp, boolean actualFileTemp, long durationMillis) {
        if (localizedFailureMessage == null) {
            TestFailedEvent.$$$reportNull$$$0(5);
        }
        super(testName, id);
        this.myLocalizedFailureMessage = localizedFailureMessage;
        this.myStacktrace = stackTrace;
        this.myTestError = testError;
        this.myExpectedFilePath = expectedFilePath;
        if (comparisonFailureExpectedText == null && expectedFilePath != null) {
            try {
                comparisonFailureExpectedText = FileUtil.loadFile((File)new File(expectedFilePath));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.myComparisonFailureActualText = comparisonFailureActualText;
        this.myActualFilePath = actualFilePath;
        this.myComparisonFailureExpectedText = comparisonFailureExpectedText;
        this.myDurationMillis = durationMillis;
        this.myExpectedFileTemp = expectedFileTemp;
        this.myActualFileTemp = actualFileTemp;
    }

    @NotNull
    public String getLocalizedFailureMessage() {
        String string = this.myLocalizedFailureMessage;
        if (string == null) {
            TestFailedEvent.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nullable
    public String getStacktrace() {
        return this.myStacktrace;
    }

    public boolean isTestError() {
        return this.myTestError;
    }

    @Nullable
    public String getComparisonFailureActualText() {
        return this.myComparisonFailureActualText;
    }

    @Nullable
    public String getComparisonFailureExpectedText() {
        return this.myComparisonFailureExpectedText;
    }

    @Override
    protected void appendToStringInfo(@NotNull StringBuilder buf) {
        if (buf == null) {
            TestFailedEvent.$$$reportNull$$$0(7);
        }
        TestFailedEvent.append(buf, "localizedFailureMessage", this.myLocalizedFailureMessage);
        TestFailedEvent.append(buf, "stacktrace", this.myStacktrace);
        TestFailedEvent.append(buf, "isTestError", this.myTestError);
        TestFailedEvent.append(buf, "comparisonFailureActualText", this.myComparisonFailureActualText);
        TestFailedEvent.append(buf, "comparisonFailureExpectedText", this.myComparisonFailureExpectedText);
    }

    public String getFilePath() {
        return this.myExpectedFilePath;
    }

    @Nullable
    public String getExpectedFilePath() {
        return this.myExpectedFilePath;
    }

    @Nullable
    public String getActualFilePath() {
        return this.myActualFilePath;
    }

    public long getDurationMillis() {
        return this.myDurationMillis;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFailed";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testName";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localizedFailureMessage";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/testframework/sm/runner/events/TestFailedEvent";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buf";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/testframework/sm/runner/events/TestFailedEvent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalizedFailureMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "appendToStringInfo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

