/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration.ui.models;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffContentFactoryEx;
import com.intellij.diff.contents.DiffContent;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.ui.models.FileDifferenceModel;
import com.intellij.history.integration.ui.models.RevisionProcessingProgress;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;

public class EntireFileDifferenceModel
extends FileDifferenceModel {
    private final Entry myLeft;
    private final Entry myRight;

    public EntireFileDifferenceModel(Project p, IdeaGateway gw, Entry left, Entry right, boolean editableRightContent) {
        super(p, gw, editableRightContent);
        this.myLeft = left;
        this.myRight = right;
    }

    @Override
    protected Entry getLeftEntry() {
        return this.myLeft;
    }

    @Override
    protected Entry getRightEntry() {
        return this.myRight;
    }

    @Override
    protected boolean isLeftContentAvailable(RevisionProcessingProgress p) {
        return this.myLeft.getContent().isAvailable();
    }

    @Override
    protected boolean isRightContentAvailable(RevisionProcessingProgress p) {
        return this.myRight.getContent().isAvailable();
    }

    @Override
    protected DiffContent doGetLeftDiffContent(RevisionProcessingProgress p) {
        return this.getDiffContent(this.myLeft);
    }

    @Override
    protected DiffContent getReadOnlyRightDiffContent(RevisionProcessingProgress p) {
        return this.getDiffContent(this.myRight);
    }

    @Override
    protected DiffContent getEditableRightDiffContent(RevisionProcessingProgress p) {
        Document d = this.getDocument();
        return DiffContentFactory.getInstance().create(this.myProject, d);
    }

    private DiffContent getDiffContent(Entry e) {
        byte[] content = e.getContent().getBytes();
        FileType fileType = this.myGateway.getFileType(e.getName());
        return DiffContentFactoryEx.getInstanceEx().createDocumentFromBytes(this.myProject, content, fileType, e.getName());
    }
}

