/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmarks;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.bookmarks.Bookmark;
import com.intellij.ide.bookmarks.BookmarkItem;
import com.intellij.ide.bookmarks.BookmarkManager;
import com.intellij.ide.bookmarks.BookmarksListener;
import com.intellij.ide.favoritesTreeView.AbstractFavoritesListProvider;
import com.intellij.ide.favoritesTreeView.FavoritesManager;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.CommonActionsPanel;
import com.intellij.ui.RowIcon;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BookmarksFavoriteListProvider
extends AbstractFavoritesListProvider<Bookmark>
implements BookmarksListener {
    private final BookmarkManager myBookmarkManager;
    private final FavoritesManager myFavoritesManager;

    public BookmarksFavoriteListProvider(Project project, BookmarkManager bookmarkManager, FavoritesManager favoritesManager) {
        super(project, "Bookmarks");
        this.myBookmarkManager = bookmarkManager;
        this.myFavoritesManager = favoritesManager;
        project.getMessageBus().connect((Disposable)project).subscribe(BookmarksListener.TOPIC, (Object)this);
        this.updateChildren();
    }

    @Override
    public void bookmarkAdded(@NotNull Bookmark b) {
        if (b == null) {
            BookmarksFavoriteListProvider.$$$reportNull$$$0(0);
        }
        this.updateChildren();
    }

    @Override
    public void bookmarkRemoved(@NotNull Bookmark b) {
        if (b == null) {
            BookmarksFavoriteListProvider.$$$reportNull$$$0(1);
        }
        this.updateChildren();
    }

    @Override
    public void bookmarkChanged(@NotNull Bookmark b) {
        if (b == null) {
            BookmarksFavoriteListProvider.$$$reportNull$$$0(2);
        }
        this.updateChildren();
    }

    @Override
    public void bookmarksOrderChanged() {
        this.updateChildren();
    }

    @Override
    public String getListName(Project project) {
        return "Bookmarks";
    }

    private void updateChildren() {
        if (this.myProject.isDisposed()) {
            return;
        }
        this.myChildren.clear();
        List<Bookmark> bookmarks = this.myBookmarkManager.getValidBookmarks();
        for (final Bookmark bookmark : bookmarks) {
            AbstractTreeNode<Bookmark> child = new AbstractTreeNode<Bookmark>(this.myProject, bookmark){

                @NotNull
                public Collection<? extends AbstractTreeNode> getChildren() {
                    List list2 = Collections.emptyList();
                    if (list2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return list2;
                }

                public boolean canNavigate() {
                    return bookmark.canNavigate();
                }

                public boolean canNavigateToSource() {
                    return bookmark.canNavigateToSource();
                }

                public void navigate(boolean requestFocus) {
                    bookmark.navigate(requestFocus);
                }

                protected void update(PresentationData presentation) {
                    presentation.setPresentableText(bookmark.toString());
                    presentation.setIcon(bookmark.getIcon());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/bookmarks/BookmarksFavoriteListProvider$1", "getChildren"));
                }
            };
            child.setParent((AbstractTreeNode)this.myNode);
            this.myChildren.add(child);
        }
        this.myFavoritesManager.fireListeners(this.getListName(this.myProject));
    }

    @Override
    @Nullable
    public String getCustomName(@NotNull CommonActionsPanel.Buttons type) {
        if (type == null) {
            BookmarksFavoriteListProvider.$$$reportNull$$$0(3);
        }
        switch (type) {
            case EDIT: {
                return IdeBundle.message((String)"action.bookmark.edit.description", (Object[])new Object[0]);
            }
            case REMOVE: {
                return IdeBundle.message((String)"action.bookmark.delete", (Object[])new Object[0]);
            }
        }
        return null;
    }

    @Override
    public boolean willHandle(@NotNull CommonActionsPanel.Buttons type, Project project, @NotNull Set<Object> selectedObjects) {
        if (type == null) {
            BookmarksFavoriteListProvider.$$$reportNull$$$0(4);
        }
        if (selectedObjects == null) {
            BookmarksFavoriteListProvider.$$$reportNull$$$0(5);
        }
        switch (type) {
            case EDIT: {
                if (selectedObjects.size() != 1) {
                    return false;
                }
                Object toEdit = selectedObjects.iterator().next();
                return toEdit instanceof AbstractTreeNode && ((AbstractTreeNode)toEdit).getValue() instanceof Bookmark;
            }
            case REMOVE: {
                for (Object toRemove2 : selectedObjects) {
                    if (toRemove2 instanceof AbstractTreeNode && ((AbstractTreeNode)toRemove2).getValue() instanceof Bookmark) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void handle(@NotNull CommonActionsPanel.Buttons type, Project project, @NotNull Set<Object> selectedObjects, JComponent component) {
        if (type == null) {
            BookmarksFavoriteListProvider.$$$reportNull$$$0(6);
        }
        if (selectedObjects == null) {
            BookmarksFavoriteListProvider.$$$reportNull$$$0(7);
        }
        switch (type) {
            case EDIT: {
                if (selectedObjects.size() != 1) {
                    return;
                }
                Object toEdit = selectedObjects.iterator().next();
                if (toEdit instanceof AbstractTreeNode && ((AbstractTreeNode)toEdit).getValue() instanceof Bookmark) {
                    Bookmark bookmark = (Bookmark)((AbstractTreeNode)toEdit).getValue();
                    if (bookmark == null) {
                        return;
                    }
                    BookmarkManager.getInstance(project).editDescription(bookmark);
                }
                return;
            }
            case REMOVE: {
                for (Object toRemove2 : selectedObjects) {
                    Bookmark bookmark = (Bookmark)((AbstractTreeNode)toRemove2).getValue();
                    BookmarkManager.getInstance(project).removeBookmark(bookmark);
                }
                return;
            }
        }
    }

    @Override
    public int getWeight() {
        return 100;
    }

    @Override
    public void customizeRenderer(ColoredTreeCellRenderer renderer, JTree tree, @NotNull Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (value == null) {
            BookmarksFavoriteListProvider.$$$reportNull$$$0(8);
        }
        renderer.clear();
        renderer.setIcon(Bookmark.DEFAULT_ICON);
        if (value instanceof Bookmark) {
            Bookmark bookmark = (Bookmark)value;
            BookmarkItem.setupRenderer((SimpleColoredComponent)renderer, this.myProject, bookmark, selected);
            if (renderer.getIcon() != null) {
                RowIcon icon = new RowIcon(3, RowIcon.Alignment.CENTER);
                icon.setIcon(bookmark.getIcon(), 0);
                icon.setIcon((Icon)JBUI.scale((JBUI.JBIcon)EmptyIcon.create((int)1)), 1);
                icon.setIcon(renderer.getIcon(), 2);
                renderer.setIcon((Icon)icon);
            } else {
                renderer.setIcon(bookmark.getIcon());
            }
        } else {
            renderer.append(this.getListName(this.myProject));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedObjects";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/bookmarks/BookmarksFavoriteListProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "bookmarkAdded";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "bookmarkRemoved";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "bookmarkChanged";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getCustomName";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "willHandle";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "handle";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "customizeRenderer";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

