/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates.impl;

import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.ide.fileTemplates.impl.FTManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.ex.FileTypeManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.velocity.runtime.parser.ParseException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FileTemplateBase
implements FileTemplate {
    static final boolean DEFAULT_REFORMAT_CODE_VALUE = true;
    static final boolean DEFAULT_ENABLED_VALUE = true;
    @Nullable
    private String myText;
    private boolean myShouldReformatCode = true;
    private boolean myLiveTemplateEnabled;

    @Override
    public final boolean isReformatCode() {
        return this.myShouldReformatCode;
    }

    @Override
    public final void setReformatCode(boolean reformat) {
        this.myShouldReformatCode = reformat;
    }

    public final String getQualifiedName() {
        return FileTemplateBase.getQualifiedName(this.getName(), this.getExtension());
    }

    public static String getQualifiedName(String name, String extension) {
        return FTManager.encodeFileName(name, extension);
    }

    @Override
    @NotNull
    public final String getText() {
        String text = this.myText;
        String string = text != null ? text : this.getDefaultText();
        if (string == null) {
            FileTemplateBase.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public final void setText(@Nullable String text) {
        String converted;
        this.myText = text == null ? null : ((converted = StringUtil.convertLineSeparators((String)text)).equals(this.getDefaultText()) ? null : converted);
    }

    @NotNull
    protected String getDefaultText() {
        if ("" == null) {
            FileTemplateBase.$$$reportNull$$$0(1);
        }
        return "";
    }

    @Override
    @NotNull
    public final String getText(Map attributes) throws IOException {
        String string = FileTemplateUtil.mergeTemplate(attributes, this.getText(), false);
        if (string == null) {
            FileTemplateBase.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public final String getText(Properties attributes) throws IOException {
        String string = FileTemplateUtil.mergeTemplate(attributes, this.getText(), false);
        if (string == null) {
            FileTemplateBase.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @NotNull
    public final String[] getUnsetAttributes(@NotNull Properties properties, Project project) throws ParseException {
        if (properties == null) {
            FileTemplateBase.$$$reportNull$$$0(4);
        }
        String[] stringArray = FileTemplateUtil.calculateAttributes(this.getText(), properties, false, project);
        if (stringArray == null) {
            FileTemplateBase.$$$reportNull$$$0(5);
        }
        return stringArray;
    }

    @Override
    public FileTemplateBase clone() {
        try {
            return (FileTemplateBase)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isTemplateOfType(@NotNull FileType fType) {
        if (fType == null) {
            FileTemplateBase.$$$reportNull$$$0(6);
        }
        return fType.equals(FileTypeManagerEx.getInstanceEx().getFileTypeByExtension(this.getExtension()));
    }

    @Override
    public boolean isLiveTemplateEnabled() {
        return this.myLiveTemplateEnabled;
    }

    @Override
    public void setLiveTemplateEnabled(boolean value) {
        this.myLiveTemplateEnabled = value;
    }

    public boolean isLiveTemplateEnabledByDefault() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/fileTemplates/impl/FileTemplateBase";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultText";
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/fileTemplates/impl/FileTemplateBase";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnsetAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getUnsetAttributes";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isTemplateOfType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

