/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.PseudoMap;
import com.intellij.openapi.vcs.checkin.CheckinChangeListSpecificComponent;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.ui.Refreshable;
import com.intellij.openapi.vcs.ui.RefreshableOnComponent;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class CommitOptionsPanel
extends BorderLayoutPanel
implements Refreshable,
Disposable {
    private static final Comparator<AbstractVcs> VCS_COMPARATOR = Comparator.comparing(it -> it.getKeyInstanceMethod().getName(), String::compareToIgnoreCase);
    @NotNull
    private final CheckinProjectPanel myCommitPanel;
    @NotNull
    private final Collection<CheckinHandler> myHandlers;
    @NotNull
    private final Map<AbstractVcs, JPanel> myPerVcsOptionsPanels;
    @NotNull
    private final List<RefreshableOnComponent> myAdditionalComponents;
    @NotNull
    private final Set<CheckinChangeListSpecificComponent> myCheckinChangeListSpecificComponents;
    @NotNull
    private final PseudoMap<Object, Object> myAdditionalData;
    private final boolean myEmpty;

    public CommitOptionsPanel(@NotNull CheckinProjectPanel panel2, @NotNull Collection<CheckinHandler> handlers, @NotNull Collection<AbstractVcs> vcses) {
        if (panel2 == null) {
            CommitOptionsPanel.$$$reportNull$$$0(0);
        }
        if (handlers == null) {
            CommitOptionsPanel.$$$reportNull$$$0(1);
        }
        if (vcses == null) {
            CommitOptionsPanel.$$$reportNull$$$0(2);
        }
        this.myPerVcsOptionsPanels = ContainerUtil.newHashMap();
        this.myAdditionalComponents = ContainerUtil.newArrayList();
        this.myCheckinChangeListSpecificComponents = ContainerUtil.newHashSet();
        this.myAdditionalData = new PseudoMap();
        this.myCommitPanel = panel2;
        this.myHandlers = handlers;
        this.myEmpty = this.init(vcses);
    }

    public boolean isEmpty() {
        return this.myEmpty;
    }

    @NotNull
    public List<RefreshableOnComponent> getAdditionalComponents() {
        List<RefreshableOnComponent> list2 = Collections.unmodifiableList(this.myAdditionalComponents);
        if (list2 == null) {
            CommitOptionsPanel.$$$reportNull$$$0(3);
        }
        return list2;
    }

    @NotNull
    public PseudoMap<Object, Object> getAdditionalData() {
        PseudoMap<Object, Object> pseudoMap = this.myAdditionalData;
        if (pseudoMap == null) {
            CommitOptionsPanel.$$$reportNull$$$0(4);
        }
        return pseudoMap;
    }

    public void saveState() {
        this.myAdditionalComponents.forEach(Refreshable::saveState);
    }

    public void restoreState() {
        this.myAdditionalComponents.forEach(Refreshable::restoreState);
    }

    public void refresh() {
        this.myAdditionalComponents.forEach(Refreshable::refresh);
    }

    public void onChangeListSelected(@NotNull LocalChangeList changeList, List<VirtualFile> unversionedFiles) {
        if (changeList == null) {
            CommitOptionsPanel.$$$reportNull$$$0(5);
        }
        Set affectedVcses = ContainerUtil.union((Set)ChangesUtil.getAffectedVcses((Collection)changeList.getChanges(), (Project)this.myCommitPanel.getProject()), (Set)ChangesUtil.getAffectedVcsesForFiles(unversionedFiles, (Project)this.myCommitPanel.getProject()));
        for (Map.Entry<AbstractVcs, JPanel> entry : this.myPerVcsOptionsPanels.entrySet()) {
            entry.getValue().setVisible(affectedVcses.contains(entry.getKey()));
        }
        this.myCheckinChangeListSpecificComponents.forEach(component -> {
            if (changeList == null) {
                CommitOptionsPanel.$$$reportNull$$$0(9);
            }
            component.onChangeListSelected(changeList);
        });
    }

    public void saveChangeListComponentsState() {
        this.myCheckinChangeListSpecificComponents.forEach(Refreshable::saveState);
    }

    public void dispose() {
    }

    private boolean init(@NotNull Collection<AbstractVcs> vcses) {
        if (vcses == null) {
            CommitOptionsPanel.$$$reportNull$$$0(6);
        }
        String borderTitleName = this.myCommitPanel.getCommitActionName().replace("_", "").replace("&", "");
        boolean hasVcsOptions = false;
        Box vcsCommitOptions = Box.createVerticalBox();
        for (AbstractVcs vcs : ContainerUtil.sorted(vcses, VCS_COMPARATOR)) {
            RefreshableOnComponent options;
            CheckinEnvironment checkinEnvironment = vcs.getCheckinEnvironment();
            if (checkinEnvironment == null || (options = checkinEnvironment.createAdditionalOptionsPanel(this.myCommitPanel, this.myAdditionalData)) == null) continue;
            JPanel vcsOptions = new JPanel(new BorderLayout());
            vcsOptions.add((Component)options.getComponent(), "Center");
            vcsOptions.setBorder((Border)IdeBorderFactory.createTitledBorder((String)vcs.getDisplayName(), (boolean)true));
            vcsCommitOptions.add(vcsOptions);
            this.myPerVcsOptionsPanels.put(vcs, vcsOptions);
            this.myAdditionalComponents.add(options);
            if (options instanceof CheckinChangeListSpecificComponent) {
                this.myCheckinChangeListSpecificComponents.add((CheckinChangeListSpecificComponent)options);
            }
            hasVcsOptions = true;
        }
        boolean beforeVisible = false;
        boolean afterVisible = false;
        Box beforeBox = Box.createVerticalBox();
        Box afterBox = Box.createVerticalBox();
        for (CheckinHandler handler2 : this.myHandlers) {
            RefreshableOnComponent afterPanel;
            RefreshableOnComponent beforePanel = handler2.getBeforeCheckinConfigurationPanel();
            if (beforePanel != null) {
                beforeVisible = true;
                this.addCheckinHandlerComponent(beforePanel, beforeBox);
            }
            if ((afterPanel = handler2.getAfterCheckinConfigurationPanel((Disposable)this)) == null) continue;
            afterVisible = true;
            this.addCheckinHandlerComponent(afterPanel, afterBox);
        }
        if (!(hasVcsOptions || beforeVisible || afterVisible)) {
            return true;
        }
        Box optionsBox = Box.createVerticalBox();
        if (hasVcsOptions) {
            vcsCommitOptions.add(Box.createVerticalGlue());
            optionsBox.add(vcsCommitOptions);
        }
        if (beforeVisible) {
            beforeBox.add(Box.createVerticalGlue());
            JPanel beforePanel = new JPanel(new BorderLayout());
            beforePanel.add(beforeBox);
            beforePanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)VcsBundle.message((String)"border.standard.checkin.options.group", (Object[])new Object[]{borderTitleName}), (boolean)true));
            optionsBox.add(beforePanel);
        }
        if (afterVisible) {
            afterBox.add(Box.createVerticalGlue());
            JPanel afterPanel = new JPanel(new BorderLayout());
            afterPanel.add(afterBox);
            afterPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)VcsBundle.message((String)"border.standard.after.checkin.options.group", (Object[])new Object[]{borderTitleName}), (boolean)true));
            optionsBox.add(afterPanel);
        }
        optionsBox.add(Box.createVerticalGlue());
        JPanel additionalOptionsPanel = new JPanel(new BorderLayout());
        additionalOptionsPanel.add((Component)optionsBox, "North");
        JScrollPane optionsPane = ScrollPaneFactory.createScrollPane((Component)additionalOptionsPanel, (boolean)true);
        this.addToCenter(optionsPane).withBorder((Border)JBUI.Borders.emptyLeft((int)10));
        return false;
    }

    private void addCheckinHandlerComponent(@NotNull RefreshableOnComponent component, @NotNull Box container) {
        if (component == null) {
            CommitOptionsPanel.$$$reportNull$$$0(7);
        }
        if (container == null) {
            CommitOptionsPanel.$$$reportNull$$$0(8);
        }
        container.add(component.getComponent());
        this.myAdditionalComponents.add(component);
        if (component instanceof CheckinChangeListSpecificComponent) {
            this.myCheckinChangeListSpecificComponents.add((CheckinChangeListSpecificComponent)component);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handlers";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcses";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/CommitOptionsPanel";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeList";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/CommitOptionsPanel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalComponents";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "onChangeListSelected";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addCheckinHandlerComponent";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lambda$onChangeListSelected$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

